/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CKeyView.cp,v 1.14 1999/03/10 02:34:52 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>

#include "CKeyView.h"
#include "CKeyTable.h"
#include "CKeyTableLabels.h"
#include "CPGPActiveScroller.h"

CKeyView::CKeyView()
{

}

CKeyView::CKeyView(
	LStream	*inStream)
		: LView(inStream)
{
}

CKeyView::~CKeyView()
{

}

	void
CKeyView::FinishCreateSelf()
{
	LView::FinishCreateSelf();
	
	mKeyTable =			(CKeyTable *)		FindPaneByID(kKeyTable);
	pgpAssertAddrValid(mKeyTable,			VoidAlign);
	mKeyTableLabels =	(CKeyTableLabels *)	FindPaneByID(kKeyTableLabels);
	pgpAssertAddrValid(mKeyTableLabels,	VoidAlign);
	mKeyScroller =		(CPGPActiveScroller *)	FindPaneByID(kKeyScroller);
	pgpAssertAddrValid(mKeyScroller,	VoidAlign);
	mKeyTableLabels->SetKeyTable(mKeyTable);
	mKeyTable->SetKeyLabels(mKeyTableLabels);
	
	mStatusCaption	=	(LCaption *)		FindPaneByID(kStatusCaption);
	mUnlockButton	=	(LBevelButton *)	FindPaneByID(kUnlockButton);
	mLockButton		=	(LBevelButton *)	FindPaneByID(kLockButton);
}

	void
CKeyView::SetKeyDBInfo(	PGPKeySetRef	keySet,
						Boolean			writable,
						Boolean			defaultRings )
{
	pgpAssertAddrValid(keySet, PGPKeySetRef);
	mKeyTable->SetKeyDBInfo(keySet, writable, defaultRings);
}

	void
CKeyView::Empty()
{
	mKeyTable->Empty();
}

	void
CKeyView::CloseKeys()
{
	mKeyTable->Reset1();
}

	PGPKeySetRef
CKeyView::GetKeySet()
{
	return mKeyTable->GetKeySet();
}

	void
CKeyView::ImportKeysFromHandle(Handle data)
{
	mKeyTable->ImportKeysFromHandle(data);
}

