/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPPreferencesGrafPortView.cp,v 1.47.4.1 1999/06/11 06:14:45 heller Exp $
____________________________________________________________________________*/

#include <LBevelButton.h>
#include <LBroadcaster.h>
#include <LCheckBox.h>
#include <LEditText.h>
#include <LIconPane.h>
#include <LLittleArrows.h>
#include <LMultiPanelView.h>
#include <LPopupButton.h>
#include <LPushButton.h>
#include <LRadioButton.h>
#include <LStaticText.h>
#include <LTableView.h>
#include <LTableMultiSelector.h>
#include <URegistrar.h>
#include <UDesktop.h>
#include <UEnvironment.h>
#include <PP_Messages.h>

#include "pflPrefTypes.h"

#include "pgpAdminPrefs.h"
#include "pgpClientLib.h"
#include "pgpClientLibDialogs.h"
#include "pgpClientLibUtils.h"
#include "pgpClientPrefs.h"

#include "CColumnTable.h"
#include "CCommandKeyWell.h"
#include "CGADurationEditField.h"
#include "CPGPPreferencesGrafPortView.h"
#include "CPGPStDialogHandler.h"
#include "pgpUtilities.h"
#include "pgpStrings.h"
#include "pgpErrors.h"
#include "pgpMemoryMgr.h"
#include "pgpSDKPrefs.h"
#include "pgpKeyServerPrefs.h"
#include "pgpMacMemory.h"
#include "MacFiles.h"
#include "MacDialogs.h"
#include "MacStrings.h"

#include <string.h>

const PaneIDT	kPGPmenuAppListID			= 'pmAL';
const PaneIDT	kPGPmenuAddButton			= 'bAdd';
const PaneIDT	kPGPmenuRemoveButton		= 'bRmv';
const PaneIDT	kServerNameEditField		= 'eSrv';
const PaneIDT	kServerPortEditField		= 'ePrt';

const ResIDT	kPGPPreferencesDialogID		= 4760;
const ResIDT	kGeneralPanelViewResID		= 4761;
const ResIDT	kFilesPanelViewResID		= 4762;
const ResIDT	kEmailPanelViewResID		= 4763;
const ResIDT	kPGPmenuPanelViewResID		= 4764;
const ResIDT	kAdvancedPGPmenuDialogID	= 4765;
const ResIDT	kServerPanelViewResID		= 4766;
const ResIDT	kNewServerDialogID			= 4767;
const ResIDT	kAdvancedPanelViewResID		= 4768;
const ResIDT	kCAPanelViewResID			= 4770;

const ResIDT	kPreferencesStringListResID	= 4750;

enum
{
	kNoDomainOrURLErrorStrIndex	= 1,
	kNoAlgorithmsErrorStrIndex,
	kNoServersErrorStrIndex,
	kCAEndsInSlashErrorStrIndex
};

enum
{
	kIDEAMenuItemIndex		= 1,
	kTripleDESMenuItemIndex,
	kCASTMenuItemIndex
};

enum	
{
	kGeneralPanelViewIndex		= 1,
	kFilesPanelViewIndex		= 2,
	kEmailPanelViewIndex		= 3,
	kPGPmenuPanelViewIndex		= 4,
	kServerPanelViewIndex		= 5,
	kCAPanelViewIndex			= 6,
	kAdvancedPanelViewIndex		= 7
};


static PGPKeySetRef			gAllKeysRef;
static PGPPrefRef			gClientPrefsRef;
static PGPPrefRef			gAdminPrefsRef;
static PGPContextRef		gContext;
static PGPPrefDialogFlags	gDialogFlags;

class	CServerTable	:	public CColumnTable
{
public:
	enum { class_ID = 'SPht' };
						CServerTable(LStream *inStream) :
							CColumnTable(inStream) { };
	virtual				~CServerTable() { };
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
};

class	CPGPmenuTable	:	public CColumnTable
{
public:
	enum { class_ID = 'pmeT' };
						CPGPmenuTable(LStream *inStream) :
							CColumnTable(inStream) { };
	virtual				~CPGPmenuTable() { };
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
	Boolean				DrawCellCustom(
								const STableCell	&inCell,
								const Rect			&inLocalRect,
								Boolean				hilite );
};

	PGPError
PGPPreferencesDialog(
	PGPContextRef		context,
	PGPKeySetRef		allKeys,
	PGPPrefRef 			clientPrefs,
	PGPPrefRef 			adminPrefs,
	PGPPrefDialogFlags 	*flags)
{
	PGPError			err;
	PGPclientLibState	state;
	
	if( IsntNull( flags ) )
		*flags = 0;
		
	PGPValidateParam( PGPContextRefIsValid( context ) );

	err = EnterPGPclientLib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		
		gContext		= context;
		gDialogFlags	= 0;
		
		gAllKeysRef = allKeys;
		
		if( PGPPrefRefIsValid( clientPrefs ) )
		{
			gClientPrefsRef = clientPrefs;
		}
		else
		{
			gClientPrefsRef = state.clientPrefsRef;
		}

		if( PGPPrefRefIsValid( adminPrefs ) )
		{
			gAdminPrefsRef = adminPrefs;
		}
		else
		{
			gAdminPrefsRef = state.adminPrefsRef;
		}
		
		RegisterClass_( CGADurationEditField );
		RegisterClass_( CPGPPreferencesGrafPortView );
		RegisterClass_( CPGPmenuTable );
		RegisterClass_( CServerTable );
		RegisterClass_( CCommandKeyWell );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPPreferencesGrafPortView::CreateDialog(
							kPGPPreferencesDialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPPreferencesGrafPortView	*prefsGrafPortView;
		
			prefsGrafPortView = (CPGPPreferencesGrafPortView *)
											GetWRefCon( theDialog );
			pgpAssertAddrValid( prefsGrafPortView, VoidAlign );

			err = prefsGrafPortView->DoDialog();
			if( IsntPGPError( err ) && IsntNull( flags ) )
			{
				*flags = gDialogFlags;
			}
			
			delete( prefsGrafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
	
	ExitPGPclientLib( &state );
	
	return( err );
}

#pragma mark --- CPreferencePanelView ---

class CPreferencePanelView : 	public LView,
								public LCommander
{
public:

	enum { class_ID = 'vPrf' };
	
					CPreferencePanelView(LStream *inStream);
	virtual			~CPreferencePanelView();

	virtual void	Show(void);

protected:

	void			GetPrefCheckbox(PaneIDT paneID, PGPPrefIndex prefIndex);
	void			SetPrefCheckbox(PGPPrefIndex prefIndex, PaneIDT paneID);
};

CPreferencePanelView::CPreferencePanelView(LStream *inStream)
	: LView(inStream)
{
}

CPreferencePanelView::~CPreferencePanelView()
{
}

      void
CPreferencePanelView::Show(void)
{
	LView::Show();
	
	RestoreTarget();
}

	void 
CPreferencePanelView::SetPrefCheckbox(
	PGPPrefIndex	prefIndex,
	PaneIDT			paneID)
{
	PGPError	err;
	PGPBoolean	boolPref;
	LCheckBox	*checkBoxObj;

	err = PGPGetPrefBoolean( gClientPrefsRef, prefIndex, &boolPref );
	pgpAssertNoErr( err );
	
	checkBoxObj = (LCheckBox *) FindPaneByID( paneID );
	pgpAssertAddrValid( checkBoxObj, VoidAlign );
	
	checkBoxObj->SetValue( boolPref ? 1 : 0 );	
}

	void
CPreferencePanelView::GetPrefCheckbox(
	PaneIDT			paneID,
	PGPPrefIndex	prefIndex)
{
	PGPError		err;
	LCheckBox		*checkBoxObj;
	
	checkBoxObj = (LCheckBox *) FindPaneByID( paneID );
	pgpAssertAddrValid( checkBoxObj, VoidAlign );
	
	err = PGPSetPrefBoolean( gClientPrefsRef, prefIndex,
					(Boolean) checkBoxObj->GetValue() );
	pgpAssertNoErr( err );
}

#pragma mark --- CPrefPanelGeneral ---

class CPrefPanelGeneral :	public CPreferencePanelView,
							public LListener
{
public:

	enum { class_ID = 'vPGe' };
	
					CPrefPanelGeneral(LStream *inStream);
	virtual			~CPrefPanelGeneral();
	virtual	void	FinishCreateSelf();
	virtual	void	ListenToMessage(MessageT inMessage, void *ioParam);
	
	void			SavePanel();

private:
	Int32			mLastArrowDecrypt,
					mLastArrowSign;
	LEditText		*mWipePasses;

	enum	{	
				kEncryptToDefault		= 'xEnc',
				kUseMacBinary	 		= 'xMBi',
				kCacheDecrypt			= 'xDCa',
				kCacheSign				= 'xSCa',
				kCacheDecryptTime		= 'eDDu',
				kCacheDecryptArrows		= 'lArD',
				kCacheSignTime			= 'eSDu',
				kCacheSignArrows		= 'lArS',
				kCommentLine			= 'eCom',
				kFastKeyGen				= 'xFas',
				kWarnWipe				= 'xWip',
				kWipePassesText			= 'cPas',
				kWipePassesArrows		= 'aPas'
			};
};

CPrefPanelGeneral::CPrefPanelGeneral(LStream *inStream)
	: CPreferencePanelView(inStream)
{
}

CPrefPanelGeneral::~CPrefPanelGeneral(void)
{
}

	void
CPrefPanelGeneral::ListenToMessage(MessageT inMessage, void *ioParam)
{
	Int32					newValue;
	CGADurationEditField	*durationObj;
	
	switch( inMessage )
	{
		case kCacheDecryptArrows:
			durationObj = (CGADurationEditField *)
							FindPaneByID( kCacheDecryptTime );
			newValue = *(Int32 *)ioParam;
			if(newValue < mLastArrowDecrypt)
				durationObj->AdjustValue(kDownAdjust);
			else
				durationObj->AdjustValue(kUpAdjust);
			mLastArrowDecrypt = newValue;
			break;
		case kCacheSignArrows:
			durationObj = (CGADurationEditField *)
							FindPaneByID( kCacheSignTime );
			newValue = *(Int32 *)ioParam;
			if(newValue < mLastArrowSign)
				durationObj->AdjustValue(kDownAdjust);
			else
				durationObj->AdjustValue(kUpAdjust);
			mLastArrowSign = newValue;
			break;
		case kWipePassesArrows:
			mWipePasses->SetValue( *(Int32 *)ioParam );
			break;
	}
}

	void
CPrefPanelGeneral::FinishCreateSelf()
{
	PGPError 				err;
	PGPUInt32				longPref;
	char					commentStr[256];
	Str255					commentPStr;
	PGPSize					commentLen;
	LEditText				*commentField;
	CGADurationEditField	*durationObj;
	LLittleArrows			*arrowsObj;
	
	CPreferencePanelView::FinishCreateSelf();
	
	SetPrefCheckbox( kPGPPrefEncryptToSelf, kEncryptToDefault );
	SetPrefCheckbox( kPGPPrefFastKeyGen, kFastKeyGen );
	SetPrefCheckbox( kPGPPrefDecryptCacheEnable, kCacheDecrypt );
	SetPrefCheckbox( kPGPPrefSignCacheEnable, kCacheSign );
	SetPrefCheckbox( kPGPPrefWarnOnWipe, kWarnWipe );
	
	mWipePasses = (LEditText *) FindPaneByID( kWipePassesText );
	err = PGPGetPrefNumber( gClientPrefsRef, kPGPPrefFileWipePasses, &longPref);
	pgpAssertNoErr( err );
	mWipePasses->SetValue( longPref );
	arrowsObj = (LLittleArrows *) FindPaneByID( kWipePassesArrows );
	arrowsObj->SetValue( longPref );
	arrowsObj->AddListener(this);

	err = PGPGetPrefNumber( gClientPrefsRef, kPGPPrefMacBinaryDefault,
				&longPref );
	pgpAssertNoErr( err );
	
	((LCheckBox *)FindPaneByID(kUseMacBinary))->
			SetValue((longPref == kPGPPrefMacBinaryOn));

	commentLen = 256;
	err = PGPGetPrefStringBuffer( gClientPrefsRef,
		kPGPPrefComment, commentLen, commentStr);
	pgpAssertNoErr( err );
	CToPString(commentStr, commentPStr);
	commentField = (LEditText *)FindPaneByID(kCommentLine);
	commentField->SetDescriptor(commentPStr);
	
#if PGP_BUSINESS_SECURITY						
	err = PGPGetPrefStringBuffer( gAdminPrefsRef,
		kPGPPrefComments, commentLen, commentStr);
	if(IsntPGPError(err) && commentStr[0] != '\0')
	{
		CToPString(commentStr, commentPStr);
		commentField->SetDescriptor(commentPStr);
		commentField->Disable();
	}
#endif

	err = PGPGetPrefNumber( gClientPrefsRef,
		kPGPPrefDecryptCacheSeconds, &longPref);
	pgpAssertNoErr( err );
	durationObj = (CGADurationEditField *)
		FindPaneByID(kCacheDecryptTime);
	durationObj->SetDurationType(kLengthDurationType);
	durationObj->SetDurationValue(longPref);
	durationObj->Refresh();
	
	err = PGPGetPrefNumber( gClientPrefsRef,
		kPGPPrefSignCacheSeconds, &longPref);
	pgpAssertNoErr( err );
	durationObj = (CGADurationEditField *)
		FindPaneByID(kCacheSignTime);
	durationObj->SetDurationType(kLengthDurationType);
	durationObj->SetDurationValue(longPref);
	durationObj->Refresh();
	
	arrowsObj = (LLittleArrows *) FindPaneByID(kCacheDecryptArrows);
	mLastArrowDecrypt =  arrowsObj->GetValue();
	arrowsObj->AddListener(this);
	arrowsObj = (LLittleArrows *) FindPaneByID(kCacheSignArrows);
	mLastArrowSign =  arrowsObj->GetValue();
	arrowsObj->AddListener(this);
	
	//SetTarget( commentField );
}

	void
CPrefPanelGeneral::SavePanel()
{
	PGPUInt32	longPref;
	PGPError	err;
	Boolean		boolPref;
	Str255		commentPStr;
	char		commentCStr[ sizeof( commentPStr ) ];
				
	GetPrefCheckbox(kEncryptToDefault, kPGPPrefEncryptToSelf);
	GetPrefCheckbox(kFastKeyGen, kPGPPrefFastKeyGen);
	GetPrefCheckbox(kCacheDecrypt, kPGPPrefDecryptCacheEnable);
	GetPrefCheckbox(kCacheSign, kPGPPrefSignCacheEnable);
	GetPrefCheckbox(kWarnWipe, kPGPPrefWarnOnWipe);

	longPref = mWipePasses->GetValue();
	err = PGPSetPrefNumber( gClientPrefsRef, kPGPPrefFileWipePasses, longPref);
	pgpAssertNoErr( err );
	
	boolPref = ((LCheckBox *)FindPaneByID(kUseMacBinary))->GetValue();
	err = PGPSetPrefNumber( gClientPrefsRef, kPGPPrefMacBinaryDefault, 
		boolPref ? kPGPPrefMacBinaryOn : kPGPPrefMacBinaryOff);
	pgpAssertNoErr( err );
	
	((LEditText *)FindPaneByID(kCommentLine))->GetDescriptor(commentPStr);
	PToCString( commentPStr, commentCStr );
	err = PGPSetPrefString( gClientPrefsRef, kPGPPrefComment, commentCStr);
	pgpAssertNoErr( err );
	
	longPref = ((CGADurationEditField *)
		FindPaneByID(kCacheDecryptTime))->GetDurationValue();
	err = PGPSetPrefNumber( gClientPrefsRef,
		kPGPPrefDecryptCacheSeconds, longPref);
	pgpAssertNoErr( err );
	
	longPref = ((CGADurationEditField *)
		FindPaneByID(kCacheSignTime))->GetDurationValue();
	err = PGPSetPrefNumber( gClientPrefsRef,
		kPGPPrefSignCacheSeconds, longPref);
	pgpAssertNoErr( err );
}

#pragma mark --- CPrefPanelFiles ---

class CPrefPanelFiles :		public CPreferencePanelView,
							public LListener
{
public:

	enum { class_ID = 'vPFi' };
	
					CPrefPanelFiles(LStream *inStream);
	virtual			~CPrefPanelFiles();
	virtual	void	FinishCreateSelf();
	virtual	void	ListenToMessage(MessageT inMessage, void *ioParam);
	
	void			SavePanel();
private:
	void			SetCaptionFromSpec(
						LStaticText		*inCaptionP,
						const FSSpec	&inSpec);
	
	LStaticText		*mPublicCaption,
					*mPrivateCaption,
					*mRandomCaption;
	FSSpec			mPrivateSpec,
					mPublicSpec,
					mRandomSpec;
	
	enum	{	
				kSetPublicButton		= 'bPub',
				kSetPrivateButton		= 'bPri',
				kSetRandomButton		= 'bRnd',
				kPublicCaption			= 'cPub',
				kPrivateCaption			= 'cPri',
				kRandomCaption			= 'cRnd'
			};
};

CPrefPanelFiles::CPrefPanelFiles(LStream *inStream)
	: CPreferencePanelView(inStream)
{
}

CPrefPanelFiles::~CPrefPanelFiles(void)
{
}

	void
CPrefPanelFiles::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	PGPError		err;
	FSSpec			fileSpec;
	
	(void) ioParam;
	
	switch( inMessage )
	{
		case kSetPublicButton:
		{
			err = PGPSelectPGPFile( gContext, kPGPFileSelector_PublicKeys,
						&fileSpec );
			if( IsntPGPError( err ) )
			{
				mPublicSpec		= fileSpec;
				gDialogFlags 	|= kPGPPrefDialog_ChangedKeyFiles;

				SetCaptionFromSpec( mPublicCaption, mPublicSpec );
			}
			break;
		}	
			
		case kSetPrivateButton:
		{
			err = PGPSelectPGPFile( gContext, kPGPFileSelector_PrivateKeys,
						&fileSpec );
			if( IsntPGPError( err ) )
			{
				mPrivateSpec 	= fileSpec;
				gDialogFlags 	|= kPGPPrefDialog_ChangedKeyFiles;

				SetCaptionFromSpec( mPrivateCaption, mPrivateSpec );
			}
			
			break;
		}	
			
		case kSetRandomButton:
		{
			err = PGPSelectPGPFile( gContext, kPGPFileSelector_RandomSeed,
						&fileSpec );
			if( IsntPGPError( err ) )
			{
				mRandomSpec = fileSpec;

				SetCaptionFromSpec( mRandomCaption, mRandomSpec );
			}
			
			break;
		}	
	}
}

	void
CPrefPanelFiles::SetCaptionFromSpec(
	LStaticText		*inCaptionP,
	const FSSpec	&inSpec)
{
	if (inCaptionP)
	{
		Str255	thePathStr;
		
		thePathStr[0] = 0;
		FSpGetFullPath(&inSpec, (uchar *)&thePathStr);
		
		inCaptionP->SetDescriptor(thePathStr);
	}
}

	void
CPrefPanelFiles::SavePanel()
{
	PGPError	err;
	
	err = PGPSetPGPFileFSSpec( gContext, kPGPFileSelector_PublicKeys,
				&mPublicSpec );
	pgpAssertNoErr( err );

	err = PGPSetPGPFileFSSpec( gContext, kPGPFileSelector_PrivateKeys,
				&mPrivateSpec );
	pgpAssertNoErr( err );

	err = PGPSetPGPFileFSSpec( gContext, kPGPFileSelector_RandomSeed,
				&mRandomSpec );
	pgpAssertNoErr( err );
}

	void
CPrefPanelFiles::FinishCreateSelf()
{
	PGPError		err;
	PGPFileSpecRef	fileRef;

	CPreferencePanelView::FinishCreateSelf();

	err = PGPsdkPrefGetFileSpec(	gContext,
									kPGPsdkPref_PublicKeyring,
									&fileRef);
	if(IsntPGPError(err) && fileRef)
	{
		err = PGPGetFSSpecFromFileSpec(fileRef, &mPublicSpec);
		pgpAssertNoErr( err );
		PGPFreeFileSpec(fileRef);
	}
	else
		PGPGetPGPFileDefaultFSSpec( gContext,
					kPGPFileSelector_PublicKeys, &mPublicSpec );
	err = PGPsdkPrefGetFileSpec(	gContext,
									kPGPsdkPref_PrivateKeyring,
									&fileRef);
	if(IsntPGPError(err) && fileRef)
	{
		err = PGPGetFSSpecFromFileSpec(fileRef, &mPrivateSpec);
		pgpAssertNoErr( err );
		PGPFreeFileSpec(fileRef);
	}
	else
		PGPGetPGPFileDefaultFSSpec( gContext,
					kPGPFileSelector_PrivateKeys, &mPrivateSpec );
	err = PGPsdkPrefGetFileSpec(	gContext,
									kPGPsdkPref_RandomSeedFile,
									&fileRef);
	if(IsntPGPError(err) && fileRef)
	{
		err = PGPGetFSSpecFromFileSpec(fileRef, &mRandomSpec);
		pgpAssertNoErr( err );
		PGPFreeFileSpec(fileRef);
	}
	else
		PGPGetPGPFileDefaultFSSpec( gContext,
					kPGPFileSelector_RandomSeed, &mRandomSpec );

	((LBevelButton *) FindPaneByID(kSetPublicButton))->
					AddListener(this);
	((LBevelButton *) FindPaneByID(kSetPrivateButton))->
					AddListener(this);
	((LBevelButton *) FindPaneByID(kSetRandomButton))->
					AddListener(this);
	mPublicCaption =
		(LStaticText *)FindPaneByID(kPublicCaption);
	pgpAssertAddrValid(mPublicCaption, VoidAlign);
	mPrivateCaption =
		(LStaticText *)FindPaneByID(kPrivateCaption);
	pgpAssertAddrValid(mPrivateCaption, VoidAlign);
	mRandomCaption =
		(LStaticText *)FindPaneByID(kRandomCaption);
	pgpAssertAddrValid(mPrivateCaption, VoidAlign);
	
	SetCaptionFromSpec( mPublicCaption, mPublicSpec );
	SetCaptionFromSpec( mPrivateCaption, mPrivateSpec );
	SetCaptionFromSpec( mRandomCaption, mRandomSpec );

}

#pragma mark --- CPrefPanelEmail ---

class CPrefPanelEmail :		public CPreferencePanelView
{
public:

	enum { class_ID = 'vPEm' };
	
					CPrefPanelEmail(LStream *inStream);
	virtual			~CPrefPanelEmail();
	virtual	void	FinishCreateSelf();
	
	void			SavePanel();
private:
	enum
	{			
		kPGPMIME				= 'xMIM',
		kWordWrapCheckBox		= 'xWrp',
		kWordWrapEditField		= 'eWrp',
		kEncryptDefault			= 'xEDe',
		kSignDefault			= 'xSDe',
		kAutoDecrypt			= 'xADe'
	};

};

CPrefPanelEmail::CPrefPanelEmail(LStream *inStream)
	: CPreferencePanelView(inStream)
{
}

CPrefPanelEmail::~CPrefPanelEmail(void)
{
}

	void
CPrefPanelEmail::SavePanel()
{
	PGPError		err;
	PGPUInt32		longPref;
	
	GetPrefCheckbox(kPGPMIME, kPGPPrefMailEncryptPGPMIME);
	GetPrefCheckbox(kPGPMIME, kPGPPrefMailSignPGPMIME);
	GetPrefCheckbox(kWordWrapCheckBox, kPGPPrefWordWrapEnable);
	GetPrefCheckbox(kEncryptDefault, kPGPPrefMailEncryptDefault);
	GetPrefCheckbox(kSignDefault, kPGPPrefMailSignDefault);
	GetPrefCheckbox(kAutoDecrypt, kPGPPrefAutoDecrypt);

	longPref = ((LCheckBox *)FindPaneByID(
		kWordWrapEditField))->GetValue();
	if(longPref < 30)
		longPref = 78;
	else if(longPref > 240)
		longPref = 240;
	err = PGPSetPrefNumber( gClientPrefsRef, kPGPPrefWordWrapWidth, longPref);
	pgpAssertNoErr( err );
}

	void
CPrefPanelEmail::FinishCreateSelf()
{
	PGPError		err;
	PGPUInt32		longPref;
	
	CPreferencePanelView::FinishCreateSelf();

	SetPrefCheckbox(kPGPPrefMailEncryptPGPMIME, kPGPMIME);
	SetPrefCheckbox(kPGPPrefWordWrapEnable, kWordWrapCheckBox);
	SetPrefCheckbox(kPGPPrefMailEncryptDefault, kEncryptDefault);
	SetPrefCheckbox(kPGPPrefMailSignDefault, kSignDefault);
	SetPrefCheckbox(kPGPPrefAutoDecrypt, kAutoDecrypt);
	err = PGPGetPrefNumber( gClientPrefsRef, kPGPPrefWordWrapWidth, &longPref);
	pgpAssertNoErr( err );
	((LCheckBox *)FindPaneByID(kWordWrapEditField))->SetValue(longPref);
}

#pragma mark --- CPrefPanelPGPmenu ---

	Boolean
CPGPmenuTable::DrawCellCustom(
	const STableCell		&inCell,
	const Rect				&inLocalRect,
	Boolean					hilite )
{
	if( inCell.col == 1 )
	{
		Uint32				dataSize = sizeof(PGPmenuApps);
		PGPmenuApps 		app;
		IconRef				icRef;
		
		GetCellData( inCell, &app, dataSize );
		if( IsntErr( GetIconRef( kOnSystemDisk, app.creator, 'APPL', &icRef ) ) )
		{
			Rect				iconRect;

			iconRect.left	=	inLocalRect.left + 2;
			iconRect.top	=	inLocalRect.top + 1;
			iconRect.right 	= 	iconRect.left + 16;
			iconRect.bottom = 	iconRect.top + 16;
			
			PlotIconRef( &iconRect, kAlignNone,
				hilite ? kTransformSelected : kTransformNone,
				kIconServicesNormalUsageFlag, icRef );
			ReleaseIconRef( icRef );
		}
	}
	return TRUE;
}

	Boolean
CPGPmenuTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&,
	Str255				data,
	StyleParameter		& )
{
	Uint32				dataSize = sizeof(PGPmenuApps);
	PGPmenuApps 		app;
	Boolean				custom = FALSE;
	
	iconID = 0;
	GetCellData( inCell, &app, dataSize );
	switch( inCell.col )
	{
		case 1:
			CopyPString( app.appName, data );
			if( UEnvironment::HasGestaltAttribute(
					gestaltIconUtilitiesAttr,
					gestaltIconUtilitiesHasIconServices ) )
				custom = TRUE;
			else
				iconID = -3996;
			break;
	}
	return custom;
}

class CPrefPanelPGPmenu :	public CPreferencePanelView,
							public LListener
{
public:

	enum { class_ID = 'vPMe' };
	
					CPrefPanelPGPmenu(LStream *inStream);
	virtual			~CPrefPanelPGPmenu();
	virtual	void	FinishCreateSelf();
	virtual	void	ListenToMessage(MessageT inMessage, void *ioParam);
	
	void			SavePanel();
	
private:
	
	LArray			*mAppInfoList;
	CPGPmenuTable	*mAppTable;

	enum
	{			
		kPGPmenuAddButton		= 'bAdd',
		kPGPmenuRemoveButton	= 'bRmv',
		kPGPmenuAppListID		= 'pmAL',
		kPGPmenuEncryptCKW		= 'kEnc',
		kPGPmenuSignCKW			= 'kSig',
		kPGPmenuEncryptSignCKW	= 'kEnS',
		kPGPmenuDecryptCKW		= 'kDec',
		kPGPmenuTrashWipe		= 'xTra'
	};
};

CPrefPanelPGPmenu::CPrefPanelPGPmenu(LStream *inStream)
	: CPreferencePanelView(inStream)
{
	mAppInfoList = new LArray( sizeof( PGPmenuApps ) );
}

CPrefPanelPGPmenu::~CPrefPanelPGPmenu(void)
{
	delete mAppInfoList;
}

	void
CPrefPanelPGPmenu::SavePanel()
{
	PGPError			err;
	PGPmenuHotkeys		hkp;
	
	mAppInfoList->Lock();
	
	GetPrefCheckbox( kPGPmenuTrashWipe, kPGPPrefTrashIntegration );
	err = PGPSetPrefData( gClientPrefsRef, kPGPPrefPGPmenuMacAppSignatures,
				mAppInfoList->GetCount() * sizeof( PGPmenuApps ),
				(void *) *mAppInfoList->GetItemsHandle() );
	pgpAssertNoErr( err );
	
	pgpClearMemory( &hkp, sizeof( PGPmenuHotkeys ) );
	( (CCommandKeyWell *)FindPaneByID( kPGPmenuEncryptCKW ) )->
		GetCKW( hkp.encryptModifiers, hkp.encryptKey );
	( (CCommandKeyWell *)FindPaneByID( kPGPmenuSignCKW ) )->
		GetCKW( hkp.signModifiers, hkp.signKey );
	( (CCommandKeyWell *)FindPaneByID( kPGPmenuEncryptSignCKW ) )->
		GetCKW( hkp.encryptSignModifiers, hkp.encryptSignKey );
	( (CCommandKeyWell *)FindPaneByID( kPGPmenuDecryptCKW ) )->
		GetCKW( hkp.decryptModifiers, hkp.decryptKey );
	err = PGPSetPrefData( gClientPrefsRef, kPGPPrefHotKeyData,
				sizeof( PGPmenuHotkeys ), &hkp );
	pgpAssertNoErr( err );

	mAppInfoList->Unlock();
}

	void
CPrefPanelPGPmenu::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	STableCell	cell;
			
	switch( inMessage )
	{
		case kPGPmenuAddButton:
		{
			SFTypeList 			sfTypes;
			StandardFileReply 	reply;
			FInfo 				fndrInfo;
			
			sfTypes[0] = 'APPL';
			sfTypes[1] = 'FNDR';
			sfTypes[2] = 'adrp';
			
			StandardGetFile( NULL, 3, sfTypes, &reply );
			
			if( reply.sfGood && 
				FSpGetFInfo( &reply.sfFile, &fndrInfo ) == noErr )
			{
				PGPmenuApps				info;
				
				info.privateScrap 		= TRUE;
				info.useOutputDialog 	= TRUE;
				info.creator			= fndrInfo.fdCreator;

				CopyPString( reply.sfFile.name, info.appName );
				
				if( mAppInfoList->AddItem( &info ) != LArray::index_Bad )
				{
					mAppTable->InsertRows(1, LArray::index_Last,
							&info, sizeof( info ), TRUE );
				}
			}

			break;
		}
		case kPGPmenuRemoveButton:
			cell = mAppTable->GetFirstSelectedCell();
			if( cell.row > 0 && cell.col == 1 )
			{
				mAppTable->RemoveRows( 1, cell.row, TRUE );
				mAppInfoList->RemoveItemsAt( 1, cell.row );
			}
			break;
		case coltable_SelectChange:
		{
			LPushButton	*removePMButton;
			
			removePMButton = (LPushButton *)
								FindPaneByID( kPGPmenuRemoveButton );
			pgpAssertAddrValid( removePMButton, VoidAlign );
			
			if( mAppTable->GetFirstSelectedCell().IsNullCell() )
				removePMButton->Disable();
			else
				removePMButton->Enable();
			break;
		}
			
		case coltable_DoubleClick:
		{
			DialogRef	theDialog;
			GrafPtr		savePort;
			
			GetPort( &savePort );
			
			theDialog = CPGPModalGrafPortView::CreateDialog(
								kAdvancedPGPmenuDialogID );
			if( IsntNull( theDialog ) )
			{
				CPGPModalGrafPortView	*grafPortView;
				PGPmenuApps				info;
				LCheckBox				*privateScrapCheckBox;
				LCheckBox				*outputDialogCheckBox;
				LStaticText				*textObj;
				TableIndexT				row;
				const PaneIDT			kPrivateScrapCheckbox	= 'xScr';
				const PaneIDT			kOutputDialogCheckbox	= 'xOut';
				const PaneIDT			kAppNameCaption			= 'cNam';
			
				cell = *(STableCell *)ioParam;
				row = cell.row;
				grafPortView = (CPGPModalGrafPortView *)
										GetWRefCon( theDialog );
				pgpAssertAddrValid( grafPortView, VoidAlign );

				mAppInfoList->FetchItemAt( row, &info );
				
				textObj = (LStaticText *) grafPortView->FindPaneByID(
								kAppNameCaption );
				pgpAssertAddrValid( textObj, VoidAlign );
				
				textObj->SetDescriptor( info.appName );
				
				privateScrapCheckBox = (LCheckBox *)
						grafPortView->FindPaneByID( kPrivateScrapCheckbox );
				pgpAssertAddrValid( privateScrapCheckBox, VoidAlign );
								
				privateScrapCheckBox->SetValue( info.privateScrap ? 1 : 0 );
				
				outputDialogCheckBox = (LCheckBox *)
						grafPortView->FindPaneByID( kOutputDialogCheckbox );
				pgpAssertAddrValid( outputDialogCheckBox, VoidAlign );

				outputDialogCheckBox->SetValue( info.useOutputDialog ? 1 : 0 );

				if( IsntPGPError( grafPortView->DoDialog() ) )
				{
					info.privateScrap =
							( privateScrapCheckBox->GetValue() != 0 );
					info.useOutputDialog = 
							( outputDialogCheckBox->GetValue() != 0 );
							
					mAppInfoList->AssignItemsAt( 1, row, &info );
				}
				
				delete( grafPortView );
				DisposeDialog( theDialog );
			}

			SetPort( savePort );
			
			break;
		}
	}
}

	void
CPrefPanelPGPmenu::FinishCreateSelf()
{
	PGPError	err;
	PGPSize		appListSize;
	void		*appListBuffer;
	LPushButton	*buttonObj;
	
	CPreferencePanelView::FinishCreateSelf();

	buttonObj = (LPushButton *) FindPaneByID( kPGPmenuAddButton );
	pgpAssertAddrValid( buttonObj, VoidAlign );
	
	buttonObj->AddListener( this );
	
	buttonObj = (LPushButton *) FindPaneByID( kPGPmenuRemoveButton );
	pgpAssertAddrValid( buttonObj, VoidAlign );
	
	buttonObj->AddListener( this );
	buttonObj->Disable();
	
	mAppTable = (CPGPmenuTable *) FindPaneByID( kPGPmenuAppListID);
	pgpAssertAddrValid( mAppTable, VoidAlign );

	mAppTable->AddListener(this);

	err = PGPGetPrefData( gClientPrefsRef, kPGPPrefPGPmenuMacAppSignatures,
					&appListSize, &appListBuffer );
	if( IsntNull( appListBuffer ) )
	{
		PGPUInt32		numApps;
		PGPmenuApps		*curAppInfo;
		
		numApps = appListSize / sizeof( PGPmenuApps );
		pgpAssert( ( appListSize % sizeof( PGPmenuApps ) ) == 0 );

		curAppInfo = (PGPmenuApps *) appListBuffer;
		
		for( PGPUInt32 appIndex = 0; appIndex < numApps; appIndex++ )
		{
			mAppInfoList->AddItem( curAppInfo );
			mAppTable->InsertRows( 1, LArray::index_Last, curAppInfo,
					sizeof( PGPmenuApps ), TRUE );
				
			++curAppInfo;
		}
			
		PGPDisposePrefData( gClientPrefsRef, appListBuffer );
	}
	SetLatentSub( mAppTable );
	
	err = PGPGetPrefData( gClientPrefsRef, kPGPPrefHotKeyData,
					&appListSize, &appListBuffer );
	if( IsntNull( appListBuffer ) &&
		( appListSize == sizeof( PGPmenuHotkeys ) ) )
	{
		PGPmenuHotkeys *	hkp = (PGPmenuHotkeys *) appListBuffer;
		
		( (CCommandKeyWell *)FindPaneByID( kPGPmenuEncryptCKW ) )->
			SetCKW( hkp->encryptModifiers, hkp->encryptKey );
		( (CCommandKeyWell *)FindPaneByID( kPGPmenuSignCKW ) )->
			SetCKW( hkp->signModifiers, hkp->signKey );
		( (CCommandKeyWell *)FindPaneByID( kPGPmenuEncryptSignCKW ) )->
			SetCKW( hkp->encryptSignModifiers, hkp->encryptSignKey );
		( (CCommandKeyWell *)FindPaneByID( kPGPmenuDecryptCKW ) )->
			SetCKW( hkp->decryptModifiers, hkp->decryptKey );
		
		PGPDisposePrefData( gClientPrefsRef, appListBuffer );
	}
	SetPrefCheckbox( kPGPPrefTrashIntegration, kPGPmenuTrashWipe );
}

#pragma mark --- CEditKeyServerGrafPort ---

class CEditKeyServerGrafPort : public CPGPModalGrafPortView
{
public:

	enum { class_ID = 'EKSE' };
	
					CEditKeyServerGrafPort(LStream *inStream);
	virtual			~CEditKeyServerGrafPort();
	
	void			SetupDialog(PGPKeyServerEntry	*tableEntry );
	virtual void	ListenToMessage(MessageT inMessage, void *ioParam);
	
protected:

	virtual MessageT	HandleMessage(MessageT theMessage);
	
private:

	enum
	{
		kDomainEditTextPaneID	= 'eDom',
		kURLEditTextPaneID		= 'eURL',
		kListedCheckboxPaneID	= 'xLis',
		kPortEditTextPaneID		= 'ePrt',
		kProtocolPopupPaneID	= 'pPro',
		kDomainRadioPaneID		= 'rDom',
		kAnyDomainRadioPaneID	= 'rNon',
		kAuthKeyTextPaneID		= 'cAut'
	};

	PGPKeyServerEntry	*mTableEntry;
	LEditText			*mDomainEditText;
	LEditText			*mURLEditText;
	LEditText			*mPortEditText;
	LEditText			*mAuthKeyEditText;
	LCheckBox			*mListedCheckBox;
	LPopupButton		*mProtoPopup;
	LRadioButton		*mAnyDomainRadio,
						*mDomainRadio;
};

CEditKeyServerGrafPort::CEditKeyServerGrafPort(LStream *inStream)
	: CPGPModalGrafPortView( inStream )
{
	mTableEntry = NULL;
}

CEditKeyServerGrafPort::~CEditKeyServerGrafPort(void)
{
}

	void
CEditKeyServerGrafPort::SetupDialog(
	PGPKeyServerEntry	*tableEntry )
{
	Str255		tempPStr;
	Int32		newValue;

	mTableEntry = tableEntry;

	mDomainEditText = (LEditText *) 	FindPaneByID( kDomainEditTextPaneID );
	mURLEditText 	= (LEditText *) 	FindPaneByID( kURLEditTextPaneID );
	mPortEditText 	= (LEditText *) 	FindPaneByID( kPortEditTextPaneID );
	mAuthKeyEditText= (LEditText *)		FindPaneByID( kAuthKeyTextPaneID );
	mListedCheckBox = (LCheckBox *) 	FindPaneByID( kListedCheckboxPaneID );
	mProtoPopup		= (LPopupButton *)	FindPaneByID( kProtocolPopupPaneID );
	mAnyDomainRadio	= (LRadioButton *)	FindPaneByID( kAnyDomainRadioPaneID );
	mDomainRadio	= (LRadioButton *)	FindPaneByID( kDomainRadioPaneID );

	pgpAssertAddrValid( mDomainEditText, VoidAlign );
	pgpAssertAddrValid( mURLEditText, VoidAlign );
	pgpAssertAddrValid( mListedCheckBox, VoidAlign );
	
	CToPString( tableEntry->domain, tempPStr );
	mDomainEditText->SetDescriptor( tempPStr );
	mDomainEditText->AddListener(this);
	
	if( !tempPStr[0] )
		mAnyDomainRadio->SetValue(1);

	CToPString( tableEntry->serverDNS, tempPStr );
	mURLEditText->SetDescriptor( tempPStr );
	
	mPortEditText->SetValue( tableEntry->serverPort );
	
	switch( tableEntry->protocol )
	{
		case kPGPKeyServerType_LDAP:
			newValue = 1;
			break;
		case kPGPKeyServerType_LDAPS:
			newValue = 2;
			break;
		case kPGPKeyServerType_HTTPS:
		case kPGPKeyServerType_HTTP:
			newValue = 3;
			break;
	}
	mProtoPopup->SetValue( newValue );
	
	if( tableEntry->authAlg != kPGPPublicKeyAlgorithm_Invalid )
	{
		PGPKeyID	keyID;
		char		keyString[kPGPMaxKeyIDStringSize];
		Str255		keyPString;
		
		keyString[0] = '\0';
		if( PGPKeySetRefIsValid( gAllKeysRef ) )
		{
			PGPKeyRef	authKey;
			PGPError	err;
			
			err = PGPGetKeyIDFromString( tableEntry->authKeyIDString, &keyID );
			if( IsntPGPError( err ) )
			{
				err = PGPGetKeyByKeyID( gAllKeysRef, &keyID,
										tableEntry->authAlg, &authKey );
				if( IsntPGPError( err ) )
				{
					PGPSize	keyStringLen;
					
					err = PGPGetPrimaryUserIDNameBuffer( authKey,
								kPGPMaxKeyIDStringSize, keyString, &keyStringLen );
					if( IsntPGPError( err ) )
						keyString[keyStringLen] = '\0';
				}
			}
		}
		if( !keyString[0] )
		{
			CopyCString( tableEntry->authKeyIDString, keyString );
			keyString[10] = '\0';
		}
		CToPString( keyString, keyPString );
		mAuthKeyEditText->SetDescriptor( keyPString );
	}
	
	mListedCheckBox->SetValue( IsKeyServerListed( tableEntry->flags ) );
}

	void
CEditKeyServerGrafPort::ListenToMessage(MessageT inMessage, void *ioParam)
{
	switch( inMessage )
	{
		case kDomainEditTextPaneID:
		{
			Str255	domain;
			
			mDomainEditText->GetDescriptor( domain );
			if( domain[0] != '\0' )
				mDomainRadio->SetValue( 1 );
			else
				mAnyDomainRadio->SetValue( 1 );
			break;
		}
		default:
			CPGPModalGrafPortView::ListenToMessage( inMessage, ioParam );
			break;
	}
}

	MessageT
CEditKeyServerGrafPort::HandleMessage(MessageT theMessage)
{
	pgpAssert( IsntNull( mTableEntry ) );
	
	theMessage = CPGPModalGrafPortView::HandleMessage( theMessage );
	switch( theMessage )
	{
		case msg_OK:
		{
			Str255		domain,
						url;
			PGPBoolean	anyDomain = FALSE;
			
			mDomainEditText->GetDescriptor( domain );
			mURLEditText->GetDescriptor( url );

			anyDomain = (mAnyDomainRadio->GetValue() > 0 );
			if( ( !anyDomain && domain[0] == 0 ) || url[0] == 0 )
			{
				SysBeep( 1 );
				
				PGPUIWarningAlert( kWACautionAlertType, kWAOKStyle,
							kPreferencesStringListResID,
							kNoDomainOrURLErrorStrIndex );
				theMessage = msg_Nothing;
			}
			else
			{
				gDialogFlags |= kPGPPrefDialog_ChangedServerList;

				if( anyDomain )
					mTableEntry->domain[0] = '\0';
				else
					PToCString( domain, mTableEntry->domain );
				PToCString( url, mTableEntry->serverDNS );
				
				mTableEntry->serverPort = mPortEditText->GetValue();
				
				switch( mProtoPopup->GetValue() )
				{
					case 1:
						mTableEntry->protocol = kPGPKeyServerType_LDAP;
						break;
					case 2:
						mTableEntry->protocol = kPGPKeyServerType_LDAPS;
						break;
					case 3:
						mTableEntry->protocol = kPGPKeyServerType_HTTP;
						break;
				}
				
				if( mListedCheckBox->GetValue() != 0 )
					mTableEntry->flags |= kKeyServerListed;
				else
					mTableEntry->flags &= ~kKeyServerListed;
			}
			break;
		}
	}
	
	return( theMessage );
}

#pragma mark --- CPrefPanelServer ---

	Boolean
CServerTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		&style )
{
	const ResIDT		kValidKeyIconID		= 3014;
	const ResIDT		kKeyAttrOffIconID	= 3015;
	const ResIDT		kAnyDomainIconID	= 4763;
	const ResIDT		kKeyServerIconID	= 4764;
	TableIndexT			col;
	Uint32				dataSize = sizeof(PGPKeyServerEntry);
	PGPKeyServerEntry	entry;
	
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &entry, dataSize );
	switch( col )
	{
		case 1:
		{
			char				url[kMaxServerNameLength + 1];
			
			iconID = kKeyServerIconID;
			PGPGetKeyServerURL( &entry, url );
			CToPString( url, data );
			if( IsKeyServerRoot( entry.flags ) )
				style = bold;
			break;
		}
		case 2:
			if( entry.domain[0] )
				CToPString( entry.domain, data );
			else
			{
				iconID		= kAnyDomainIconID;
				indentLevel	= 1;
			}
			break;
		case 3:
			if( IsKeyServerListed(entry.flags) )
				iconID = kValidKeyIconID;
			else
				iconID = kKeyAttrOffIconID;
			break;
	}
	return FALSE;
}

class CPrefPanelServer :	public CPreferencePanelView,
							public LListener
{
public:

	enum { class_ID = 'vPSe' };
	
					CPrefPanelServer(LStream *inStream);
	virtual			~CPrefPanelServer();
	
	virtual void	Click(SMouseDownEvent &inMouseDown);
	virtual	void	FinishCreateSelf();
	virtual	void	ListenToMessage(MessageT inMessage, void *ioParam);
	
	void			SavePanel();
	
private:
	virtual void	ConfirmUniqueRoot( TableIndexT	row );

	CServerTable	*mServerTable;
	LPushButton		*mSetRootButton;
	
	PGPError		ServerEntryDialog(PGPKeyServerEntry *tableEntry );
	
	enum
	{
		kKeyServerTable			= 'tKsv',
		kNewKeyServerButton		= 'bNSv',
		kRemoveKeyServerButton	= 'bRSv',
		kEditKeyServerButton	= 'bESv',
		kKeyServerSyncGroup		= 'gSyn',
		kUnknownEncryptCheckbox = 'xUnk',
		kAddNamesCheckbox		= 'xAdd',
		kSignKeysCheckbox		= 'xSig',
		kRevokeKeysCheckbox		= 'xRev',
		kVerifyCheckbox			= 'xVer',
		kSetRootButton			= 'bSRS',
		kServerHeaderPaneID		= 'SHdr',
		kDomainHeaderPaneID		= 'DHdr',
		kListedHeaderPaneID		= 'LHdr',
		kMoveUpButton			= 'bMUp',
		kMoveDownButton			= 'bMDn'
	};
};

CPrefPanelServer::CPrefPanelServer(LStream *inStream)
	: CPreferencePanelView(inStream)
{
}

CPrefPanelServer::~CPrefPanelServer(void)
{
}

	void
CPrefPanelServer::Click(SMouseDownEvent	&inMouseDown)
{
	LPane	*clickedPane;
	
	clickedPane = FindSubPaneHitBy(inMouseDown.wherePort.h,
											inMouseDown.wherePort.v);
																			
	if( clickedPane != FindPaneByID( kServerHeaderPaneID ) &&
		clickedPane != FindPaneByID( kDomainHeaderPaneID ) &&
		clickedPane != FindPaneByID( kListedHeaderPaneID ) )
	{
		CPreferencePanelView::Click( inMouseDown );
	}
}

	void
CPrefPanelServer::SavePanel()
{
	PGPError			err;
	TableIndexT			numRows,
						numCols;
	STableCell			cell;
	PGPKeyServerEntry	*ksEntries;
	
	GetPrefCheckbox(	kUnknownEncryptCheckbox,
						kPGPPrefKeyServerSyncUnknownKeys);
	GetPrefCheckbox(	kAddNamesCheckbox,
						kPGPPrefKeyServerSyncOnAdd);
	GetPrefCheckbox(	kSignKeysCheckbox,
						kPGPPrefKeyServerSyncOnKeySign);
	GetPrefCheckbox(	kRevokeKeysCheckbox,
						kPGPPrefKeyServerSyncOnRevocation);
	GetPrefCheckbox(	kVerifyCheckbox,
						kPGPPrefKeyServerSyncOnVerify);
	
	mServerTable->GetTableSize( numRows, numCols );
	ksEntries = (PGPKeyServerEntry *) PGPNewData(
					PGPGetContextMemoryMgr( gContext ),
					numRows * sizeof(PGPKeyServerEntry), 0 );
	pgpAssertAddrValid( ksEntries, PGPKeyServerEntry );
	if( IsntNull( ksEntries ) )
	{
		PGPUInt32	ksIndex = 0;

		cell.col		= 1;
		for( cell.row = 1; cell.row <= numRows; cell.row++ )
		{
			PGPKeyServerEntry	kstEntry;
			Uint32				dataSize = sizeof( kstEntry );

			mServerTable->GetCellData( cell, &kstEntry, dataSize );
			ksEntries[ksIndex++] = kstEntry;
		}
		err = PGPSetKeyServerPrefs( gClientPrefsRef, ksEntries, ksIndex );
		pgpAssertNoErr( err );
		
		PGPFreeData( ksEntries );
	}
}

	PGPError
CPrefPanelServer::ServerEntryDialog(
	PGPKeyServerEntry	*tableEntry )
{
	DialogRef	theDialog;
	GrafPtr		savePort;
	PGPError	err = kPGPError_NoErr;
	
	GetPort( &savePort );
	
	theDialog = CEditKeyServerGrafPort::CreateDialog( kNewServerDialogID );
	if( IsntNull( theDialog ) )
	{
		CEditKeyServerGrafPort	*grafPortView;
		
		grafPortView = (CEditKeyServerGrafPort *) GetWRefCon( theDialog );
		pgpAssertAddrValid( grafPortView, VoidAlign );

		grafPortView->SetupDialog( tableEntry );
		
		err = grafPortView->DoDialog();
		
		delete( grafPortView );
		DisposeDialog( theDialog );
	}
	else
	{
		err = kPGPError_OutOfMemory;
	}

	SetPort( savePort );
	
	return( err );
}

	void
CPrefPanelServer::ConfirmUniqueRoot(
	TableIndexT		row )
{
	TableIndexT		numRows, numCols;
	STableCell		cell;
	
	cell.col = 1;
	
	mServerTable->GetTableSize( numRows, numCols );
	
	for( cell.row = numRows; cell.row >= 1; cell.row-- )
	{
		if( cell.row != row )
		{
			PGPKeyServerEntry	kstEntry;
			Uint32				dataSize = sizeof( kstEntry );
			
			mServerTable->GetCellData( cell, &kstEntry, dataSize );
			if( IsKeyServerRoot( kstEntry.flags ) )
			{
				kstEntry.flags &= ~kKeyServerIsRoot;
				mServerTable->SetCellData( cell, &kstEntry, dataSize );
				mServerTable->RefreshCell( cell );
			}
		}
	}
}

	void
CPrefPanelServer::ListenToMessage(
	MessageT				inMessage,
	void					*ioParam)
{
	TableIndexT				numRows,
							numCols;
	STableCell				cell;
	PGPKeyServerEntry		kstEntry;
	Uint32					dataSize = sizeof( kstEntry );
	
	switch( inMessage )
	{
		case kNewKeyServerButton:
		{
			pgpClearMemory( &kstEntry, sizeof( kstEntry ) );
			
			kstEntry.flags		|= kKeyServerListed;
			kstEntry.protocol	= kPGPKeyServerType_LDAP;
			kstEntry.authAlg	= kPGPPublicKeyAlgorithm_Invalid;
			
			cell = mServerTable->GetFirstSelectedCell();
			
			if( IsntPGPError( ServerEntryDialog( &kstEntry ) ) )
				mServerTable->InsertRows( 1, LArray::index_Last, &kstEntry,
									sizeof( kstEntry ), TRUE );
			break;
		}
		
		case kSetRootButton:
		{
			cell.col = 1;
			
			mServerTable->GetTableSize( numRows, numCols );
			
			for( cell.row = numRows; cell.row >= 1; cell.row-- )
			{
				if( mServerTable->CellIsSelected( cell ) )
				{
					mServerTable->GetCellData( cell, &kstEntry, dataSize );
					kstEntry.flags |= kKeyServerIsRoot;
					mServerTable->SetCellData( cell, &kstEntry, dataSize );
					mServerTable->RefreshCell( cell );
					ConfirmUniqueRoot( cell.row );
					break;
				}
			}
			break;
		}
			
		case kRemoveKeyServerButton:
		{
			cell.col = 1;
			
			mServerTable->GetTableSize( numRows, numCols );
			if( numRows == 1 )
			{
				SysBeep( 1 );
				
				PGPUIWarningAlert( kWACautionAlertType, kWAOKStyle,
							kPreferencesStringListResID,
							kNoServersErrorStrIndex );
			}
			else for( cell.row = numRows; cell.row >= 1; cell.row-- )
			{
				if( mServerTable->CellIsSelected( cell ) )
					mServerTable->RemoveRows( 1, cell.row, TRUE );
			}
			gDialogFlags |= kPGPPrefDialog_ChangedServerList;
			break;
		}
		
		case kEditKeyServerButton:
		{
			cell.col = 1;
			
			mServerTable->GetTableSize( numRows, numCols );
			
			for( cell.row = numRows; cell.row >= 1; cell.row-- )
			{
				if( mServerTable->CellIsSelected( cell ) )
				{
					mServerTable->GetCellData( cell, &kstEntry, dataSize );
					if( IsntPGPError( ServerEntryDialog( &kstEntry ) ) )
						mServerTable->SetCellData( cell, &kstEntry, dataSize );
					break;
				}
			}
			break;
		}
		
		case kMoveUpButton:
		{
			cell = mServerTable->GetFirstSelectedCell();
			mServerTable->GetCellData( cell, &kstEntry, dataSize );
			mServerTable->RemoveRows( 1, cell.row, TRUE );
			cell.row -= 1;
			mServerTable->InsertRows( 1, cell.row - 1, &kstEntry, dataSize, TRUE );
			mServerTable->SelectCell( cell );
			break;
		}
		
		case kMoveDownButton:
		{
			cell = mServerTable->GetFirstSelectedCell();
			mServerTable->GetCellData( cell, &kstEntry, dataSize );
			mServerTable->RemoveRows( 1, cell.row, TRUE );
			cell.row += 1;
			mServerTable->InsertRows( 1, cell.row, &kstEntry, dataSize, TRUE );
			mServerTable->SelectCell( cell );
			break;
		}
		
		case coltable_SelectChange:
		{
			LPushButton	*removeKSButton,
						*editKSButton,
						*moveUpButton,
						*moveDownButton;
			TableIndexT	selRow;
			
			removeKSButton = (LPushButton *)FindPaneByID(
									kRemoveKeyServerButton);
			editKSButton = (LPushButton *)FindPaneByID(
									kEditKeyServerButton);
			moveUpButton = (LPushButton *)FindPaneByID(
									kMoveUpButton);
			moveDownButton = (LPushButton *)FindPaneByID(
									kMoveDownButton);
			mServerTable->GetTableSize( numRows, numCols );
			if( ( selRow = mServerTable->GetTableSelector()->GetFirstSelectedRow() ) > 0 )
			{
				removeKSButton->Enable();
				editKSButton->Enable();
				mSetRootButton->Enable();
				if( selRow > 1 )
					moveUpButton->Enable();
				else
					moveUpButton->Disable();
				if( numRows > selRow )
					moveDownButton->Enable();
				else
					moveDownButton->Disable();
			}
			else
			{
				removeKSButton->Disable();
				editKSButton->Disable();
				mSetRootButton->Disable();
				moveUpButton->Disable();
				moveDownButton->Disable();
			}
			break;
		}
		
		case coltable_DoubleClick:
		{
			cell = *(STableCell *)ioParam;
			
			mServerTable->GetCellData( cell, &kstEntry, dataSize );
			if( IsntPGPError( ServerEntryDialog( &kstEntry ) ) )
				mServerTable->SetCellData( cell, &kstEntry, dataSize );
			break;
		}
	}
}

	void
CPrefPanelServer::FinishCreateSelf()
{
	PGPError	err;
	
	CPreferencePanelView::FinishCreateSelf();

	RegisterClass_( CEditKeyServerGrafPort );
	
	((LPushButton *)FindPaneByID(
		kNewKeyServerButton ))->AddListener(this);
	((LPushButton *)FindPaneByID(
		kRemoveKeyServerButton ))->AddListener(this);
	((LPushButton *)FindPaneByID(
		kEditKeyServerButton  ))->AddListener(this);
	((LPushButton *)FindPaneByID(
		kMoveUpButton  ))->AddListener(this);
	((LPushButton *)FindPaneByID(
		kMoveDownButton  ))->AddListener(this);
	( mSetRootButton = (LPushButton *)FindPaneByID( kSetRootButton ) )->
		AddListener(this);

	SetPrefCheckbox(	kPGPPrefKeyServerSyncUnknownKeys,
						kUnknownEncryptCheckbox);
	SetPrefCheckbox(	kPGPPrefKeyServerSyncOnAdd,
						kAddNamesCheckbox);
	SetPrefCheckbox(	kPGPPrefKeyServerSyncOnKeySign,
						kSignKeysCheckbox);
	SetPrefCheckbox(	kPGPPrefKeyServerSyncOnRevocation,
						kRevokeKeysCheckbox);
	SetPrefCheckbox(	kPGPPrefKeyServerSyncOnVerify,
						kVerifyCheckbox);
	mSetRootButton->Show();
		
	{
		PGPUInt32			ksCount;
		PGPKeyServerEntry	*ksEntries;
		
		err = PGPGetKeyServerPrefs( gClientPrefsRef, &ksEntries, &ksCount);
		pgpAssertNoErr( err );
		mServerTable = (CServerTable *) FindPaneByID(kKeyServerTable);
		mServerTable->AddListener(this);
		for(short inx=0;inx<ksCount;inx++)
		{
			mServerTable->InsertRows( 1, inx + 1, &ksEntries[inx],
								sizeof( PGPKeyServerEntry ), TRUE );
		}
		PGPDisposePrefData( gClientPrefsRef, ksEntries);
	}
	SetLatentSub( mServerTable );
}

#pragma mark --- CPrefPanelAdvanced ---

class CPrefPanelAdvanced :	public CPreferencePanelView,
							public LListener
{
public:

	enum { class_ID = 'vPAd' };
	
					CPrefPanelAdvanced(LStream *inStream);
	virtual			~CPrefPanelAdvanced();
	virtual	void	FinishCreateSelf();
	virtual	void	ListenToMessage(MessageT inMessage, void *ioParam);
	
	void			SavePanel();
private:
	enum
	{
		kPreferredAlgPopup		= 'pAlg',
		kAllowCASTCheckbox		= 'xCAS',
		kAllowIDEACheckbox		= 'xIDE',
		kAllowTripleDESCheckbox	= 'x3DE',
		kMarginalInvalidCheckbox= 'xInv',
		kShowMarginalCheckbox	= 'xMrg',
		kWarnOnMRK				= 'xMRK',
		kExportCompatible		= 'rEFc',
		kExportComplete			= 'rEFo'
	};
};

	static PGPCipherAlgorithm
AlgorithmMenuIndexToPGPCipherAlgorithm(UInt32 menuIndex)
{
	PGPCipherAlgorithm	algorithm;
	
	switch( menuIndex )
	{
		case kIDEAMenuItemIndex:
			algorithm = kPGPCipherAlgorithm_IDEA;
			break;

		case kTripleDESMenuItemIndex:
			algorithm = kPGPCipherAlgorithm_3DES;
			break;

		case kCASTMenuItemIndex:
			algorithm = kPGPCipherAlgorithm_CAST5;
			break;
			
		default:
			pgpDebugMsg(
				"AlgorithmMenuIndexToPGPCipherAlgorithm(): Bad index" );
			algorithm = kPGPCipherAlgorithm_None;
			break;
	}
	
	return( algorithm );
}

	static UInt32
PGPCipherAlgorithmToAlgorithmMenuIndex(PGPCipherAlgorithm algorithm)
{
	UInt32 menuIndex;
	
	switch( algorithm )
	{
		case kPGPCipherAlgorithm_IDEA:
			menuIndex = kIDEAMenuItemIndex;
			break;

		case kPGPCipherAlgorithm_3DES:
			menuIndex = kTripleDESMenuItemIndex;
			break;

		case kPGPCipherAlgorithm_CAST5:
			menuIndex = kCASTMenuItemIndex;
			break;

		default:
			pgpDebugMsg(
				"PGPCipherAlgorithmToAlgorithmMenuIndex(): Bad index" );
			menuIndex = kIDEAMenuItemIndex;
			break;
	}
	
	return( menuIndex );
}

CPrefPanelAdvanced::CPrefPanelAdvanced(LStream *inStream)
	: CPreferencePanelView(inStream)
{
}

CPrefPanelAdvanced::~CPrefPanelAdvanced(void)
{
}

	void
CPrefPanelAdvanced::ListenToMessage(MessageT inMessage, void *ioParam)
{
	(void) ioParam;
	
	switch( inMessage )
	{
		case kAllowCASTCheckbox:
		case kAllowIDEACheckbox:
		case kAllowTripleDESCheckbox:
		{
			if(!(((LCheckBox *)
				FindPaneByID(kAllowCASTCheckbox))->GetValue() +
				((LCheckBox *)
				FindPaneByID(kAllowIDEACheckbox))->GetValue() +
				((LCheckBox *)
				FindPaneByID(kAllowTripleDESCheckbox))->GetValue() ))
			{
				SysBeep( 1 );
				
				PGPUIWarningAlert( kWACautionAlertType, kWAOKStyle,
							kPreferencesStringListResID,
							kNoAlgorithmsErrorStrIndex );
				((LCheckBox *)
					FindPaneByID(kAllowCASTCheckbox))->SetValue(1);
			}
			break;
		}
	}
}

	void
CPrefPanelAdvanced::SavePanel()
{
	PGPInt32			numAlgs = 0;
	PGPCipherAlgorithm	prefCipher;
	PGPSize				dataSize;
	PGPCipherAlgorithm	allowedCiphers[4];
	PGPError			err;
	LRadioButton		*radioButton;
	
	prefCipher = AlgorithmMenuIndexToPGPCipherAlgorithm( ((LPopupButton *)
		FindPaneByID(kPreferredAlgPopup))->GetValue() );
	err = PGPSetPrefNumber( gClientPrefsRef,
				kPGPPrefPreferredAlgorithm, prefCipher);
	pgpAssertNoErr( err );
	
	numAlgs				= 1;
	allowedCiphers[0]	= prefCipher;
	
	if(prefCipher != kPGPCipherAlgorithm_CAST5)
	{
		if(((LCheckBox *)FindPaneByID(kAllowCASTCheckbox))->GetValue())
			allowedCiphers[numAlgs++] = kPGPCipherAlgorithm_CAST5;
	}
	if(prefCipher != kPGPCipherAlgorithm_3DES)
	{
		if(((LCheckBox *)FindPaneByID(kAllowTripleDESCheckbox))->GetValue())
			allowedCiphers[numAlgs++] = kPGPCipherAlgorithm_3DES;
	}
	if(prefCipher != kPGPCipherAlgorithm_IDEA)
	{
		if(((LCheckBox *)FindPaneByID(kAllowIDEACheckbox))->GetValue())
			allowedCiphers[numAlgs++] = kPGPCipherAlgorithm_IDEA;
	}
	dataSize = numAlgs * sizeof(PGPCipherAlgorithm);
	err = PGPSetPrefData( gClientPrefsRef, kPGPPrefAllowedAlgorithmsList,
				dataSize, &allowedCiphers);
	pgpAssertNoErr( err );
	
	GetPrefCheckbox(kMarginalInvalidCheckbox, kPGPPrefMarginalIsInvalid);
	GetPrefCheckbox(kShowMarginalCheckbox, kPGPPrefDisplayMarginalValidity);
	GetPrefCheckbox(kWarnOnMRK, kPGPPrefWarnOnADK);
	
	radioButton = (LRadioButton *) FindPaneByID( kExportCompatible );
	PGPSetPrefBoolean( gClientPrefsRef, kPGPPrefExportKeysCompatible,
						( radioButton->GetValue() == 1 ) );
}

	void
CPrefPanelAdvanced::FinishCreateSelf()
{
	PGPInt32			algIndex;
	PGPUInt32			prefValue;
	PGPSize				dataSize;
	PGPBoolean			compatibleExp;
	PGPCipherAlgorithm	*allowedCiphers;
	PGPError			err;
	LPopupButton		*algPopup;
	LRadioButton		*radioButton;
	
	CPreferencePanelView::FinishCreateSelf();

	((LCheckBox *)FindPaneByID(kAllowIDEACheckbox))->AddListener(this);
	((LCheckBox *)FindPaneByID(kAllowTripleDESCheckbox))->AddListener(this);
	((LCheckBox *)FindPaneByID(kAllowCASTCheckbox))->AddListener(this);

	// kPGPPrefPreferredAlgorithm
	err = PGPGetPrefNumber( gClientPrefsRef, kPGPPrefPreferredAlgorithm, &prefValue);
	pgpAssertNoErr( err );
	
	algPopup = (LPopupButton *) FindPaneByID (kPreferredAlgPopup );
	pgpAssertAddrValid( algPopup, VoidAlign );
	
	algPopup->SetValue( PGPCipherAlgorithmToAlgorithmMenuIndex(
							(PGPCipherAlgorithm) prefValue ) );
	
	// kPGPPrefAllowedAlgorithmsList
	err = PGPGetPrefData( gClientPrefsRef,
				kPGPPrefAllowedAlgorithmsList,
				&dataSize,
				&allowedCiphers);
	if(IsntPGPError(err))
	{
		PGPInt32	numAlgs = dataSize / sizeof(PGPCipherAlgorithm);
		
		for(algIndex = 0; algIndex < numAlgs; algIndex ++)
		{
			switch(allowedCiphers[algIndex])
			{
				case kPGPCipherAlgorithm_IDEA:
					((LCheckBox *)FindPaneByID(kAllowIDEACheckbox))->
						SetValue(1);
					break;
				case kPGPCipherAlgorithm_3DES:
					((LCheckBox *)FindPaneByID(kAllowTripleDESCheckbox))->
						SetValue(1);
					break;
				case kPGPCipherAlgorithm_CAST5:
					((LCheckBox *)FindPaneByID(kAllowCASTCheckbox))->
						SetValue(1);
					break;
			}
		}
		PGPDisposePrefData( gClientPrefsRef, allowedCiphers);
	}
	
	SetPrefCheckbox(kPGPPrefMarginalIsInvalid, kMarginalInvalidCheckbox);
	SetPrefCheckbox(kPGPPrefDisplayMarginalValidity, kShowMarginalCheckbox);
	SetPrefCheckbox(kPGPPrefWarnOnADK, kWarnOnMRK);
	
	PGPGetPrefBoolean( gClientPrefsRef, kPGPPrefExportKeysCompatible,
						&compatibleExp );
	if( compatibleExp )
	{
		radioButton = (LRadioButton *) FindPaneByID( kExportCompatible );
		pgpAssertAddrValid( radioButton, VoidAlign );

		radioButton->SetValue( 1 );
	}
	else
	{
		radioButton = (LRadioButton *) FindPaneByID( kExportComplete );
		pgpAssertAddrValid( radioButton, VoidAlign );

		radioButton->SetValue( 1 );
	}
}

#pragma mark --- CPrefPanelCA ---

class CPrefPanelCA :		public CPreferencePanelView,
							public LListener
{
public:

	enum { class_ID = 'vPCA' };
	
					CPrefPanelCA(LStream *inStream);
	virtual			~CPrefPanelCA();
	virtual	void	FinishCreateSelf();
	virtual	void	ListenToMessage(MessageT inMessage, void *ioParam);
	
	void			SavePanel();
private:
	PGPKeyRef		m509AuthKey;
	PGPSigRef		m509AuthCert;
	
	enum
	{
		kCAURLEdit			= 'eURL',
		kCACRLURLEdit		= 'eCRL',
		kCATypePopup		= 'pCAT',
		kCARootCertCaption	= 'cCer',
		kClearCertButton	= 'bClr',
		kSelectCertButton	= 'bSel',
		kX509Icon			= 'i509'	
	};
};

CPrefPanelCA::CPrefPanelCA(LStream *inStream)
	: CPreferencePanelView(inStream)
{
	m509AuthKey		= kInvalidPGPKeyRef;
	m509AuthCert	= kInvalidPGPSigRef;
}

CPrefPanelCA::~CPrefPanelCA(void)
{
}

	void
CPrefPanelCA::SavePanel()
{
	PGPError	err;
	PGPUInt32	num;
	Str255		str;
	char		cstr[256];
	PGPKeyID	keyID;
	PGPUInt32	alg = kPGPPublicKeyAlgorithm_DSA;
	PGPSize		len;
	PGPUInt32	iasnSize = 0;
	PGPByte *	iasn;
	
	num = ( (LPopupButton *)FindPaneByID( kCATypePopup ) )->GetValue() + 1;
	err = PGPSetPrefNumber( gClientPrefsRef, kPGPPrefCAType, num);
	pgpAssertNoErr( err );
	
	( (LPopupButton *)FindPaneByID( kCAURLEdit ) )->GetDescriptor( str );
	PToCString( str, cstr );
	PGPSetPrefString( gClientPrefsRef, kPGPPrefCAServerURL, cstr );
	if( str[str[0]] == '/' )
		PGPUIWarningAlert( kWACautionAlertType, kWAOKStyle,
					kPreferencesStringListResID,
					kCAEndsInSlashErrorStrIndex );
	
	( (LPopupButton *)FindPaneByID( kCACRLURLEdit ) )->GetDescriptor( str );
	PToCString( str, cstr );
	PGPSetPrefString( gClientPrefsRef, kPGPPrefCARevocationServerURL, cstr );
	
	pgpClearMemory( &keyID, sizeof(PGPKeyID) );
	if( PGPSigRefIsValid( m509AuthCert ) )
	{
		if( IsntPGPError( PGPX509CertToExport( gContext,
								m509AuthKey, m509AuthCert,
								&alg, (PGPByte *)&keyID,
								&iasn, &iasnSize ) ) )
		{
			PGPSetPrefNumber( gClientPrefsRef,
				kPGPPrefCARootKeyAlg, alg );
			PGPSetPrefData( gClientPrefsRef,
				kPGPPrefCARootX509IASN, iasnSize, iasn );
			len = sizeof(PGPKeyID);
			PGPSetPrefData( gClientPrefsRef,
				kPGPPrefCARootKeyID, len, &keyID );
			PGPFreeData( iasn );
		}
	}
	else
		PGPRemovePref( gClientPrefsRef, kPGPPrefCARootKeyID );
}

	void
CPrefPanelCA::FinishCreateSelf()
{
	PGPError	err;
	PGPSize		strLen;
	Str255		str;
	char		cstr[256];
	PGPUInt32	num;
	PGPByte *	keyID = NULL;
	PGPUInt32	iasnSize;
	PGPByte *	iasn = NULL;
	PGPUInt32	algNum;
	
	CPreferencePanelView::FinishCreateSelf();
	
	strLen = 256;
	err = PGPGetPrefStringBuffer( gClientPrefsRef, 
		kPGPPrefCAServerURL, strLen, cstr);
	pgpAssertNoErr( err );
	CToPString( cstr, str );
	( (LEditText *)FindPaneByID( kCAURLEdit ) )->SetDescriptor( str );
	err = PGPGetPrefStringBuffer( gClientPrefsRef,
		kPGPPrefCARevocationServerURL, strLen, cstr);
	pgpAssertNoErr( err );
	CToPString( cstr, str );
	( (LEditText *)FindPaneByID( kCACRLURLEdit ) )->SetDescriptor( str );
	err = PGPGetPrefNumber( gClientPrefsRef, kPGPPrefCAType, &num );
	pgpAssertNoErr( err );
	( (LPopupButton *)FindPaneByID( kCATypePopup ) )->SetValue( num - 1 );
	
	PGPGetPrefData( gClientPrefsRef,
			kPGPPrefCARootKeyID,
			&strLen, &keyID );
	PGPGetPrefNumber( gClientPrefsRef,
			kPGPPrefCARootKeyAlg, &algNum );
	PGPGetPrefData( gClientPrefsRef,
			kPGPPrefCARootX509IASN,
			(PGPSize *)&iasnSize, &iasn );
	if( IsntNull( iasn ) && IsntNull( keyID ) )
	{
		err = PGPX509CertFromExport( gContext,
					algNum, keyID, iasn, iasnSize,
					gAllKeysRef,
					&m509AuthKey, &m509AuthCert );
		if( IsntPGPError( err ) )
		{
			Str255		pstr;
			char		cstr[256];
			PGPSize		strSize = sizeof(cstr) - 1;
			
			PGPGetSigPropertyBuffer( m509AuthCert,
					kPGPSigPropX509LongName, strSize,
					(char *)&cstr, &strSize );
			cstr[strSize] = '\0';
			CToPString( cstr, pstr );
			FindPaneByID(kCARootCertCaption)->
				SetDescriptor( pstr );
			( (LIconPane *) FindPaneByID( kX509Icon ) )->
				Show();
		}
	}
	if( IsntNull( iasn ) )
		PGPFreeData( iasn );
	if( IsntNull( keyID ) )
		PGPFreeData( keyID );
	
	( (LPushButton *)FindPaneByID( kSelectCertButton ) )->AddListener(this);
	( (LPushButton *)FindPaneByID( kClearCertButton ) )->AddListener(this);
}

	void
CPrefPanelCA::ListenToMessage(
	MessageT	inMessage,
	void		*)
{
	PGPError	err;
	
	switch( inMessage )
	{
		case kSelectCertButton:
		{
			PGPKeySetRef	selSet;
			PGPKeyRef		selKey;
			PGPSigRef		selCert;
			
			err = PGPSelect509Dialog( gContext,
					kPGPSelect509CAOnly, NULL, gAllKeysRef,
					&selSet, &selKey, &selCert );
			if( IsntPGPError( err ) )
			{
				Str255		pstr;
				char		cstr[256];
				PGPSize		strSize = sizeof(cstr) - 1;
				
				err = PGPGetSigPropertyBuffer( selCert,
							kPGPSigPropX509LongName, strSize,
							(char *)&cstr, &strSize );
				cstr[strSize] = '\0';
				CToPString( cstr, pstr );
				FindPaneByID( kCARootCertCaption )->SetDescriptor( pstr );
				( (LIconPane *) FindPaneByID( kX509Icon ) )->Show();
				
				m509AuthKey		= selKey;
				m509AuthCert	= selCert;
				
				PGPFreeKeySet( selSet );
			}
			break;
		}
		case kClearCertButton:
			FindPaneByID( kCARootCertCaption )->SetDescriptor( "\p" );
			( (LIconPane *) FindPaneByID( kX509Icon ) )->Hide();
			m509AuthKey		= kInvalidPGPKeyRef;
			m509AuthCert	= kInvalidPGPSigRef;
			break;
	}
}

#pragma mark --- CPGPPreferencesGrafPortView ---

CPGPPreferencesGrafPortView::CPGPPreferencesGrafPortView(LStream *inStream)
	: CPGPModalGrafPortView(inStream)
{
	RegisterClass_( CPrefPanelGeneral );
	RegisterClass_( CPrefPanelFiles );
	RegisterClass_( CPrefPanelEmail );
	RegisterClass_( CPrefPanelPGPmenu );
	RegisterClass_( CPrefPanelServer );
	RegisterClass_( CPrefPanelAdvanced );
	RegisterClass_( CPrefPanelCA );
	
	mWindowIsMoveable = TRUE;
}

CPGPPreferencesGrafPortView::~CPGPPreferencesGrafPortView()
{
}

	void
CPGPPreferencesGrafPortView::FinishCreateSelf()
{
	UInt16	numPanels;

	CPGPModalGrafPortView::FinishCreateSelf();
	
	mMultiView = (LMultiPanelView *) FindPaneByID(kMultiPanelView);
	pgpAssertAddrValid( mMultiView, VoidAlign );
	
	mMultiView->AddPanel( kGeneralPanelViewResID, NULL, kGeneralPanelViewIndex );
	mMultiView->AddPanel( kFilesPanelViewResID, NULL, kFilesPanelViewIndex );
	mMultiView->AddPanel( kEmailPanelViewResID, NULL, kEmailPanelViewIndex );
	mMultiView->AddPanel( kPGPmenuPanelViewResID, NULL, kPGPmenuPanelViewIndex );
	mMultiView->AddPanel( kServerPanelViewResID, NULL, kServerPanelViewIndex );
	mMultiView->AddPanel( kCAPanelViewResID, NULL, kCAPanelViewIndex );
	mMultiView->AddPanel( kAdvancedPanelViewResID, NULL, kAdvancedPanelViewIndex );

	// Force creation of all panels so we can control the LCommander hierarchy
	
	numPanels = mMultiView->GetPanelCount();
	for( UInt16 panelIndex = 1; panelIndex <= numPanels; panelIndex++ )
	{
		CPreferencePanelView	*theView;
		
		LCommander::SetDefaultCommander( mMultiView );
		LPane::SetDefaultView( mMultiView );
		
		theView = (CPreferencePanelView *) mMultiView->CreatePanel( panelIndex );
	}

	mMultiView->SwitchToPanel( kGeneralPanelViewIndex, FALSE );
}

	MessageT
CPGPPreferencesGrafPortView::HandleMessage(MessageT theMessage)
{
	Boolean	save = FALSE;
	
	theMessage = CPGPModalGrafPortView::HandleMessage( theMessage );
	
	switch( theMessage )
	{
		case msg_OK:
			save = TRUE;
			/* Fall through */
		
		case msg_Cancel:
		{
			CPrefPanelGeneral	*generalView;
			CPrefPanelFiles		*filesView;
			CPrefPanelEmail		*emailView;
			CPrefPanelPGPmenu	*pgpMenuView;
			CPrefPanelServer	*serverView;
			CPrefPanelAdvanced	*advancedView;
			CPrefPanelCA		*caView;
			
			Hide();

			advancedView = (CPrefPanelAdvanced *)
				mMultiView->RemovePanel(kAdvancedPanelViewIndex);
			if(IsntNull(advancedView) && save)
				advancedView->SavePanel();
			delete advancedView;

			caView = (CPrefPanelCA *)
				mMultiView->RemovePanel(kCAPanelViewIndex);
			if(IsntNull(caView) && save)
				caView->SavePanel();
			delete caView;

			serverView = (CPrefPanelServer *)
				mMultiView->RemovePanel(kServerPanelViewIndex);
			if(IsntNull(serverView) && save)
				serverView->SavePanel();
			delete serverView;

			pgpMenuView = (CPrefPanelPGPmenu *)
				mMultiView->RemovePanel(kPGPmenuPanelViewIndex);
			if(IsntNull(pgpMenuView) && save)
				pgpMenuView->SavePanel();
			delete pgpMenuView;

			emailView = (CPrefPanelEmail *)
				mMultiView->RemovePanel(kEmailPanelViewIndex);
			if(IsntNull(emailView) && save)
				emailView->SavePanel();
			delete emailView;

			filesView = (CPrefPanelFiles *)
				mMultiView->RemovePanel(kFilesPanelViewIndex);
			if(IsntNull(filesView) && save)
				filesView->SavePanel();
			delete filesView;

			generalView = (CPrefPanelGeneral *)
				mMultiView->RemovePanel(kGeneralPanelViewIndex);
			if(IsntNull(generalView) && save)
				generalView->SavePanel();
			delete generalView;
			
			
			if( save )
			{
				PGPIncPGPPrefsUpdateCount();
				PGPSavePrefFile( gClientPrefsRef );
				PGPsdkSavePrefs( gContext );
			}
			
			break;
		}
	}

	return( theMessage );
}
