/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPnetService.cp,v 1.65.4.2 1999/06/16 03:49:11 wprice Exp $
____________________________________________________________________________*/
#include <OpenTptInternet.h>
#include <Power.h>
#include "PGPnetService.h"
#include "PGPnetOT.h"
#include "PGPnetOpenPrefs.h"
#include "PGPnetIPC.h"
#include "pgpIKE.h"
#include "MacEvents.h"
#include "pgpKeys.h"
#include "pgpUtilities.h"
#include "pgpMem.h"
#include "pgpSDKPrefs.h"
#include "pgpNetPrefs.h"
#include "pgpRandomPool.h"
#include "pflPrefTypes.h"
#include "pgpClientLib.h"
#include "pgpIPsecErrors.h"
#include "pgpMacCustomContextAlloc.h"
#include "MacProcesses.h"
#include "MacDesktop.h"

#include <string.h>

#define			kSleepUnconnected				60
#define			kSleepConnectedNoSA				15
#define			kSleepConnected					1
#define			kIKEIdleTicks					30
#define			kSeedRandomTicks				60
const PGPUInt32	kMinimumOTVersion				= 0x01300000;

Boolean					gQuitFlag = FALSE;
Str255					gNotifyStr;
Boolean					gGo = TRUE;
Boolean					gOn = TRUE;
NMRec					gNMRec;
PGPContextRef			gPGPContext = NULL;
PGPMemoryMgrRef			gMemoryMgr = kInvalidPGPMemoryMgrRef;
PGPikeContextRef		gIKEContext = kInvalidPGPikeContextRef;
PGPPrefRef				gNetPrefs = kInvalidPGPPrefRef;
PGPNetPrefHostEntry *	gHosts = NULL;
PGPUInt32				gNumHosts;
PGPUInt32				gSAIIndex = 0;
PGPBoolean				gAllowUnconfigured = TRUE;
PGPBoolean				gRequireSecure = FALSE;
PGPBoolean				gRequireValidKey = TRUE;
PGPBoolean				gCache = FALSE;
PGPBoolean				gSleepWatch = FALSE;
EndpointRef				gEndpoint = kOTInvalidEndpointRef;
PGPByte *				gInPacket = NULL;
PGPSize					gInPacketLen;
PGPUInt32				gInPacketAddr;
PGPUInt32				gLocalIP = 0;
PGPBoolean				gAppIsOpen = FALSE;
PGPikeSAInfo *			gSAs = NULL;
StreamRef				gModuleStream = kOTInvalidStreamRef;
SleepQRec				gSleepRec;
PGPKeySetRef			gKeyring = kInvalidPGPKeySetRef;
PGPByte *				gGP = NULL;
char *					gPGPPassphrase = NULL;
char *					g509Passphrase = NULL;

PGPError PGPnetIKEMessage(
				PGPikeContextRef	ike,
				void *				inUserData,
				PGPikeMessageType	msg,
				void *				data );
void InitRequiredAE(void);
pascal OSErr DoAEOpenApplication(AppleEvent * theAppleEvent,
				AppleEvent * replyAppleEvent, 
				long refCon);
pascal OSErr DoAEOpenDocuments(AppleEvent * theAppleEvent,
				AppleEvent * replyAppleEvent, 
				long refCon);
pascal OSErr DoAEPrintDocuments(AppleEvent * theAppleEvent,
				AppleEvent * replyAppleEvent, 
				long refCon);
pascal OSErr DoAEQuitApplication(AppleEvent * theAppleEvent,
				AppleEvent * replyAppleEvent, 
				long refCon);
void DoHighLevelEvent(EventRecord * event);
void RealMain();
void EventIdle();

	pascal OSErr
DoAEOpenApplication(AppleEvent * theAppleEvent,
					AppleEvent * replyAppleEvent, 
					long refCon)
{
#pragma unused (theAppleEvent, replyAppleEvent, refCon)
	return noErr;
}

	pascal OSErr
DoAEOpenDocuments(AppleEvent * theAppleEvent,
                   AppleEvent * replyAppleEvent, 
                   long refCon)
{
#pragma unused (theAppleEvent, replyAppleEvent, refCon)
	return errAEEventNotHandled;
}

	pascal OSErr
DoAEPrintDocuments(AppleEvent * theAppleEvent,
                    AppleEvent * replyAppleEvent, 
                    long refCon)
{
#pragma unused (theAppleEvent, replyAppleEvent, refCon)
	return errAEEventNotHandled;
}

	pascal OSErr
DoAEQuitApplication(AppleEvent * theAppleEvent,
                     AppleEvent * replyAppleEvent, 
                     long refCon)
{
#pragma unused (theAppleEvent, replyAppleEvent, refCon)
	gQuitFlag = true;
	return noErr;
}

	static Boolean
PowerManagerExists()
{
	Boolean routinesExist = false;
	long	pmgrAttributes;
	
	if( Gestalt( gestaltPowerMgrAttr, &pmgrAttributes ) == noErr )
		if( pmgrAttributes & ( 1<<gestaltPMgrDispatchExists ) )
			routinesExist = true;
	return routinesExist;
}

	void
SendHostsToModule()
{
	OSStatus	status;
	
	if( gModuleStream != kOTInvalidStreamRef )
	{
		PGPnetModuleMsg *	msg;
		PGPUInt32			msgLen;
		
		msgLen = sizeof(PGPNetPrefHostEntry) * gNumHosts + sizeof(PGPnetModuleHostsMsg);
		msg = (PGPnetModuleMsg *)PGPNewData( gMemoryMgr, msgLen, 0 );
		if( IsntNull( msg ) )
		{
			msg->type					= kPGPnetModuleHostsMsg;
			msg->hosts.numHosts			= gNumHosts;
			if( IsntNull( gHosts ) )
				pgpCopyMemory( gHosts, msg->hosts.host,
					sizeof(PGPNetPrefHostEntry) * gNumHosts );
			status = PGPnetModuleSendMessage( gModuleStream, msg, msgLen );
			LogIfOSStatus( status );
			PGPFreeData( msg );
		}
		else
			LogIfPGPError( kPGPError_OutOfMemory );
	}
}

	void
LoadPrefs()
{
	PGPError	err = kPGPError_NoErr;
	
	if( PGPPrefRefIsValid( gNetPrefs ) )
	{
		PGPClosePrefFile( gNetPrefs );
		gNetPrefs = kInvalidPGPPrefRef;
	}
	err = PGPnetOpenPrefs( gMemoryMgr, &gNetPrefs );
	if( IsntPGPError( err ) )
	{
		PGPikeMTPref					pref;
		PGPUInt32						numPref;
		PGPNetPrefIKEProposalEntry *	ikeProps;
		PGPNetPrefIPSECProposalEntry *	ipsecProps;
		PGPUInt32						numProps;
		PGPBoolean						enableExp;
		OSStatus						status;
		
		PGPGetPrefBoolean( gNetPrefs, kPGPNetPrefEnablePGPnet, &gOn );
		PGPGetPrefBoolean( gNetPrefs, kPGPNetPrefAllowUnconfiguredHosts,
			&gAllowUnconfigured );
		PGPGetPrefBoolean( gNetPrefs, kPGPNetPrefRequireValidKey,
			&gRequireValidKey );
		PGPGetPrefBoolean( gNetPrefs, kPGPNetPrefRequireSecure,
			&gRequireSecure );
		PGPGetPrefBoolean( gNetPrefs, kPGPNetPrefEnablePassphraseCache, &gCache );
		gCache = TRUE;	// hardwire this, it is not an option in the GUI
		if( gModuleStream != kOTInvalidStreamRef )
		{
			PGPnetModuleMsg	msg;
			
			msg.type					= kPGPnetModulePrefsMsg;
			msg.prefs.enabled			= gOn;
			msg.prefs.allowUnconfigured	= gAllowUnconfigured;
			msg.prefs.requireSecure		= gRequireSecure;
			status = PGPnetModuleSendMessage( gModuleStream, &msg,
						sizeof(PGPnetModulePrefsMsg) );
			LogIfOSStatus( status );
		}

		if( IsntNull( gHosts ) )
		{
			PGPFreeData( gHosts );
			gHosts = NULL;
		}
		err = PGPGetNetHostPrefs( gNetPrefs, &gHosts, &gNumHosts );
		LogIfPGPError( err );
		SendHostsToModule();
		
		pref.pref							= kPGPike_PF_Expiration;
		PGPGetPrefBoolean( gNetPrefs,
			kPGPNetPrefEnableIKEKByteExpiration, &enableExp );
		if( enableExp )
		{
			PGPGetPrefNumber( gNetPrefs,
				kPGPNetPrefIKEKByteExpiration, &numPref );
			pref.u.expiration.kbLifeTimeIKE		= numPref;
		}
		else
			pref.u.expiration.kbLifeTimeIKE		= 0;
		PGPGetPrefBoolean( gNetPrefs,
			kPGPNetPrefEnableIKETimeExpiration, &enableExp );
		if( enableExp )
		{
			PGPGetPrefNumber( gNetPrefs,
				kPGPNetPrefIKETimeExpiration, &numPref );
			pref.u.expiration.secLifeTimeIKE	= numPref;
		}
		else
			pref.u.expiration.secLifeTimeIKE	= 0;
		PGPGetPrefBoolean( gNetPrefs,
			kPGPNetPrefEnableIPSECKByteExpiration, &enableExp );
		if( enableExp )
		{
			PGPGetPrefNumber( gNetPrefs,
				kPGPNetPrefIPSECKByteExpiration, &numPref );
			pref.u.expiration.kbLifeTimeIPSEC	= numPref;
		}
		else
			pref.u.expiration.kbLifeTimeIPSEC	= 0;
		PGPGetPrefBoolean( gNetPrefs,
			kPGPNetPrefEnableIPSECTimeExpiration, &enableExp );
		if( enableExp )
		{
			PGPGetPrefNumber( gNetPrefs,
				kPGPNetPrefIPSECTimeExpiration, &numPref );
			pref.u.expiration.secLifeTimeIPSEC	= numPref;
		}
		else
			pref.u.expiration.secLifeTimeIPSEC	= 0;
		err = PGPikeProcessMessage( gIKEContext, kPGPike_MT_Pref, &pref );
		LogIfPGPError( err );
		
		pref.pref							= kPGPike_PF_AllowedAlgorithms;
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowCipherCAST,
			&pref.u.allowedAlgorithms.cast5 );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowCipher3DES,
			&pref.u.allowedAlgorithms.tripleDES );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowCipherDES56,
			&pref.u.allowedAlgorithms.singleDES );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowCipherNone,
			&pref.u.allowedAlgorithms.espNULL );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowHashSHA1,
			&pref.u.allowedAlgorithms.sha1 );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowHashMD5,
			&pref.u.allowedAlgorithms.md5 );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowHashNone,
			&pref.u.allowedAlgorithms.noAuth );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowCompLZS,
			&pref.u.allowedAlgorithms.lzs );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowCompDeflate,
			&pref.u.allowedAlgorithms.deflate );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowDH768,
			&pref.u.allowedAlgorithms.modpOne768 );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowDH1024,
			&pref.u.allowedAlgorithms.modpTwo1024 );
		PGPGetPrefBoolean(gNetPrefs, kPGPNetPrefAllowDH1536,
			&pref.u.allowedAlgorithms.modpFive1536 );
		err = PGPikeProcessMessage( gIKEContext, kPGPike_MT_Pref, &pref );
		LogIfPGPError( err );
		
		err = PGPGetNetIKEProposalPrefs( gNetPrefs, &ikeProps, &numProps );
		pgpAssert( IsntNull( ikeProps ) );
		if( IsntPGPError( err ) )
		{
			PGPikeTransform *	ikeTrans;
			
			ikeTrans = (PGPikeTransform *)PGPNewData( gMemoryMgr,
							sizeof(PGPikeTransform) * numProps,
							kPGPMemoryMgrFlags_Clear );
			if( IsntNull( ikeTrans ) )
			{
				PGPUInt32	propIndex;
				
				for( propIndex = 0; propIndex < numProps; propIndex++ )
				{
					ikeTrans[propIndex].authMethod	= ikeProps[propIndex].authMethod;
					ikeTrans[propIndex].hash		= ikeProps[propIndex].hash;
					ikeTrans[propIndex].cipher		= ikeProps[propIndex].cipher;
					ikeTrans[propIndex].modpGroup	= TRUE;
					ikeTrans[propIndex].groupID		= ikeProps[propIndex].groupID;
				}
				pref.pref							= kPGPike_PF_IKEProposals;
				pref.u.ikeProposals.t				= ikeTrans;
				pref.u.ikeProposals.numTransforms	= numProps;
				err = PGPikeProcessMessage( gIKEContext, kPGPike_MT_Pref, &pref );
				LogIfPGPError( err );
				(void)PGPFreeData( ikeTrans );
			}
			else
			{
				pgpAssert( IsntNull( ikeTrans ) );
			}
			(void)PGPFreeData( ikeProps );
		}
		PGPGetPrefNumber( gNetPrefs, kPGPnetPrefIPSECGroupID, &numPref );
		err = PGPGetNetIPSECProposalPrefs( gNetPrefs, &ipsecProps, &numProps );
		pgpAssert( IsntNull( ipsecProps ) );
		if( IsntPGPError( err ) )
		{
			PGPipsecTransform *	ipsecTrans;
			
			ipsecTrans = (PGPipsecTransform *)PGPNewData( gMemoryMgr,
							sizeof(PGPipsecTransform) * numProps,
							kPGPMemoryMgrFlags_Clear );
			if( IsntNull( ipsecTrans ) )
			{
				PGPUInt32	propIndex;
				
				for( propIndex = 0; propIndex < numProps; propIndex++ )
				{
					ipsecTrans[propIndex].useESP	= ipsecProps[propIndex].useESP;
					ipsecTrans[propIndex].useAH		= ipsecProps[propIndex].useAH;
					ipsecTrans[propIndex].useIPCOMP	= ipsecProps[propIndex].useIPCOMP;
					ipsecTrans[propIndex].groupID	= (PGPikeGroupID)numPref;
					
					ipsecTrans[propIndex].esp.cipher	=
						ipsecProps[propIndex].espCipher;
					ipsecTrans[propIndex].esp.authAttr	=
						ipsecProps[propIndex].espHash;
					ipsecTrans[propIndex].ah.authAlg	=
						ipsecProps[propIndex].ahAuthAlg;
					ipsecTrans[propIndex].ah.authAttr	=
						ipsecProps[propIndex].ahHash;
					ipsecTrans[propIndex].ipcomp.compAlg=
						ipsecProps[propIndex].ipcomp;
				}
				pref.pref							= kPGPike_PF_IPSECProposals;
				pref.u.ipsecProposals.t				= ipsecTrans;
				pref.u.ipsecProposals.numTransforms	= numProps;
				err = PGPikeProcessMessage( gIKEContext, kPGPike_MT_Pref, &pref );
				LogIfPGPError( err );
				(void)PGPFreeData( ipsecTrans );
			}
			else
			{
				pgpAssert( IsntNull( ipsecTrans ) );
			}
			(void)PGPFreeData( ipsecProps );
		}
		
		// Make sure we have the passphrases
		if( gOn )
		{
			PGPKeyRef	key;
			PGPSigRef	cert;
			PGPBoolean	needPhrase;
			OSStatus	appOpen = 0;
			PGPBoolean	launchForPGP = FALSE,
						launchFor509 = FALSE;
			
			key = PGPnetGetLocalPGPAuthKey();
			if( PGPKeyRefIsValid( key ) )
			{
				PGPGetKeyBoolean( key, kPGPKeyPropNeedsPassphrase, &needPhrase );
				if( needPhrase && ( IsNull( gPGPPassphrase ) ||
					!PGPPassphraseIsValid( key,
						PGPOPassphrase( gPGPContext, gPGPPassphrase ),
						PGPOLastOption( gPGPContext ) ) ) )
				{
					launchForPGP = TRUE;
				}
			}
			else if( IsntNull( gPGPPassphrase ) )
			{
				PGPFreeData( gPGPPassphrase );
				gPGPPassphrase = NULL;
			}
			key = PGPnetGetLocalX509AuthKey( &cert );
			if( PGPKeyRefIsValid( key ) )
			{
				PGPGetKeyBoolean( key, kPGPKeyPropNeedsPassphrase, &needPhrase );
				if( needPhrase && ( IsNull( g509Passphrase ) ||
					!PGPPassphraseIsValid( key,
						PGPOPassphrase( gPGPContext, g509Passphrase ),
						PGPOLastOption( gPGPContext ) ) ) )
				{
					launchFor509 = TRUE;
				}
			}
			else if( IsntNull( g509Passphrase ) )
			{
				PGPFreeData( g509Passphrase );
				g509Passphrase = NULL;
			}
			if( launchForPGP || launchFor509 )
			{
				if( ( appOpen = MakeSureAppIsOpen() ) >= 0 )
				{
					PGPBoolean	appOld = gAppIsOpen;
					UInt32		eventID;
					
					gAppIsOpen = TRUE;
					if( launchForPGP )
					{
						if( ( appOpen == 1 ) && !launchFor509 )
							eventID = kPGPnetHLEvent_NeedPhrasePGPQ;
						else
							eventID = kPGPnetHLEvent_NeedPhrasePGP;
						PostPNEvent( eventID );
					}
					if( launchFor509 )
					{
						if( appOpen == 1 )
							eventID = kPGPnetHLEvent_NeedPhraseX509Q;
						else
							eventID = kPGPnetHLEvent_NeedPhraseX509;
						PostPNEvent( eventID );
					}
					gAppIsOpen = appOld;
				}
			}
		}
	}
}

	OSStatus
MakeSureAppIsOpen()
{
	OSStatus			status = 0;
	ProcessSerialNumber	appPSN;
	FSSpec				appSpec;
	
	if( FindProcess( 'APPL', kPGPnetAppID, &appPSN, nil, nil, nil ) )
		goto done;
	if( FindApplication( 'APPL', kPGPnetAppID, kFindAppOnLocalVolumes, &appSpec ) )
	{
		LaunchParamBlockRec	launchPB;

		pgpClearMemory( &launchPB, sizeof( launchPB ) );
	
		launchPB.launchBlockID			= extendedBlock;
		launchPB.launchEPBLength		= extendedBlockLen;
		launchPB.launchFileFlags		= 0;
		launchPB.launchControlFlags		= launchContinue | launchNoFileFlags;
		launchPB.launchAppSpec			= &appSpec;
		launchPB.launchAppParameters	= nil;
		
		status = LaunchApplication( &launchPB );
		if( IsntErr( status ) )
			status = 1;
	}
	else
		status = -1;
done:
	return status;
}

	void
DoHighLevelEvent(EventRecord * event)
{
	if( event->message == kPGPnetHLEventClass )
	{
		OSErr			err;
		TargetID		source;
		UInt32			refCon;
		UInt32			length = 0;
		char *			buff = NULL;
		
		err = AcceptHighLevelEvent( &source, &refCon, NULL, &length );
		if( err == bufferIsSmall )
		{
			buff = (char *)PGPNewData( gMemoryMgr, length, 0 );
			if( IsntNull( buff ) )
			{
				err = AcceptHighLevelEvent( &source, &refCon, buff, &length );
				pgpAssertNoErr( err );
			}
		}
		pgpAssertNoErr( err );
		if( IsntErr( err ) )
		{
			UInt32			msgType;
			
			msgType = (unsigned long)event->where.v << 16;
			msgType |= event->where.h;
			
			switch( msgType )
			{
				case kPGPnetHLEvent_AppStartup:
				{
					PGPikeSAInfo *		sai;
					PGPUInt32			saCount = 0;
					
					gAppIsOpen	= TRUE;
					for( sai = gSAs; IsntNull( sai ); sai = sai->next )
						saCount++;
					if( saCount )
					{
						PGPikeSA *	flatSAs;
						
						flatSAs = (PGPikeSA *)PGPNewData( gMemoryMgr,
										saCount * sizeof(PGPikeSA), 0 );
						if( IsntNull( flatSAs ) )
						{
							for(saCount = 0,sai = gSAs;IsntNull( sai );sai = sai->next )
							{
								pgpCopyMemory( sai->sa, &flatSAs[saCount],
									sizeof(PGPikeSA) );
								saCount++;
							}
							PostPNEvent( kPGPnetHLEvent_StatusFull, flatSAs,
								sizeof(PGPikeSA) * saCount );
							PGPFreeData( flatSAs );
						}
						else
							LogIfPGPError( kPGPError_OutOfMemory );
					}
					break;
				}
				case kPGPnetHLEvent_AppShutdown:
					gAppIsOpen	= FALSE;
					break;
				case kPGPnetHLEvent_UpdateConfig:
					LoadPrefs();
					break;
				case kPGPnetHLEvent_KeyringUpdate:
					PGPnetCloseKeyring();
					break;
				case kPGPnetHLEvent_RemoveSA:
				{
					PGPikeSAInfo *	sai;
					PGPikeSA *		sa = (PGPikeSA *)buff;
					
					if( IsntNull( sai = FindSAIData( sa ) ) )
					{
					 	err = PGPikeProcessMessage( gIKEContext,
					 			kPGPike_MT_SADied, sai->sa );
					 	LogIfPGPError( err );
						RemoveSAI( sai->sa );
					}
					break;
				}
				case kPGPnetHLEvent_RequestSA:
				 	RequestSA( *(PGPInt32 *)buff, 0 );
				 	break;
				case kPGPnetHLEvent_ClearPhrasePGP:
					if( IsntNull( gPGPPassphrase ) )
						PGPFreeData( gPGPPassphrase );
					gPGPPassphrase = NULL;
					break;
				case kPGPnetHLEvent_ClearPhrase509:
					if( IsntNull( g509Passphrase ) )
						PGPFreeData( g509Passphrase );
					g509Passphrase = NULL;
					break;
				case kPGPnetHLEvent_PhrasePGP:
					if( IsntNull( gPGPPassphrase ) )
						PGPFreeData( gPGPPassphrase );
					gPGPPassphrase = NULL;
					gPGPPassphrase = (char *)PGPNewSecureData( gMemoryMgr,
						length, kPGPMemoryMgrFlags_Clear );
					if( IsntNull( gPGPPassphrase ) )
						pgpCopyMemory( buff, gPGPPassphrase, length );
					break;
				case kPGPnetHLEvent_Phrase509:
					if( IsntNull( g509Passphrase ) )
						PGPFreeData( g509Passphrase );
					g509Passphrase = NULL;
					g509Passphrase = (char *)PGPNewSecureData( gMemoryMgr,
						length, kPGPMemoryMgrFlags_Clear );
					if( IsntNull( g509Passphrase ) )
						pgpCopyMemory( buff, g509Passphrase, length );
					break;
				case kPGPnetHLEvent_ClearLog:
				{
					PGPnetLogRef		logRef;
					PGPError			err;
					
					err = PGPnetOpenLog( gMemoryMgr, TRUE, &logRef );
					if( IsntPGPError( err ) )
					{
						err = PGPnetClearLogFile( logRef );
						(void)PGPnetCloseLogFile( logRef );
					}
					pgpAssertNoErr( err );
					break;
				}
			}
		}
		if( IsntNull( buff ) )
			PGPFreeData( buff );
	}
	else
		(void) AEProcessAppleEvent( event );
}

	void
RequestSA(
	PGPInt32		hostIndex,
	PGPUInt32		destIP )
{
 	PGPError		err = kPGPError_NoErr;
 	PGPikeMTSASetup sas;
 	PGPInt32		destIndex = -1,
 					ipConvert;
	PGPByte *		dn = NULL;
	PGPSize			dnLen;
 	
 	if( IsNull( gHosts ) || !gOn )
 		return;
 	if( gHosts[hostIndex].childOf >= 0 )
 	{
 		destIndex = hostIndex;
 		hostIndex = gHosts[destIndex].childOf;
 	}
 	if( gHosts[hostIndex].hostType == kPGPnetInsecureHost )
 		return;
 	pgpClearMemory( &sas, sizeof( PGPikeMTSASetup ) );
 	PNOpenEndpoint( TRUE );
 	sas.localIPAddress		= gLocalIP;
 	sas.doi					= kPGPike_DOI_IPSEC;
 	sas.ipAddress			= destIP ? destIP : gHosts[hostIndex].ipAddress;
 	sas.sharedKey			= (PGPByte *)
 		gHosts[hostIndex].sharedSecret;
 	sas.sharedKeySize		=
 		strlen( gHosts[hostIndex].sharedSecret );
 	if( gHosts[hostIndex].hostType != kPGPnetSecureGateway )
 		sas.u.ipsec.packetMode = kPGPike_PM_Transport;
 	else
 	{
 		sas.u.ipsec.packetMode	= kPGPike_PM_Tunnel;
 		sas.u.ipsec.destIsRange	= FALSE;
 		if( destIndex == -1 )
 			destIndex = hostIndex;
 		sas.u.ipsec.ipAddrStart	= gHosts[destIndex].ipAddress;
 		sas.u.ipsec.ipMaskEnd	= gHosts[destIndex].ipMask;
 	}
 	sas.u.ipsec.idType		= gHosts[hostIndex].identityType;
 	switch( sas.u.ipsec.idType )
 	{
 		default:
		 	sas.u.ipsec.idData		= gHosts[hostIndex].identity;
		 	sas.u.ipsec.idDataSize	= gHosts[hostIndex].identityLen;
 			break;
 		case kPGPike_ID_IPV4_Addr:
 		{
			/*if( OTInetStringToHost( (char *)gHosts[hostIndex].identity,
					(UInt32 *)&ipConvert ) )*/
			ipConvert = gLocalIP;
		 	sas.u.ipsec.idData		= (PGPByte *)&ipConvert;
		 	sas.u.ipsec.idDataSize	= sizeof(PGPUInt32);
 			break;
 		}
 		case kPGPike_ID_DER_ASN1_DN:
 		{
 			char		dnTemp[256];
 			
 			pgpCopyMemory( gHosts[hostIndex].identity, dnTemp,
 				gHosts[hostIndex].identityLen );
 			dnTemp[gHosts[hostIndex].identityLen] = '\0';
 			err = PGPCreateDistinguishedName( gPGPContext,
 					dnTemp, &dn, &dnLen );
 			LogIfPGPError( err );
 			sas.u.ipsec.idData		= dn;
 			sas.u.ipsec.idDataSize	= dnLen;
 			break;
 		}
 	}
 	err = PGPikeProcessMessage( gIKEContext, kPGPike_MT_SARequest, &sas );
 	LogIfPGPError( err, sas.ipAddress );
 	if( IsntNull( dn ) )
 		PGPFreeData( dn );
}

	void
AddSAI(
	PGPikeSA *		sa )
{
	PGPikeSAInfo *	sai;
	
	sai = (PGPikeSAInfo *)PGPNewData( gMemoryMgr,
			sizeof( PGPikeSAInfo ), kPGPMemoryMgrFlags_Clear );
	if( IsntNull( sai ) )
	{
		sai->next	= gSAs;
		sai->index	= gSAIIndex++;
		sai->sa		= sa;
		gSAs = sai;
		if( gModuleStream != kOTInvalidStreamRef )
		{
			PGPnetModuleMsg			msg;
			OSStatus				status;
			
			msg.type		= kPGPnetModuleNewSAMsg;
			msg.newSA.index = sai->index;
			pgpCopyMemory( sa, &msg.newSA.sa, sizeof(PGPikeSA) );
			status = PGPnetModuleSendMessage( gModuleStream, &msg,
						sizeof(PGPnetModuleNewSAMsg) );
			LogIfOSStatus( status );
		}
	}
	else
		LogIfPGPError( kPGPError_OutOfMemory );
}

	void
RemoveSAI(
	PGPikeSA *		sa )
{
	PGPikeSAInfo *	sai,
				 *	lastsai = NULL;
	
	for( sai = gSAs; IsntNull( sai ); sai = sai->next )
	{
		if( sai->sa == sa )
		{
			if( gModuleStream != kOTInvalidStreamRef )
			{
				PGPnetModuleMsg			msg;
				OSStatus				status;
				
				msg.type				= kPGPnetModuleKillSAMsg;
				msg.killSA.index		= sai->index;
				status = PGPnetModuleSendMessage( gModuleStream, &msg,
							sizeof(PGPnetModuleKillSAMsg) );
				LogIfOSStatus( status );
			}
			if( IsntNull( lastsai ) )
				lastsai->next = sai->next;
			else
				gSAs = sai->next;
			(void)PGPFreeData( sai );
			break;
		}
		lastsai = sai;
	}
}

	PGPikeSAInfo *
FindSAIData(
	PGPikeSA *		sa )
{
	PGPikeSAInfo *	sai;
	
	for( sai = gSAs; IsntNull( sai ); sai = sai->next )
	{
		if( SAMatch( sai->sa, sa ) )
		{
			return sai;
		}
	}
	return NULL;
}

	PGPikeSAInfo *
FindSAIIndex(
	PGPUInt32	index )
{
	PGPikeSAInfo *	sai;
	
	for( sai = gSAs; IsntNull( sai ); sai = sai->next )
	{
		if( sai->index == index )
		{
			return sai;
		}
	}
	return NULL;
}

	PGPikeSAInfo *
FindSAI(
	PGPikeSA *		sa )
{
	PGPikeSAInfo *	sai;
	
	for( sai = gSAs; IsntNull( sai ); sai = sai->next )
	{
		if( sa == sai->sa )
		{
			return sai;
		}
	}
	return NULL;
}

	PGPBoolean
SAMatch(
	PGPikeSA *		sa1,
	PGPikeSA *		sa2 )
{
	PGPBoolean		match = FALSE;
	
	if( ( sa1->ipAddress == sa2->ipAddress ) &&
		( sa1->ipMaskEnd == sa2->ipMaskEnd ) &&
		( sa1->ipAddrStart == sa2->ipAddrStart ) &&
		( sa1->destIsRange == sa2->destIsRange ) &&
		( sa1->birthTime == sa2->birthTime ) &&
		( sa1->numTransforms == sa2->numTransforms ) )
	{
		PGPUInt16	trIndex;
		
		for( trIndex = 0; trIndex < sa1->numTransforms; trIndex++ )
		{
			if( !pgpMemoryEqual( &sa1->transform[trIndex],
					&sa2->transform[trIndex], sizeof(PGPikeDOIParams) ) )
				goto noMatch;
		}
		match = TRUE;
	}
noMatch:
	return match;
}

	void
PostPNEvent(
	UInt32			eventID,
	void *			data,
	PGPUInt32		dataLen )
{
	EventRecord			event;
	PGPUInt32			rcvr;
	OSErr				err;
	
	if( !gAppIsOpen )
		return;
	pgpClearMemory( &event, sizeof( EventRecord ) );
	event.what			= kHighLevelEvent;
	event.message		= kPGPnetHLEventClass;
	event.where.v		= eventID >> 16;
	event.where.h		= eventID & 0xFFFF;
	rcvr				= kPGPnetAppID;
	
	err = PostHighLevelEvent( &event, (void *)rcvr, 0, data, dataLen,
			receiverIDisSignature );
	if( IsErr( err ) )
	{
		//pgpAssertNoErr( err );
	}
}

	PGPBoolean
LogIfOSStatus(
	OSStatus			err )
{
	if( IsErr( err ) )
	{
		PGPnetLogEvent		event;
		
		event.timeOfEvent	= PGPGetTime();
		event.typeOfEvent	= kPGPnetLogEvent_System;
		event.ipaddress		= 0;
		event.info.pgperror.error = err;
		AddLogEvent( &event );
#if PGP_DEBUG
		//pgpAssertNoErr( err );
#endif
		return TRUE;
	}
	return FALSE;
}

	PGPBoolean
LogIfPGPError(
	PGPError				err,
	PGPUInt32				ipAddress )
{
	if( IsPGPError( err ) )
	{
		PGPnetLogEvent		event;
		
		event.timeOfEvent	= PGPGetTime();
		if( ( err >= kPGPIPsecError_FirstError ) &&
			( err <= kPGPIPsecError_LastError ) )
			event.typeOfEvent	= kPGPnetLogEvent_IPSEC;
		else
			event.typeOfEvent	= kPGPnetLogEvent_PGPError;
		event.ipaddress		= ipAddress;
		event.info.pgperror.error = err;
		AddLogEvent( &event );
#if PGP_DEBUG
		//pgpAssertNoErr( err );
#endif
		return TRUE;
	}
	return FALSE;
}

	void
LogServiceError(
	PGPnetServiceError	svcErr,
	PGPUInt32			ipAddress )
{
	PGPnetLogEvent		event;
	
	event.timeOfEvent	= PGPGetTime();
	event.typeOfEvent	= kPGPnetLogEvent_Service;
	event.ipaddress		= ipAddress;
	event.info.svcerror.error = svcErr;
	AddLogEvent( &event );
}

	void
AddLogEvent(
	PGPnetLogEvent *	event )
{
	PGPnetLogRef		logRef;
	PGPError			err;
	
	PostPNEvent( kPGPnetHLEvent_LogEvent, event,
					sizeof( PGPnetLogEvent ) );
	err = PGPnetOpenLog( gMemoryMgr, TRUE, &logRef );
	if( IsntPGPError( err ) )
	{
		err = PGPnetLogEventToFile( logRef, event );
		pgpAssertNoErr( err );	// don't log this!  infinite loop
		err = PGPnetCloseLogFile( logRef );
	}
	pgpAssertNoErr( err );	// don't log this!  infinite loop
}

	void
PostGUINotification( PGPInt16	stringID )
{
	GetIndString(	gNotifyStr,
					kStringListID,
					stringID );
	gNMRec.qType		= nmType;
	gNMRec.nmMark		= 0;
	gNMRec.nmIcon		= NULL;
	gNMRec.nmSound		= NULL;
	gNMRec.nmStr		= gNotifyStr;
	gNMRec.nmResp		= (NMUPP)-1;
	gNMRec.nmRefCon		= 0;
	NMInstall(&gNMRec);
}

	static void
SleepNotify(
	long			message,
	SleepQRecPtr	/*qRecPtr*/ )
{
	switch( message )
	{
		case sleepRequest:
		case sleepDemand:
		{
			PGPError	err = kPGPError_NoErr;
			
			/* Machine is going to sleep, kill all the SAs to remove
				keys from memory */
			if( PGPikeContextRefIsValid( gIKEContext ) )
			{
				err = PGPikeProcessMessage( gIKEContext,
						kPGPike_MT_SAKillAll, NULL );
				LogIfPGPError( err );
			}
			break;
		}
	}
}

	void
main(void)
{
	long		theGestaltResult;
	OSStatus	err = noErr;

	::MaxApplZone();
	for( PGPInt16 i = 1; i <= 3; i++ )
		::MoreMasters();
	::InitGraf(&qd.thePort);
	InitRequiredAE();

	if((((UniversalProcPtr) InitOpenTransport) !=
		(UniversalProcPtr) kUnresolvedCFragSymbolAddress)
		&& (::Gestalt(gestaltOpenTpt, &theGestaltResult) == noErr)
		&& (theGestaltResult & gestaltOpenTptTCPPresentMask)
		&& (::Gestalt(gestaltOpenTptVersions, &theGestaltResult) == noErr)
		&& (((NumVersionVariant *) &theGestaltResult)->whole >=
		kMinimumOTVersion))
		err = ::InitOpenTransport();
	else
	{
		PostGUINotification( kNeedOT13 );
		gGo = FALSE;
	}
	if( IsErr( err ) )
		gGo = FALSE;

	pgpLeaksBeginSession("main");
		RealMain();
	pgpLeaksEndSession();
	::CloseOpenTransport();
}

	void
RealMain()
{
	PGPError	err;
	PGPUInt32	lastIKEIdle,
				lastRandIdle;
	Point		lastMouseLoc;
	OSStatus	status;

	err = pgpNewContextCustomMacAllocators( &gPGPContext );
	/*err = PGPNewContext( kPGPsdkAPIVersion, &gPGPContext );*/
	if( IsntPGPError( err ) )
		err = PGPsdkLoadDefaultPrefs( gPGPContext );
	if( IsntPGPError( err ) )
		err = PGPNewMemoryMgr( 0, &gMemoryMgr );
	if( IsntPGPError( err ) )
		err = PGPNewIKEContext( gPGPContext, PGPnetIKEMessage,
								NULL, &gIKEContext );
	if( IsntPGPError( err ) )
		status = PGPnetModuleOpenStream( &gModuleStream );
	if( IsntPGPError( err ) && IsntErr( status ) )
		LoadPrefs();
	if( IsntPGPError( err ) )
	{
		gInPacket = (PGPByte *)NewPtr( kMaximumUDPPacketSize );
		if( IsNull( gInPacket ) )
			err = kPGPError_OutOfMemory;
	}
	gSleepRec.sleepQLink			= NULL;
	if( IsntPGPError( err ) && PowerManagerExists() )
	{
		gSleepRec.sleepQType		= sleepQType;
		gSleepRec.sleepQFlags		= 0;
		gSleepRec.sleepQProc		= NewSleepQProc( SleepNotify );
		SleepQInstall( &gSleepRec );
		gSleepWatch = TRUE;
	}
	if( IsPGPError( err ) || IsErr( status ) )
	{
#if PGP_DEBUG
		SysBeep(1);
		if( IsPGPError( err ) )
			gGo = FALSE;
#else
		PostGUINotification( kNoPGPSDK );
		gGo = FALSE;
#endif
	}
	lastRandIdle = lastIKEIdle = TickCount();
	while( !gQuitFlag )
	{
		EventIdle();
		if( gGo )
		{
			PGPnetModuleMsg		msg;
			
			if( ( gModuleStream != kOTInvalidStreamRef ) &&
				!PGPnetModuleReceiveMessage( gModuleStream, &msg ) )
			{
				HandleModuleMessage( &msg );
			}
			if( PNReadPacket() )
			{
				if( gOn )
				{
					PGPikeMTPacket	mt;
					
					mt.ipAddress	= gInPacketAddr;
					mt.packetSize	= gInPacketLen;
					mt.packet		= gInPacket;
					err = PGPikeProcessMessage( gIKEContext,
								kPGPike_MT_Packet, &mt );
					LogIfPGPError( err, gInPacketAddr );
				}
			}
			if( TickCount() - lastIKEIdle > kIKEIdleTicks )
			{
				err = PGPikeProcessMessage( gIKEContext,
							kPGPike_MT_Idle, NULL );
				LogIfPGPError( err );
				lastIKEIdle = TickCount();
			}
			if( TickCount() - lastRandIdle > kSeedRandomTicks )
			{
				GrafPtr		savePort;
				GrafPtr		wMgrPort;
				Point		mouseLoc;
				
				GetPort( &savePort );
				GetWMgrPort( &wMgrPort );	
				
				SetPort( wMgrPort );
				GetMouse( &mouseLoc );
				SetPort( savePort );
				if( ( mouseLoc.v != lastMouseLoc.v ) ||
					( mouseLoc.h != lastMouseLoc.h ) )
				{
					PGPGlobalRandomPoolAddMouse( mouseLoc.h, mouseLoc.v );
					lastMouseLoc = mouseLoc;
				}
				lastRandIdle = TickCount();
			}
		}
	}
	if( gOn )
	{
		err = PGPikeProcessMessage( gIKEContext,
					kPGPike_MT_SAKillAll, NULL );
		LogIfPGPError( err );
	}
done:
	if( IsntNull( gPGPPassphrase ) )
	{
		PGPFreeData( gPGPPassphrase );
		gPGPPassphrase = NULL;
	}
	if( IsntNull( g509Passphrase ) )
	{
		PGPFreeData( g509Passphrase );
		g509Passphrase = NULL;
	}
	if( gSleepWatch )
		SleepQRemove( &gSleepRec );
	if( IsntNull( gGP ) )
		PGPFreeData( gGP );
	PNCloseEndpoint();
	if( gModuleStream != kOTInvalidStreamRef )
		status = PGPnetModuleCloseStream( gModuleStream );
	if( IsntNull( gIKEContext ) )
		PGPFreeIKEContext( gIKEContext );
	PGPnetCloseKeyring();
	if( IsntNull( gInPacket ) )
		DisposePtr( (char *)gInPacket );
	if( IsntNull( gHosts ) )
		PGPFreeData( gHosts );
	if( PGPPrefRefIsValid( gNetPrefs ) )
		PGPClosePrefFile( gNetPrefs );
	if( IsntNull( gMemoryMgr ) )
		PGPFreeMemoryMgr(gMemoryMgr);
	if( IsntNull( gPGPContext ) )
	{
		err = PGPFreeContext( gPGPContext );
		pgpAssertNoErr( err );
	}
	return;
}

	void
HandleModuleMessage(
	PGPnetModuleMsg *	msg )
{
	PGPError			err;
	
	switch( msg->type )
	{
		case kPGPnetModuleNeedSAMsg:
		{
			PGPInt32	hostIndex;
			PGPUInt32	destIP = 0;
			PGPBoolean	found = FALSE;
			
			if( msg->needSA.ipAddrStart )
			{
				for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
				{
					if( ( msg->needSA.ipAddrStart == gHosts[hostIndex].ipAddress ) &&
						( msg->needSA.ipMaskEnd == gHosts[hostIndex].ipMask ) )
					{
						found = TRUE;
						break;
					}
				}
			}
			else
			{
				for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
				{
					if( ( msg->needSA.ipAddress & gHosts[hostIndex].ipMask ) ==
						( gHosts[hostIndex].ipAddress & gHosts[hostIndex].ipMask ) )
					{
						if( msg->needSA.ipAddress != gHosts[hostIndex].ipAddress )
							destIP = msg->needSA.ipAddress;
						found = TRUE;
						break;
					}
				}
			}
			if( found )
				RequestSA( hostIndex, destIP );
			else
			{
				if( gRequireSecure && !msg->needSA.ipAddrStart && gOn )
				{
					PGPikeMTSASetup sas;
					
				 	pgpClearMemory( &sas, sizeof( PGPikeMTSASetup ) );
				 	sas.localIPAddress		= gLocalIP;
				 	sas.doi					= kPGPike_DOI_IPSEC;
				 	sas.ipAddress			= msg->needSA.ipAddress;
				 	sas.u.ipsec.packetMode	= kPGPike_PM_Transport;
				 	err = PGPikeProcessMessage( gIKEContext, kPGPike_MT_SARequest, &sas );
				 	LogIfPGPError( err, sas.ipAddress );
				}
				else
				{
					pgpAssert( 0 );	/* big bad bug if we get this */
					LogIfPGPError( kPGPError_AssertFailed, msg->needSA.ipAddress );
				}
			}
			break;
		}
		case kPGPnetModuleErrorMsg:
		{
			LogIfPGPError( msg->err.err, msg->err.addr );
			break;
		}
		case kPGPnetModuleSAStatsMsg:
		{
			PGPikeSAInfo * sai = FindSAIIndex( msg->stats.index );
			
			if( IsntNull( sai ) )
			{
				pgpAssert( sizeof(PGPnetIKESAUserData) <= kPGPike_UserDataSize );
				pgpCopyMemory( &msg->stats.stats, &sai->sa->userData,
					sizeof(PGPnetIKESAUserData) );
				PostPNEvent( kPGPnetHLEvent_UpdateSA, sai->sa, sizeof(PGPikeSA) );
			}
			break;
		}
		case kPGPnetModuleKillSAMsg:
		{
			PGPikeSAInfo * sai = FindSAIIndex( msg->killSA.index );
			
			if( IsntNull( sai ) )
			{
				err = PGPikeProcessMessage( gIKEContext,
							kPGPike_MT_SADied, sai->sa );
				LogIfPGPError( err );
			}
			break;
		}
		case kPGPnetModuleStartupMsg:
			break;
		case kPGPnetModuleShutdownMsg:
			break;
	}
}

	void
ClientIDCheck(
	PGPikeMTClientIDCheck *	cic )
{
	PGPBoolean				found = FALSE;
	PGPUInt16				hostIndex;
	
	cic->approved	= FALSE;
	
	for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
	{
		if( ( cic->ipAddrStart == gHosts[hostIndex].ipAddress ) &&
			( cic->ipMaskEnd == gHosts[hostIndex].ipMask ) &&
			!cic->destIsRange )
		{
			found = TRUE;
			break;
		}
	}
	if( found )
	{
		if ( gHosts[hostIndex].childOf != -1 )
		{
			if( gHosts[gHosts[hostIndex].childOf].ipAddress ==
				cic->ipAddress )
				cic->approved = TRUE;
		}
		else if( ( cic->ipAddress == cic->ipAddrStart ) &&
					( cic->ipMaskEnd == 0xFFFFFFFF ) )
		{
			cic->approved = TRUE;
			
		}
	}
}

	void
PolicyCheck(
	PGPikeMTSASetup *	sas )
{
	PGPBoolean			found = FALSE;
	PGPUInt32			hostIndex;
	PGPNetPrefHostEntry *host;
	PGPByte *			dn = NULL;
	PGPSize				dnLen;
	PGPError			err;
		
	if( IsntNull( gGP ) )
	{
		PGPFreeData( gGP );
		gGP = NULL;
	}
	sas->approved			= FALSE;
	sas->doi				= kPGPike_DOI_IPSEC;
 	sas->localIPAddress		= gLocalIP;
	
	for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
	{
		if( sas->ipAddress == gHosts[hostIndex].ipAddress )
		{
			found = TRUE;
			break;
		}
	}
	if( !found )
	{
		for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
		{
			if( ( sas->ipAddress & gHosts[hostIndex].ipMask ) ==
				( gHosts[hostIndex].ipAddress & gHosts[hostIndex].ipMask ) )
			{
				found = TRUE;
				break;
			}
		}
	}
	
	if( found )
	{
		host = &gHosts[hostIndex];
		
		sas->approved			= TRUE;
		if( host->hostType == kPGPnetSecureGateway )
			sas->u.ipsec.packetMode		= kPGPike_PM_Tunnel;
		else
			sas->u.ipsec.packetMode		= kPGPike_PM_Transport;
		if( host->sharedSecret[0] )
		{
			sas->sharedKey			= (PGPByte *)host->sharedSecret;
			sas->sharedKeySize		= strlen( host->sharedSecret );
			sas->u.ipsec.idType		= host->identityType;
			switch( host->identityType )
			{
				default:
					sas->u.ipsec.idDataSize	= host->identityLen;
					sas->u.ipsec.idData		= host->identity;
					break;
				case kPGPike_ID_IPV4_Addr:
				{
					gGP = (PGPByte *)PGPNewData( gMemoryMgr, sizeof(PGPUInt32), 0 );
					/*if( IsntNull( gGP ) )
						OTInetStringToHost( (char *)host->identity,
								(UInt32 *)gGP );*/
					pgpCopyMemory( &gLocalIP, gGP, sizeof(PGPUInt32) );
					sas->u.ipsec.idDataSize	= sizeof(PGPUInt32);
					sas->u.ipsec.idData		= gGP;
					break;
				}
				case kPGPike_ID_DER_ASN1_DN:
		 		{
		 			char		dnTemp[256];
		 			
		 			pgpCopyMemory( host->identity, dnTemp, host->identityLen );
		 			dnTemp[host->identityLen] = '\0';
		 			err = PGPCreateDistinguishedName( gPGPContext,
		 					dnTemp, &dn, &dnLen );
		 			LogIfPGPError( err );
		 			sas->u.ipsec.idData		= dn;
		 			sas->u.ipsec.idDataSize	= dnLen;
		 			break;
		 		}
			}
		}
	}
	else if( gAllowUnconfigured )
	{
		sas->approved		= TRUE;
		sas->u.ipsec.packetMode		= kPGPike_PM_Transport;
	}
	if( IsntNull( dn ) )
		PGPFreeData( dn );
}

	PGPBoolean
PGPnetOpenKeyring()
{
	PGPError	err = kPGPError_NoErr;
	
	if( !PGPKeySetRefIsValid( gKeyring ) )
	{
		err = PGPsdkLoadDefaultPrefs( gPGPContext );
		if( IsntPGPError( err ) )
		{
			err = PGPOpenDefaultKeyRings( gPGPContext, 0, &gKeyring );
			if( err != kPGPError_FileNotFound )
				LogIfPGPError( err );
		}
	}
	return IsntPGPError( err );
}

	void
PGPnetCloseKeyring()
{
	if( PGPKeySetRefIsValid( gKeyring ) )
	{
		PGPFreeKeySet( gKeyring );
		gKeyring = kInvalidPGPKeySetRef;
	}
}

	PGPKeyRef
PGPnetGetLocalPGPAuthKey()
{
	PGPKeyRef	key = kInvalidPGPKeyRef;
	PGPKeyID *	keyID;
	PGPSize		len;
	PGPUInt32	algNum;
	PGPBoolean	canSign;
	
	PGPGetPrefData( gNetPrefs, kPGPNetPrefPGPAuthKeyID, &len, &keyID );
	if( IsntNull( keyID ) && PGPnetOpenKeyring() )
	{
		PGPGetPrefNumber( gNetPrefs, kPGPNetPrefPGPAuthKeyAlgorithm, &algNum );
		PGPGetKeyByKeyID( gKeyring, keyID,
			(PGPPublicKeyAlgorithm)algNum, &key );
		PGPGetKeyBoolean( key, kPGPKeyPropCanSign, &canSign );
		if( !canSign )
			key = kInvalidPGPKeyRef;
		PGPFreeData( keyID );
	}
	return key;
}

	PGPKeyRef
PGPnetGetLocalX509AuthKey(
	PGPSigRef *			pCert )
{
	PGPError			err = kPGPError_NoErr;
	PGPKeyRef			key = kInvalidPGPKeyRef;
	PGPKeyID *			keyID;
	PGPSize				len;
	PGPUInt32			algNum;
	PGPBoolean			canSign;
	PGPSize				iasnSize = 0;
	PGPByte *			iasn = NULL;
	PGPSigRef			cert;
					
	*pCert = kInvalidPGPSigRef;
	
	PGPGetPrefData( gNetPrefs, kPGPNetPrefX509AuthKeyID, &len, &keyID );
	if( IsntNull( keyID ) )
	{
		PGPGetPrefNumber( gNetPrefs, kPGPNetPrefX509AuthKeyAlgorithm,
			&algNum );
		PGPGetPrefData( gNetPrefs, kPGPNetPrefX509AuthCertIASN,
			&iasnSize, &iasn );
		if( IsntNull( iasn ) )
		{
			if( PGPnetOpenKeyring() )
			{
				err = PGPX509CertFromExport( gPGPContext,
							algNum, (PGPByte *)keyID, iasn, iasnSize,
							gKeyring, &key, &cert );
				if( IsntPGPError( err ) )
				{
					PGPGetKeyBoolean( key, kPGPKeyPropCanSign, &canSign );
					if( !canSign )
						key = kInvalidPGPKeyRef;
					else
						*pCert	= cert;
				}
			}
			PGPFreeData( iasn );
		}
		PGPFreeData( keyID );
	}
	return key;
}

	PGPBoolean
CheckRemoteCert(
	PGPUInt32			ipAddress,
	PGPKeyRef			rKey,
	PGPSigRef			rCert )
{
	PGPBoolean			valid = FALSE,
						expired = FALSE,
						revoked = FALSE;
	PGPError			err = kPGPError_NoErr;
	PGPKeySetRef		singKeySet = kInvalidPGPKeySetRef,
						combKeySet = kInvalidPGPKeySetRef;
	PGPInt32			validity;
	PGPUInt32			hostIndex;
	PGPNetPrefHostEntry *host;
	PGPBoolean			found = FALSE;
	PGPUInt32			alg;
	PGPKeyID			expKeyID,
						remKeyID;
	PGPByte				iasn[256];
	PGPSize				iasnSize = sizeof(iasn);
	PGPnetLogEvent		event;

	if( !PGPKeyRefIsValid( rKey ) )
		goto done;
	if( !PGPnetOpenKeyring() )
		goto done;
	err = PGPGetKeyIDFromKey( rKey, &remKeyID ); CKERR;
	err = PGPGetKeyNumber( rKey, kPGPKeyPropAlgID, (PGPInt32 *)&alg );	CKERR;
	err = PGPNewSingletonKeySet( rKey, &singKeySet );					CKERR;
	err = PGPNewKeySet( gPGPContext, &combKeySet );						CKERR;
	err = PGPAddKeys( singKeySet, combKeySet );							CKERR;
	err = PGPAddKeys( gKeyring, combKeySet );							CKERR;
	err = PGPCheckKeyRingSigs( singKeySet, combKeySet, FALSE, NULL, 0 );CKERR;
	err = PGPPropagateTrust( combKeySet );								CKERR;
	if( PGPSigRefIsValid( rCert ) )
	{
		err = PGPGetUserIDNumber( PGPGetSigUserID( rCert ),
				kPGPUserIDPropValidity, &validity);						CKERR;
		err = PGPGetSigBoolean( rCert, kPGPSigPropIsExpired, &expired );CKERR;
		err = PGPGetSigBoolean( rCert, kPGPSigPropIsRevoked, &revoked );CKERR;
	}
	else
	{
		err = PGPGetKeyNumber( rKey, kPGPKeyPropValidity, &validity );	CKERR;
		err = PGPGetKeyBoolean( rKey, kPGPKeyPropIsExpired, &expired );	CKERR;
		err = PGPGetKeyBoolean( rKey, kPGPKeyPropIsRevoked, &revoked );	CKERR;
	}
	
	event.timeOfEvent	= PGPGetTime();
	event.typeOfEvent	= kPGPnetLogEvent_Service;
	event.ipaddress		= ipAddress;
	if( PGPSigRefIsValid( rCert ) )
	{
		if( revoked )
			event.info.svcerror.error = kPGPnetSrvcError_RevokedCert;
		else if( expired )
			event.info.svcerror.error = kPGPnetSrvcError_ExpiredCert;
		else
			event.info.svcerror.error = kPGPnetSrvcError_AuthenticatedCert;
	}
	else
	{
		if( revoked )
			event.info.svcerror.error = kPGPnetSrvcError_RevokedKey;
		else if( expired )
			event.info.svcerror.error = kPGPnetSrvcError_ExpiredKey;
		else
			event.info.svcerror.error = kPGPnetSrvcError_AuthenticatedKey;
		pgpCopyMemory( &remKeyID, &event.info.svcerror.keyID, sizeof(PGPKeyID) );
	}
	AddLogEvent( &event );

	for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
	{
		if( ipAddress == gHosts[hostIndex].ipAddress )
		{
			found = TRUE;
			break;
		}
	}
	if( !found )
	{
		for( hostIndex = 0; hostIndex < gNumHosts; hostIndex++ )
		{
			if( ( ipAddress & gHosts[hostIndex].ipMask ) ==
				( gHosts[hostIndex].ipAddress & gHosts[hostIndex].ipMask ) )
			{
				found = TRUE;
				break;
			}
		}
	}
	if( found )
	{
		host = &gHosts[hostIndex];
		
		if( host->authKeyAlg != kPGPPublicKeyAlgorithm_Invalid )
		{
			/* make sure keys match */
			if( alg == host->authKeyAlg )
			{
				err = PGPImportKeyID( host->authKeyExpKeyID, &expKeyID ); CKERR;
				if( !PGPCompareKeyIDs( &expKeyID, &remKeyID ) )
				{
					if( host->authCertIASNLength > 0 )
					{
						if( PGPSigRefIsValid( rCert ) )
						{
							err = PGPGetSigPropertyBuffer( rCert, 
								kPGPSigPropX509IASN,
								iasnSize, iasn, &iasnSize ); CKERR;
							if( iasnSize == host->authCertIASNLength )
							{
								if( pgpMemoryEqual( host->authCertIASN,
										iasn, iasnSize ) )
									valid = TRUE;
							}
						}
					}
					else
					{
						valid = TRUE;
					}
				}
			}
		}
		else
		{
			/* we're just looking for any valid key */
			if( ( validity >= kPGPValidity_Complete ) || !gRequireValidKey )
				valid = TRUE;
		}
	}
	else
	{
		if( gRequireValidKey  )
		{
			if( validity >= kPGPValidity_Complete )
				valid = TRUE;
		}
		else if( validity >= kPGPValidity_Complete )
			valid = TRUE;
		else
		{
			//PGPNetPrefHostEntry	newHost;
			//PGPSize				kidSize = sizeof(PGPKeyID);
			
			/* make new host entry with this info */
			/*pgpClearMemory( &newHost, sizeof( PGPNetPrefHostEntry ) );
			newHost.hostType		=	kPGPnetSecureHost;
			newHost.ipAddress		=	ipAddress;
			newHost.ipMask			=	0xFFFFFFFF;
			newHost.childOf			=	-1;
			strcpy( newHost.hostName, "Untitled Host" );
			newHost.identityType	=	kPGPike_ID_IPV4_Addr;
			OTInetHostToString( (unsigned long)gLocalIP, (char *)newHost.identity );
			newHost.identityLen		=	strlen( (char *)newHost.identity );
			PGPGetKeyNumber( rKey, kPGPKeyPropAlgID,
				(PGPInt32 *)&newHost.authKeyAlg );
			err = PGPExportKeyID( &remKeyID, &newHost.authKeyExpKeyID[0],
					&kidSize );	CKERR;
			if( PGPSigRefIsValid( rCert ) )
			{
				err = PGPGetSigPropertyBuffer( rCert, 
					kPGPSigPropX509IASN,
					iasnSize, iasn, &iasnSize ); CKERR;
				newHost.authCertIASNLength	=	iasnSize;
				pgpCopyMemory( iasn, &newHost.authCertIASN[0], iasnSize );
			}
			if( gAppIsOpen )
			{
				PostPNEvent( kPGPnetHLEvent_NewHost, &newHost,
					sizeof( PGPNetPrefHostEntry ) );
			}
			gNumHosts++;
			err = PGPReallocData( gMemoryMgr, &gHosts,
					gNumHosts * sizeof( PGPNetPrefHostEntry ), 0 );	CKERR;
			pgpCopyMemory( &newHost, &gHosts[gNumHosts - 1],
					sizeof(PGPNetPrefHostEntry) );
			SendHostsToModule();
			if( !gAppIsOpen )
			{
				err = PGPSetNetHostPrefs( gNetPrefs, gHosts, gNumHosts );	CKERR;
				err = PGPSavePrefFile( gNetPrefs );	CKERR;
			}*/
			valid = TRUE;
		}
	}
	if( expired || revoked )
		valid = FALSE;
done:
	if( PGPKeySetRefIsValid( combKeySet ) )
		PGPFreeKeySet( combKeySet );
	if( PGPKeySetRefIsValid( singKeySet ) )
		PGPFreeKeySet( singKeySet );
	LogIfPGPError( err );
	return valid;
}

	PGPError
PGPnetIKEMessage(
	PGPikeContextRef	ike,
	void *				inUserData,
	PGPikeMessageType	msg,
	void *				data )
{
	PGPError			err = kPGPError_NoErr;
	
#pragma unused (ike, inUserData)
	switch( msg )
	{
		case kPGPike_MT_SARequestFailed:
			PGPikeMTSAFailed *		saf = (PGPikeMTSAFailed *)data;
			
			if( gModuleStream != kOTInvalidStreamRef )
			{
				PGPnetModuleMsg			msg;
				OSStatus				status;
				
				msg.type				= kPGPnetModuleNoSAMsg;
				msg.noSA.ipAddress		= saf->ipAddress;
				msg.noSA.destIsRange	= saf->u.ipsec.destIsRange;
				msg.noSA.ipAddrStart	= saf->u.ipsec.ipAddrStart;
				msg.noSA.ipMaskEnd		= saf->u.ipsec.ipMaskEnd;
				status = PGPnetModuleSendMessage( gModuleStream, &msg,
							sizeof(PGPnetModuleNoSAMsg) );
				LogIfOSStatus( status );
			}
			LogServiceError( kPGPnetSrvcError_SAFailed, saf->ipAddress );
			break;
		case kPGPike_MT_SAEstablished:
		{
			AddSAI( (PGPikeSA *)data );
			PostPNEvent( kPGPnetHLEvent_UpdateSA, data, sizeof(PGPikeSA) );
			break;
		}
		case kPGPike_MT_SADied:
			RemoveSAI( (PGPikeSA *) data );
			PostPNEvent( kPGPnetHLEvent_RemoveSA, data, sizeof(PGPikeSA) );
			break;
		case kPGPike_MT_SAUpdate:
			if( gModuleStream != kOTInvalidStreamRef )
			{
				PGPnetModuleMsg			msg;
				OSStatus				status;
				PGPikeSAInfo *			sai;
				
				sai = FindSAI( (PGPikeSA *)data );
				pgpAssert( IsntNull( sai ) );
				if( IsntNull( sai ) )
				{
					msg.type			= kPGPnetModuleUpdateSAMsg;
					msg.updateSA.index	= sai->index;
					pgpCopyMemory( sai->sa, &msg.updateSA.sa, sizeof(PGPikeSA) );
					status = PGPnetModuleSendMessage( gModuleStream, &msg,
								sizeof(PGPnetModuleUpdateSAMsg) );
					LogIfOSStatus( status );
				}
			}
			break;
		case kPGPike_MT_PolicyCheck:
		{
			PGPikeMTSASetup *	poc = (PGPikeMTSASetup *)data;
			
			PolicyCheck( poc );
			break;
		}
		case kPGPike_MT_ClientIDCheck:
		{
			PGPikeMTClientIDCheck *	cic = (PGPikeMTClientIDCheck *)data;
			
			ClientIDCheck( cic );
			break;
		}
		case kPGPike_MT_LocalPGPCert:
		{
			PGPikeMTCert *	pgpc = (PGPikeMTCert *)data;
			
			pgpc->baseKeySet	= gKeyring;
			pgpc->authKey		= PGPnetGetLocalPGPAuthKey();
			pgpc->pass			= gPGPPassphrase;
			if( IsntNull( gPGPPassphrase ) )
			{
				pgpc->passLength = strlen( gPGPPassphrase ) + 1;
			}
			break;
		}
		case kPGPike_MT_LocalX509Cert:
		{
			PGPikeMTCert *	pkixc = (PGPikeMTCert *)data;
			
			pkixc->baseKeySet	= gKeyring;
			pkixc->authKey		= PGPnetGetLocalX509AuthKey( &pkixc->authCert );
			pkixc->pass			= g509Passphrase;
			if( IsntNull( g509Passphrase ) )
			{
				pkixc->passLength = strlen( g509Passphrase ) + 1;
			}
			break;
		}
		case kPGPike_MT_RemoteCert:
		{
			PGPikeMTRemoteCert * rcm = (PGPikeMTRemoteCert *)data;
			
			if( CheckRemoteCert( rcm->ipAddress, rcm->remoteKey, rcm->remoteCert ) )
				rcm->approved	= TRUE;
			break;
		}
		case kPGPike_MT_Packet:
		{
			PGPikeMTPacket *	pkt = (PGPikeMTPacket *)data;
			
			if( gOn )
				PNSendPacket( pkt->ipAddress, pkt->packet, pkt->packetSize );
			break;
		}
		case kPGPike_MT_Alert:
		{
			PGPnetLogEvent		event;
			PGPikeMTAlert *		alert = (PGPikeMTAlert *)data;
			
			event.timeOfEvent	= PGPGetTime();
			event.typeOfEvent	= kPGPnetLogEvent_PGPike;
			event.ipaddress		= alert->ipAddress;
			event.info.ikealert.alert			= alert->alert;
			event.info.ikealert.value			= alert->value;
			event.info.ikealert.remoteGenerated = alert->remoteGenerated;
			AddLogEvent( &event );
			break;
		}
		case kPGPike_MT_DebugLog:
			PostPNEvent( kPGPnetHLEvent_IKELog, data,
				strlen( ( char * ) data ) );
			break;
		default:
			pgpAssert( 0 );
			break;
	}
	return err;
}

	void
EventIdle()
{
	EventRecord		mainEvent;
	Boolean			eventFlag;
	PGPUInt32		sleepVal;
	
	if( gEndpoint == kOTInvalidEndpointRef )
		sleepVal = kSleepUnconnected;
	else if( IsNull( gSAs ) )
		sleepVal = kSleepConnectedNoSA;
	else
		sleepVal = kSleepConnected;
	eventFlag = WaitNextEvent( everyEvent, &mainEvent, sleepVal, nil );
	
	switch( mainEvent.what )
	{
		case kHighLevelEvent:
			DoHighLevelEvent( &mainEvent );
			break;
	}
#if PGP_DEBUG
	if( CapsLockIsDown() )
		gQuitFlag = TRUE;
#endif
}

	void
InitRequiredAE(void)
{
	OSErr retCode;

	retCode = AEInstallEventHandler(kCoreEventClass, kAEOpenApplication,
	            NewAEEventHandlerProc (DoAEOpenApplication), 0, false);
									
	if (retCode == noErr)
		retCode = AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments,
		        NewAEEventHandlerProc (DoAEOpenDocuments), 0, false);

	if (retCode == noErr)
		retCode = AEInstallEventHandler(kCoreEventClass, kAEPrintDocuments,
		        NewAEEventHandlerProc (DoAEPrintDocuments), 0, false);
	if (retCode == noErr)
		retCode = AEInstallEventHandler(kCoreEventClass, kAEQuitApplication,
		        NewAEEventHandlerProc (DoAEQuitApplication), 0, false);

	if (retCode != noErr)
		DebugStr("\pInstall event handler failed");
}

