/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPMountUtils.cp,v 1.8 1999/03/10 02:53:39 heller Exp $
____________________________________________________________________________*/

#include <FSM.h>

#include "PGPMountUtils.h"

#include "MacFiles.h"
#include "MacDriverUtils.h"
#include "MacEnvirons.h"
#include "pgpMacMemory.h"
#include "MacResources.h"
#include "MacStrings.h"





/*
**	Allocate a device control entry low in memory, initialize its dCtlDriver,
**	dCtlFlags, and dCtlRefNum fields, and then add it to the unit table.
*/

	OSErr
MyDRVRInstall(
	Ptr		drvrPtr,
	short	driverRefNum)
{
	OSErr			err = noErr;
	short			unitNum;
	AuxDCEHandle	*unitTable;
	AuxDCEHandle	dceHandle;
	
	unitNum	= -1 * ( driverRefNum + 1 );
	
	unitTable = (AuxDCEHandle *)LMGetUTableBase();
	
	/* Make room as low as possible because the device control entry will */
	/* be locked while the driver is open */
	ReserveMem( sizeof(AuxDCE) );
	
	dceHandle	= (AuxDCEHandle)NewHandleSysClear(sizeof(AuxDCE));
	if ( IsntNull( dceHandle ) )
	{
		MacLeaks_IgnoreItem( dceHandle );
		
		// We clear the dRAMBased bit below to make sure that our driver is
		// accessed more quickly by a pointer rather than by a handle.  Also
		// using a pointer for this makes it interrupt safe to call this
		// driver. 
		HLock((Handle)dceHandle);
		(**dceHandle).dCtlDriver	= drvrPtr;
		(**dceHandle).dCtlFlags		&= ~dRAMBasedMask;
		(**dceHandle).dCtlRefNum	= driverRefNum;		

		/* Put dceHandle in the unit table */
		unitTable[ unitNum ]			= dceHandle;		
	}
	else
	{
		err = memFullErr;
	}
	
	return (err);
}


	static OSErr
GetVRefNumForDrive(
	short	driveNum,
	short *	vRefNum )
	{
	const VCB *	vcb;
	OSErr		err	= nsvErr;
	
	vcb	= (const VCB *)GetVCBQHdr()->qHead;
	while ( IsntNull( vcb ) )
		{
		if ( vcb->vcbDrvNum == driveNum )
			{
			err			= noErr;
			*vRefNum	= vcb->vcbVRefNum;
			break;
			}
		
		vcb	= (const VCB *)vcb->qLink;
		}
	
	return( err );
	}
	

	static OSErr
UnmountAllDrivesForDriver( short	driverRefNum )
	{
	const DrvQEl *	drvQElem	= (const DrvQEl *)GetDrvQHdr()->qHead;
	OSErr			err	= noErr;
	
	while ( IsntNull( drvQElem ) )
		{
		const DrvQEl *	next;
		
		next	= (const DrvQEl *)drvQElem->qLink;
		
		if ( drvQElem->dQRefNum == driverRefNum )
			{
			short	vRefNum;
			
			err	= GetVRefNumForDrive( drvQElem->dQDrive, &vRefNum);
			if ( err == noErr )
				{
				err	= UnmountVol( nil, vRefNum );
				AssertNoErr( err, "UnmountAllDrivesForDriver (UnmountVol)" );
				if ( IsErr( err ) )
					break;
				}
			else
				{
				// ignore
				err	= noErr;
				}
			}
			
		drvQElem	= next;
		}
	
	return( err );
	}
	
	
	static OSErr
DRVRClose( short	driverRefNum )
	{
	ParamBlockRec	pb;
	OSErr			err	= noErr;
	
	pb.ioParam.ioRefNum	= driverRefNum;
	err	= PBCloseSync( &pb );
	
	return( err );
	}
	
		
	static OSErr
DRVRAccRun( short	driverRefNum )
	{
	ParamBlockRec	pb;
	OSErr			err	= noErr;
	
	pb.cntrlParam.ioCRefNum	= driverRefNum;
	pb.cntrlParam.csCode	= accRun;
	err	= PBControlSync( &pb );
	
	return( err );
	}


/*
**	Unmount all drives using the driver, close the driver, and remove it
*/
	OSErr
UnmountAllCloseAndRemove( short	driverRefNum )
	{
	OSErr			err	= noErr;
	
	err	= UnmountAllDrivesForDriver( driverRefNum );
	if ( IsntErr( err ) )
		{
		short			 unitNum;
		AuxDCEHandle *	unitTable;

		unitNum		= -1 * (driverRefNum + 1);
		unitTable	= (AuxDCEHandle *)LMGetUTableBase();

		if (unitNum > 0 && (unitNum <= kMaxUnitTableEntries))
			{
			AuxDCEHandle 	dceHandle;
		
			dceHandle	= unitTable[ unitNum ];
			if ( IsntNull( dceHandle ) )
				{
				err	= DRVRClose( driverRefNum );
				if ( IsntErr( err ) )
					{
					Handle	driverHandle;
					
					pgpAssert( ((**dceHandle).dCtlFlags & dOpenedMask) == 0 );
					
					driverHandle = RecoverHandle( (**dceHandle).dCtlDriver );
					if ( IsntNull( driverHandle ) )
						{
						DisposeHandle( driverHandle );
						driverHandle	= nil;
						err	= MemError();
						}
					
					unitTable[ unitNum ] = nil;
					DisposeHandle( (Handle)dceHandle );	
					dceHandle	= nil;
					}
				}
			}
		}
	return( err );
	}




	static FlagsDrvQEl *
NewDriveQElem(
	const short	driverRefNum,
	const short	driveNumber,
	const ulong	numBlocks)
	{
	FlagsDrvQEl	*myEl;
	
	myEl	= (FlagsDrvQEl *)NewPtrSysClear( sizeof( FlagsDrvQEl ) );
	if ( IsntNull( myEl ) )
		{
		myEl->flags				= 0;
		
		// qType of 1 indicates both dQDrvSz and dQDrvSz2 are used
		// see IM IV pg 181
		myEl->el.qType			= 1;	
		myEl->el.dQDrvSz		= numBlocks;
		myEl->el.dQDrvSz2		= numBlocks >> 16;
		
		myEl->el.dQDrive		= driveNumber;
		myEl->el.dQRefNum		= driverRefNum;
		myEl->el.dQFSID			= 0;
		}
	
	return( myEl );
	}
	
	
/*
**	Find the first unused drive number greater than 4, allocate and
** 	initialize a drive queue element (including the drive flags), and add
**	the drive queue element to the drive queue.
*/
	OSErr
AddDriveToQueue(
	long		size,
	short		driverRefNum,
	Boolean		writeProtect,
	FlagsDrvQEl	**driveQEl)
{
	OSErr			err = noErr;
	const QHdr *	driveQHdr;
	const DrvQEl*	drivePtr;
	Boolean			driveNumFound = false;
	short			driveNum;
	
	*driveQEl	= nil;
	
	driveQHdr = GetDrvQHdr();
	
	/* find first free drive number */
	driveNum = 5;					/* drive numbers 1-4 are reserved */
	while( ! driveNumFound )
	{
		drivePtr = (const DrvQEl *)driveQHdr->qHead;	/* get first drive */
		while ( IsntNull( drivePtr ) )
			{
			if ( driveNum == drivePtr->dQDrive )
				break;
				
			drivePtr = (const DrvQEl *)drivePtr->qLink;	/* get next drive */
			}
		
		if ( IsNull( drivePtr ) )
			driveNumFound = TRUE;
		else
			driveNum	+= 1;
	}
	
	if (driveNum > 0)	/* must be a positive short */
	{
		FlagsDrvQEl *	newDrivePtr;
	
		newDrivePtr	= NewDriveQElem( driverRefNum, driveNum, size );
		if( IsntNull( newDrivePtr ) )
		{
			MacLeaks_IgnoreItem( newDrivePtr );
			
			*driveQEl	= newDrivePtr;
			
			// to avoid problems caused by this, we also have to set
			// 'kDriveWantsEjectCallMask' in order to get an eject call
			// to fix up the mess when the Finder occassionally
			// "ejects" us.
			newDrivePtr->flags	= 0;
		
		#if ALLOW_VM_PAGING	// [
			This is non-shipping test code
			if ( VirtualMemoryIsOn() )
				{
				// VM is one, we have to mark the drive as ejectable (don't
				// set the not-ejectable flag) in order to keep the system
				// from trying to page off our drive
				newDrivePtr->flags	= kDriveIsNotEjectableMask;
				}
			else
				{
				// we'd like to mark it as non-ejectable, but the
				// unfortunate side-effect of this is the:
				//	"...disk will reappear when the computer is restarted"
				// message. which implies a security leak
				newDrivePtr->flags	= kDriveIsNotEjectableMask;
				}
		
		#else	// ] ALLOW_VM_PAGING [
		
			if ( VirtualMemoryIsOn() )
				{
				// VM is one, we have to mark the drive as ejectable (don't
				// set the not-ejectable flag) in order to keep the system
				// from trying to page off our drive
				newDrivePtr->flags	= kDiskInDriveMask |
							kDriveWantsEjectCallMask;
				}
			else
				{
				// we'd like to mark it as non-ejectable, but the
				// unfortunate side-effect of this is the:
				//	"...disk will reappear when the computer is restarted"
				// message. which implies a security leak
				newDrivePtr->flags	= kDiskInDriveMask |
							kDriveWantsEjectCallMask;
				}
				
		#endif	// ] ALLOW_VM_PAGING
			
			if( writeProtect )
				{
				newDrivePtr->flags |= kDriveLockedMask;	
				}
				
			Enqueue( (QElem *)&newDrivePtr->el.qLink, GetDrvQHdr() );
			
			// AddDrive is buggy when run from native code, it also
			// seems pointless in general since a simple Enqueue as
			// above does the same thing as far as I know.  If anyone
			// knows any other weird things that AddDrive does that a simple
			// Enqueue does not here, please let me know.
			// Doing AddDrive instead of Enqueue does work in 68K code.
			// It was used that way until CD 1.2
		}
		else
		{
			err = memFullErr;
		}
	}
	else
	{
		/* more than 32768 drives!?! */
		err = nsDrvErr;
	}
	
	return ( err );
}








	
	
	
