/*
The contents of this file contain text and code describing and 
implementing the 'DES' encryption algorithm. Despite the fact 
that this information is freely available overseas, it remains 
a violation of ITAR and/or EAR to export this information 
from inside the US or Canada to outside the US or Canada, or 
to pass it to a non-US or non-Canadian citizen within the US 
or Canada. The US Government evidently defines 'Export' to 
include placing this information on a non-restricted FTP server 
or Web site. Please do not do so, and be sure that any person you
pass this on to is made aware of this restriction.
									Peter Trei
									ptrei@acm.org

 * THIS SOFTWARE IS PROVIDED BY PETER TREI ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.

This software is copyright (c) 1997 Peter Trei (ptrei@acm.org), except for
those portions written by Phil Karn, which retain their
original ownership.

This software may be redistributed freely for use in the RSA DES Challenge,
but please obey the restrictions imposed by the US Government, and make
sure that anyone you pass it to is also aware of them.

This software may not be used for commercial purposes without the written
permission of Peter Trei and the other owners.

Please redistribute only as a complete, unmodified package, including 
source code, and ptrei@acm.org's PGP signature file and key.

 */

#ifndef DES_H
#define DES_H 1

#ifdef ultrix
#define const
#endif
#include <time.h>

/* the following line should be short, but completely identify the
   version of the program being used - enough so that we can verify
   the output by re-running the test. Thus, it needs to change when
   ever the checksum or output format is affected, or the calculations
   of the key test changes - if some version turns up deficient, we
   need to be able to toss out the results produced by that version.
   Here, I'm giving the name of the program, the platform, and
   a version number. */
#define VERSION "deskr-win32-0.8"

#define CHKPNTTMP "chkpnt.tmp"
#define CHKPNTDES "chkpnt.des"
#define DESKROUT "deskr.out"
#ifdef REALTEST
#define DESINPUT "deskr.inp"
#else
#define DESINPUT "testchal.txt"
#endif
#define DESINPUT2 "deskr2.inp"
#define DESKRID  "desident.txt"
#define DESKRLOCK "deslock.txt"
#define DESKRSOLUTION "solution.txt"
#define STOPNOW "stop.now"

#define CHKPNTMIN 10 /* minutes between checkpointing status */

/* The following is a working triple for single DES, EBC mode.
   It includes a key, an 8-bit plaintext, and an 8-bit ciphertext,
   encrypted using the key. The key turns out to be fairly
   near the start of chunk 4533 (hex) */

#if 1
/*static */unsigned char targkey[8];				/* key to find */
/*static */unsigned char plain[8];					/* plain text */
/*static */unsigned char cipher[8];					/* ciphertext */
#else
/*static */unsigned char targkey[8] =				/* key to find */
    {0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef};
/*static */unsigned char plain[8] =					/* plain text */
	{0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xe7};
/*static */unsigned char cipher[8] =				/* ciphertext */
	{0xc9,0x57,0x44,0x25,0x6a,0x5e,0xd3,0x1d};
#endif

unsigned char iv[8];
unsigned char key[8];
int ciphertext_len;
int knowntext_len;
int ascii_plaintext_len;
unsigned char full_ciphertext[256];
unsigned char full_knowntext[256];
unsigned char ascii_plaintext[256];
unsigned char output[256];
unsigned char con_id[256];
unsigned char cipher_name[256];
unsigned char con_state[256];

static unsigned char cipher0[8]; /* for CBC mode */
unsigned char cipher_mode[3];    /* cbc or ebc */


unsigned char pkey[8];

typedef struct tKeySchedule
{
	unsigned long a[16][2];
} tKeySchedule, *pKeySchedule;


/* In deskey.c: */
void deskey (unsigned long [16][2],unsigned char *,int);
void deskey2(unsigned long [16][2],unsigned char *,unsigned int);
void deskey3(unsigned long [16][2],unsigned long, unsigned long, unsigned int);
void deskey4(unsigned long [16][2],		
									unsigned long,
									unsigned long,
									unsigned long,
									unsigned long);
void set_keydiffs(); /* create key difference tables */
void set_gray8(); /* create table of which bit changes with*/
				  /* each step of 0-255 in gray code order */
void print_ks(unsigned long ks[16][2]);
void ks_to_key(unsigned long [16][2],
			   unsigned int *,
			   unsigned int *);
void print_dkeydiffs();
void restore_key_schedule(
			   unsigned long kh,
			   unsigned int b3,
			   unsigned int b2,
			   unsigned int b1,
			   unsigned int b0);

/* In desport.c, desborl.cas or desgnu.s: */
void des(unsigned long [16][2],unsigned char * /*, unsigned long count*/);
extern int Asmversion;	/* 1 if we're linked with an asm version, 0 if C */

void initial_perm(unsigned char * );
void final_perm (unsigned char * );
void do_rounds(unsigned long [16][2]);
void do_first_round(unsigned long [16][2]);
void do_middle_rounds(unsigned long [16][2]);
void do_last_round(unsigned long [16][2]);

void crunchkey(unsigned char *key, long *pkhi, long *pklo);
void uncrunchkey(unsigned char *key, long pkhi, long pklo);

long ekeydiffs[64][16][2]; /* key difference table for encryption*/
long dkeydiffs[64][16][2]; /* key difference table for decryption*/
/* below are the crunched versions */
long erkeydiffs[56][16][2]; /* rearranged key difference table for encryption*/
long drkeydiffs[56][16][2]; /* rearranged key difference table for decryption*/

unsigned long left, right; /* working variables */

/* gray8 contains the number of the bit which changes at a byte
   is incremented in Gray code order. This can be used to 
   increment the key schedule a lot more quickly than if we
   have to figure out which bit changed the hard way 

   The values for this array are set up by calling set_gray8 at the
   start of the program. */
unsigned int gray8[256]; 
/* some working variables */
unsigned long dleft,dright,cleft,cright,eleft,eright;
unsigned long final_perm_input_left;
unsigned long final_perm_input_right;
unsigned long initial_perm_output_left; 
unsigned long initial_perm_output_right;
unsigned long round1_output_left;
unsigned long round1_output_right;
unsigned long th,tl,sl,sh,el,eh,oh,ol;
unsigned long gray3,gray2,gray1,gray0;
unsigned long checksum;
unsigned char half_match[10][8];
unsigned int  half_matches_found;
unsigned int  chkpntcnt, chkpnttime;

unsigned long nonce;
unsigned long searchid;
/* command line switches */
int print_usage;
int run_tests;
int start_this_chunk;
int run_quietly;
int test_a_key;
int verbose_flag;
int use_lockfiles;
unsigned char unpacked_key_to_test[16];
unsigned char key_to_test[8];

int b0, b1, b2, b3, bi, carry;
int done, done_lower; /* flags for outer and inner loops */

unsigned long knd[16][2];	/* current key schedule */

char des_cwd_dir[100];
char *des_dir;
char des_prog_dir[100]; /* dir containing deskr.exe */
char *des_local_dir; /* dir for checkpoint files */
char *des_share_dir; /* shared dir for many machines */
char des_local_output_dir[100]; /* dir for private copy of output */
char chkpnt_tmp[80], chkpnt_des[80]; /* dir + file */
char deskr_out[80]; 
char deskr_in[80];
char deskr_in2[80];
char deskr_id[80];
char deskr_lock[80];
char deskr_solution[80];
unsigned char ident_string[80];
char filepath[80];

#ifdef TESTGRAY
unsigned int q[65536];
unsigned long qh, ql;
#endif /* TESTGRAY */
int count;



/* routines in desutil.c */
void print_blurb();
void checkpoint_status();
int restore_checkpoint();
int rivest_test();
void record_output();
void put8(unsigned char *);
void time_check(int);
int get_test_data();
int get_ident();
void pack_hex_string(char *unpacked,char *packed,int packed_length);
void startup_functions();

/* in deskr.c */
unsigned char firstarg[80]; /* first arg of argv, contains invocation. */
int do_lower_16();
int x86_do_lower_16();
#endif
