#ifndef GABA_DEFINE
struct proxy_connection
{
  struct lsh_object super;
  struct ssh_connection *client;
  struct ssh_connection *server;
  void (*(set_client_conn))(struct proxy_connection *self, struct ssh_connection *conn);
  void (*(set_server_conn))(struct proxy_connection *self, struct ssh_connection *conn);
};
extern struct lsh_class proxy_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_connection_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_connection *i = (struct proxy_connection *) o;
  mark((struct lsh_object *) i->client);
  mark((struct lsh_object *) i->server);
}

struct lsh_class proxy_connection_class =
{ STATIC_HEADER,
  0, "proxy_connection", sizeof(struct proxy_connection),
  do_proxy_connection_mark,
  NULL
};
#endif /* !GABA_DECLARE */

