#ifndef CLASS_DEFINE
struct resource
{
  struct lsh_object super;
  int alive;
  void (*(kill))(struct resource *self);
};
extern struct lsh_class resource_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_resource_free(struct lsh_object *o)
{
  struct resource *i = (struct resource *) o;
  dont_free_live_resource(i->alive);
}

struct lsh_class resource_class =
{ STATIC_HEADER,
  0, "resource", sizeof(struct resource),
  NULL,
  do_resource_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct resource_list
{
  struct lsh_object super;
  struct resource_node * head;
  struct resource_node * tail;
  struct resource_node * (*(remember))(struct resource_list *self, struct resource *r);
  void (*(kill_all))(struct resource_list *self);
};
extern struct lsh_class resource_list_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_resource_list_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct resource_list *i = (struct resource_list *) o;
  do_mark_resources(i->head, mark);
}

static void do_resource_list_free(struct lsh_object *o)
{
  struct resource_list *i = (struct resource_list *) o;
  do_free_resources(i->head);
}

struct lsh_class resource_list_class =
{ STATIC_HEADER,
  0, "resource_list", sizeof(struct resource_list),
  do_resource_list_mark,
  do_resource_list_free
};
#endif /* !CLASS_DECLARE */

