#ifndef CLASS_DEFINE
struct cbc_algorithm
{
  struct crypto_algorithm super;
  struct crypto_algorithm *inner;
};
extern struct lsh_class cbc_algorithm_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_cbc_algorithm_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct cbc_algorithm *i = (struct cbc_algorithm *) o;
  mark((struct lsh_object *) i->inner);
}

struct lsh_class cbc_algorithm_class =
{ STATIC_HEADER,
  &crypto_algorithm_class, "cbc_algorithm", sizeof(struct cbc_algorithm),
  do_cbc_algorithm_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct cbc_instance
{
  struct crypto_instance super;
  struct crypto_instance *inner;
  UINT8 (*(iv));
};
extern struct lsh_class cbc_instance_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_cbc_instance_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct cbc_instance *i = (struct cbc_instance *) o;
  mark((struct lsh_object *) i->inner);
}

static void do_cbc_instance_free(struct lsh_object *o)
{
  struct cbc_instance *i = (struct cbc_instance *) o;
  lsh_space_free(i->iv);
}

struct lsh_class cbc_instance_class =
{ STATIC_HEADER,
  &crypto_instance_class, "cbc_instance", sizeof(struct cbc_instance),
  do_cbc_instance_mark,
  do_cbc_instance_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct crypto_inverted
{
  struct crypto_algorithm super;
  struct crypto_algorithm *inner;
};
extern struct lsh_class crypto_inverted_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_crypto_inverted_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct crypto_inverted *i = (struct crypto_inverted *) o;
  mark((struct lsh_object *) i->inner);
}

struct lsh_class crypto_inverted_class =
{ STATIC_HEADER,
  &crypto_algorithm_class, "crypto_inverted", sizeof(struct crypto_inverted),
  do_crypto_inverted_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct crypto_cascade_algorithm
{
  struct crypto_algorithm super;
  struct object_list *cascade;
};
extern struct lsh_class crypto_cascade_algorithm_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_crypto_cascade_algorithm_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct crypto_cascade_algorithm *i = (struct crypto_cascade_algorithm *) o;
  mark((struct lsh_object *) i->cascade);
}

struct lsh_class crypto_cascade_algorithm_class =
{ STATIC_HEADER,
  &crypto_algorithm_class, "crypto_cascade_algorithm", sizeof(struct crypto_cascade_algorithm),
  do_crypto_cascade_algorithm_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct crypto_cascade_instance
{
  struct crypto_instance super;
  struct object_list *cascade;
};
extern struct lsh_class crypto_cascade_instance_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_crypto_cascade_instance_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct crypto_cascade_instance *i = (struct crypto_cascade_instance *) o;
  mark((struct lsh_object *) i->cascade);
}

struct lsh_class crypto_cascade_instance_class =
{ STATIC_HEADER,
  &crypto_instance_class, "crypto_cascade_instance", sizeof(struct crypto_cascade_instance),
  do_crypto_cascade_instance_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct hmac_algorithm
{
  struct mac_algorithm super;
  struct hash_algorithm *hash;
};
extern struct lsh_class hmac_algorithm_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_hmac_algorithm_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct hmac_algorithm *i = (struct hmac_algorithm *) o;
  mark((struct lsh_object *) i->hash);
}

struct lsh_class hmac_algorithm_class =
{ STATIC_HEADER,
  &mac_algorithm_class, "hmac_algorithm", sizeof(struct hmac_algorithm),
  do_hmac_algorithm_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct hmac_instance
{
  struct mac_instance super;
  struct hash_instance *hinner;
  struct hash_instance *houter;
  struct hash_instance *state;
};
extern struct lsh_class hmac_instance_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_hmac_instance_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct hmac_instance *i = (struct hmac_instance *) o;
  mark((struct lsh_object *) i->hinner);
  mark((struct lsh_object *) i->houter);
  mark((struct lsh_object *) i->state);
}

struct lsh_class hmac_instance_class =
{ STATIC_HEADER,
  &mac_instance_class, "hmac_instance", sizeof(struct hmac_instance),
  do_hmac_instance_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

