// Cipher test mode code...
// Note that blowfish test mode only uses a 128 bit key, whereas in the
// program it uses a 256 bit key....... A reminder is placed on the 
// appropriate dialog box.....
int blowkeysize=16;
int inputerror;
int aninputerror;
unsigned long cipherdata[12];  // 4 longs key 4 longs plain 4 longs cipher
unsigned long tu[12];
int testcipher=0;

int testbytemode=0;

void testencipher(int algorithm) //,unsigned long *key,unsigned long * ctext,unsigned long * ptext)
{	
	unsigned long *ptext=&tu[4];
	unsigned long *key=&tu[0];

	memcpy ((char *) &tu[0],(char *) &cipherdata[0],12*4);
	cipher=testcipher+1;
	InitializeCipher((char *) key,blowkeysize); // format.cpp reads "cipher" variable...

				switch (cipher)
				{
				case BLOWFISH:
					 Blowfish_encipher(&ptext[0],&ptext[1],0);
					 break;

				case TEA16:
				case TEA32:
					 teaencipher(ptext,0);
					 break;
				
				case IDEA:
					 ideaencipher(ptext,0);
					 break;

				case DES:
					 desencipher(ptext,0);
					 break;
				
				case SQUARE:
					 squareencipher(ptext,0);
					 break;
				
				case MISTY1:
					 mistyencipher(ptext,0);
					 break;

				case THREEDES:
					 threedesencipher(ptext,0);
					 break;
				

				}
				memcpy((char *) &cipherdata[8],(char *) &tu[4],16);

}


void testdecipher(int algorithm) //,unsigned long *key,unsigned long * ctext,unsigned long * ptext)
{
	
	
	unsigned long *ctext=&tu[8];
	unsigned long *key=&tu[0];

	memcpy ((char *) &tu[0],(char *) &cipherdata[0],12*4);
	cipher=testcipher+1;
	InitializeCipher((char *) key,blowkeysize); // format.cpp reads "cipher" variable...

	switch (cipher)
				{
				
				case BLOWFISH:
				Blowfish_decipher(&ctext[0],&ctext[1],0);
				break;
				case TEA16:
				case TEA32:
				teadecipher(ctext,0);
				break;

				case IDEA:
				ideadecipher(ctext,0);
				break;

				case DES:
				desdecipher(ctext,0);
				break;
				
				case SQUARE:
				squaredecipher(ctext,0);
				break;

				case MISTY1:
				mistydecipher(ctext,0);
				break;

				case THREEDES:
				threedesdecipher(ctext,0);
				break;
			    }

	memcpy((char *) &cipherdata[4],(char *) &tu[8],16);
}


unsigned int gethex32(char * buffer)
{


	unsigned int d,d2;
	unsigned char ch,c;
	int len;
	inputerror=0;
	d=0;
	d2=0;

	char  *dp;

	len=strlen(buffer);
	if (len>8)
	{

		inputerror=2;
		return 0;
	}
	
	if (len==0) return 0;

	while (ch=*buffer++)
	{
		if (ch!=32)
		{
			
			if ( (ch>='0') && (ch<='9') ); // do nothing
				else
					if ( (ch<'a') || (ch>'f') )
						{
						inputerror++;
						return 0;
						}
			
			
			d=d<<4;
			if (ch<'A')
		
					ch=ch-'0';		
				
			else
		
			{
				ch=ch-'a';
				ch=ch+10;
			}
		
		if (ch>15) 
		
			{
			inputerror++;
			return 0;
			}
	
			d2=ch;
			d=d|d2;
		}

	}
	


	if (testbytemode)
	{

		dp=(char *) &d;
		c=dp[0];
		dp[0]=dp[3];
		dp[3]=c;

		c=dp[1];
		dp[1]=dp[2];
		dp[2]=c;

		

	}

return d;
}




BOOL sethexdata (HWND hDlg, short id,unsigned long *u,int numdwords)
{
	int n;
	short z;

	char buffer[32];
	char errors[12][64]=
	{
	 "key Long0",
	 "key Long1",
	 "key Long2",
	 "key Long3",
	 "plaintextLong0",
	 "plaintext Long1",
	 "plaintext Long2",
	 "plaintext Long3",
	 
	 "ciphertext Long0",
	 "ciphertext Long1",
	 "ciphertext Long2",
	 "ciphertext Long3"
	};
	 
	char err1[]="Invalid HEX input at: Hexadecimal  ";
	char err2[256];
	// note that ID MUST be contiguous......
	for (n=0;n<numdwords;n++)
	{
		GetDlgItemText(hDlg,id,buffer,9);
		*u=gethex32(buffer);
		if (inputerror)
			{
			z=id-IDC_EDIT1;
			strcpy(err2,err1);
			strcat(err2,errors[z]);
			SetDlgItemText(hDlg,id,"????????");
			MessageBox(hDlg,err2,"Input error",MB_ICONSTOP|MB_OK);
			aninputerror++;
			return TRUE;
			}
		
		u++;
		id++;
	}
	return FALSE;
}



BOOL getkey(HWND hDlg)
{
	memset ((char *)cipherdata,0,4*4);
	if (testcipher!=4)
		return (sethexdata(hDlg,IDC_EDIT1,&cipherdata[0],4));
	else 
		return (sethexdata(hDlg,IDC_EDIT1,&cipherdata[0],4));
}


BOOL getplain(HWND hDlg)
{
	memset ((char *)&cipherdata[4],0,4*4);
	if ((testcipher!=5) )
		return (sethexdata(hDlg,IDC_EDIT5,&cipherdata[4],2));
	else 
		return (sethexdata(hDlg,IDC_EDIT5,&cipherdata[4],4)); //square...
}

BOOL getcipher(HWND hDlg)
{
	memset ((char *)&cipherdata[8],0,4*4);
	if ((testcipher!=5) && (testcipher!=6) )
		return (sethexdata(hDlg,IDC_EDIT9,&cipherdata[8],2));
	else 
		return (sethexdata(hDlg,IDC_EDIT9,&cipherdata[8],4)); //square...
}




void SetTestRadioButtons(HWND hDlg,WPARAM id)
{

WPARAM ids[]=
{
IDC_BLOWFISH,                   
IDC_TEA16,                        
IDC_TEA32,                       
IDC_IDEA,                        
IDC_DES,                         
IDC_SQUARE,                      
IDC_MISTY1,                      
};

int x;
BOOL en34;
BOOL en781112;
HWND hCtrl;


for (x=0;x<7;x++)
	{
	hCtrl=GetDlgItem(hDlg,ids[x]);	
	SendMessage(hCtrl,BM_SETCHECK,BST_UNCHECKED,0);
	if (ids[x]==id)
		{
		SendMessage(hCtrl,BM_SETCHECK,BST_CHECKED,0);
		testcipher=x;
		}
	}		

	en781112=FALSE;
	if (testcipher==5)   //SQUARE 
		en781112=TRUE;

		hCtrl=GetDlgItem(hDlg,IDC_EDIT7); 	  
				EnableWindow(hCtrl,en781112);
		hCtrl=GetDlgItem(hDlg,IDC_EDIT8); 	  
				EnableWindow(hCtrl,en781112);
		hCtrl=GetDlgItem(hDlg,IDC_EDIT11); 	  
				EnableWindow(hCtrl,en781112);
		hCtrl=GetDlgItem(hDlg,IDC_EDIT12); 	  
				EnableWindow(hCtrl,en781112);
	

	 en34=TRUE;
	if (testcipher==4)	//DES
		en34=FALSE;

		hCtrl=GetDlgItem(hDlg,IDC_EDIT3); 	  
				EnableWindow(hCtrl,en34);
		hCtrl=GetDlgItem(hDlg,IDC_EDIT4); 	  
				EnableWindow(hCtrl,en34);
}



void makehex32(char *buffer,unsigned long number)
{

	char hex[]="0123456789abcdef";

	int x;
	unsigned int d;
	unsigned char c;
	if (testbytemode==0)
	{
	for (x=0;x<8;x++)
		{
		d=number;
		number=number<<4;
		d=d>>28;
		buffer[x]=hex[d];
		}
	buffer[x]=0;
	return;
	}
	


		for (x=0;x<8;x+=2)
	{

		c=(unsigned char) (number&255);
		buffer[x]=hex[(c>>4)&15];
		buffer [x+1]=hex[c&15];
		number=number>>8;


	}



}
	
		
void settestinputlimits(HWND hDlg)
{
		int n;
		HWND hCtrl;
		for (n=0;n<12;n++)
		{
		 hCtrl=GetDlgItem(hDlg,IDC_EDIT1+n);	//box of 11 chars
		 SendMessage(hCtrl,EM_LIMITTEXT,8,0);
		}
}
void SetTestTexts(HWND hDlg)
{
int x;	
BOOL doit;
char number[32]="        ";
for (x=0;x<12;x++)
	{
		
		doit=TRUE;
		strcpy (number,"        ");
		
		if ( (x==2) || (x==3) )
			{
			if (testcipher==4) doit=FALSE;
			}
		

			if ( (x==6) || (x==7) || (x==10) || (x==11) )
				{
					if (testcipher!=5) // square 
					doit=FALSE;
				}


		if (doit)
			makehex32(number,cipherdata[x]);		
		
		SetDlgItemText(hDlg,IDC_EDIT1+x,number);  // Make sure EDIT1..EDIT12 is		
							   // contiguous
	}


}



BOOL CALLBACK TestDlgProc(HWND hDlg,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
static HWND hCtrlPic;

HWND hparent;
HWND hCtrl;
hparent=GetParent(hDlg);


  switch(iMsg)
	{
	case WM_INITDIALOG:
	settestinputlimits(hDlg);
	SetTestRadioButtons(hDlg,IDC_BLOWFISH);
	memset ((char *)cipherdata,0,4*12);
	SetTestTexts(hDlg);	 
	return TRUE;


	case WM_COMMAND:
		 switch(LOWORD (wParam))
		     
		 
			{
				
			 case IDOK:   // encrypt
				 aninputerror=0;
				 getkey(hDlg); 
				 getplain(hDlg);
				 if (aninputerror==0)
					testencipher(testcipher); 
				 SetTestTexts(hDlg);
				 return TRUE;


			 case IDC_BUTTON1: // decrypt
				 aninputerror=0;
				 getkey(hDlg); 
				 getcipher(hDlg);	
				 if (aninputerror==0)
				     testdecipher(testcipher); 
				 SetTestTexts(hDlg);	 
				 return TRUE;

			 case IDC_TESTCLEAR:
				  memset ((char *)cipherdata,0,12*4);
				  SetTestTexts(hDlg);	 
				  return TRUE;

			 case IDCANCEL:
					EndDialog(hDlg,0);  
					return TRUE;


			case IDC_CHECK2:
			     hCtrl=GetDlgItem(hDlg,IDC_CHECK2);
		         testbytemode=FALSE;
	              if(BST_CHECKED==SendMessage(hCtrl,BM_GETCHECK,0,0)) 
				     testbytemode=TRUE; 
				 getkey(hDlg); 
				 getplain(hDlg);
				 getcipher(hDlg);
				  SetTestTexts(hDlg);	
				  return TRUE;

			case IDC_BLOWFISH:                   
			case IDC_TEA16:                        
			case IDC_TEA32:                       
			case IDC_IDEA:                       
			case IDC_DES:                         
			case IDC_SQUARE:                     
			case IDC_MISTY1:    
			SetTestRadioButtons(hDlg,wParam);
			SetTestTexts(hDlg);	 
			return TRUE;
			}
			break;


	case WM_DRAWITEM:
	     return TRUE;

	case WM_PAINT:
	     break;
	}

	return FALSE;
}



