#ifndef CLASS_DEFINE
struct group
{
  struct lsh_object super;
  mpz_t order;
  int (*(member))(struct group *self, mpz_t x);
  void (*(invert))(struct group *self, mpz_t res, mpz_t x);
  void (*(combine))(struct group *self, mpz_t res, mpz_t a, mpz_t b);
  void (*(power))(struct group *self, mpz_t res, mpz_t g, mpz_t e);
};
extern struct lsh_class group_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_group_free(struct lsh_object *o)
{
  struct group *i = (struct group *) o;
  mpz_clear(i->order);
}

struct lsh_class group_class =
{ STATIC_HEADER,
  0, "group", sizeof(struct group),
  NULL,
  do_group_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct dss_public
{
  mpz_t p;
  mpz_t q;
  mpz_t g;
  mpz_t y;
};
extern void dss_public_mark(struct dss_public *i, 
    void (*mark)(struct lsh_object *o));
extern void dss_public_free(struct dss_public *i);
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
void dss_public_mark(struct dss_public *i, 
    void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
}

void dss_public_free(struct dss_public *i)
{
  (void) i;
  mpz_clear(i->p);
  mpz_clear(i->q);
  mpz_clear(i->g);
  mpz_clear(i->y);
}

#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct diffie_hellman_method
{
  struct lsh_object super;
  struct group *G;
  mpz_t generator;
  struct hash_algorithm *H;
  struct randomness *random;
};
extern struct lsh_class diffie_hellman_method_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_diffie_hellman_method_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct diffie_hellman_method *i = (struct diffie_hellman_method *) o;
  mark((struct lsh_object *) i->G);
  mark((struct lsh_object *) i->H);
  mark((struct lsh_object *) i->random);
}

static void do_diffie_hellman_method_free(struct lsh_object *o)
{
  struct diffie_hellman_method *i = (struct diffie_hellman_method *) o;
  mpz_clear(i->generator);
}

struct lsh_class diffie_hellman_method_class =
{ STATIC_HEADER,
  0, "diffie_hellman_method", sizeof(struct diffie_hellman_method),
  do_diffie_hellman_method_mark,
  do_diffie_hellman_method_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct diffie_hellman_instance
{
  struct diffie_hellman_method *method;
  mpz_t e;
  mpz_t f;
  struct lsh_string *server_key;
  struct lsh_string *signature;
  mpz_t secret;
  mpz_t K;
  struct hash_instance *hash;
  struct lsh_string *exchange_hash;
};
extern void diffie_hellman_instance_mark(struct diffie_hellman_instance *i, 
    void (*mark)(struct lsh_object *o));
extern void diffie_hellman_instance_free(struct diffie_hellman_instance *i);
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
void diffie_hellman_instance_mark(struct diffie_hellman_instance *i, 
    void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
  mark((struct lsh_object *) i->method);
  mark((struct lsh_object *) i->hash);
}

void diffie_hellman_instance_free(struct diffie_hellman_instance *i)
{
  (void) i;
  mpz_clear(i->e);
  mpz_clear(i->f);
  lsh_string_free(i->server_key);
  lsh_string_free(i->signature);
  mpz_clear(i->secret);
  mpz_clear(i->K);
  lsh_string_free(i->exchange_hash);
}

#endif /* !CLASS_DECLARE */

