#ifndef CLASS_DEFINE
struct dss_signer
{
  struct signer super;
  struct randomness *random;
  struct dss_public public;
  mpz_t a;
};
extern struct lsh_class dss_signer_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dss_signer_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dss_signer *i = (struct dss_signer *) o;
  mark((struct lsh_object *) i->random);
  dss_public_mark(&i->public, mark);
}

static void do_dss_signer_free(struct lsh_object *o)
{
  struct dss_signer *i = (struct dss_signer *) o;
  dss_public_free(&i->public);
  mpz_clear(i->a);
}

struct lsh_class dss_signer_class =
{ STATIC_HEADER,
  &signer_class, "dss_signer", sizeof(struct dss_signer),
  do_dss_signer_mark,
  do_dss_signer_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct dss_verifier
{
  struct verifier super;
  struct dss_public public;
};
extern struct lsh_class dss_verifier_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dss_verifier_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dss_verifier *i = (struct dss_verifier *) o;
  dss_public_mark(&i->public, mark);
}

static void do_dss_verifier_free(struct lsh_object *o)
{
  struct dss_verifier *i = (struct dss_verifier *) o;
  dss_public_free(&i->public);
}

struct lsh_class dss_verifier_class =
{ STATIC_HEADER,
  &verifier_class, "dss_verifier", sizeof(struct dss_verifier),
  do_dss_verifier_mark,
  do_dss_verifier_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct dss_algorithm
{
  struct signature_algorithm super;
  struct randomness *random;
};
extern struct lsh_class dss_algorithm_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dss_algorithm_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dss_algorithm *i = (struct dss_algorithm *) o;
  mark((struct lsh_object *) i->random);
}

struct lsh_class dss_algorithm_class =
{ STATIC_HEADER,
  &signature_algorithm_class, "dss_algorithm", sizeof(struct dss_algorithm),
  do_dss_algorithm_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct group_zn
{
  struct group super;
  mpz_t modulo;
};
extern struct lsh_class group_zn_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_group_zn_free(struct lsh_object *o)
{
  struct group_zn *i = (struct group_zn *) o;
  mpz_clear(i->modulo);
}

struct lsh_class group_zn_class =
{ STATIC_HEADER,
  &group_class, "group_zn", sizeof(struct group_zn),
  NULL,
  do_group_zn_free
};
#endif /* !CLASS_DECLARE */

