#ifndef CLASS_DEFINE
struct dh_server_exchange
{
  struct keyexchange_algorithm super;
  struct diffie_hellman_method *dh;
  struct lsh_string *server_key;
  struct signer *signer;
};
extern struct lsh_class dh_server_exchange_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dh_server_exchange_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_server_exchange *i = (struct dh_server_exchange *) o;
  mark((struct lsh_object *) i->dh);
  mark((struct lsh_object *) i->signer);
}

static void do_dh_server_exchange_free(struct lsh_object *o)
{
  struct dh_server_exchange *i = (struct dh_server_exchange *) o;
  lsh_string_free(i->server_key);
}

struct lsh_class dh_server_exchange_class =
{ STATIC_HEADER,
  &keyexchange_algorithm_class, "dh_server_exchange", sizeof(struct dh_server_exchange),
  do_dh_server_exchange_mark,
  do_dh_server_exchange_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct dh_server
{
  struct packet_handler super;
  struct diffie_hellman_instance dh;
  struct signer *signer;
  struct install_keys *install;
  struct ssh_service *finished;
};
extern struct lsh_class dh_server_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dh_server_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dh_server *i = (struct dh_server *) o;
  diffie_hellman_instance_mark(&i->dh, mark);
  mark((struct lsh_object *) i->signer);
  mark((struct lsh_object *) i->install);
  mark((struct lsh_object *) i->finished);
}

static void do_dh_server_free(struct lsh_object *o)
{
  struct dh_server *i = (struct dh_server *) o;
  diffie_hellman_instance_free(&i->dh);
}

struct lsh_class dh_server_class =
{ STATIC_HEADER,
  &packet_handler_class, "dh_server", sizeof(struct dh_server),
  do_dh_server_mark,
  do_dh_server_free
};
#endif /* !CLASS_DECLARE */

