/* randomness.h
 *
 *
 *
 * $Id: randomness.h,v 1.4 1998/09/22 04:11:56 nisse Exp $ */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1998 Niels Mller
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LSH_RANDOMNESS_H_INCLUDED
#define LSH_RANDOMNESS_H_INCLUDED

#include "abstract_crypto.h"

struct randomness
{
  struct lsh_object header;
  
  void (*random)(struct randomness **closure, UINT32 length, UINT8 *dst);
};

#define RANDOM(r, length, dst) ((r)->random(&(r), length, dst))

struct randomness *make_poor_random(struct hash_algorithm *hash,
				    struct lsh_string *init);

#endif /* LSH_RANDOMNESS_H_INCLUDED */
