/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import sunw.hotjava.misc.Globals;

class MessageBox
extends Window {
    private String message;
    private Point location;
    private Font font = Globals.getFont("hotjava.timedMessage.font", new Font("SansSerif", 0, 10));
    private FontMetrics fm = this.getFontMetrics(this.font);
    private static final int hMargin = 2;
    private static final int vMargin = 2;

    MessageBox(Frame frame, String string, Point point) {
        super(frame);
        this.message = string;
        this.location = point;
        Dimension dimension = this.measureMessage(string);
        dimension.width += 4;
        dimension.height += 4;
        this.setEnabled(false);
        ((Component)this).setSize(dimension);
        ((Component)this).setLocation(point.x, point.y);
        ((Component)this).setVisible(true);
    }

    private Dimension measureMessage(String string) {
        Dimension dimension = new Dimension();
        dimension.width = this.fm.stringWidth(string);
        dimension.height = this.fm.getHeight();
        return dimension;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Globals.getColor("hotjava.timedMessage.color", Color.yellow));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setFont(this.font);
        graphics.drawString(this.message, 2, 2 + this.fm.getAscent());
    }
}

