/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.net.www.protocol.http.HttpURLConnection;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HttpCookie;
import sunw.hotjava.misc.StaticStateWatcher;

public class Cookies {
    static Hashtable cookieJar = new Hashtable();

    public static void recordAnyCookies(URLConnection uRLConnection) {
        String string;
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        if (!Boolean.getBoolean("hotjava.enableCookies")) {
            return;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        int n = 1;
        while ((string = httpURLConnection.getHeaderFieldKey(n)) != null) {
            if (string.equalsIgnoreCase("set-cookie")) {
                String string2 = httpURLConnection.getHeaderField(n);
                Cookies.recordCookie(httpURLConnection, string2);
            }
            ++n;
        }
    }

    private static void recordCookie(HttpURLConnection httpURLConnection, String string) {
        HttpCookie httpCookie = new HttpCookie(httpURLConnection.getURL(), string);
        String[] stringArray = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String string2 = httpCookie.getDomain();
        if (string2 == null) {
            return;
        }
        string2.toLowerCase();
        String string3 = httpURLConnection.getURL().getHost();
        string3.toLowerCase();
        boolean bl = string3.equals(string2);
        if (!bl && string3.endsWith(string2)) {
            int n = 2;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string2.endsWith(stringArray[n2])) {
                    n = 1;
                }
                ++n2;
            }
            int n3 = string2.length();
            while (n3 > 0 && n > 0) {
                n3 = string2.lastIndexOf(46, n3 - 1);
                --n;
            }
            if (n3 > 0) {
                bl = true;
            }
        }
        if (bl) {
            Cookies.recordCookie(httpCookie);
            Globals.newCookieRecorded(httpCookie);
        }
    }

    public static void recordCookie(HttpCookie httpCookie) {
        Cookies.recordCookieToJar(httpCookie, cookieJar, true);
    }

    public static void recordCookieToJar(HttpCookie httpCookie, Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            if (Cookies.shouldRejectCookie(httpCookie)) {
                Object var4_4 = null;
                return;
            }
            String string = httpCookie.getDomain().toLowerCase();
            Vector vector = (Vector)hashtable.get(string);
            if (vector == null) {
                vector = new Vector();
            }
            if (Cookies.addOrReplaceCookie(vector, httpCookie, bl)) {
                hashtable.put(string, vector);
            }
            return;
        }
    }

    public static void setCookiesFromBean(Hashtable hashtable) {
        boolean[] blArray = new boolean[1];
        Globals.forEachWatcher(new 1(hashtable, blArray));
        if (blArray[0]) {
            return;
        }
        Hashtable hashtable2 = cookieJar;
        cookieJar = hashtable;
        Globals.forEachWatcher(new 2(hashtable, hashtable2));
    }

    public static Hashtable getCookiesForBean() {
        return (Hashtable)cookieJar.clone();
    }

    private static boolean addOrReplaceCookie(Vector vector, HttpCookie httpCookie, boolean bl) {
        String string;
        Object object;
        int n = vector.size();
        String string2 = httpCookie.getPath();
        String string3 = httpCookie.getName();
        Object object2 = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            String string4;
            object = (HttpCookie)vector.elementAt(n3);
            string = ((HttpCookie)object).getPath();
            if (string2.equals(string) && string3.equals(string4 = ((HttpCookie)object).getName())) {
                object2 = object;
                n2 = n3;
                break;
            }
            ++n3;
        }
        object = new boolean[1];
        string = object2;
        Globals.forEachWatcher(new 3(httpCookie, (HttpCookie)((Object)string), (boolean[])object));
        if (object[0] != false) {
            return false;
        }
        if (object2 != null) {
            vector.setElementAt(httpCookie, n2);
        } else {
            vector.addElement(httpCookie);
        }
        Globals.forEachWatcher(new 4(httpCookie, (HttpCookie)((Object)string)));
        return true;
    }

    private static boolean shouldRejectCookie(HttpCookie httpCookie) {
        return false;
    }

    public static void applyRelevantCookies(URL uRL, URLConnection uRLConnection) {
        int n;
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        if (!Boolean.getBoolean("hotjava.enableCookies")) {
            return;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        String string = uRL.getHost();
        Cookies.applyCookiesForHost(string, uRL, httpURLConnection);
        while ((n = string.indexOf(46, 1)) >= 0) {
            string = string.substring(n + 1);
            Cookies.applyCookiesForHost(string, uRL, httpURLConnection);
        }
    }

    private static void applyCookiesForHost(String string, URL uRL, HttpURLConnection httpURLConnection) {
        Object object;
        Object object2;
        Vector vector = (Vector)cookieJar.get(string);
        if (vector == null) {
            return;
        }
        String string2 = uRL.getFile();
        int n = string2.indexOf(63);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        Enumeration enumeration = vector.elements();
        Vector<Object> vector2 = new Vector<Object>(10);
        while (enumeration.hasMoreElements()) {
            object2 = (HttpCookie)enumeration.nextElement();
            object = ((HttpCookie)object2).getPath();
            if (!string2.startsWith((String)object) || ((HttpCookie)object2).hasExpired()) continue;
            vector2.addElement(object2);
        }
        if (vector2.size() > 1) {
            int n2 = 0;
            while (n2 < vector2.size() - 1) {
                object = (HttpCookie)vector2.elementAt(n2);
                String string3 = ((HttpCookie)object).getPath();
                if (!string3.endsWith("/")) {
                    string3 = String.valueOf(string3) + "/";
                }
                int n3 = n2 + 1;
                while (n3 < vector2.size()) {
                    HttpCookie httpCookie = (HttpCookie)vector2.elementAt(n3);
                    String string4 = httpCookie.getPath();
                    if (!string4.endsWith("/")) {
                        string4 = String.valueOf(string4) + "/";
                    }
                    int n4 = 0;
                    int n5 = -1;
                    while ((n5 = string3.indexOf(47, n5 + 1)) != -1) {
                        ++n4;
                    }
                    n5 = -1;
                    int n6 = 0;
                    while ((n5 = string4.indexOf(47, n5 + 1)) != -1) {
                        ++n6;
                    }
                    if (n6 > n4) {
                        vector2.setElementAt(object, n3);
                        vector2.setElementAt(httpCookie, n2);
                        object = httpCookie;
                        string3 = string4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        enumeration = vector2.elements();
        object2 = null;
        while (enumeration.hasMoreElements()) {
            object = (HttpCookie)enumeration.nextElement();
            object2 = object2 == null ? ((HttpCookie)object).getNameValue() : String.valueOf(object2) + "; " + ((HttpCookie)object).getNameValue();
        }
        if (object2 != null) {
            httpURLConnection.setRequestProperty("Cookie", (String)object2);
        }
    }

    static void loadPersistentCookies() {
        String string = Cookies.getCookieFilePath();
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    HttpCookie httpCookie = new HttpCookie(string2);
                    Cookies.recordCookieToJar(httpCookie, cookieJar, false);
                }
                return;
            }
            finally {
                Object var4_5 = null;
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    static void savePersistentCookies() {
        String string = Cookies.getCookieFilePath();
        try {
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, false);
            try {
                Cookies.saveCookiesToStream(printWriter);
                return;
            }
            finally {
                Object var4_4 = null;
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Saving cookies failed " + iOException.getMessage());
            return;
        }
    }

    private static void saveCookiesToStream(PrintWriter printWriter) {
        Enumeration enumeration = cookieJar.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                HttpCookie httpCookie = (HttpCookie)enumeration2.nextElement();
                if (!httpCookie.isSaveable()) continue;
                printWriter.println(httpCookie);
            }
        }
    }

    private static String getCookieFilePath() {
        String string = System.getProperty("user.home");
        if (string != null && !string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return String.valueOf(string) + ".hotjava" + File.separator + "cookies";
    }

    private static final class 1
    extends StaticStateWatcher.Action {
        private final /* synthetic */ Hashtable val$newJar;
        private final /* synthetic */ boolean[] val$veto;

        public void doit(StaticStateWatcher staticStateWatcher) {
            this.val$veto[0] = this.val$veto[0] || staticStateWatcher.vetoCookieListChange(cookieJar, this.val$newJar);
        }

        /* synthetic */ 1(Hashtable hashtable, boolean[] blArray) {
            this.val$newJar = hashtable;
            this.val$veto = blArray;
        }
    }

    private static final class 2
    extends StaticStateWatcher.Action {
        private final /* synthetic */ Hashtable val$newJar;
        private final /* synthetic */ Hashtable val$oldJar;

        public void doit(StaticStateWatcher staticStateWatcher) {
            staticStateWatcher.notifyCookieListChange(this.val$oldJar, this.val$newJar);
        }

        /* synthetic */ 2(Hashtable hashtable, Hashtable hashtable2) {
            this.val$newJar = hashtable;
            this.val$oldJar = hashtable2;
        }
    }

    private static final class 3
    extends StaticStateWatcher.Action {
        private final /* synthetic */ HttpCookie val$cookie;
        private final /* synthetic */ HttpCookie val$replacedCookie;
        private final /* synthetic */ boolean[] val$veto;

        public void doit(StaticStateWatcher staticStateWatcher) {
            this.val$veto[0] = this.val$veto[0] || staticStateWatcher.vetoCookieAdd(cookieJar, this.val$replacedCookie, this.val$cookie);
        }

        /* synthetic */ 3(HttpCookie httpCookie, HttpCookie httpCookie2, boolean[] blArray) {
            this.val$cookie = httpCookie;
            this.val$replacedCookie = httpCookie2;
            this.val$veto = blArray;
        }
    }

    private static final class 4
    extends StaticStateWatcher.Action {
        private final /* synthetic */ HttpCookie val$cookie;
        private final /* synthetic */ HttpCookie val$replacedCookie;

        public void doit(StaticStateWatcher staticStateWatcher) {
            staticStateWatcher.notifyCookieAdd(cookieJar, this.val$replacedCookie, this.val$cookie);
        }

        /* synthetic */ 4(HttpCookie httpCookie, HttpCookie httpCookie2) {
            this.val$cookie = httpCookie;
            this.val$replacedCookie = httpCookie2;
        }
    }
}

