/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.forms;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.Document;
import sunw.hotjava.forms.FormPanel;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.tags.A;

class ImageCanvas
extends Canvas
implements DocConstants {
    Image img;
    boolean depressed;
    boolean usingErrorImage = false;
    static Image errorImage = null;
    boolean badErrorImage = false;
    ActionListener listeners;
    int border = 2;
    private static boolean lazyLoadingNotDone = true;

    public ImageCanvas(Image image) {
        ImageCanvas.loadLazy();
        if (image == null) {
            image = errorImage;
        }
        this.img = image;
        this.addMouseListener(new MouseEventListener());
    }

    public ImageCanvas(Image image, String string) {
        this(image);
        ImageCanvas.loadLazy();
        try {
            this.border = Integer.parseInt(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.border = 2;
            return;
        }
    }

    private static synchronized void loadLazy() {
        if (lazyLoadingNotDone) {
            errorImage = Globals.getImage(System.getProperty("img.errimg"));
            lazyLoadingNotDone = false;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, actionListener);
    }

    protected void dispatchActionEvent(MouseEvent mouseEvent) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.getName(), mouseEvent.getModifiers());
        this.listeners.actionPerformed(actionEvent);
    }

    public Dimension preferredSize() {
        if (this.img != null) {
            int n = this.img.getWidth(this);
            int n2 = this.img.getHeight(this);
            if (n >= 0 && n2 >= 0) {
                return new Dimension(n, n2);
            }
        }
        return super.preferredSize();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.badErrorImage || this.usingErrorImage && image != errorImage || !this.usingErrorImage && image != this.img) {
            return false;
        }
        if ((n & 0x40) != 0) {
            if (this.usingErrorImage) {
                this.badErrorImage = true;
                return false;
            }
            this.img = errorImage;
            this.usingErrorImage = true;
        }
        if ((n & 0x43) != 0) {
            FormPanel formPanel = (FormPanel)this.getParent();
            Object object = Globals.getAwtLock();
            synchronized (object) {
                Document document = formPanel.doc;
                synchronized (document) {
                    int n6 = formPanel.item.getIndex();
                    formPanel.doc.change(n6 << 16, n6 + 1 << 16);
                }
            }
        }
        if ((n & 0x40) != 0) {
            return false;
        }
        return super.imageUpdate(this.img, n, n2, n3, n4, n5);
    }

    private void paintBorder(Graphics graphics, Color color) {
        int n = this.img.getWidth(this);
        int n2 = this.img.getHeight(this);
        if (n <= 0 || n2 <= 0) {
            return;
        }
        graphics.setColor(color);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this.border) {
            graphics.drawRect(n4, n5, n - (n3 * 2 + 1), n2 - (n3 * 2 + 1));
            ++n3;
            ++n4;
            ++n5;
        }
    }

    public void paint(Graphics graphics) {
        if (this.img != null && !this.badErrorImage) {
            graphics.drawImage(this.img, 0, 0, this);
            if (this.border != 0) {
                this.paintBorder(graphics, A.newColor);
            }
        }
    }

    private void mouseDown() {
        if (this.img != null && !this.badErrorImage) {
            this.depressed = true;
            if (this.border != 0) {
                this.paintBorder(this.getGraphics(), A.activeColor);
            }
        }
    }

    private void mouseUp(Point point) {
        if (this.img != null && !this.badErrorImage) {
            if (this.depressed && this.inside(point.x, point.y)) {
                if (this.border != 0) {
                    this.paintBorder(this.getGraphics(), A.newColor);
                }
                String string = String.valueOf(point.x) + ":" + point.y;
                ((FormPanel)this.getParent()).processUserAction(new ActionEvent(this, 1001, string));
            }
            this.depressed = false;
        }
    }

    class MouseEventListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            ImageCanvas.this.mouseDown();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageCanvas.this.mouseUp(mouseEvent.getPoint());
        }

        MouseEventListener() {
            ImageCanvas.this = ImageCanvas.this;
        }
    }
}

