/*
 * Decompiled with CFR 0.152.
 */
package netscape.secfile;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import netscape.secfile.FileOutputStreamNoFinalize;
import netscape.secfile.SecureFile;
import netscape.secfile.SecureFileException;
import netscape.secfile.SecureRandomAccessFile;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;

public class SecureFileOutputStream
extends FileOutputStream {
    private String prepend;
    private Principal prin;

    public SecureFileOutputStream(String string) throws IOException {
        this(string, false, SecureFile.getClassPrincipal(1), 1);
    }

    public SecureFileOutputStream(String string, boolean bl) throws IOException {
        this(string, bl, SecureFile.getClassPrincipal(1), 1);
    }

    public SecureFileOutputStream(SecureFile secureFile) throws IOException {
        this(secureFile.getPath(), false, secureFile.getPrincipal(), 1);
    }

    public SecureFileOutputStream(FileDescriptor fileDescriptor) {
        this(fileDescriptor, PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdWrite")));
        this.prin = null;
    }

    private static FileDescriptor rethrow(String string, String string2, boolean bl) throws IOException {
        FileOutputStreamNoFinalize fileOutputStreamNoFinalize;
        PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFileWrite"));
        try {
            fileOutputStreamNoFinalize = new FileOutputStreamNoFinalize(string, bl);
        }
        catch (IOException iOException) {
            throw new IOException(string2);
        }
        try {
            return fileOutputStreamNoFinalize.getFD();
        }
        catch (IOException iOException) {
            throw new SecureFileException("Internal error");
        }
    }

    public SecureFileOutputStream(String string, Principal principal) throws IOException {
        this(string, false, principal, 1);
    }

    public SecureFileOutputStream(String string, boolean bl, Principal principal) throws IOException {
        this(string, bl, principal, 1);
    }

    SecureFileOutputStream(String string, boolean bl, Principal principal, int n) throws IOException {
        this(SecureFileOutputStream.rethrow(SecureFile.getPrependedPath(SecureFile.getPrepend(principal, n + 1), string), string, bl), PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdWrite")));
        this.prepend = SecureFile.getPrepend(principal, n + 1);
        SecureFile.checkCanonicalPath(string, this.prepend);
        this.prin = principal;
    }

    private SecureFileOutputStream(FileDescriptor fileDescriptor, Object object) {
        super(fileDescriptor);
    }

    public Principal getPrincipal() {
        return this.prin;
    }
}

