/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.registry;

import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.Registry;
import java.rmi.registry.RegistryHandler;

public final class LocateRegistry {
    private static String registryPkgPrefix;
    private static RegistryHandler handler;

    private LocateRegistry() {
    }

    public static Registry getRegistry() throws RemoteException {
        try {
            return LocateRegistry.getRegistry(null, 1099);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static Registry getRegistry(int n) throws RemoteException {
        try {
            return LocateRegistry.getRegistry(null, n);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static Registry getRegistry(String string) throws RemoteException, UnknownHostException {
        return LocateRegistry.getRegistry(string, 1099);
    }

    public static Registry getRegistry(String string, int n) throws RemoteException, UnknownHostException {
        if (handler != null) {
            return handler.registryStub(string, n);
        }
        throw new RemoteException("No registry handler present");
    }

    public static Registry createRegistry(int n) throws RemoteException {
        if (handler != null) {
            return handler.registryImpl(n);
        }
        throw new RemoteException("No registry handler present");
    }

    static {
        handler = null;
        try {
            SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
            registryPkgPrefix = System.getProperty("java.rmi.registry.packagePrefix", "sun.rmi.registry");
            SecurityManager.revertPrivilege();
            Class<?> clazz = Class.forName(String.valueOf(registryPkgPrefix) + ".RegistryHandler");
            handler = (RegistryHandler)clazz.newInstance();
        }
        catch (Exception exception) {}
    }
}

