/*
 * Decompiled with CFR 0.152.
 */
package netscape.jsdebug;

import netscape.jsdebug.DebugBreakHook;
import netscape.jsdebug.InstructionHook;
import netscape.jsdebug.InterruptHook;
import netscape.jsdebug.JSErrorReporter;
import netscape.jsdebug.JSStackFrameInfo;
import netscape.jsdebug.PC;
import netscape.jsdebug.ScriptHook;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;
import netscape.util.Hashtable;

public final class DebugController {
    private static DebugController controller;
    private ScriptHook scriptHook;
    private Hashtable instructionHookTable;
    private InterruptHook interruptHook;
    private DebugBreakHook debugBreakHook;
    private JSErrorReporter errorReporter;
    private Hashtable scriptTable = new Hashtable();
    private int _nativeContext;
    private static final int majorVersion = 1;
    private static final int minorVersion = 0;

    public static synchronized DebugController getDebugController() throws ForbiddenTargetException {
        try {
            PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
            if (controller == null) {
                controller = new DebugController();
            }
            return controller;
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            System.out.println("failed in check Priv in DebugController.getDebugController()");
            forbiddenTargetException.printStackTrace(System.out);
            throw forbiddenTargetException;
        }
    }

    private DebugController() {
        this._setController(true);
    }

    public synchronized ScriptHook setScriptHook(ScriptHook scriptHook) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        ScriptHook scriptHook2 = this.scriptHook;
        this.scriptHook = scriptHook;
        return scriptHook2;
    }

    public ScriptHook getScriptHook() throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this.scriptHook;
    }

    public synchronized InstructionHook setInstructionHook(PC pC, InstructionHook instructionHook) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        if (this.instructionHookTable == null) {
            this.instructionHookTable = new Hashtable();
        }
        InstructionHook instructionHook2 = (InstructionHook)this.instructionHookTable.get((Object)pC);
        this.instructionHookTable.put((Object)pC, (Object)instructionHook);
        this.setInstructionHook0(pC);
        return instructionHook2;
    }

    private native void setInstructionHook0(PC var1);

    public InstructionHook getInstructionHook(PC pC) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this.getInstructionHook0(pC);
    }

    private InstructionHook getInstructionHook0(PC pC) {
        if (this.instructionHookTable == null) {
            return null;
        }
        return (InstructionHook)this.instructionHookTable.get((Object)pC);
    }

    public synchronized InterruptHook setInterruptHook(InterruptHook interruptHook) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        InterruptHook interruptHook2 = this.interruptHook;
        this.interruptHook = interruptHook;
        return interruptHook2;
    }

    public InterruptHook getInterruptHook() throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this.interruptHook;
    }

    public void sendInterrupt() throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        this.sendInterrupt0();
    }

    private native void sendInterrupt0();

    public synchronized DebugBreakHook setDebugBreakHook(DebugBreakHook debugBreakHook) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        DebugBreakHook debugBreakHook2 = this.debugBreakHook;
        this.debugBreakHook = debugBreakHook;
        return debugBreakHook2;
    }

    public DebugBreakHook getDebugBreakHook() throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this.debugBreakHook;
    }

    public int getNativeContext() throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this._nativeContext;
    }

    private native void _setController(boolean var1);

    public String executeScriptInStackFrame(JSStackFrameInfo jSStackFrameInfo, String string, String string2, int n) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this.executeScriptInStackFrame0(jSStackFrameInfo, string, string2, n);
    }

    private native String executeScriptInStackFrame0(JSStackFrameInfo var1, String var2, String var3, int var4);

    public JSErrorReporter getErrorReporter() throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        return this.errorReporter;
    }

    public JSErrorReporter setErrorReporter(JSErrorReporter jSErrorReporter) throws ForbiddenTargetException {
        PrivilegeManager.checkPrivilegeEnabled((String)"Debugger");
        JSErrorReporter jSErrorReporter2 = this.errorReporter;
        this.errorReporter = jSErrorReporter;
        return jSErrorReporter2;
    }

    public static int getMajorVersion() {
        return 1;
    }

    public static int getMinorVersion() {
        return 0;
    }

    private static native int getNativeMajorVersion();

    private static native int getNativeMinorVersion();
}

