/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.Archiver;
import netscape.util.ClassTable;
import netscape.util.Unarchiver;

final class ArchivingStack {
    int depth;
    int maxDepth;
    Object[] objArray;
    int[] intArray;

    ArchivingStack() {
    }

    private void growArrays() {
        this.maxDepth = this.maxDepth == 0 ? 8 : 2 * this.maxDepth;
        Object[] objectArray = new Object[2 * this.maxDepth];
        int[] nArray = new int[4 * this.maxDepth];
        if (this.objArray != null && this.intArray != null) {
            System.arraycopy(this.objArray, 0, objectArray, 0, this.objArray.length);
            System.arraycopy(this.intArray, 0, nArray, 0, this.intArray.length);
        }
        this.objArray = objectArray;
        this.intArray = nArray;
    }

    void pushArchiver(Archiver archiver) {
        ++this.depth;
        int n = this.depth;
        if (this.depth >= this.maxDepth) {
            this.growArrays();
        }
        this.objArray[2 * n] = archiver.currentObject;
        this.objArray[2 * n + 1] = archiver.currentTable;
        this.intArray[4 * n] = archiver.currentId;
        this.intArray[4 * n + 1] = archiver.currentColumnCount;
        this.intArray[4 * n + 2] = archiver.currentRow;
        this.intArray[4 * n + 3] = archiver.currentColumn;
    }

    void pushUnarchiver(Unarchiver unarchiver) {
        ++this.depth;
        int n = this.depth;
        if (this.depth >= this.maxDepth) {
            this.growArrays();
        }
        this.objArray[2 * n] = unarchiver.currentObject;
        this.objArray[2 * n + 1] = unarchiver.currentTable;
        this.intArray[4 * n] = unarchiver.currentId;
        this.intArray[4 * n + 1] = unarchiver.currentColumnCount;
        this.intArray[4 * n + 2] = unarchiver.currentRow;
        this.intArray[4 * n + 3] = unarchiver.currentColumn;
    }

    void popArchiver(Archiver archiver) {
        int n = this.depth--;
        archiver.currentObject = this.objArray[2 * n];
        this.objArray[2 * n] = null;
        archiver.currentTable = (ClassTable)this.objArray[2 * n + 1];
        this.objArray[2 * n + 1] = null;
        archiver.currentId = this.intArray[4 * n];
        archiver.currentColumnCount = this.intArray[4 * n + 1];
        archiver.currentRow = this.intArray[4 * n + 2];
        archiver.currentColumn = this.intArray[4 * n + 3];
    }

    void popUnarchiver(Unarchiver unarchiver) {
        int n = this.depth--;
        unarchiver.currentObject = this.objArray[2 * n];
        this.objArray[2 * n] = null;
        unarchiver.currentTable = (ClassTable)this.objArray[2 * n + 1];
        this.objArray[2 * n + 1] = null;
        unarchiver.currentId = this.intArray[4 * n];
        unarchiver.currentColumnCount = this.intArray[4 * n + 1];
        unarchiver.currentRow = this.intArray[4 * n + 2];
        unarchiver.currentColumn = this.intArray[4 * n + 3];
    }
}

