/*
	This is the header file for wpls2rtf.c 2.0
*/

#define	VERSION	"2.0"

/*
	If your compiler fails to set an appropriate OS macro, do so
	here; if none is selected, the program compiles for Unix.
*/


#if defined(applec) || defined(MPW) || defined(__MC68K__) || defined(__POWERPC__)
	#define	__MACOS__
#endif

#define uchar	unsigned char

#if defined(__INTEL__) && defined(__MWERKS__)	/*	CodeWarrior's x86 compiler	*/
	#define __MSDOS__	1
	#define TOOL
	int	strcasecmp(uchar *, uchar *);
	int	strncasecmp(uchar *, uchar *, int);
#endif

#if defined(__TURBOC__)
	#define HASSTRICMP
#endif

/* fix for incomplete stdio -- SunOS!	*/
#ifndef SEEK_SET
	#define	SEEK_SET	0
	#define	SEEK_CUR	1
	#define	SEEK_END	2
#endif

#if defined(HASSTRICMP)	/* ANSI, right?	:-)	*/
	#define	eq(a,b)		!stricmp(a,b)
	#define	eqn(a,b,n)	!strnicmp(a,b,n)
#else
	#define	eq(a,b)		!strcasecmp(a,b)
	#define	eqn(a,b,n)	!strncasecmp(a,b,n)
#endif


#define warn(a,b,c,d)	{sprintf(errStr,a,b,c,d); fprintf(stderr,errStr);}

#if defined(__MSDOS__) || defined(__TOS__)
	#define	DIRSEP	'\\'	/*	TOS or DOS	*/
#else
	#ifdef __MACOS__
		#define	DIRSEP	':'
		int	strcasecmp(uchar *, uchar *);
		int	strncasecmp(uchar *, uchar *, int);
		#ifndef TOOL
			#undef warn
			#define warn(a,b,c,d)	{sprintf(&errStr[1],a,b,c,d); macwarn(errStr);}
			void macwarn(uchar *);
			void SetFileInfo(uchar *);
		#endif
	#else
		#define	DIRSEP	'/'	/*	Unix, I hope	*/
	#endif
#endif

#ifndef FALSE
	#define	FALSE	0
	#define	TRUE	!FALSE
#endif
#define	NEWLINE	"\x0D\x0A"

/* Style bitflags */

#define BIT(x)	(1 << x)

#define	BOLD	0
#define	LIGHT	1
#define	ITALIC	2
#define	UNDERLINE	3
#define	SUPERSCRIPT	4
#define	SUBSCRIPT	5

#define VALID(x)	(!(x & BIT(6)) && (x & BIT(7)))
#define STYLED(x)	(x & 0x3F)

#define	BLOCKSTART	0
#define	BLOCKEND	1

/* Function prototypes */

#if !defined(__MACOS__) || defined(TOOL)
	int	main(int, uchar **);
	void	usage(uchar *);
	void	version(uchar *);
#endif
int	hex2num(uchar);
int	init_table(uchar *, int);
void	translate(uchar *, int);
void	dump(void);
