/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef DEBUG
extern u_int16_t our_port;
#endif

main(int argc, char **argv)
{
    int i;

#ifndef DEBUG
#if defined(__OpenBSD__) || defined(__NetBSD__)
    if (daemon(0, 0))  /* Conviniently available */
    {
	fprintf(stderr, "daemon() failed in main()");
	exit(-1);
    }
#else
    i = fork();
    if (i < 0)
    {
	fprintf(stderr, "fork() failed in main()");
	exit(-1);
    }
    else
      if (i)
	exit(0);  /* Parent dies */
    
    if (setsid() < 0)
    {
	fprintf(stderr, "setsid() failed in main()");
	exit(-1);
    }

    for (i = getdtablesize() - 1; i >= 0; i--)  /* Bad hack */
      close(i);
#endif
#endif

#ifdef DEBUG
    if (argc == 2)
    {
	if (!strcmp(argv[1], "-h"))
	  exit_log("usage: %s [port number]", argv[0], 0, 0);

	our_port = atoi(argv[1]);
    }
    else 
      if (argc != 1)
	exit_log("usage: %s [port number]", argv[0], 0, 0);
#endif    

    init_log();
    init_rnd_pool();
    init_vars();
    init_state();
    init_nums();
    call_server();
    exit(-1);        /* Shouldn't ever reach this */
}
