BEGIN;
SELECT _v.register_patch('exchange-0007', NULL, NULL);
SET search_path TO exchange;
CREATE FUNCTION alter_table_wire_targets7()
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE wire_targets'
    ' ADD COLUMN h_normalized_payto BYTEA CHECK(LENGTH(h_normalized_payto)=32)'
    '   DEFAULT NULL'
    ',ADD COLUMN aml_program_lock_timeout INT8'
    '   DEFAULT NULL'
    ';'
  );
  PERFORM comment_partitioned_column(
     'hash over the normalized payto URI for this account; used for KYC operations; NULL if not available (due to DB migration not initializing this value)'
    ,'h_normalized_payto'
    ,'wire_targets'
    ,NULL
  );
  PERFORM comment_partitioned_column(
     'If non-NULL, an AML program should be running and it holds a lock on this account, thus other AML programs should not be started concurrently. Given the possibility of crashes, the lock automatically expires at the time value given in this column. At that time, the lock can be considered stale.'
    ,'aml_program_lock_timeout'
    ,'wire_targets'
    ,NULL
  );
END $$;
CREATE FUNCTION constrain_table_wire_targets7(
  IN partition_suffix TEXT
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'wire_targets';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'CREATE INDEX ' || table_name || '_normalized_h_payto_index '
    'ON ' || table_name || ' '
    '(h_normalized_payto);'
  );
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('wire_targets7'
    ,'exchange-0007'
    ,'alter'
    ,TRUE
    ,FALSE),
    ('wire_targets7'
    ,'exchange-0007'
    ,'constrain'
    ,TRUE
    ,FALSE);
CREATE FUNCTION foreign_table_legitimization_outcomes7()
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'legitimization_outcomes';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' DROP CONSTRAINT ' || table_name || '_foreign_key_h_payto');
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('legitimization_outcomes7'
    ,'exchange-0007'
    ,'foreign'
    ,TRUE
    ,FALSE);
CREATE FUNCTION alter_table_batch_deposits7(
  IN partition_suffix TEXT DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  PERFORM create_partitioned_table(
    'ALTER TABLE %I'
    ' ADD COLUMN merchant_sig BYTEA CHECK(LENGTH(merchant_sig)=64)'
    '   DEFAULT NULL'
    ';',
    'batch_deposits'
    ,''
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'signature by the merchant over the contract terms, of purpose TALER_SIGNATURE_MERCHANT_CONTRACT'
    ,'merchant_sig'
    ,'batch_deposits'
    ,partition_suffix
  );
END $$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('batch_deposits7'
    ,'exchange-0007'
    ,'alter'
    ,TRUE
    ,FALSE);
CREATE FUNCTION alter_table_kyc_attributes7(
  IN partition_suffix TEXT DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'kyc_attributes';
BEGIN
  PERFORM create_partitioned_table(
    'ALTER TABLE %I'
    ' DROP COLUMN trigger_outcome_serial'
    ';'
    ,table_name
    ,''
    ,partition_suffix
  );
END $$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('kyc_attributes7'
    ,'exchange-0007'
    ,'alter'
    ,TRUE
    ,FALSE);
COMMIT;
