/** @file shishid_cmd.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef SHISHID_CMD_H
#define SHISHID_CMD_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "shishid"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "shishid"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * listen_arg;	/**< @brief Sockets to listen for queries on.  Family is `IPv4' or `IPv6', if absent the family is decided by gethostbyname(ADDR). An address of `*' indicates all addresses on the local host. The default is `*:kerberos/udp, *:kerberos/tcp'..  */
  char * listen_orig;	/**< @brief Sockets to listen for queries on.  Family is `IPv4' or `IPv6', if absent the family is decided by gethostbyname(ADDR). An address of `*' indicates all addresses on the local host. The default is `*:kerberos/udp, *:kerberos/tcp'. original value given at command line.  */
  const char *listen_help; /**< @brief Sockets to listen for queries on.  Family is `IPv4' or `IPv6', if absent the family is decided by gethostbyname(ADDR). An address of `*' indicates all addresses on the local host. The default is `*:kerberos/udp, *:kerberos/tcp'. help description.  */
  char * setuid_arg;	/**< @brief After binding socket, set user identity..  */
  char * setuid_orig;	/**< @brief After binding socket, set user identity. original value given at command line.  */
  const char *setuid_help; /**< @brief After binding socket, set user identity. help description.  */
  int no_tls_flag;	/**< @brief Disable TLS support (default=off).  */
  const char *no_tls_help; /**< @brief Disable TLS support help description.  */
  char * x509cafile_arg;	/**< @brief X.509 certificate authorities used to verify client certificates, in PEM format..  */
  char * x509cafile_orig;	/**< @brief X.509 certificate authorities used to verify client certificates, in PEM format. original value given at command line.  */
  const char *x509cafile_help; /**< @brief X.509 certificate authorities used to verify client certificates, in PEM format. help description.  */
  char * x509certfile_arg;	/**< @brief X.509 server certificate, in PEM format..  */
  char * x509certfile_orig;	/**< @brief X.509 server certificate, in PEM format. original value given at command line.  */
  const char *x509certfile_help; /**< @brief X.509 server certificate, in PEM format. help description.  */
  char * x509crlfile_arg;	/**< @brief X.509 certificate revocation list to check for revoked client certificates, in PEM format..  */
  char * x509crlfile_orig;	/**< @brief X.509 certificate revocation list to check for revoked client certificates, in PEM format. original value given at command line.  */
  const char *x509crlfile_help; /**< @brief X.509 certificate revocation list to check for revoked client certificates, in PEM format. help description.  */
  char * x509keyfile_arg;	/**< @brief X.509 server certificate key, in PEM format..  */
  char * x509keyfile_orig;	/**< @brief X.509 server certificate key, in PEM format. original value given at command line.  */
  const char *x509keyfile_help; /**< @brief X.509 server certificate key, in PEM format. help description.  */
  short resume_limit_arg;	/**< @brief Keep track of up to this many TLS sessions for resume purposes (0 to disable TLS resume). (default='50').  */
  char * resume_limit_orig;	/**< @brief Keep track of up to this many TLS sessions for resume purposes (0 to disable TLS resume). original value given at command line.  */
  const char *resume_limit_help; /**< @brief Keep track of up to this many TLS sessions for resume purposes (0 to disable TLS resume). help description.  */
  char * configuration_file_arg;	/**< @brief Use specified configuration file..  */
  char * configuration_file_orig;	/**< @brief Use specified configuration file. original value given at command line.  */
  const char *configuration_file_help; /**< @brief Use specified configuration file. help description.  */
  unsigned int verbose_min; /**< @brief Produce verbose output.\nUse multiple times to increase amount of information.'s minimum occurreces */
  unsigned int verbose_max; /**< @brief Produce verbose output.\nUse multiple times to increase amount of information.'s maximum occurreces */
  const char *verbose_help; /**< @brief Produce verbose output.\nUse multiple times to increase amount of information. help description.  */
  int quiet_flag;	/**< @brief Don't produce any diagnostic output.\n (default=off).  */
  const char *quiet_help; /**< @brief Don't produce any diagnostic output.\n help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int listen_given ;	/**< @brief Whether listen was given.  */
  unsigned int setuid_given ;	/**< @brief Whether setuid was given.  */
  unsigned int no_tls_given ;	/**< @brief Whether no-tls was given.  */
  unsigned int x509cafile_given ;	/**< @brief Whether x509cafile was given.  */
  unsigned int x509certfile_given ;	/**< @brief Whether x509certfile was given.  */
  unsigned int x509crlfile_given ;	/**< @brief Whether x509crlfile was given.  */
  unsigned int x509keyfile_given ;	/**< @brief Whether x509keyfile was given.  */
  unsigned int resume_limit_given ;	/**< @brief Whether resume-limit was given.  */
  unsigned int configuration_file_given ;	/**< @brief Whether configuration-file was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* SHISHID_CMD_H */
