/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "Board.h"
#include "BoardException.h"
#include <sstream>
#include <time.h>
Board::Board(int xSize,int ySize):xSize_(xSize),ySize_(ySize),
	warped_(0), players_(0), active_players_(0), remaining_players_(0), turn_(0) , n_att_(0),actualPlayer_(NULL),
	nbCoupperTurnAttack_(6),
	nbCoutRestant_(0),actualAction_(NOTCHOOSE),
	nbCoupperTurnDefend_(3),
	nbCoupperTurnGuerilla_(1),winner_(NULL)
{
	case_=new Case[xSize*ySize];
	isPlayerChoosedByHazard=false;
}

Board::Board(int xSize,int ySize,int warped,int players,int active_players,int remaining_players,int turn ,int n_att)
	:xSize_(xSize),ySize_(ySize),actualPlayer_(NULL),
	warped_(warped), players_(players), active_players_(active_players), remaining_players_(remaining_players), turn_(turn) , n_att_(n_att),
	nbCoupperTurnAttack_(6),
	nbCoutRestant_(0),actualAction_(NOTCHOOSE),
	nbCoupperTurnDefend_(3),
	nbCoupperTurnGuerilla_(1),winner_(NULL)
{
	case_=new Case[xSize*ySize];
	isPlayerChoosedByHazard=false;
}

Board::~Board(void)
{
}
/*
Case &Board::getCase(int x, int y){
	if ((x+y*xSize_)<0 || (x+y*xSize_) >xSize_*ySize_||x<0||y<0||x>=xSize_||y>=ySize_)
	{
		throw BoardException("bad coordinate , verify x or y");
	}
	return case_[x+y*xSize_];
}*/
Case *Board::getCaseNoThrow(int x, int y){
	if ((x+y*xSize_)<0 || (x+y*xSize_) >xSize_*ySize_||x<0||y<0||x>=xSize_||y>=ySize_)
	{
		return NULL;
	}
	return &case_[x+y*xSize_];
}

void Board::setCase(int x, int y, Case pcase) {
	if ((x+y*xSize_)<0 || (x+y*xSize_) >xSize_*ySize_)
	{
		throw BoardException("bad coordinate , verify x or y");
	}
	case_[x+y*xSize_]=pcase;
}

std::string Board::toString(){
	int ix=0;
	int iy=0;
	
	std::stringstream retValue;
	for (ix=0;ix<xSize_;ix++)
	for (iy=0;iy<ySize_;iy++)
	{

		retValue<<":["<<ix<<","<<iy<<"]"<<case_[ix+iy*xSize_].toString()<<std::endl;
	}
	return retValue.str();
}

int Board::getWidth(){
	return xSize_;
}

int Board::getHeight(){
	return ySize_;
}

Player *Board::getOrCreatePlayerByName(std::string name){
	if (playerMap_[name]==NULL)
	{
		playerMap_[name]=new Player(name);
	}
	return playerMap_[name];
}

Player *Board::getActualPlayer(){
	return actualPlayer_;
}

void Board::setActualPlayer(Player *act){
	actualPlayer_=act;
}

void Board::setFirstPlayerAsActualPlayer(){
	if (!isPlayerChoosedByHazard)
	{
		if (playerMap_.size()!=0)
		{
			 
			 actualPlayer_=playerMap_.begin()->second;
		}
	}
	else
	{
			setHazardPlayerAsActualPlayer();
	}
}
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <cstdlib>
#include <cstring>
void Board::setHazardPlayerAsActualPlayer(){
	if (playerMap_.size()!=0)
	{
		/* initialize random seed: */
		srand ((unsigned int) time(NULL) );
		unsigned int index=(unsigned int)(abs(rand()) % playerMap_.size());
		std::map<std::string,Player*>::iterator el= playerMap_.begin(); 
		unsigned int i=0;
		for (i=0;i<index;i++)
		{
			el++;
		}
		actualPlayer_=el->second;
	}
}
void Board::setPlayerChoosedByHazard(bool plByH){
	isPlayerChoosedByHazard=plByH;
}

void Board::setNbCoutRestant(int  a){nbCoutRestant_=a; }
void Board::setNbCoupperTurnAttack(int a){nbCoupperTurnAttack_=a;}
void Board::setNbCoupperTurnDefend(int a){nbCoupperTurnDefend_=a;}
void Board::setNbCoupperTurnGuerilla(int a){nbCoupperTurnGuerilla_=a;}

int Board::getNbCoutRestant(){return nbCoutRestant_;}
int Board::getNbCoupperTurnAttack(){return nbCoupperTurnAttack_;}
int Board::getNbCoupperTurnDefend(){return nbCoupperTurnDefend_;}
int Board::getNbCoupperTurnGuerilla(){return nbCoupperTurnGuerilla_;}

void Board::decNbCoutRestant(){ nbCoutRestant_--;}
void Board::incNbCoutRestant(){ nbCoutRestant_++;}


void Board::setNextPlayer(){
	std::map<std::string,Player*>::iterator el= playerMap_.find(actualPlayer_->getName());
	int count=0;
	do{
		
		el++;
		count++;
		if (el==playerMap_.end())
		{
			el=playerMap_.begin();
		}
		
	}while (el->second->hasLost()&&count<playerMap_.size());
	actualPlayer_=el->second;
}

void Board::setActionMode(ActualActionMode m){
	actualAction_=m;
}

Board::ActualActionMode Board::getActionMode(){
	return actualAction_;
}

Player * Board::getWinner(){
	return winner_;
}


void Board::setWinner(Player * w){
	winner_=w;
}

Player * Board::getPlayer(int i)
{
	std::map<std::string,Player*>::iterator p=playerMap_.begin();
	unsigned int j=0;
	for (j=0;j<playerMap_.size();j++)
	{
		if (i==j) return p->second;
		p++;
	}
	return NULL;
}

void Board::rename(int i,std::string user){
	std::map<std::string,Player*>::iterator p=playerMap_.begin();
	unsigned int j=0;
	for (j=0;j<playerMap_.size();j++)
	{
		if (i==j) 
		{
		  for (int k=0;k<xSize_*ySize_;k++)
		  {
		      if(case_[k].getPlayer()!=NULL&&case_[k].getPlayer()->getName()==p->second->getName() )
		      {
			case_[k].playerName_=user;
			case_[k].previousplayername_=user;
		      }
		  }
		  p->second->setName(user);
		  return ;
		}
		p++;
	}
	

}

int Board::getNbPlayers(){
	return (int)playerMap_.size();

}


std::istream&  operator>> (std::istream& in, Board& per)

{
	int version=0;
	in >> version;
	if (version==1)
	{
		
		in >> per.xSize_;
		in >> per.ySize_;
		in >> per.warped_;
		in >> per.players_;
		in >> per.active_players_;
		in >> per.remaining_players_;
		in >> per.turn_ ; 
		in >> per.n_att_;

		//Manage players
		int nbPlayer=0;
		in >> nbPlayer;
		int i=0;
		for (i=0;i<nbPlayer;i++)
		{
			Player *pl = new Player("");
			in >> *pl;
			per.playerMap_[pl->getName()]=pl;
		}

		//manage actualPlayer
		std::string tempo;
		in >> tempo; 
		std::map<std::string,Player*>::iterator itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.actualPlayer_=itt->second;
		}
		else
			per.actualPlayer_=NULL;
		//Case management
		int nbCase=0;
		in >> nbCase;
		per.case_=new Case[nbCase];
		for (i=0;i<nbCase;i++)
		{
			
			in >> per.case_[i];
			itt=per.playerMap_.find(per.case_[i].playerName_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPlayer(itt->second);
			}
			else
				per.case_[i].setPlayer(NULL);

			itt=per.playerMap_.find(per.case_[i].previousplayername_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPreviousPlayer(itt->second);
			}
			else
				per.case_[i].setPreviousPlayer(NULL);
		}
		
		in >> per.isPlayerChoosedByHazard;
		in >> per.nbCoutRestant_;
		in >> per.nbCoupperTurnAttack_;
		in >> per.nbCoupperTurnDefend_;
		in >> per.nbCoupperTurnGuerilla_;
		int act=0;
		in >> act;
		per.actualAction_=(Board::ActualActionMode)act;
		//Winner
		in >> tempo; 
		itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.winner_=itt->second;
		}
		else
			per.winner_=NULL;
	}

	return in;

}

std::ostream&  operator<< (std::ostream& in, Board& per)

{
	
	in << 1;
	in << per.xSize_;
	in << per.ySize_;
	in << per.warped_;
	in << per.players_;
	in << per.active_players_;
	in << per.remaining_players_;
	in << per.turn_ ; 
	in << per.n_att_;

	//Player
	std::map<std::string,Player*>::iterator itt=per.playerMap_.begin();
	in <<per.playerMap_.size();
	while (itt!=per.playerMap_.end())
	{
		in << *(itt->second);
		itt++;
	}
	//Actual Player
	std::string empty;
	if (per.actualPlayer_!=NULL)
		in << per.actualPlayer_->getName();
	else
		in << empty;
	//Cases
	in << per.xSize_*per.ySize_;
	int i=0;
	for (i=0;i<per.xSize_*per.ySize_;i++)
	{
		in << per.case_[i];
	}
	in << per.isPlayerChoosedByHazard;
	in << per.nbCoutRestant_;
	in << per.nbCoupperTurnAttack_;
	in << per.nbCoupperTurnDefend_;
	in << per.nbCoupperTurnGuerilla_;
	in << per.actualAction_;
	if (per.winner_!=NULL)
		in << per.winner_->getName();
	else
		in << empty;
	
	

	return in;

}



std::string Board::generateJson(){
	std::stringstream in;
	in <<"{";
	in <<"\"version\":"<< 1<<",";
	in <<"\"xsize\":"<<xSize_<<",";
	in <<"\"ysize\":"<< ySize_<<",";
	in <<"\"warped\":"<< warped_<<",";
	in <<"\"players\":"<< players_<<",";
	in <<"\"activePlayers_\":\""<< active_players_<<"\",";
	in <<"\"remainingPlayers\":\""<< remaining_players_<<"\",";
	in <<"\"turn\":"<< turn_ <<",";
	in <<"\"nAtt\":"<< n_att_<<",";

	//Player
	std::map<std::string,Player*>::iterator itt=playerMap_.begin();
	
	in <<"\"playerMapSize\":"<<(int)playerMap_.size()<<",";
	in <<"\"playerMapList\":[";
	while (itt!=playerMap_.end())
	{
		//in <<"\"playerName\":"<< itt->first<<",";
		if (itt->second!=NULL)
		{
		  std::string vale=(itt->second)->generateJson();
		  in << vale;
		}
		itt++;
		if(itt!=playerMap_.end())
		  in<<",";
	}
	in <<"],";
	//Actual Player
	std::string empty;
	if (actualPlayer_!=NULL&&!actualPlayer_->getName().empty())
		in <<"\"actualPlayer\":\""<< actualPlayer_->getName()<<"\"";
	else
		in <<"\"actualPlayer\":\"\"";
	in <<",";
	//Cases
	in <<"\"nbCase\":"<< (xSize_*ySize_)<<",";
	int i=0;
	in <<"\"cases\":[";
	for (i=0;i<xSize_*ySize_;i++)
	{
		in << case_[i].generateJson();
		if (i+1<xSize_*ySize_)
		  in <<","  ;
	}
	in <<"],";
	in <<"\"isPlayerChoosedByHazard\":"<< isPlayerChoosedByHazard<<",";
	in <<"\"nbCoutRestant\":"<< nbCoutRestant_<<",";
	in <<"\"nbCoupperTurnAttack\":"<< nbCoupperTurnAttack_<<",";
	in <<"\"nbCoupperTurnDefend\":"<< nbCoupperTurnDefend_<<",";
	in <<"\"nbCoupperTurnGuerilla\":"<<nbCoupperTurnGuerilla_<<",";
	in <<"\"actualAction\":";
	switch (actualAction_){
		case ATTACK:
		  in <<"\"ATTACK\"";
		  break;
		case DEFEND:
		  in <<"\"DEFEND\"";
		  break;
		case GUERILLA:
		  in <<"\"GUERILLA\"";
		  break;
		case NOTCHOOSE:
		  in <<"\"NOTCHOOSE\"";
		  break;
	  
	}
	in <<",";
	empty="";
	if (winner_!=NULL)
		in <<"\"winnerName\":\""<< winner_->getName()<<"\"";
	else
		in <<"\"winnerName\":\"\"";
	in <<"}";
	
	return in.str();
  
}

Serializer&  operator>> (Serializer& in, Board& per)

{
	int version=0;
	in >> version;
	if (version==1)
	{
		
		in >> per.xSize_;
		in >> per.ySize_;
		in >> per.warped_;
		in >> per.players_;
		in >> per.active_players_;
		in >> per.remaining_players_;
		in >> per.turn_ ; 
		in >> per.n_att_;

		//Manage players
		int nbPlayer=0;
		in >> nbPlayer;
		int i=0;
		for (i=0;i<nbPlayer;i++)
		{
			Player *pl = new Player("");
			in >> *pl;
			per.playerMap_[pl->getName()]=pl;
		}

		//manage actualPlayer
		std::string tempo;
		in >> tempo; 
		std::map<std::string,Player*>::iterator itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.actualPlayer_=itt->second;
		}
		else
			per.actualPlayer_=NULL;
		//Case management
		int nbCase=0;
		in >> nbCase;
		per.case_=new Case[nbCase];
		for (i=0;i<nbCase;i++)
		{
			
			in >> per.case_[i];
			
			itt=per.playerMap_.find(per.case_[i].playerName_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPlayer(itt->second);
			}
			else
				per.case_[i].setPlayer(NULL);

			itt=per.playerMap_.find(per.case_[i].previousplayername_);
			if (itt!=per.playerMap_.end())
			{
				per.case_[i].setPreviousPlayer(itt->second);
			}
			else
				per.case_[i].setPreviousPlayer(NULL);
		}
		
		in >> per.isPlayerChoosedByHazard;
		in >> per.nbCoutRestant_;
		in >> per.nbCoupperTurnAttack_;
		in >> per.nbCoupperTurnDefend_;
		in >> per.nbCoupperTurnGuerilla_;
		int act=0;
		in >> act;
		per.actualAction_=(Board::ActualActionMode)act;
		//Winner
		tempo="";
		in >> tempo; 
		itt=per.playerMap_.find(tempo);
		if (itt!=per.playerMap_.end())
		{
			per.winner_=itt->second;
		}
		else
			per.winner_=NULL;
	}

	return in;

}

Serializer&  operator<< (Serializer& in, Board& per)

{
	
	in << 1;
	in << per.xSize_;
	in << per.ySize_;
	in << per.warped_;
	in << per.players_;
	in << per.active_players_;
	in << per.remaining_players_;
	in << per.turn_ ; 
	in << per.n_att_;

	//Player
	std::map<std::string,Player*>::iterator itt=per.playerMap_.begin();
	in <<(int)per.playerMap_.size();
	while (itt!=per.playerMap_.end())
	{
		in << *(itt->second);
		itt++;
	}
	//Actual Player
	std::string empty;
	if (per.actualPlayer_!=NULL)
		in << per.actualPlayer_->getName();
	else
		in << empty;
	//Cases
	in << (per.xSize_*per.ySize_);
	int i=0;
	for (i=0;i<per.xSize_*per.ySize_;i++)
	{
		in << per.case_[i];
	}
	in << per.isPlayerChoosedByHazard;
	in << per.nbCoutRestant_;
	in << per.nbCoupperTurnAttack_;
	in << per.nbCoupperTurnDefend_;
	in << per.nbCoupperTurnGuerilla_;
	in << (int)per.actualAction_;
	empty="";
	if (per.winner_!=NULL)
		in << per.winner_->getName();
	else
		in << empty;
	
	

	return in;

}
/*
int Board::operator =(Board b){


}*/

void Board::setCases(Case *pcase){
	if (case_!=NULL) delete []case_;
	case_=pcase;
}

void Board::setWidth(int z){xSize_=z;}
void Board::setHeight(int z){ySize_=z;}

void Board::recalculatePlayer(){
	playerMap_.clear();
	for (int i=0;i<xSize_*ySize_;i++)
	{
		if(case_[i].getPlayer()!=NULL)
		{
			getOrCreatePlayerByName(case_[i].getPlayer()->getName());
		}
	}
}
Board::Board(std::string json){
  createFromJson(json);
}
#include "JSON.h"
#include "JSONParser.h"
void Board::createFromJson(std::string json){
//  {"version":1,"xsize":10,"ysize":10,"warped":0,"players":0,"activePlayers_":"0","remainingPlayers":"0",
  //"turn":0,"nAtt":0,"playerMapSize":0,"playerMapList":[],"actualPlayer":"","nbCase":100,
  //"cases":[{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter"
//:0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":1,"caseType":"SELECTED","playerName":"JoueurTest","previousPlayerName":"JoueurTest","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"
//NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0},{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0}],
  //"isPlayerChoosedByHazard":0,"nbCoutRestant":0,"nbCoupperTurnAttack":6,"nbCoupperTurnDefend":3,"nbCoupperTurnGuerilla":1,"actualAction":"NOTCHOOSE","winnerName":""}
  std::istringstream  ssJson(json);
  json_parser::Parser parser(&ssJson);
  try{
    json_parser::Value *val = parser.jValue();
    
    json_parser::Object* my_object = dynamic_cast<json_parser::Object*>(val);
    if (my_object==NULL)
      return ;
    json_parser::Value *version=getValue(my_object,"version");
    json_parser::Value *xsize=getValue(my_object,"xsize");
    json_parser::Value *ysize=getValue(my_object,"ysize");
    json_parser::Value *warped=getValue(my_object,"warped");
    json_parser::Value *players=getValue(my_object,"players");
    json_parser::Value *activePlayers_=getValue(my_object,"activePlayers_");
    json_parser::Value *remainingPlayers=getValue(my_object,"remainingPlayers");
    json_parser::Value *turn=getValue(my_object,"turn");
    json_parser::Value *nAtt=getValue(my_object,"nAtt");
    json_parser::Value *playerMapSize=getValue(my_object,"playerMapSize");
    json_parser::Elements* playerMapList=(dynamic_cast<json_parser::Array*>(getValue(my_object,"playerMapList")))->elems_;
    std::map<std::string,Player*> playerMap;
    std::list<json_parser::Value *> values=playerMapList->values_;
    playerMap_.clear();
    for (std::list<json_parser::Value *>::iterator it=values.begin(); it != values.end(); ++it)
    {
	Player *player=Player::createFromNode(dynamic_cast<json_parser::Object*>(*it));
	playerMap_.insert(std::pair<std::string,Player*>(player->getName(),player));
    }
   
    json_parser::Value *actualPlayer=getValue(my_object,"actualPlayer");
    json_parser::Value *nbCase=getValue(my_object,"nbCase");
    json_parser::Elements* cases=(dynamic_cast<json_parser::Array*>(getValue(my_object,"cases")))->elems_;
    
    case_= new Case[atoi(nbCase->cleanStr().c_str())];
    int i=0;
    for (std::list<json_parser::Value *>::iterator it=cases->values_.begin(); it != cases->values_.end(); ++it)
	case_[i++]=Case::createFromNode(dynamic_cast<json_parser::Object*>(*it),playerMap_);
    json_parser::Value *isPlayerChoosedByHazardI=getValue(my_object,"isPlayerChoosedByHazard");
    json_parser::Value *nbCoutRestant=getValue(my_object,"nbCoutRestant");
    json_parser::Value *nbCoupperTurnAttack=getValue(my_object,"nbCoupperTurnAttack");
    json_parser::Value *nbCoupperTurnDefend=getValue(my_object,"nbCoupperTurnDefend");
    json_parser::Value *nbCoupperTurnGuerilla=getValue(my_object,"nbCoupperTurnGuerilla");
    json_parser::Value *actualAction=getValue(my_object,"actualAction");
    json_parser::Value *winnerName=getValue(my_object,"winnerName");

    xSize_=atoi(xsize->cleanStr().c_str());
    ySize_=atoi(ysize->cleanStr().c_str());
    warped_=atoi(warped->cleanStr().c_str());
    players_=atoi(players->cleanStr().c_str());
    active_players_=atoi(activePlayers_->cleanStr().c_str());
    remaining_players_=atoi(remainingPlayers->cleanStr().c_str());
    turn_=atoi(turn->cleanStr().c_str());
    n_att_=atoi(nAtt->cleanStr().c_str());
    if (!actualPlayer->cleanStr().empty())
    {
      actualPlayer_=playerMap_.find(actualPlayer->cleanStr())->second;
    }
    else
      actualPlayer_=NULL;
    if(isPlayerChoosedByHazardI->cleanStr()=="1")
      isPlayerChoosedByHazard=true;
    else
      isPlayerChoosedByHazard=false;
    
    nbCoutRestant_=atoi(nbCoutRestant->cleanStr().c_str());
    nbCoupperTurnAttack_=atoi(nbCoupperTurnAttack->cleanStr().c_str());
    nbCoupperTurnDefend_=atoi(nbCoupperTurnDefend->cleanStr().c_str());
    nbCoupperTurnGuerilla_=atoi(nbCoupperTurnGuerilla->cleanStr().c_str());
    
    actualAction_=Board::NOTCHOOSE;
    if(actualAction->cleanStr()=="ATTACK")
	actualAction_=Board::ATTACK;
    if(actualAction->cleanStr()=="DEFEND")
	actualAction_=Board::DEFEND;
    if(actualAction->cleanStr()=="GUERILLA")
	actualAction_=Board::GUERILLA;
    if (!winnerName->cleanStr().empty())
      winner_=playerMap_.find(winnerName->cleanStr())->second;
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
  }
  
  

  
  
  
}

Player* Board::getPlayerByName(std::string user){
  if (playerMap_.find(user)!=playerMap_.end())
      return playerMap_.find(user)->second;
  else 
      return NULL;
}
