/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Computer Science Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/

#ifndef _MAV_AVATAR_INCLUDE
#define _MAV_AVATAR_INCLUDE

#ifdef __cplusplus
extern "C" {
#endif

/* Avatar */

typedef struct {
  int num;
  MAV_object *obj;
  MAV_matrix position;
  MAV_matrix rotation;
  struct MAV_AVATARPARTPTR *children;
} MAV_avatarPart;

typedef struct MAV_AVATARPARTPTR {
  MAV_avatarPart *part;
  struct MAV_AVATARPARTPTR *next;
} MAV_avatarPartPtr;

typedef struct {
  MAV_avatarPart *root;
  MAV_avatarPart *part[19];
  MAV_surfaceParams *sp[5];
  int movement;
  float speed;
  float offset;
  int animFromMat;
  int animate;
  int move;
  MAV_timer timer;
  float time;
  float last_time;
  MAV_vector last_pos;
  MAV_matrix vertical;
  MAV_matrix rotation;
  MAV_matrix matrix;
  MAV_vector right_hand;
  MAV_vector left_hand;
  int holding_right;
  int holding_left;
  MAV_surfaceParams *laser_sp;
  void *userdef;
} MAV_avatar;

extern MAV_class *mav_class_avatar;
int mav_avatarDraw(MAV_object *o, MAV_drawInfo *di);
int mav_avatarBB(MAV_object *o, MAV_BB *bb);
int mav_avatarBB2(MAV_object *o, MAV_BB *bb);
int mav_avatarIntersect(MAV_object *o, MAV_line *ln, MAV_objectIntersection *oi);
int mav_avatarID(MAV_object *o, char **id);
int mav_avatarGetUserdef(MAV_object *o, void ***ud);
int mav_avatarGetMatrix(MAV_object *o, MAV_matrix **m);
int mav_avatarGetSurfaceParams(MAV_object *o, MAV_surfaceParams ***sp);
int mav_avatarDump(MAV_object *o);

MAV_avatar *mav_avatarNew(MAV_surfaceParams **sp);
void mav_avatarAnimate(MAV_avatar *avatar);
void mav_avatarMove(MAV_avatar *avatar);
void mav_avatarSetSurfaceParams(MAV_avatar *, MAV_surfaceParams **sp);



/* Module initialise */

char *mav_avatarModuleID(void);
int mav_avatarModuleInit(void);

#ifdef __cplusplus
}
#endif
#endif
