/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var scriptObject = require("html_script_finder/dom_handler/script_object");

exports.testCreateNewScript = function (test) {
    var script1, script2;

    script1 = scriptObject.Script({'type': 'inline',
				   'status': 'test',
				   'text': 'test',
				   'element': {}});

    test.assertEqual('object', typeof script1);
    test.assertEqual('inline', script1.type);
    
    script2 = scriptObject.Script({'type': 'external',
				   'status': 'test',
				   'element': {}});
    test.assertEqual(script2.text, null);
    
};

exports.testRemoveNarcissusBugLine = function (test) {
    var script = scriptObject.Script({'type': 'external',
				   'status': 'test',
				   'element': {}});
    var scriptText = "var i = 0;\n\nthis.narcissusBugFixLibreJS";
    var scriptText2 = "var i = 0;";
    test.assertEqual(script.removeNarcissusBugLine(scriptText), 'var i = 0;');
    test.assertEqual(script.removeNarcissusBugLine(scriptText2), 'var i = 0;');
};