# Libidn README -- Introduction information

Libidn is a package for internationalized string handling based on the
Stringprep, Punycode, IDNA2003 and TLD specifications.  Libidn is a
GNU project.  For technical reference, see:

 * [Stringprep](https://www.rfc-editor.org/rfc/rfc3454)
 * [IDNA aka IDNA2003](https://www.rfc-editor.org/rfc/rfc3490)
 * [Nameprep](https://www.rfc-editor.org/rfc/rfc3491)
 * [Punycode](https://www.rfc-editor.org/rfc/rfc3492)
 * [Unicode 3.2.0](http://www.unicode.org/versions/Unicode3.2.0/)

WARNING!  The IDNA2003 specifications have been superseded by IDNA2008
which is implemented by Libidn2
<https://www.gnu.org/software/libidn/#libidn2>.  The only reasonable
use of the libidn library today is to support the historic IDNA2003
behaviour or to use Stringprep profiles.  Please try to migrate to
libidn2 wherever possible.

If this file came to you as part of a tar archive, then see the file
(INSTALL)[INSTALL] for generic compilation and installation
instructions.  Before building you should consider installing the
[dependencies](DEPENDENCIES.md).  If you obtained this file as part of
a "git clone", then see the CONTRIBUTING.md file.

If you need help to use Libidn, or wish to help others, you are
invited to join our mailing list help-libidn@gnu.org, see
<https://lists.gnu.org/mailman/listinfo/help-libidn>.

For more information, see <https://www.gnu.org/software/libidn/>.

# Documentation

[GNU Libidn Manual](https://www.gnu.org/software/libidn/manual/)

[Libidn API Reference Manual](https://www.gnu.org/software/libidn/reference/)

# License

The source code for the C library (libidn.a or libidn.so), the C#
library (Libidn.dll) and the Java library (libidn-*.jar) are
dual-licensed under the terms of either the GNU General Public License
version 2.0 or later - see the file [COPYINGv2](COPYINGv2) - or the
GNU Lesser General Public License version 3.0 or later - see the file
[COPYING.LESSERv3](COPYING.LESSERv3) - or both in parallel as here.

The author of the Java library has agreed to also distribute it under
the Apache License Version 2.0, see the file
[java/LICENSE-2.0](java/LICENSE-2.0).

The manual is licensed under the GNU Free Documentation License,
Version 1.3 or any later, see the file
[doc/fdl-1.3.texi](doc/fdl-1.3.texi).

The command line tool, self tests, examples, and other auxiliary
files, are licensed under the GNU General Public License version 3.0
or later, see the file [COPYING](COPYING).

The library embed data tables published by Unicode, Inc and The
Internet Society (IETF), see [doc/specification/](doc/specification/).

Other files are licensed as indicated in each file.  There may be
exceptions to these general rules, see each file for precise
information.

For any copyright year range specified as YYYY-ZZZZ in this package
note that the range specifies every single year in that closed
interval.

----------------------------------------------------------------------
Copyright (C) 2002-2025 Simon Josefsson
Copying and distribution of this file, with or without modification,
are permitted in any medium without royalty provided the copyright
notice and this notice are preserved.
