
(define-derived-mode c2j-mode java-mode "C2J Mode"
  "DOCSTRING"
  ;;(java-mode)
  ;;(setq major-mode 'c2j-mode)
  ;;(setq mode-name "C2J Mode")
  ;;(make-local-variable 'c2j-mode-map)
  ;;(setq c2j-mode-map (copy-keymap java-mode-map))
  ;;(use-local-map c2j-mode-map)
  (assert (fboundp 'd-indent-line))
  (setcdr (assq 9 c2j-mode-map) 'd-indent-line)
  (define-key c2j-mode-map [tab] 'd-indent-line)
  (define-key c2j-mode-map [(tab)] 'd-indent-line)
  (define-key c2j-mode-map "\t" 'd-indent-line)
  )

(setq auto-mode-alist (cons '("\\.c2j$" . c2j-mode) auto-mode-alist))

(add-hook 'font-lock-mode-hook 'd-c2j-font-lock-mode-hook nil)
;;(remove-hook 'font-lock-mode-hook 'd-c2j-font-lock-mode-hook)

(defun d-c2j-font-lock-mode-hook ()
  (when (eq major-mode 'c2j-mode)
    (d-font-lock-add-begin
     '(
       ("\\<strobe\\>" 0 'd-face-cc-debugging t)
       ("\\<sp\\>"     0 'font-lock-type-face t)
       ("\\<r[0-9]\\>" 0 'font-lock-type-face t)
       ;;("\\(^\\|[^a-z0-9_]\\)\\(\\([+-]?[0-9]+\\)\\(\\.[0-9]+\\)?\\([eE][+-]?[0-9]+\\)?\\>\\)" 2 'd-face-cc-digits t)
       ("\\(\\<nop \\)\\([a-zA-Z0-9_]*\\);\\(.*\\)$"
        (1 'bold t)
        (2 'fg:lightred t)
        (3 'font-lock-comment-face nil)
        )
       ("\\(\\<label\\) \\([a-zA-Z0-9_]+\\)" (1 'bold t) (2 'font-lock-function-name-face t))
       ("\\(\\<return\\>\\)["                 1 'bold nil)
       ("\\(\\<goto\\) \\([a-zA-Z0-9_]+\\)"  (1 'bold t) (2 'font-lock-function-name-face t))
       ("\\(\\<line_[a-zA-Z0-9_]*\\)"         1 'font-lock-function-name-face t)
       ("[0-9]+"                              0 'd-face-cc-digits t)
       ;;("\\<\\(fcall\\) \\([a-zA-Z0-9_]+\\)" (1 'bold t) (2 'font-lock-function-name-face t))
       ;;("\\<\\(jcall\\) \\(function_[a-zA-Z0-9_]+\\)" (1 'bold t) (2 'font-lock-function-name-face t))
       ;;("\\<\\(xif\\|negate\\|not\\|newvar\\|p?push\\|p?pop\\|newmove\\|move\\|addby\\|multiplyby\\|subtractby\\|callnot\\|call\\|eq\\)\\>" 1 'bold t)
       ;;("\\<push \\([a-zA-Z][a-zA-Z0-9_]*\\)" 1 'fg:lightred t)
       )))
  (when (and prefs-advanced-user-p (eq major-mode 'c2j-mode))
    (d-font-lock-add-end
     '(
       ("\\(\\<nop beg_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       ("\\(\\<nop end_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       ("\\(\\<nop BEG_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       ("\\(\\<nop END_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       )))
  )

(provide 'c2j)
;;; c2j.el ends here
