/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_unary_primitive;
import gnu.jel.debug.Debug;

class OP_unary
extends OP_unary_primitive {
    int opc;

    OP_unary(int opc) {
        this.opc = opc;
    }

    void doOperation(OP_load c) throws Throwable {
        Debug.assert(c.type != null && c.type.isPrimitive(), "Wrong types for binary OP");
        int id = ExpressionImage.primitiveID(c.type);
        Number val = OP_function.widen(c.what, id);
        if (this.opc == 0) {
            val = OP_function.isFloat(id) ? (Number)new Double(-val.doubleValue()) : (Number)new Long(-val.longValue());
        } else {
            Debug.println("Wrong unary opcode.");
        }
        c.what = OP_function.narrow(val, id);
    }

    void compile(ExpressionImage ei) {
        ei.asm_unary(this.opc);
    }

    public String toString() {
        return "-";
    }
}

