# GNU Guix --- Functional package management for GNU
# Copyright © 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Ludovic Courtès <ludo@gnu.org>
# Copyright © 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Andreas Enge <andreas@enge.fr>
# Copyright © 2016 Mathieu Lirzin <mthl@gnu.org>
# Copyright © 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021 Mark H Weaver <mhw@netris.org>
# Copyright © 2016 Chris Marusich <cmmarusich@gmail.com>
# Copyright © 2016, 2017, 2018 Kei Kebreau <kkebreau@posteo.net>
# Copyright © 2016, 2017 Rene Saavedra <rennes@openmailbox.org>
# Copyright © 2016 Adonay "adfeno" Felipe Nogueira <https://libreplanet.org/wiki/User:Adfeno> <adfeno@openmailbox.org>
# Copyright © 2016, 2017, 2018, 2019, 2020, 2021 Ricardo Wurmus <rekado@elephly.net>
# Copyright © 2016 Ben Woodcroft <donttrustben@gmail.com>
# Copyright © 2016, 2017, 2018, 2019 Alex Vong <alexvong1995@gmail.com>
# Copyright © 2016, 2017, 2018, 2019, 2020, 2021 Efraim Flashner <efraim@flashner.co.il>
# Copyright © 2016, 2017, 2018, 2019, 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
# Copyright © 2017, 2018, 2019, 2020 Tobias Geerinckx-Rice <me@tobias.gr>
# Copyright © 2017, 2018 Clément Lassieur <clement@lassieur.org>
# Copyright © 2017, 2020 Mathieu Othacehe <m.othacehe@gmail.com>
# Copyright © 2017, 2018, 2019 Gábor Boskovits <boskovits@gmail.com>
# Copyright © 2018 Amirouche Boubekki <amirouche@hypermove.net>
# Copyright © 2018, 2019, 2020, 2021 Oleg Pykhalov <go.wigust@gmail.com>
# Copyright © 2018 Stefan Stefanović <stefanx2ovic@gmail.com>
# Copyright © 2018, 2020 Maxim Cournoyer <maxim.cournoyer@gmail.com>
# Copyright © 2019, 2020 Guillaume Le Vaillant <glv@posteo.net>
# Copyright © 2019, 2020 John Soo <jsoo1@asu.edu>
# Copyright © 2019 Jonathan Brielmaier <jonathan.brielmaier@web.de>
# Copyright © 2019 Evan Straw <evan.straw99@gmail.com>
# Copyright © 2019, 2020 Brett Gilio <brettg@gnu.org>
# Copyright © 2019 Amin Bandali <bandali@gnu.org>
# Copyright © 2020 Brendan Tildesley <mail@brendan.scot>
# Copyright © 2020 Vincent Legoll <vincent.legoll@gmail.com>
# Copyright © 2020 R Veera Kumar <vkor@vkten.in>
# Copyright © 2020 Nicolò Balzarotti <nicolo@nixo.xyz>
# Copyright © 2020 Michael Rohleder <mike@rohleder.de>
# Copyright © 2020, 2021 Felix Gruber <felgru@posteo.net>
# Copyright © 2020 Ryan Prior <rprior@protonmail.com>
# Copyright © 2020 Jan Wielkiewicz <tona_kosmicznego_smiecia@interia.pl>
# Copyright © 2020, 2021 Brice Waegeneire <brice@waegenei.re>
# Copyright © 2020 Tanguy Le Carrour <tanguy@bioneland.org>
# Copyright © 2020 Martin Becze <mjbecze@riseup.net>
# Copyright © 2020 Malte Frank Gerdes <mate.f.gerdes@gmail.com>
# Copyright © 2020 Vinicius Monego <monego@posteo.net>
# Copyright © 2021 Björn Höfling <bjoern.hoefling@bjoernhoefling.de>
# Copyright © 2021 Philip McGrath <philip@philipmcgrath.com>
#
# This file is part of GNU Guix.
#
# GNU Guix is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# GNU Guix is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

# Definitions for the GNU System: package modules, patches, bootstrap
# binaries.

GNU_SYSTEM_MODULES =				\
  gnu.scm					\
  %D%/artwork.scm				\
  %D%/bootloader.scm				\
  %D%/bootloader/grub.scm                       \
  %D%/bootloader/extlinux.scm                   \
  %D%/bootloader/u-boot.scm                     \
  %D%/bootloader/depthcharge.scm                \
  %D%/ci.scm					\
  %D%/image.scm					\
  %D%/packages.scm				\
  %D%/packages/abduco.scm			\
  %D%/packages/abiword.scm			\
  %D%/packages/accessibility.scm		\
  %D%/packages/acct.scm				\
  %D%/packages/acl.scm				\
  %D%/packages/ada.scm				\
  %D%/packages/admin.scm			\
  %D%/packages/adns.scm				\
  %D%/packages/agda.scm				\
  %D%/packages/algebra.scm			\
  %D%/packages/aidc.scm				\
  %D%/packages/android.scm			\
  %D%/packages/animation.scm			\
  %D%/packages/anthy.scm			\
  %D%/packages/antivirus.scm			\
  %D%/packages/apl.scm				\
  %D%/packages/apr.scm				\
  %D%/packages/arcan.scm			\
  %D%/packages/aspell.scm			\
  %D%/packages/assembly.scm			\
  %D%/packages/astronomy.scm			\
  %D%/packages/attr.scm				\
  %D%/packages/audio.scm			\
  %D%/packages/augeas.scm			\
  %D%/packages/authentication.scm		\
  %D%/packages/autogen.scm			\
  %D%/packages/autotools.scm			\
  %D%/packages/avahi.scm			\
  %D%/packages/avr.scm				\
  %D%/packages/axoloti.scm			\
  %D%/packages/backup.scm			\
  %D%/packages/base.scm				\
  %D%/packages/bash.scm				\
  %D%/packages/batik.scm			\
  %D%/packages/bdw-gc.scm			\
  %D%/packages/benchmark.scm			\
  %D%/packages/bioconductor.scm			\
  %D%/packages/bioinformatics.scm		\
  %D%/packages/bittorrent.scm			\
  %D%/packages/bison.scm			\
  %D%/packages/boost.scm			\
  %D%/packages/bootloaders.scm			\
  %D%/packages/bootstrap.scm			\
  %D%/packages/browser-extensions.scm		\
  %D%/packages/build-tools.scm			\
  %D%/packages/busybox.scm			\
  %D%/packages/c.scm				\
  %D%/packages/calcurse.scm			\
  %D%/packages/ccache.scm			\
  %D%/packages/cdrom.scm			\
  %D%/packages/cedille.scm			\
  %D%/packages/certs.scm			\
  %D%/packages/check.scm			\
  %D%/packages/chemistry.scm			\
  %D%/packages/chez.scm				\
  %D%/packages/chicken.scm				\
  %D%/packages/chromium.scm			\
  %D%/packages/ci.scm				\
  %D%/packages/cinnamon.scm			\
  %D%/packages/clojure.scm			\
  %D%/packages/cluster.scm			\
  %D%/packages/cmake.scm			\
  %D%/packages/cobol.scm			\
  %D%/packages/code.scm				\
  %D%/packages/commencement.scm			\
  %D%/packages/compression.scm			\
  %D%/packages/compton.scm 			\
  %D%/packages/configuration-management.scm	\
  %D%/packages/conky.scm			\
  %D%/packages/connman.scm			\
  %D%/packages/convmv.scm			\
  %D%/packages/cook.scm				\
  %D%/packages/coq.scm				\
  %D%/packages/cpio.scm				\
  %D%/packages/cpp.scm 				\
  %D%/packages/cppi.scm				\
  %D%/packages/cran.scm				\
  %D%/packages/crates-io.scm			\
  %D%/packages/crates-graphics.scm		\
  %D%/packages/crates-gtk.scm			\
  %D%/packages/cross-base.scm			\
  %D%/packages/crypto.scm			\
  %D%/packages/cryptsetup.scm			\
  %D%/packages/cups.scm				\
  %D%/packages/curl.scm				\
  %D%/packages/cvassistant.scm			\
  %D%/packages/cybersecurity.scm		\
  %D%/packages/cyrus-sasl.scm			\
  %D%/packages/databases.scm			\
  %D%/packages/datamash.scm			\
  %D%/packages/datastructures.scm		\
  %D%/packages/dav.scm				\
  %D%/packages/dbm.scm				\
  %D%/packages/dc.scm				\
  %D%/packages/debian.scm			\
  %D%/packages/debug.scm			\
  %D%/packages/dejagnu.scm			\
  %D%/packages/dhall.scm			\
  %D%/packages/dico.scm				\
  %D%/packages/dictionaries.scm			\
  %D%/packages/diffoscope.scm			\
  %D%/packages/digest.scm			\
  %D%/packages/direct-connect.scm		\
  %D%/packages/disk.scm			\
  %D%/packages/distributed.scm			\
  %D%/packages/display-managers.scm		\
  %D%/packages/django.scm			\
  %D%/packages/djvu.scm				\
  %D%/packages/dlang.scm			\
  %D%/packages/dns.scm				\
  %D%/packages/docbook.scm			\
  %D%/packages/docker.scm			\
  %D%/packages/documentation.scm		\
  %D%/packages/drones.scm			\
  %D%/packages/dunst.scm			\
  %D%/packages/dvtm.scm				\
  %D%/packages/easyrpg.scm			\
  %D%/packages/ebook.scm			\
  %D%/packages/ed.scm				\
  %D%/packages/education.scm			\
  %D%/packages/efi.scm				\
  %D%/packages/electronics.scm			\
  %D%/packages/elf.scm				\
  %D%/packages/elixir.scm			\
  %D%/packages/elm.scm				\
  %D%/packages/embedded.scm			\
  %D%/packages/emacs.scm			\
  %D%/packages/emacs-xyz.scm			\
  %D%/packages/emulators.scm			\
  %D%/packages/enchant.scm			\
  %D%/packages/engineering.scm			\
  %D%/packages/enlightenment.scm		\
  %D%/packages/entr.scm				\
  %D%/packages/erlang.scm			\
  %D%/packages/esolangs.scm			\
  %D%/packages/fabric-management.scm		\
  %D%/packages/fcitx.scm			\
  %D%/packages/fcitx5.scm			\
  %D%/packages/figlet.scm			\
  %D%/packages/file.scm				\
  %D%/packages/file-systems.scm			\
  %D%/packages/finance.scm			\
  %D%/packages/firmware.scm			\
  %D%/packages/flashing-tools.scm		\
  %D%/packages/flex.scm				\
  %D%/packages/fltk.scm				\
  %D%/packages/fonts.scm			\
  %D%/packages/fontutils.scm			\
  %D%/packages/fpga.scm				\
  %D%/packages/forth.scm			\
  %D%/packages/freedesktop.scm			\
  %D%/packages/freeipmi.scm			\
  %D%/packages/ftp.scm				\
  %D%/packages/fribidi.scm			\
  %D%/packages/fvwm.scm				\
  %D%/packages/game-development.scm		\
  %D%/packages/games.scm			\
  %D%/packages/gawk.scm				\
  %D%/packages/gcal.scm				\
  %D%/packages/gcc.scm				\
  %D%/packages/gd.scm				\
  %D%/packages/gdb.scm				\
  %D%/packages/genealogy.scm			\
  %D%/packages/genimage.scm			\
  %D%/packages/geo.scm				\
  %D%/packages/gettext.scm			\
  %D%/packages/ghostscript.scm			\
  %D%/packages/gimp.scm				\
  %D%/packages/gkrellm.scm			\
  %D%/packages/gl.scm				\
  %D%/packages/glib.scm				\
  %D%/packages/gnome.scm			\
  %D%/packages/gnome-xyz.scm			\
  %D%/packages/gnu-doc.scm			\
  %D%/packages/gnucash.scm			\
  %D%/packages/gnunet.scm			\
  %D%/packages/gnupg.scm			\
  %D%/packages/gnustep.scm			\
  %D%/packages/gnuzilla.scm			\
  %D%/packages/gnu-pw-mgr.scm			\
  %D%/packages/gobby.scm			\
  %D%/packages/golang.scm			\
  %D%/packages/gperf.scm			\
  %D%/packages/gpodder.scm			\
  %D%/packages/gps.scm				\
  %D%/packages/graph.scm			\
  %D%/packages/graphics.scm			\
  %D%/packages/graphviz.scm			\
  %D%/packages/groff.scm			\
  %D%/packages/groovy.scm			\
  %D%/packages/gsasl.scm			\
  %D%/packages/gstreamer.scm			\
  %D%/packages/gtk.scm				\
  %D%/packages/guile.scm			\
  %D%/packages/guile-wm.scm			\
  %D%/packages/guile-xyz.scm			\
  %D%/packages/gv.scm				\
  %D%/packages/gxmessage.scm			\
  %D%/packages/hardware.scm			\
  %D%/packages/haskell.scm			\
  %D%/packages/haskell-apps.scm			\
  %D%/packages/haskell-check.scm		\
  %D%/packages/haskell-crypto.scm		\
  %D%/packages/haskell-web.scm			\
  %D%/packages/haskell-xyz.scm			\
  %D%/packages/heads.scm			\
  %D%/packages/hexedit.scm			\
  %D%/packages/hugs.scm				\
  %D%/packages/hunspell.scm				\
  %D%/packages/hurd.scm				\
  %D%/packages/hyperledger.scm			\
  %D%/packages/i2p.scm				\
  %D%/packages/ibus.scm				\
  %D%/packages/icu4c.scm			\
  %D%/packages/idris.scm			\
  %D%/packages/idutils.scm			\
  %D%/packages/image.scm			\
  %D%/packages/image-processing.scm	\
  %D%/packages/image-viewers.scm	\
  %D%/packages/imagemagick.scm			\
  %D%/packages/inklingreader.scm		\
  %D%/packages/inkscape.scm			\
  %D%/packages/installers.scm			\
  %D%/packages/ipfs.scm			\
  %D%/packages/irc.scm  			\
  %D%/packages/iso-codes.scm			\
  %D%/packages/jami.scm				\
  %D%/packages/java.scm				\
  %D%/packages/java-compression.scm		\
  %D%/packages/java-graphics.scm		\
  %D%/packages/java-maths.scm			\
  %D%/packages/javascript.scm			\
  %D%/packages/jemalloc.scm			\
  %D%/packages/jrnl.scm				\
  %D%/packages/jose.scm				\
  %D%/packages/julia.scm			\
  %D%/packages/julia-xyz.scm			\
  %D%/packages/jupyter.scm			\
  %D%/packages/kawa.scm				\
  %D%/packages/kde.scm				\
  %D%/packages/kde-frameworks.scm		\
  %D%/packages/kde-internet.scm			\
  %D%/packages/kde-multimedia.scm		\
  %D%/packages/kde-pim.scm			\
  %D%/packages/kde-plasma.scm			\
  %D%/packages/kde-systemtools.scm		\
  %D%/packages/kde-utils.scm			\
  %D%/packages/kerberos.scm			\
  %D%/packages/key-mon.scm			\
  %D%/packages/kodi.scm				\
  %D%/packages/language.scm			\
  %D%/packages/lean.scm				\
  %D%/packages/lego.scm				\
  %D%/packages/less.scm				\
  %D%/packages/lesstif.scm			\
  %D%/packages/libbsd.scm			\
  %D%/packages/libcanberra.scm			\
  %D%/packages/libdaemon.scm			\
  %D%/packages/libedit.scm			\
  %D%/packages/libevent.scm			\
  %D%/packages/libffcall.scm			\
  %D%/packages/libffi.scm			\
  %D%/packages/libftdi.scm			\
  %D%/packages/license.scm			\
  %D%/packages/calendar.scm			\
  %D%/packages/libidn.scm			\
  %D%/packages/libphidget.scm			\
  %D%/packages/libreoffice.scm			\
  %D%/packages/libsigsegv.scm			\
  %D%/packages/libunistring.scm			\
  %D%/packages/libusb.scm			\
  %D%/packages/libunwind.scm			\
  %D%/packages/lighting.scm                     \
  %D%/packages/linphone.scm			\
  %D%/packages/linux.scm			\
  %D%/packages/lirc.scm				\
  %D%/packages/lisp.scm				\
  %D%/packages/lisp-xyz.scm			\
  %D%/packages/llvm.scm				\
  %D%/packages/lout.scm				\
  %D%/packages/logging.scm			\
  %D%/packages/logo.scm				\
  %D%/packages/loko.scm				\
  %D%/packages/lsof.scm				\
  %D%/packages/lua.scm				\
  %D%/packages/lxde.scm				\
  %D%/packages/lxqt.scm				\
  %D%/packages/m4.scm				\
  %D%/packages/machine-learning.scm		\
  %D%/packages/magic-wormhole.scm		\
  %D%/packages/man.scm				\
  %D%/packages/mastodon.scm			\
  %D%/packages/mail.scm				\
  %D%/packages/make-bootstrap.scm		\
  %D%/packages/markup.scm			\
  %D%/packages/marst.scm			\
  %D%/packages/mate.scm             \
  %D%/packages/maths.scm			\
  %D%/packages/matrix.scm			\
  %D%/packages/maven.scm			\
  %D%/packages/maven-parent-pom.scm		\
  %D%/packages/mc.scm				\
  %D%/packages/mcrypt.scm			\
  %D%/packages/medical.scm			\
  %D%/packages/mercury.scm			\
  %D%/packages/mes.scm				\
  %D%/packages/messaging.scm			\
  %D%/packages/mingw.scm			\
  %D%/packages/microcom.scm			\
  %D%/packages/moe.scm				\
  %D%/packages/motti.scm			\
  %D%/packages/monitoring.scm			\
  %D%/packages/mono.scm				\
  %D%/packages/moreutils.scm			\
  %D%/packages/mpd.scm				\
  %D%/packages/mp3.scm				\
  %D%/packages/mpi.scm				\
  %D%/packages/multiprecision.scm		\
  %D%/packages/music.scm			\
  %D%/packages/musl.scm				\
  %D%/packages/mtools.scm			\
  %D%/packages/nano.scm				\
  %D%/packages/ncdu.scm				\
  %D%/packages/ncurses.scm			\
  %D%/packages/netpbm.scm			\
  %D%/packages/nettle.scm			\
  %D%/packages/networking.scm			\
  %D%/packages/nfs.scm                          \
  %D%/packages/nickle.scm                       \
  %D%/packages/nicotine.scm                     \
  %D%/packages/nim.scm  			\
  %D%/packages/ninja.scm			\
  %D%/packages/node.scm				\
  %D%/packages/node-xyz.scm			\
  %D%/packages/noweb.scm			\
  %D%/packages/nss.scm				\
  %D%/packages/ntp.scm				\
  %D%/packages/nutrition.scm			\
  %D%/packages/nvi.scm				\
  %D%/packages/ocaml.scm			\
  %D%/packages/ocr.scm				\
  %D%/packages/openkinect.scm			\
  %D%/packages/onc-rpc.scm			\
  %D%/packages/opencl.scm			\
  %D%/packages/openbox.scm			\
  %D%/packages/opencog.scm			\
  %D%/packages/openldap.scm			\
  %D%/packages/openpgp.scm			\
  %D%/packages/openstack.scm			\
  %D%/packages/orpheus.scm			\
  %D%/packages/ots.scm				\
  %D%/packages/package-management.scm		\
  %D%/packages/pantheon.scm			\
  %D%/packages/parallel.scm			\
  %D%/packages/pascal.scm			\
  %D%/packages/password-utils.scm		\
  %D%/packages/patchutils.scm			\
  %D%/packages/pciutils.scm			\
  %D%/packages/pcre.scm				\
  %D%/packages/pdf.scm				\
  %D%/packages/pem.scm				\
  %D%/packages/pep.scm				\
  %D%/packages/perl.scm				\
  %D%/packages/perl-check.scm			\
  %D%/packages/perl-compression.scm		\
  %D%/packages/perl-maths.scm			\
  %D%/packages/perl-web.scm			\
  %D%/packages/perl6.scm			\
  %D%/packages/photo.scm			\
  %D%/packages/phabricator.scm 			\
  %D%/packages/php.scm				\
  %D%/packages/piet.scm			\
  %D%/packages/pkg-config.scm			\
  %D%/packages/plotutils.scm			\
  %D%/packages/poedit.scm				\
  %D%/packages/polkit.scm			\
  %D%/packages/popt.scm				\
  %D%/packages/printers.scm			\
  %D%/packages/profiling.scm			\
  %D%/packages/prolog.scm			\
  %D%/packages/pth.scm				\
  %D%/packages/pulseaudio.scm			\
  %D%/packages/pumpio.scm			\
  %D%/packages/presentation.scm		\
  %D%/packages/pretty-print.scm			\
  %D%/packages/protobuf.scm			\
  %D%/packages/pure.scm				\
  %D%/packages/purescript.scm			\
  %D%/packages/pv.scm				\
  %D%/packages/python.scm			\
  %D%/packages/python-build.scm			\
  %D%/packages/python-check.scm			\
  %D%/packages/python-compression.scm		\
  %D%/packages/python-crypto.scm		\
  %D%/packages/python-science.scm		\
  %D%/packages/python-web.scm			\
  %D%/packages/python-xyz.scm			\
  %D%/packages/toys.scm				\
  %D%/packages/tryton.scm			\
  %D%/packages/qt.scm				\
  %D%/packages/radio.scm			\
  %D%/packages/ragel.scm			\
  %D%/packages/rails.scm			\
  %D%/packages/raspberry-pi.scm			\
  %D%/packages/ratpoison.scm			\
  %D%/packages/rcm.scm				\
  %D%/packages/rdesktop.scm			\
  %D%/packages/rdf.scm				\
  %D%/packages/re2c.scm				\
  %D%/packages/readline.scm			\
  %D%/packages/rednotebook.scm			\
  %D%/packages/regex.scm				\
  %D%/packages/robotics.scm			\
  %D%/packages/rpc.scm				\
  %D%/packages/rrdtool.scm			\
  %D%/packages/rsync.scm			\
  %D%/packages/ruby.scm				\
  %D%/packages/rush.scm				\
  %D%/packages/rust.scm				\
  %D%/packages/rust-apps.scm			\
  %D%/packages/samba.scm			\
  %D%/packages/sagemath.scm			\
  %D%/packages/sawfish.scm			\
  %D%/packages/scanner.scm			\
  %D%/packages/scheme.scm			\
  %D%/packages/screen.scm			\
  %D%/packages/scribus.scm			\
  %D%/packages/scsi.scm				\
  %D%/packages/sdl.scm				\
  %D%/packages/search.scm			\
  %D%/packages/security-token.scm		\
  %D%/packages/selinux.scm			\
  %D%/packages/sequoia.scm			\
  %D%/packages/serialization.scm		\
  %D%/packages/serveez.scm			\
  %D%/packages/shells.scm			\
  %D%/packages/shellutils.scm			\
  %D%/packages/simh.scm				\
  %D%/packages/simulation.scm			\
  %D%/packages/skarnet.scm			\
  %D%/packages/skribilo.scm			\
  %D%/packages/slang.scm			\
  %D%/packages/smalltalk.scm			\
  %D%/packages/sml.scm				\
  %D%/packages/speech.scm			\
  %D%/packages/sphinx.scm			\
  %D%/packages/spice.scm			\
  %D%/packages/sqlite.scm			\
  %D%/packages/squirrel.scm			\
  %D%/packages/ssh.scm				\
  %D%/packages/sssd.scm				\
  %D%/packages/stalonetray.scm			\
  %D%/packages/statistics.scm			\
  %D%/packages/stb.scm				\
  %D%/packages/stenography.scm			\
  %D%/packages/storage.scm			\
  %D%/packages/suckless.scm			\
  %D%/packages/swig.scm				\
  %D%/packages/sync.scm			\
  %D%/packages/syncthing.scm			\
  %D%/packages/synergy.scm			\
  %D%/packages/syndication.scm			\
  %D%/packages/task-management.scm		\
  %D%/packages/task-runners.scm			\
  %D%/packages/tbb.scm				\
  %D%/packages/tcl.scm				\
  %D%/packages/telegram.scm                 \
  %D%/packages/telephony.scm			\
  %D%/packages/terminals.scm			\
  %D%/packages/terraform.scm			\
  %D%/packages/texinfo.scm			\
  %D%/packages/tex.scm				\
  %D%/packages/textutils.scm			\
  %D%/packages/text-editors.scm			\
  %D%/packages/time.scm				\
  %D%/packages/tls.scm				\
  %D%/packages/tmux.scm				\
  %D%/packages/tor.scm				\
  %D%/packages/tv.scm				\
  %D%/packages/uml.scm				\
  %D%/packages/unicode.scm			\
  %D%/packages/unrtf.scm			\
  %D%/packages/upnp.scm				\
  %D%/packages/usb-modeswitch.scm		\
  %D%/packages/uucp.scm				\
  %D%/packages/valgrind.scm			\
  %D%/packages/version-control.scm		\
  %D%/packages/video.scm			\
  %D%/packages/vim.scm				\
  %D%/packages/virtualization.scm		\
  %D%/packages/visidata.scm			\
  %D%/packages/vlang.scm			\
  %D%/packages/vnc.scm				\
  %D%/packages/vpn.scm				\
  %D%/packages/vulkan.scm			\
  %D%/packages/w3m.scm				\
  %D%/packages/wdiff.scm			\
  %D%/packages/web.scm				\
  %D%/packages/web-browsers.scm			\
  %D%/packages/webkit.scm			\
  %D%/packages/wget.scm				\
  %D%/packages/wicd.scm				\
  %D%/packages/wine.scm				\
  %D%/packages/wireservice.scm				\
  %D%/packages/wm.scm				\
  %D%/packages/wordnet.scm			\
  %D%/packages/wv.scm				\
  %D%/packages/wxwidgets.scm			\
  %D%/packages/xfig.scm				\
  %D%/packages/xiph.scm				\
  %D%/packages/xml.scm				\
  %D%/packages/xnee.scm				\
  %D%/packages/xdisorg.scm			\
  %D%/packages/xorg.scm				\
  %D%/packages/xfce.scm				\
  %D%/packages/zile.scm				\
  %D%/packages/zwave.scm			\
						\
  %D%/services.scm				\
  %D%/services/admin.scm			\
  %D%/services/audio.scm                        \
  %D%/services/auditd.scm			\
  %D%/services/avahi.scm			\
  %D%/services/base.scm				\
  %D%/services/certbot.scm			\
  %D%/services/cgit.scm			\
  %D%/services/configuration.scm		\
  %D%/services/cuirass.scm			\
  %D%/services/cups.scm				\
  %D%/services/databases.scm			\
  %D%/services/dbus.scm				\
  %D%/services/desktop.scm			\
  %D%/services/dict.scm				\
  %D%/services/dns.scm				\
  %D%/services/docker.scm			\
  %D%/services/authentication.scm		\
  %D%/services/file-sharing.scm			\
  %D%/services/games.scm			\
  %D%/services/ganeti.scm			\
  %D%/services/getmail.scm				\
  %D%/services/guix.scm			\
  %D%/services/hurd.scm				\
  %D%/services/kerberos.scm			\
  %D%/services/linux.scm			\
  %D%/services/lirc.scm				\
  %D%/services/virtualization.scm		\
  %D%/services/mail.scm				\
  %D%/services/mcron.scm			\
  %D%/services/messaging.scm			\
  %D%/services/monitoring.scm			\
  %D%/services/networking.scm			\
  %D%/services/nix.scm				\
  %D%/services/nfs.scm			\
  %D%/services/pam-mount.scm			\
  %D%/services/science.scm			\
  %D%/services/security-token.scm		\
  %D%/services/shepherd.scm			\
  %D%/services/sound.scm			\
  %D%/services/herd.scm				\
  %D%/services/pm.scm				\
  %D%/services/rsync.scm			\
  %D%/services/sddm.scm				\
  %D%/services/spice.scm				\
  %D%/services/ssh.scm				\
  %D%/services/syncthing.scm			\
  %D%/services/sysctl.scm			\
  %D%/services/telephony.scm			\
  %D%/services/version-control.scm              \
  %D%/services/vpn.scm				\
  %D%/services/web.scm				\
  %D%/services/xorg.scm				\
						\
  %D%/system.scm				\
  %D%/system/accounts.scm			\
  %D%/system/file-systems.scm			\
  %D%/system/hurd.scm				\
  %D%/system/image.scm 				\
  %D%/system/install.scm			\
  %D%/system/keyboard.scm			\
  %D%/system/linux-container.scm		\
  %D%/system/linux-initrd.scm			\
  %D%/system/locale.scm				\
  %D%/system/mapped-devices.scm			\
  %D%/system/nss.scm				\
  %D%/system/pam.scm				\
  %D%/system/shadow.scm				\
  %D%/system/uuid.scm				\
  %D%/system/vm.scm				\
						\
  %D%/system/images/hurd.scm			\
  %D%/system/images/novena.scm			\
  %D%/system/images/pine64.scm			\
  %D%/system/images/pinebook-pro.scm		\
  %D%/system/images/rock64.scm			\
						\
  %D%/machine.scm				\
						\
  %D%/build/accounts.scm			\
  %D%/build/activation.scm			\
  %D%/build/bootloader.scm			\
  %D%/build/chromium-extension.scm		\
  %D%/build/cross-toolchain.scm			\
  %D%/build/image.scm				\
  %D%/build/file-systems.scm			\
  %D%/build/hurd-boot.scm			\
  %D%/build/install.scm				\
  %D%/build/linux-boot.scm			\
  %D%/build/linux-container.scm			\
  %D%/build/linux-initrd.scm			\
  %D%/build/linux-modules.scm			\
  %D%/build/marionette.scm			\
  %D%/build/secret-service.scm			\
  %D%/build/vm.scm				\
						\
  %D%/tests.scm					\
  %D%/tests/audio.scm				\
  %D%/tests/base.scm				\
  %D%/tests/cups.scm				\
  %D%/tests/databases.scm			\
  %D%/tests/desktop.scm				\
  %D%/tests/dict.scm				\
  %D%/tests/docker.scm				\
  %D%/tests/file-sharing.scm			\
  %D%/tests/ganeti.scm				\
  %D%/tests/guix.scm				\
  %D%/tests/monitoring.scm                      \
  %D%/tests/nfs.scm				\
  %D%/tests/install.scm				\
  %D%/tests/ldap.scm				\
  %D%/tests/linux-modules.scm			\
  %D%/tests/mail.scm				\
  %D%/tests/messaging.scm			\
  %D%/tests/networking.scm			\
  %D%/tests/package-management.scm		\
  %D%/tests/reconfigure.scm			\
  %D%/tests/rsync.scm				\
  %D%/tests/security-token.scm			\
  %D%/tests/singularity.scm			\
  %D%/tests/ssh.scm				\
  %D%/tests/version-control.scm			\
  %D%/tests/virtualization.scm			\
  %D%/tests/web.scm

INSTALLER_MODULES =                             \
  %D%/installer.scm      			\
  %D%/installer/connman.scm			\
  %D%/installer/final.scm			\
  %D%/installer/hostname.scm			\
  %D%/installer/keymap.scm			\
  %D%/installer/locale.scm			\
  %D%/installer/newt.scm			\
  %D%/installer/parted.scm			\
  %D%/installer/proxy.scm			\
  %D%/installer/record.scm		        \
  %D%/installer/services.scm			\
  %D%/installer/steps.scm			\
  %D%/installer/substitutes.scm			\
  %D%/installer/tests.scm			\
  %D%/installer/timezone.scm			\
  %D%/installer/user.scm			\
  %D%/installer/utils.scm			\
						\
  %D%/installer/newt/ethernet.scm		\
  %D%/installer/newt/final.scm  		\
  %D%/installer/newt/parameters.scm		\
  %D%/installer/newt/hostname.scm		\
  %D%/installer/newt/keymap.scm			\
  %D%/installer/newt/locale.scm			\
  %D%/installer/newt/menu.scm			\
  %D%/installer/newt/network.scm		\
  %D%/installer/newt/page.scm			\
  %D%/installer/newt/partition.scm		\
  %D%/installer/newt/services.scm		\
  %D%/installer/newt/substitutes.scm		\
  %D%/installer/newt/timezone.scm		\
  %D%/installer/newt/user.scm			\
  %D%/installer/newt/utils.scm			\
  %D%/installer/newt/welcome.scm		\
  %D%/installer/newt/wifi.scm

if HAVE_GUILE_SSH

GNU_SYSTEM_MODULES +=         			\
  %D%/machine/digital-ocean.scm			\
  %D%/machine/ssh.scm

endif HAVE_GUILE_SSH

# Always ship the installer modules but compile them only when
# ENABLE_INSTALLER is true.
if ENABLE_INSTALLER
GNU_SYSTEM_MODULES += $(INSTALLER_MODULES)
else !ENABLE_INSTALLER
MODULES_NOT_COMPILED += $(INSTALLER_MODULES)
endif

installerdir = $(guilemoduledir)/%D%/installer
dist_installer_DATA =				\
  %D%/installer/aux-files/logo.txt

# Modules that do not need to be compiled.
MODULES_NOT_COMPILED +=				\
  %D%/build/locale.scm				\
  %D%/build/shepherd.scm			\
  %D%/build/svg.scm

patchdir = $(guilemoduledir)/%D%/packages/patches
dist_patch_DATA =						\
  %D%/packages/patches/4store-fix-buildsystem.patch		\
  %D%/packages/patches/4store-unset-preprocessor-directive.patch	\
  %D%/packages/patches/a2ps-CVE-2001-1593.patch	\
  %D%/packages/patches/a2ps-CVE-2014-0466.patch	\
  %D%/packages/patches/a2ps-CVE-2015-8107.patch	\
  %D%/packages/patches/abcl-fix-build-xml.patch	\
  %D%/packages/patches/ableton-link-system-libraries-debian.patch	\
  %D%/packages/patches/abiword-explictly-cast-bools.patch	\
  %D%/packages/patches/abseil-cpp-fix-gtest.patch		\
  %D%/packages/patches/abseil-cpp-fix-strerror_test.patch	\
  %D%/packages/patches/adb-add-libraries.patch			\
  %D%/packages/patches/aegis-constness-error.patch         	\
  %D%/packages/patches/aegis-perl-tempdir1.patch           	\
  %D%/packages/patches/aegis-perl-tempdir2.patch           	\
  %D%/packages/patches/aegis-test-fixup-1.patch            	\
  %D%/packages/patches/aegis-test-fixup-2.patch            	\
  %D%/packages/patches/aegisub-icu59-include-unistr.patch	\
  %D%/packages/patches/aegisub-boost68.patch			\
  %D%/packages/patches/aegisub-make43.patch			\
  %D%/packages/patches/agg-am_c_prototype.patch			\
  %D%/packages/patches/akonadi-paths.patch		\
  %D%/packages/patches/akonadi-not-relocatable.patch		\
  %D%/packages/patches/akonadi-timestamps.patch		\
  %D%/packages/patches/allegro-mesa-18.2.5-and-later.patch	\
  %D%/packages/patches/amule-crypto-6.patch			\
  %D%/packages/patches/anki-mpv-args.patch			\
  %D%/packages/patches/antiword-CVE-2014-8123.patch			\
  %D%/packages/patches/antlr3-3_1-fix-java8-compilation.patch	\
  %D%/packages/patches/antlr3-3_3-fix-java8-compilation.patch	\
  %D%/packages/patches/apr-skip-getservbyname-test.patch	\
  %D%/packages/patches/aspell-default-dict-dir.patch		\
  %D%/packages/patches/ath9k-htc-firmware-binutils.patch	\
  %D%/packages/patches/ath9k-htc-firmware-gcc.patch		\
  %D%/packages/patches/ath9k-htc-firmware-objcopy.patch		\
  %D%/packages/patches/audacity-build-with-system-portaudio.patch \
  %D%/packages/patches/audacity-add-include.patch 		\
  %D%/packages/patches/audiofile-fix-datatypes-in-tests.patch	\
  %D%/packages/patches/audiofile-fix-sign-conversion.patch	\
  %D%/packages/patches/audiofile-CVE-2015-7747.patch		\
  %D%/packages/patches/audiofile-CVE-2018-13440.patch		\
  %D%/packages/patches/audiofile-CVE-2018-17095.patch		\
  %D%/packages/patches/audiofile-check-number-of-coefficients.patch \
  %D%/packages/patches/audiofile-Fail-on-error-in-parseFormat.patch \
  %D%/packages/patches/audiofile-Fix-index-overflow-in-IMA.cpp.patch \
  %D%/packages/patches/audiofile-multiply-overflow.patch	\
  %D%/packages/patches/audiofile-overflow-in-MSADPCM.patch	\
  %D%/packages/patches/audiofile-division-by-zero.patch 	\
  %D%/packages/patches/audiofile-hurd.patch 			\
  %D%/packages/patches/audiofile-function-signature.patch	\
  %D%/packages/patches/automake-skip-amhello-tests.patch	\
  %D%/packages/patches/avahi-localstatedir.patch		\
  %D%/packages/patches/avidemux-install-to-lib.patch		\
  %D%/packages/patches/awesome-reproducible-png.patch		\
  %D%/packages/patches/aws-c-cal-cmake-prefix.patch		\
  %D%/packages/patches/aws-c-event-stream-cmake-prefix.patch  \
  %D%/packages/patches/aws-c-io-cmake-prefix.patch		\
  %D%/packages/patches/aws-c-io-disable-networking-tests.patch		\
  %D%/packages/patches/aws-checksums-cmake-prefix.patch		\
  %D%/packages/patches/azr3.patch				\
  %D%/packages/patches/bash-reproducible-linux-pgrp-pipe.patch	\
  %D%/packages/patches/bash-completion-directories.patch	\
  %D%/packages/patches/bash-linux-pgrp-pipe.patch		\
  %D%/packages/patches/bastet-change-source-of-unordered_set.patch	\
  %D%/packages/patches/bazaar-CVE-2017-14176.patch		\
  %D%/packages/patches/bc-fix-cross-compilation.patch		\
  %D%/packages/patches/bear-disable-preinstall-tests.patch	\
  %D%/packages/patches/bsdiff-CVE-2014-9862.patch		\
  %D%/packages/patches/bsd-games-2.17-64bit.patch		\
  %D%/packages/patches/bsd-games-add-configure-config.patch	\
  %D%/packages/patches/bsd-games-add-wrapper.patch		\
  %D%/packages/patches/bsd-games-bad-ntohl-cast.patch		\
  %D%/packages/patches/bsd-games-dont-install-empty-files.patch	\
  %D%/packages/patches/bsd-games-gamescreen.h.patch		\
  %D%/packages/patches/bsd-games-getline.patch			\
  %D%/packages/patches/bsd-games-null-check.patch		\
  %D%/packages/patches/bsd-games-number.c-and-test.patch	\
  %D%/packages/patches/bsd-games-prevent-name-collisions.patch	\
  %D%/packages/patches/bsd-games-stdio.h.patch			\
  %D%/packages/patches/beancount-disable-googleapis-fonts.patch	\
  %D%/packages/patches/beets-werkzeug-compat.patch		\
  %D%/packages/patches/behave-skip-a-couple-of-tests.patch	\
  %D%/packages/patches/beignet-correct-file-names.patch		\
  %D%/packages/patches/biber-fix-encoding-write.patch		\
  %D%/packages/patches/biber-sortinithash.patch			\
  %D%/packages/patches/bidiv-update-fribidi.patch		\
  %D%/packages/patches/binutils-boot-2.20.1a.patch		\
  %D%/packages/patches/binutils-loongson-workaround.patch	\
  %D%/packages/patches/binutils-mingw-w64-timestamp.patch	\
  %D%/packages/patches/binutils-mingw-w64-deterministic.patch	\
  %D%/packages/patches/blender-2.79-gcc8.patch			\
  %D%/packages/patches/blender-2.79-gcc9.patch			\
  %D%/packages/patches/blender-2.79-newer-ffmpeg.patch		\
  %D%/packages/patches/blender-2.79-oiio2.patch			\
  %D%/packages/patches/blender-2.79-python-3.7-fix.patch	\
  %D%/packages/patches/blender-2.79-python-3.8-fix.patch	\
  %D%/packages/patches/bpftrace-disable-bfd-disasm.patch	\
  %D%/packages/patches/busybox-CVE-2021-28831.patch		\
  %D%/packages/patches/byobu-writable-status.patch		\
  %D%/packages/patches/cairo-CVE-2018-19876.patch		\
  %D%/packages/patches/cairo-CVE-2020-35492.patch		\
  %D%/packages/patches/calibre-no-updates-dialog.patch		\
  %D%/packages/patches/calibre-remove-test-sqlite.patch		\
  %D%/packages/patches/calibre-remove-test-unrar.patch		\
  %D%/packages/patches/casync-renameat2-declaration.patch	\
  %D%/packages/patches/catdoc-CVE-2017-11110.patch		\
  %D%/packages/patches/circos-remove-findbin.patch		\
  %D%/packages/patches/cdparanoia-fpic.patch			\
  %D%/packages/patches/cdrtools-3.01-mkisofs-isoinfo.patch 	\
  %D%/packages/patches/ceph-disable-cpu-optimizations.patch	\
  %D%/packages/patches/chez-scheme-build-util-paths-backport.patch      \
  %D%/packages/patches/chmlib-inttypes.patch			\
  %D%/packages/patches/cl-asdf-config-directories.patch		\
  %D%/packages/patches/clamav-config-llvm-libs.patch		\
  %D%/packages/patches/clamav-system-tomsfastmath.patch		\
  %D%/packages/patches/clang-3.5-libc-search-path.patch		\
  %D%/packages/patches/clang-3.5-libsanitizer-ustat-fix.patch	\
  %D%/packages/patches/clang-3.8-libc-search-path.patch		\
  %D%/packages/patches/clang-6.0-libc-search-path.patch		\
  %D%/packages/patches/clang-7.0-libc-search-path.patch		\
  %D%/packages/patches/clang-9.0-libc-search-path.patch		\
  %D%/packages/patches/clang-10.0-libc-search-path.patch	\
  %D%/packages/patches/clang-11.0-libc-search-path.patch	\
  %D%/packages/patches/clang-runtime-asan-build-fixes.patch	\
  %D%/packages/patches/clang-runtime-esan-build-fixes.patch	\
  %D%/packages/patches/clang-runtime-9-libsanitizer-mode-field.patch	\
  %D%/packages/patches/clang-runtime-3.5-libsanitizer-mode-field.patch	\
  %D%/packages/patches/clang-runtime-3.9-libsanitizer-mode-field.patch	\
  %D%/packages/patches/clang-runtime-3.8-libsanitizer-mode-field.patch	\
  %D%/packages/patches/classpath-aarch64-support.patch		\
  %D%/packages/patches/clucene-pkgconfig.patch			\
  %D%/packages/patches/cmake-curl-certificates.patch		\
  %D%/packages/patches/coda-use-system-libs.patch		\
  %D%/packages/patches/collectd-5.11.0-noinstallvar.patch		\
  %D%/packages/patches/combinatorial-blas-awpm.patch		\
  %D%/packages/patches/combinatorial-blas-io-fix.patch		\
  %D%/packages/patches/coreutils-ls.patch			\
  %D%/packages/patches/cpufrequtils-fix-aclocal.patch		\
  %D%/packages/patches/crawl-upgrade-saves.patch		\
  %D%/packages/patches/crda-optional-gcrypt.patch		\
  %D%/packages/patches/clucene-contribs-lib.patch               \
  %D%/packages/patches/cube-nocheck.patch			\
  %D%/packages/patches/curl-use-ssl-cert-env.patch		\
  %D%/packages/patches/curl-7.76-use-ssl-cert-env.patch	\
  %D%/packages/patches/cursynth-wave-rand.patch			\
  %D%/packages/patches/cvs-CVE-2017-12836.patch		\
  %D%/packages/patches/cyrus-sasl-ac-try-run-fix.patch		\
  %D%/packages/patches/cyrus-sasl-CVE-2019-19906.patch		\
  %D%/packages/patches/c++-gsl-find-system-gtest.patch		\
  %D%/packages/patches/date-output-pkg-config-files.patch	\
  %D%/packages/patches/datefudge-gettimeofday.patch		\
  %D%/packages/patches/dbacl-include-locale.h.patch		\
  %D%/packages/patches/dbus-helper-search-path.patch		\
  %D%/packages/patches/dbus-CVE-2020-12049.patch		\
  %D%/packages/patches/dbus-c++-gcc-compat.patch		\
  %D%/packages/patches/dbus-c++-threading-mutex.patch		\
  %D%/packages/patches/dbxfs-remove-sentry-sdk.patch		\
  %D%/packages/patches/debops-constants-for-external-program-names.patch \
  %D%/packages/patches/debops-debops-defaults-fall-back-to-less.patch \
  %D%/packages/patches/dee-vapi.patch			\
  %D%/packages/patches/desmume-gcc6-fixes.patch			\
  %D%/packages/patches/desmume-gcc7-fixes.patch			\
  %D%/packages/patches/dfu-programmer-fix-libusb.patch		\
  %D%/packages/patches/diffutils-gets-undeclared.patch		\
  %D%/packages/patches/dkimproxy-add-ipv6-support.patch		\
  %D%/packages/patches/docbook-xsl-nonrecursive-string-subst.patch	\
  %D%/packages/patches/doc++-include-directives.patch		\
  %D%/packages/patches/doc++-segfault-fix.patch			\
  %D%/packages/patches/docker-fix-tests.patch			\
  %D%/packages/patches/dovecot-trees-support-dovecot-2.3.patch	\
  %D%/packages/patches/doxygen-test.patch			\
  %D%/packages/patches/doxygen-1.8.17-runtests.patch		\
  %D%/packages/patches/dstat-fix-crash-when-specifying-delay.patch	\
  %D%/packages/patches/dstat-skip-devices-without-io.patch	\
  %D%/packages/patches/dune-istl-2.7-fix-non-mpi-tests.patch	\
  %D%/packages/patches/dvd+rw-tools-add-include.patch 		\
  %D%/packages/patches/ecl-16-format-directive-limit.patch	\
  %D%/packages/patches/ecl-16-ignore-stderr-write-error.patch	\
  %D%/packages/patches/ecl-16-libffi.patch			\
  %D%/packages/patches/efibootmgr-remove-extra-decl.patch	\
  %D%/packages/patches/eigen-remove-openmp-error-counting.patch	\
  %D%/packages/patches/eigen-stabilise-sparseqr-test.patch	\
  %D%/packages/patches/einstein-build.patch			\
  %D%/packages/patches/elfutils-tests-ptrace.patch		\
  %D%/packages/patches/elixir-path-length.patch			\
  %D%/packages/patches/elm-compiler-disable-reactor.patch	\
  %D%/packages/patches/elm-compiler-fix-map-key.patch		\
  %D%/packages/patches/emacs-exec-path.patch			\
  %D%/packages/patches/emacs-exwm-fix-fullscreen-states.patch	\
  %D%/packages/patches/emacs-fix-scheme-indent-function.patch	\
  %D%/packages/patches/emacs-ignore-empty-xim-styles.patch	\
  %D%/packages/patches/emacs-json-reformat-fix-tests.patch	\
  %D%/packages/patches/emacs-highlight-stages-add-gexp.patch	\
  %D%/packages/patches/emacs-hyperbole-toggle-messaging.patch	\
  %D%/packages/patches/emacs-libgit-use-system-libgit2.patch    \
  %D%/packages/patches/emacs-source-date-epoch.patch		\
  %D%/packages/patches/emacs-telega-patch-server-functions.patch	\
  %D%/packages/patches/emacs-telega-test-env.patch		\
  %D%/packages/patches/emacs-wordnut-require-adaptive-wrap.patch	\
  %D%/packages/patches/enjarify-setup-py.patch			\
  %D%/packages/patches/enlightenment-fix-setuid-path.patch	\
  %D%/packages/patches/erlang-man-path.patch			\
  %D%/packages/patches/eudev-rules-directory.patch		\
  %D%/packages/patches/evilwm-lost-focus-bug.patch		\
  %D%/packages/patches/evolution-CVE-2020-11879.patch		\
  %D%/packages/patches/evolution-data-server-CVE-2020-14928.patch	\
  %D%/packages/patches/evolution-data-server-CVE-2020-16117.patch	\
  %D%/packages/patches/evolution-data-server-locales.patch	\
  %D%/packages/patches/evolution-data-server-libical-compat.patch	\
  %D%/packages/patches/exercism-disable-self-update.patch	\
  %D%/packages/patches/extempore-unbundle-external-dependencies.patch	\
  %D%/packages/patches/extundelete-e2fsprogs-1.44.patch		\
  %D%/packages/patches/farstream-make.patch                          \
  %D%/packages/patches/fastcap-mulGlobal.patch			\
  %D%/packages/patches/fastcap-mulSetup.patch			\
  %D%/packages/patches/fasthenry-spAllocate.patch		\
  %D%/packages/patches/fasthenry-spBuild.patch			\
  %D%/packages/patches/fasthenry-spUtils.patch			\
  %D%/packages/patches/fasthenry-spSolve.patch			\
  %D%/packages/patches/fasthenry-spFactor.patch			\
  %D%/packages/patches/fbreader-curl-7.62.patch		\
  %D%/packages/patches/fifengine-swig-compat.patch		\
  %D%/packages/patches/fifo-map-fix-flags-for-gcc.patch		\
  %D%/packages/patches/fifo-map-remove-catch.hpp.patch		\
  %D%/packages/patches/findutils-localstatedir.patch		\
  %D%/packages/patches/findutils-test-rwlock-threads.patch	\
  %D%/packages/patches/flann-cmake-3.11.patch			\
  %D%/packages/patches/foobillard++-pkg-config.patch		\
  %D%/packages/patches/foomatic-filters-CVE-2015-8327.patch	\
  %D%/packages/patches/foomatic-filters-CVE-2015-8560.patch	\
  %D%/packages/patches/fontconfig-hurd-path-max.patch		\
  %D%/packages/patches/fpc-reproducibility.patch		\
  %D%/packages/patches/fplll-std-fenv.patch     		\
  %D%/packages/patches/freedink-engine-fix-sdl-hints.patch	\
  %D%/packages/patches/freebayes-devendor-deps.patch		\
  %D%/packages/patches/freeimage-unbundle.patch		\
  %D%/packages/patches/fuse-overlapping-headers.patch				\
  %D%/packages/patches/gajim-honour-GAJIM_PLUGIN_PATH.patch	\
  %D%/packages/patches/ganeti-deterministic-manual.patch	\
  %D%/packages/patches/ganeti-disable-version-symlinks.patch	\
  %D%/packages/patches/ganeti-drbd-compat.patch			\
  %D%/packages/patches/ganeti-haskell-pythondir.patch		\
  %D%/packages/patches/ganeti-os-disk-size.patch		\
  %D%/packages/patches/ganeti-preserve-PYTHONPATH.patch		\
  %D%/packages/patches/ganeti-shepherd-master-failover.patch	\
  %D%/packages/patches/ganeti-shepherd-support.patch		\
  %D%/packages/patches/gash-utils-ls-test.patch			\
  %D%/packages/patches/gawk-shell.patch				\
  %D%/packages/patches/gcc-arm-bug-71399.patch			\
  %D%/packages/patches/gcc-arm-link-spec-fix.patch		\
  %D%/packages/patches/gcc-asan-missing-include.patch		\
  %D%/packages/patches/gcc-boot-2.95.3.patch			\
  %D%/packages/patches/gcc-boot-4.6.4.patch			\
  %D%/packages/patches/gcc-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-fix-texi2pod.patch			\
  %D%/packages/patches/gcc-4.8-libsanitizer-fix.patch		\
  %D%/packages/patches/gcc-4.9-libsanitizer-fix.patch		\
  %D%/packages/patches/gcc-4.9-libsanitizer-ustat.patch		\
  %D%/packages/patches/gcc-libsanitizer-ustat.patch		\
  %D%/packages/patches/gcc-4.9-libsanitizer-mode-size.patch	\
  %D%/packages/patches/gcc-6-fix-isl-includes.patch	\
  %D%/packages/patches/gcc-6-fix-buffer-size.patch	\
  %D%/packages/patches/gcc-6-libsanitizer-mode-size.patch	\
  %D%/packages/patches/gcc-7-libsanitizer-mode-size.patch	\
  %D%/packages/patches/gcc-libvtv-runpath.patch			\
  %D%/packages/patches/gcc-strmov-store-file-names.patch	\
  %D%/packages/patches/gcc-4-compile-with-gcc-5.patch		 \
  %D%/packages/patches/gcc-4.6-gnu-inline.patch			\
  %D%/packages/patches/gcc-4.9.3-mingw-gthr-default.patch	\
  %D%/packages/patches/gcc-5-hurd.patch				\
  %D%/packages/patches/gcc-5.0-libvtv-runpath.patch		\
  %D%/packages/patches/gcc-5-source-date-epoch-1.patch		\
  %D%/packages/patches/gcc-5-source-date-epoch-2.patch		\
  %D%/packages/patches/gcc-6-arm-none-eabi-multilib.patch	\
  %D%/packages/patches/gcc-6-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-6-source-date-epoch-1.patch		\
  %D%/packages/patches/gcc-6-source-date-epoch-2.patch		\
  %D%/packages/patches/gcc-7-cross-mingw.patch			\
  %D%/packages/patches/gcc-7-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-7-cross-toolexeclibdir.patch		\
  %D%/packages/patches/gcc-8-cross-environment-variables.patch	\
  %D%/packages/patches/gcc-8-strmov-store-file-names.patch	\
  %D%/packages/patches/gcc-9-asan-fix-limits-include.patch	\
  %D%/packages/patches/gcc-9-strmov-store-file-names.patch	\
  %D%/packages/patches/gdb-hurd.patch				\
  %D%/packages/patches/gd-fix-tests-on-i686.patch		\
  %D%/packages/patches/gd-brect-bounds.patch			\
  %D%/packages/patches/gdk-pixbuf-CVE-2020-29385.patch		\
  %D%/packages/patches/gdm-default-session.patch		\
  %D%/packages/patches/geary-CVE-2020-24661.patch		\
  %D%/packages/patches/genimage-signedness.patch		\
  %D%/packages/patches/geoclue-config.patch			\
  %D%/packages/patches/ghc-8.0-fall-back-to-madv_dontneed.patch	\
  %D%/packages/patches/ghc-testsuite-dlopen-pie.patch		\
  %D%/packages/patches/ghc-diff-swap-cover-args.patch		\
  %D%/packages/patches/ghc-haddock-api-fix-haddock.patch	\
  %D%/packages/patches/ghc-hpack-fix-tests.patch		\
  %D%/packages/patches/ghc-microlens-aeson-fix-tests.patch	\
  %D%/packages/patches/ghc-monad-par-fix-tests.patch		\
  %D%/packages/patches/ghc-pandoc-fix-html-tests.patch		\
  %D%/packages/patches/ghc-pandoc-fix-latex-test.patch		\
  %D%/packages/patches/ghostscript-CVE-2020-15900.patch		\
  %D%/packages/patches/ghostscript-freetype-compat.patch	\
  %D%/packages/patches/ghostscript-no-header-id.patch		\
  %D%/packages/patches/ghostscript-no-header-uuid.patch		\
  %D%/packages/patches/ghostscript-no-header-creationdate.patch \
  %D%/packages/patches/gimp-make-gegl-introspect-optional.patch	\
  %D%/packages/patches/glib-appinfo-watch.patch			\
  %D%/packages/patches/glib-tests-timer.patch			\
  %D%/packages/patches/glib-CVE-2021-27218.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-01.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-02.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-03.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-04.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-05.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-06.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-07.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-08.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-09.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-10.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-11.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-12.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-13.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-14.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-15.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-16.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-17.patch		\
  %D%/packages/patches/glib-CVE-2021-27219-18.patch		\
  %D%/packages/patches/glib-CVE-2021-28153.patch		\
  %D%/packages/patches/glibc-CVE-2018-11236.patch		\
  %D%/packages/patches/glibc-CVE-2018-11237.patch		\
  %D%/packages/patches/glibc-CVE-2019-7309.patch		\
  %D%/packages/patches/glibc-CVE-2019-9169.patch		\
  %D%/packages/patches/glibc-CVE-2019-19126.patch		\
  %D%/packages/patches/glibc-allow-kernel-2.6.32.patch		\
  %D%/packages/patches/glibc-boot-2.16.0.patch			\
  %D%/packages/patches/glibc-boot-2.2.5.patch			\
  %D%/packages/patches/glibc-bootstrap-system-2.2.5.patch 	\
  %D%/packages/patches/glibc-bootstrap-system-2.16.0.patch 	\
  %D%/packages/patches/glibc-bootstrap-system.patch		\
  %D%/packages/patches/glibc-hidden-visibility-ldconfig.patch	\
  %D%/packages/patches/glibc-hurd-clock_gettime_monotonic.patch	\
  %D%/packages/patches/glibc-hurd-clock_t_centiseconds.patch	\
  %D%/packages/patches/glibc-hurd-gettyent.patch		\
  %D%/packages/patches/glibc-hurd-mach-print.patch		\
  %D%/packages/patches/glibc-hurd-magic-pid.patch		\
  %D%/packages/patches/glibc-hurd-signal-sa-siginfo.patch	\
  %D%/packages/patches/glibc-ldd-powerpc.patch			\
  %D%/packages/patches/glibc-ldd-x86_64.patch			\
  %D%/packages/patches/glibc-locales.patch			\
  %D%/packages/patches/glibc-locales-2.28.patch			\
  %D%/packages/patches/glibc-reinstate-prlimit64-fallback.patch	\
  %D%/packages/patches/glibc-versioned-locpath.patch		\
  %D%/packages/patches/glibc-2.27-git-fixes.patch		\
  %D%/packages/patches/glibc-2.28-git-fixes.patch		\
  %D%/packages/patches/glibc-2.29-git-updates.patch     	\
  %D%/packages/patches/glibc-2.27-supported-locales.patch     	\
  %D%/packages/patches/glibc-2.28-supported-locales.patch     	\
  %D%/packages/patches/glibc-2.29-supported-locales.patch     	\
  %D%/packages/patches/glibc-supported-locales.patch     	\
  %D%/packages/patches/gmp-arm-asm-nothumb.patch		\
  %D%/packages/patches/gmp-faulty-test.patch			\
  %D%/packages/patches/gnash-fix-giflib-version.patch	        \
  %D%/packages/patches/gnome-shell-theme.patch			\
  %D%/packages/patches/gnome-shell-disable-test.patch		\
  %D%/packages/patches/gnome-shell-CVE-2020-17489.patch		\
  %D%/packages/patches/gnome-settings-daemon-gc.patch		\
  %D%/packages/patches/gnome-todo-delete-esource-duplicate.patch \
  %D%/packages/patches/gnome-tweaks-search-paths.patch		\
  %D%/packages/patches/gnupg-default-pinentry.patch		\
  %D%/packages/patches/gnutls-skip-trust-store-test.patch	\
  %D%/packages/patches/gnutls-cross.patch			\
  %D%/packages/patches/gnutls-CVE-2021-20231.patch		\
  %D%/packages/patches/gnutls-CVE-2021-20232.patch		\
  %D%/packages/patches/gobject-introspection-absolute-shlib-path.patch \
  %D%/packages/patches/gobject-introspection-cc.patch		\
  %D%/packages/patches/gobject-introspection-girepository.patch	\
  %D%/packages/patches/go-skip-gc-test.patch			\
  %D%/packages/patches/gpm-glibc-2.26.patch			\
  %D%/packages/patches/gpodder-disable-updater.patch		\
  %D%/packages/patches/gpsbabel-fix-i686-test.patch		\
  %D%/packages/patches/grantlee-merge-theme-dirs.patch		\
  %D%/packages/patches/grep-timing-sensitive-test.patch		\
  %D%/packages/patches/grocsvs-dont-use-admiral.patch		\
  %D%/packages/patches/gromacs-tinyxml2.patch			\
  %D%/packages/patches/groovy-add-exceptionutilsgenerator.patch	\
  %D%/packages/patches/grub-cross-system-i686.patch		\
  %D%/packages/patches/grub-efi-fat-serial-number.patch		\
  %D%/packages/patches/grub-setup-root.patch			\
  %D%/packages/patches/grub-verifiers-Blocklist-fallout-cleanup.patch \
  %D%/packages/patches/gspell-dash-test.patch			\
  %D%/packages/patches/gst-plugins-good-fix-test.patch		\
  %D%/packages/patches/guile-1.8-cpp-4.5.patch			\
  %D%/packages/patches/guile-2.2-skip-oom-test.patch            \
  %D%/packages/patches/guile-2.2-skip-so-test.patch             \
  %D%/packages/patches/guile-default-utf8.patch			\
  %D%/packages/patches/guile-2.2-default-utf8.patch		\
  %D%/packages/patches/guile-relocatable.patch			\
  %D%/packages/patches/guile-3.0-relocatable.patch		\
  %D%/packages/patches/guile-linux-syscalls.patch		\
  %D%/packages/patches/guile-3.0-linux-syscalls.patch		\
  %D%/packages/patches/guile-fibers-destroy-peer-schedulers.patch \
  %D%/packages/patches/guile-gdbm-ffi-support-gdbm-1.14.patch	\
  %D%/packages/patches/guile-present-coding.patch		\
  %D%/packages/patches/guile-rsvg-pkgconfig.patch		\
  %D%/packages/patches/guile-emacs-fix-configure.patch		\
  %D%/packages/patches/gtk2-respect-GUIX_GTK2_PATH.patch	\
  %D%/packages/patches/gtk2-respect-GUIX_GTK2_IM_MODULE_FILE.patch \
  %D%/packages/patches/gtk2-theme-paths.patch			\
  %D%/packages/patches/gtk3-respect-GUIX_GTK3_PATH.patch	\
  %D%/packages/patches/gtk3-respect-GUIX_GTK3_IM_MODULE_FILE.patch \
  %D%/packages/patches/gtkglext-disable-disable-deprecated.patch \
  %D%/packages/patches/gtksourceview-2-add-default-directory.patch \
  %D%/packages/patches/gvfs-add-support-for-libplist-2.2.patch	\
  %D%/packages/patches/gzdoom-search-in-installed-share.patch	\
  %D%/packages/patches/gzdoom-find-system-libgme.patch	\
  %D%/packages/patches/hdf4-architectures.patch 		\
  %D%/packages/patches/hdf4-reproducibility.patch 		\
  %D%/packages/patches/hdf4-shared-fortran.patch 		\
  %D%/packages/patches/hdf4-tirpc.patch 			\
  %D%/packages/patches/hdf5-config-date.patch			\
  %D%/packages/patches/hdf-eos2-build-shared.patch 		\
  %D%/packages/patches/hdf-eos2-remove-gctp.patch		\
  %D%/packages/patches/hdf-eos2-fortrantests.patch		\
  %D%/packages/patches/hdf-eos5-build-shared.patch 		\
  %D%/packages/patches/hdf-eos5-remove-gctp.patch		\
  %D%/packages/patches/hdf-eos5-fix-szip.patch			\
  %D%/packages/patches/hdf-eos5-fortrantests.patch		\
  %D%/packages/patches/http-parser-CVE-2020-8287.patch		\
  %D%/packages/patches/hubbub-sort-entities.patch		\
  %D%/packages/patches/hurd-cross.patch				\
  %D%/packages/patches/hurd-xattr.patch				\
  %D%/packages/patches/hplip-remove-imageprocessor.patch	\
  %D%/packages/patches/hydra-disable-darcs-test.patch		\
  %D%/packages/patches/icecat-makeicecat.patch			\
  %D%/packages/patches/icecat-avoid-bundled-libraries.patch	\
  %D%/packages/patches/icecat-use-older-reveal-hidden-html.patch	\
  %D%/packages/patches/icecat-use-system-graphite2+harfbuzz.patch	\
  %D%/packages/patches/icecat-use-system-media-libs.patch	\
  %D%/packages/patches/icedtea-6-extend-hotspot-aarch64-support.patch	\
  %D%/packages/patches/icedtea-7-hotspot-aarch64-use-c++98.patch	\
  %D%/packages/patches/icu4c-CVE-2020-10531.patch  		\
  %D%/packages/patches/id3lib-CVE-2007-4460.patch			\
  %D%/packages/patches/id3lib-UTF16-writing-bug.patch			\
  %D%/packages/patches/idris-disable-test.patch			\
  %D%/packages/patches/ilmbase-fix-tests.patch			\
  %D%/packages/patches/imagemagick-CVE-2020-27829.patch		\
  %D%/packages/patches/imagemagick-ReadDCMImage-fix.patch	\
  %D%/packages/patches/imagemagick-ReadDCMPixels-fix.patch	\
  %D%/packages/patches/imagemagick-WriteTHUMBNAILImage-fix.patch	\
  %D%/packages/patches/inetutils-hurd.patch			\
  %D%/packages/patches/inkscape-poppler-0.76.patch		\
  %D%/packages/patches/intel-xed-fix-nondeterminism.patch	\
  %D%/packages/patches/intltool-perl-compatibility.patch	\
  %D%/packages/patches/iputils-libcap-compat.patch		\
  %D%/packages/patches/ipxe-reproducible-geniso.patch	        \
  %D%/packages/patches/irrlicht-use-system-libs.patch		\
  %D%/packages/patches/isl-0.11.1-aarch64-support.patch	\
  %D%/packages/patches/json-c-CVE-2020-12762.patch		\
  %D%/packages/patches/json-c-0.13-CVE-2020-12762.patch	\
  %D%/packages/patches/json-c-0.12-CVE-2020-12762.patch	\
  %D%/packages/patches/jacal-fix-texinfo.patch			\
  %D%/packages/patches/jamvm-1.5.1-aarch64-support.patch	\
  %D%/packages/patches/jamvm-1.5.1-armv7-support.patch	\
  %D%/packages/patches/jamvm-2.0.0-aarch64-support.patch	\
  %D%/packages/patches/jamvm-2.0.0-disable-branch-patching.patch	\
  %D%/packages/patches/jamvm-2.0.0-opcode-guard.patch		\
  %D%/packages/patches/java-antlr4-Add-standalone-generator.patch	\
  %D%/packages/patches/java-antlr4-fix-code-too-large.java	\
  %D%/packages/patches/java-tunnelvisionlabs-antlr-code-too-large.patch	\
  %D%/packages/patches/java-apache-ivy-port-to-latest-bouncycastle.patch	\
  %D%/packages/patches/java-commons-collections-fix-java8.patch \
  %D%/packages/patches/java-jeromq-fix-tests.patch		\
  %D%/packages/patches/java-openjfx-build-jdk_version.patch     \
  %D%/packages/patches/java-powermock-fix-java-files.patch		\
  %D%/packages/patches/java-simple-xml-fix-tests.patch		\
  %D%/packages/patches/java-svg-salamander-Fix-non-det.patch	\
  %D%/packages/patches/java-xerces-bootclasspath.patch	\
  %D%/packages/patches/java-xerces-build_dont_unzip.patch	\
  %D%/packages/patches/java-xerces-xjavac_taskdef.patch	\
  %D%/packages/patches/jfsutils-add-sysmacros.patch		\
  %D%/packages/patches/jfsutils-include-systypes.patch		\
  %D%/packages/patches/jsoncpp-fix-inverted-case.patch		\
  %D%/packages/patches/julia-SOURCE_DATE_EPOCH-mtime.patch	\
  %D%/packages/patches/kdbusaddons-kinit-file-name.patch	\
  %D%/packages/patches/libffi-3.3-powerpc-fixes.patch		\
  %D%/packages/patches/libffi-float128-powerpc64le.patch	\
  %D%/packages/patches/libvirt-add-install-prefix.patch	\
  %D%/packages/patches/libziparchive-add-includes.patch		\
  %D%/packages/patches/lksctp-tools-1.0.18-fix-header-file-name.patch \
  %D%/packages/patches/localed-xorg-keyboard.patch		\
  %D%/packages/patches/kdiagram-Fix-missing-link-libraries.patch \
  %D%/packages/patches/kiki-level-selection-crash.patch		\
  %D%/packages/patches/kiki-makefile.patch			\
  %D%/packages/patches/kiki-missing-includes.patch		\
  %D%/packages/patches/kiki-portability-64bit.patch		\
  %D%/packages/patches/kinit-kdeinit-extra_libs.patch		\
  %D%/packages/patches/kinit-kdeinit-libpath.patch		\
  %D%/packages/patches/kio-search-smbd-on-PATH.patch		\
  %D%/packages/patches/kmail-Fix-missing-link-libraries.patch \
  %D%/packages/patches/kmod-module-directory.patch		\
  %D%/packages/patches/kmscon-runtime-keymap-switch.patch	\
  %D%/packages/patches/kpackage-allow-external-paths.patch	\
  %D%/packages/patches/kpackage-fix-KF5PackageMacros.cmake.patch \
  %D%/packages/patches/kmplayer-aarch64.patch			\
  %D%/packages/patches/kmplayer-upstream_Fix-build-with-Qt-5.9.patch	\
  %D%/packages/patches/kobodeluxe-paths.patch			\
  %D%/packages/patches/kobodeluxe-enemies-pipe-decl.patch	\
  %D%/packages/patches/kobodeluxe-const-charp-conversion.patch	\
  %D%/packages/patches/kobodeluxe-manpage-minus-not-hyphen.patch	\
  %D%/packages/patches/kobodeluxe-midicon-segmentation-fault.patch	\
  %D%/packages/patches/kobodeluxe-graphics-window-signed-char.patch	\
  %D%/packages/patches/kodi-increase-test-timeout.patch		\
  %D%/packages/patches/kodi-set-libcurl-ssl-parameters.patch		\
  %D%/packages/patches/kodi-skip-test-449.patch		\
  %D%/packages/patches/laby-make-install.patch			\
  %D%/packages/patches/lcalc-default-parameters-1.patch		\
  %D%/packages/patches/lcalc-default-parameters-2.patch		\
  %D%/packages/patches/lcalc-lcommon-h.patch    		\
  %D%/packages/patches/lcalc-using-namespace-std.patch 		\
  %D%/packages/patches/lcms-CVE-2018-16435.patch		\
  %D%/packages/patches/ldc-bootstrap-disable-tests.patch	\
  %D%/packages/patches/ldc-disable-phobos-tests.patch		\
  %D%/packages/patches/ldns-drill-examples.patch		\
  %D%/packages/patches/leela-zero-gtest.patch			\
  %D%/packages/patches/less-hurd-path-max.patch			\
  %D%/packages/patches/lib2geom-fix-tests.patch			\
  %D%/packages/patches/liba52-enable-pic.patch			\
  %D%/packages/patches/liba52-link-with-libm.patch		\
  %D%/packages/patches/liba52-set-soname.patch			\
  %D%/packages/patches/liba52-use-mtune-not-mcpu.patch		\
  %D%/packages/patches/libbase-fix-includes.patch		\
  %D%/packages/patches/libbase-use-own-logging.patch		\
  %D%/packages/patches/libbonobo-activation-test-race.patch	\
  %D%/packages/patches/libcaca-CVE-2021-3410-pt1.patch		\
  %D%/packages/patches/libcaca-CVE-2021-3410-pt2.patch		\
  %D%/packages/patches/libcanberra-sound-theme-freedesktop.patch \
  %D%/packages/patches/libcanberra-wayland-crash.patch \
  %D%/packages/patches/libcroco-CVE-2020-12825.patch		\
  %D%/packages/patches/libcyaml-libyaml-compat.patch		\
  %D%/packages/patches/libexpected-nofetch.patch                \
  %D%/packages/patches/libgeotiff-adapt-test-script-for-proj-6.2.patch		\
  %D%/packages/patches/libgit2-mtime-0.patch			\
  %D%/packages/patches/libgnome-encoding.patch			\
  %D%/packages/patches/libgnomeui-utf8.patch			\
  %D%/packages/patches/libjxr-fix-function-signature.patch	\
  %D%/packages/patches/libjxr-fix-typos.patch			\
  %D%/packages/patches/libofa-ftbfs-1.diff		\
  %D%/packages/patches/libofa-curl.diff		\
  %D%/packages/patches/libofa-ftbfs-2.diff		\
  %D%/packages/patches/libotr-test-auth-fix.patch		\
  %D%/packages/patches/libksieve-Fix-missing-link-libraries.patch \
  %D%/packages/patches/libmad-armv7-thumb-pt1.patch		\
  %D%/packages/patches/libmad-armv7-thumb-pt2.patch		\
  %D%/packages/patches/libmad-length-check.patch		\
  %D%/packages/patches/libmad-md_size.patch			\
  %D%/packages/patches/libmad-mips-newgcc.patch			\
  %D%/packages/patches/libmp4v2-c++11.patch			\
  %D%/packages/patches/libmpeg2-arm-private-symbols.patch	\
  %D%/packages/patches/libmpeg2-global-symbol-test.patch	\
  %D%/packages/patches/libmygpo-qt-fix-qt-5.11.patch		\
  %D%/packages/patches/libmygpo-qt-missing-qt5-modules.patch	\
  %D%/packages/patches/libqalculate-3.8.0-libcurl-ssl-fix.patch	\
  %D%/packages/patches/libquicktime-ffmpeg.patch 		\
  %D%/packages/patches/libssh2-CVE-2019-17498.patch 		\
  %D%/packages/patches/libtar-CVE-2013-4420.patch 		\
  %D%/packages/patches/libtgvoip-disable-sse2.patch 		\
  %D%/packages/patches/libtgvoip-disable-webrtc.patch 		\
  %D%/packages/patches/libtheora-config-guess.patch		\
  %D%/packages/patches/libtirpc-hurd.patch			\
  %D%/packages/patches/libtirpc-hurd-client.patch		\
  %D%/packages/patches/libtommath-fix-linkage.patch		\
  %D%/packages/patches/libtool-skip-tests2.patch		\
  %D%/packages/patches/libusb-0.1-disable-tests.patch		\
  %D%/packages/patches/libusb-for-axoloti.patch			\
  %D%/packages/patches/libutils-add-includes.patch		\
  %D%/packages/patches/libutils-remove-damaging-includes.patch	\
  %D%/packages/patches/libvdpau-va-gl-unbundle.patch		\
  %D%/packages/patches/libvpx-CVE-2016-2818.patch		\
  %D%/packages/patches/libxslt-generated-ids.patch		\
  %D%/packages/patches/libxt-guix-search-paths.patch		\
  %D%/packages/patches/lierolibre-check-unaligned-access.patch	\
  %D%/packages/patches/lierolibre-is-free-software.patch	\
  %D%/packages/patches/lierolibre-newer-libconfig.patch		\
  %D%/packages/patches/lierolibre-remove-arch-warning.patch	\
  %D%/packages/patches/lierolibre-try-building-other-arch.patch	\
  %D%/packages/patches/linbox-fix-pkgconfig.patch		\
  %D%/packages/patches/linkchecker-tests-require-network.patch	\
  %D%/packages/patches/linphone-desktop-without-sdk.patch           \
  %D%/packages/patches/linux-libre-support-for-Pinebook-Pro.patch \
  %D%/packages/patches/linux-pam-no-setfsuid.patch		\
  %D%/packages/patches/lirc-localstatedir.patch			\
  %D%/packages/patches/lirc-reproducible-build.patch		\
  %D%/packages/patches/llhttp-bootstrap-CVE-2020-8287.patch	\
  %D%/packages/patches/llvm-3.5-fix-clang-build-with-gcc5.patch	\
  %D%/packages/patches/llvm-9-fix-bitcast-miscompilation.patch	\
  %D%/packages/patches/llvm-9-fix-lpad-miscompilation.patch	\
  %D%/packages/patches/llvm-9-fix-scev-miscompilation.patch	\
  %D%/packages/patches/lm-sensors-hwmon-attrs.patch		\
  %D%/packages/patches/lrcalc-includes.patch    		\
  %D%/packages/patches/lsh-fix-x11-forwarding.patch		\
  %D%/packages/patches/lsof-fatal-test-failures.patch		\
  %D%/packages/patches/lua-CVE-2014-5461.patch                      \
  %D%/packages/patches/lua-pkgconfig.patch                      \
  %D%/packages/patches/lua51-liblua-so.patch                    \
  %D%/packages/patches/lua51-pkgconfig.patch                    \
  %D%/packages/patches/lua-liblua-so.patch                      \
  %D%/packages/patches/luajit-no_ldconfig.patch			\
  %D%/packages/patches/luit-posix.patch				\
  %D%/packages/patches/lvm2-static-link.patch			\
  %D%/packages/patches/mailutils-fix-uninitialized-variable.patch	\
  %D%/packages/patches/make-impure-dirs.patch			\
  %D%/packages/patches/mariadb-CVE-2021-27928.patch		\
  %D%/packages/patches/mars-install.patch			\
  %D%/packages/patches/mars-sfml-2.3.patch			\
  %D%/packages/patches/maxima-defsystem-mkdir.patch		\
  %D%/packages/patches/maven-enforcer-api-fix-old-dependencies.patch	\
  %D%/packages/patches/maven-generate-component-xml.patch		\
  %D%/packages/patches/maven-generate-javax-inject-named.patch		\
  %D%/packages/patches/mcrypt-CVE-2012-4409.patch			\
  %D%/packages/patches/mcrypt-CVE-2012-4426.patch			\
  %D%/packages/patches/mcrypt-CVE-2012-4527.patch			\
  %D%/packages/patches/libmemcached-build-with-gcc7.patch	\
  %D%/packages/patches/libmhash-hmac-fix-uaf.patch		\
  %D%/packages/patches/mesa-skip-tests.patch			\
  %D%/packages/patches/mescc-tools-boot.patch			\
  %D%/packages/patches/meson-for-build-rpath.patch		\
  %D%/packages/patches/metabat-fix-compilation.patch		\
  %D%/packages/patches/mhash-keygen-test-segfault.patch		\
  %D%/packages/patches/mingw-w64-6.0.0-gcc.patch		\
  %D%/packages/patches/mingw-w64-dlltool-temp-prefix.patch	\
  %D%/packages/patches/mingw-w64-reproducible-gendef.patch	\
  %D%/packages/patches/minimap2-aarch64-support.patch		\
  %D%/packages/patches/minisat-friend-declaration.patch		\
  %D%/packages/patches/minisat-install.patch			\
  %D%/packages/patches/mit-krb5-hurd.patch			\
  %D%/packages/patches/mit-krb5-qualify-short-hostnames.patch	\
  %D%/packages/patches/mpc123-initialize-ao.patch		\
  %D%/packages/patches/mpg321-CVE-2019-14247.patch		\
  %D%/packages/patches/module-init-tools-moduledir.patch	\
  %D%/packages/patches/monero-use-system-miniupnpc.patch			\
  %D%/packages/patches/mono-mdoc-timestamping.patch		\
  %D%/packages/patches/mozjs17-aarch64-support.patch		\
  %D%/packages/patches/mozjs24-aarch64-support.patch		\
  %D%/packages/patches/mozjs38-pkg-config-version.patch		\
  %D%/packages/patches/mozjs38-shell-version.patch		\
  %D%/packages/patches/mozjs38-tracelogger.patch		\
  %D%/packages/patches/mozjs38-version-detection.patch		\
  %D%/packages/patches/mrrescue-support-love-11.patch		\
  %D%/packages/patches/mtools-mformat-uninitialized.patch	\
  %D%/packages/patches/mumps-build-parallelism.patch		\
  %D%/packages/patches/mumps-shared-libseq.patch		\
  %D%/packages/patches/mumps-shared-mumps.patch			\
  %D%/packages/patches/mumps-shared-pord.patch			\
  %D%/packages/patches/mupdf-fix-linkage.patch			\
  %D%/packages/patches/mupdf-CVE-2021-3407.patch		\
  %D%/packages/patches/mupen64plus-ui-console-notice.patch	\
  %D%/packages/patches/mupen64plus-video-z64-glew-correct-path.patch    \
  %D%/packages/patches/musl-cross-locale.patch			\
  %D%/packages/patches/mutt-store-references.patch		\
  %D%/packages/patches/m4-gnulib-libio.patch			\
  %D%/packages/patches/ncompress-fix-softlinks.patch		\
  %D%/packages/patches/netcdf-date-time.patch			\
  %D%/packages/patches/netpbm-CVE-2017-2586.patch		\
  %D%/packages/patches/netpbm-CVE-2017-2587.patch		\
  %D%/packages/patches/netsurf-message-timestamp.patch		\
  %D%/packages/patches/netsurf-system-utf8proc.patch		\
  %D%/packages/patches/netsurf-y2038-tests.patch		\
  %D%/packages/patches/netsurf-longer-test-timeout.patch	\
  %D%/packages/patches/nfs4-acl-tools-0.3.7-fixpaths.patch	\
  %D%/packages/patches/ngircd-handle-zombies.patch		\
  %D%/packages/patches/network-manager-plugin-path.patch	\
  %D%/packages/patches/nginx-socket-cloexec.patch		\
  %D%/packages/patches/nsis-env-passthru.patch			\
  %D%/packages/patches/nss-increase-test-timeout.patch		\
  %D%/packages/patches/nss-3.56-pkgconfig.patch			\
  %D%/packages/patches/ntfs-3g-CVE-2019-9755.patch		\
  %D%/packages/patches/nvi-assume-preserve-path.patch		\
  %D%/packages/patches/nvi-dbpagesize-binpower.patch		\
  %D%/packages/patches/nvi-db4.patch				\
  %D%/packages/patches/nyacc-binary-literals.patch		\
  %D%/packages/patches/obs-modules-location.patch		\
  %D%/packages/patches/ocaml-bitstring-fix-configure.patch \
  %D%/packages/patches/ocaml-cairo2-caml_ba_array-fix.patch     \
  %D%/packages/patches/ocaml-CVE-2015-8869.patch		\
  %D%/packages/patches/ocaml-Add-a-.file-directive.patch	\
  %D%/packages/patches/ocaml-enable-ocamldoc-reproducibility.patch	\
  %D%/packages/patches/ocaml-dose3-add-unix-dependency.patch	\
  %D%/packages/patches/ocaml-dose3-Fix-for-ocaml-4.06.patch	\
  %D%/packages/patches/ocaml-dose3-dont-make-printconf.patch	\
  %D%/packages/patches/ocaml-dose3-Install-mli-cmx-etc.patch	\
  %D%/packages/patches/omake-fix-non-determinism.patch	\
  %D%/packages/patches/openbabel-fix-crash-on-nwchem-output.patch	\
  %D%/packages/patches/opencascade-oce-glibc-2.26.patch		\
  %D%/packages/patches/opencv-fix-build-of-grfmt_jpeg2000.cpp.patch	\
  %D%/packages/patches/opencv-rgbd-aarch64-test-fix.patch	\
  %D%/packages/patches/openfoam-4.1-cleanup.patch			\
  %D%/packages/patches/openjdk-10-idlj-reproducibility.patch	\
  %D%/packages/patches/openmpi-mtl-priorities.patch		\
  %D%/packages/patches/openssh-hurd.patch			\
  %D%/packages/patches/openresolv-restartcmd-guix.patch	\
  %D%/packages/patches/opensles-add-license-file.patch			\
  %D%/packages/patches/openssl-runpath.patch			\
  %D%/packages/patches/openssl-1.1-c-rehash-in.patch		\
  %D%/packages/patches/openssl-c-rehash-in.patch		\
  %D%/packages/patches/openssl-CVE-2019-1559.patch		\
  %D%/packages/patches/open-zwave-hidapi.patch			\
  %D%/packages/patches/orpheus-cast-errors-and-includes.patch	\
  %D%/packages/patches/osip-CVE-2017-7853.patch			\
  %D%/packages/patches/ots-no-include-missing-file.patch	\
  %D%/packages/patches/owncloud-disable-updatecheck.patch	\
  %D%/packages/patches/p7zip-CVE-2016-9296.patch		\
  %D%/packages/patches/p7zip-CVE-2017-17969.patch		\
  %D%/packages/patches/p7zip-remove-unused-code.patch		\
  %D%/packages/patches/pam-krb5-CVE-2020-10595.patch		\
  %D%/packages/patches/pango-skip-libthai-test.patch		\
  %D%/packages/patches/pciutils-hurd-configure.patch		\
  %D%/packages/patches/pciutils-hurd-fix.patch			\
  %D%/packages/patches/plasma-framework-fix-KF5PlasmaMacros.cmake.patch \
  %D%/packages/patches/ppsspp-disable-upgrade-and-gold.patch		\
  %D%/packages/patches/samba-fix-fcntl-hint-detection.patch		\
  %D%/packages/patches/sdcc-disable-non-free-code.patch		\
  %D%/packages/patches/sdl-pango-api_additions.patch		\
  %D%/packages/patches/sdl-pango-blit_overflow.patch		\
  %D%/packages/patches/sdl-pango-fillrect_crash.patch		\
  %D%/packages/patches/sdl-pango-header-guard.patch		\
  %D%/packages/patches/sdl-pango-matrix_declarations.patch	\
  %D%/packages/patches/sdl-pango-sans-serif.patch		\
  %D%/packages/patches/smalltalk-multiplication-overflow.patch	\
  %D%/packages/patches/sqlite-hurd.patch			\
  %D%/packages/patches/sunxi-tools-remove-sys-io.patch	\
  %D%/packages/patches/patchutils-test-perms.patch		\
  %D%/packages/patches/patch-hurd-path-max.patch		\
  %D%/packages/patches/perl-autosplit-default-time.patch	\
  %D%/packages/patches/perl-cross.patch				\
  %D%/packages/patches/perl-deterministic-ordering.patch	\
  %D%/packages/patches/perl-finance-quote-unuse-mozilla-ca.patch \
  %D%/packages/patches/perl-io-socket-ssl-openssl-1.0.2f-fix.patch \
  %D%/packages/patches/perl-net-amazon-s3-moose-warning.patch	\
  %D%/packages/patches/perl-net-dns-resolver-programmable-fix.patch	\
  %D%/packages/patches/perl-no-sys-dirs.patch			\
  %D%/packages/patches/perl-text-markdown-discount-unbundle.patch	\
  %D%/packages/patches/perl-module-pluggable-search.patch	\
  %D%/packages/patches/perl-reproducible-build-date.patch	\
  %D%/packages/patches/perl-www-curl-fix-struct-void.patch	\
  %D%/packages/patches/perl-www-curl-remove-symbol.patch	\
  %D%/packages/patches/picard-fix-id3-rename-test.patch		\
  %D%/packages/patches/picprog-non-intel-support.patch		\
  %D%/packages/patches/pidgin-add-search-path.patch		\
  %D%/packages/patches/pinball-const-fix.patch			\
  %D%/packages/patches/pinball-cstddef.patch			\
  %D%/packages/patches/pinball-missing-separators.patch		\
  %D%/packages/patches/pinball-src-deps.patch			\
  %D%/packages/patches/pinball-system-ltdl.patch		\
  %D%/packages/patches/pingus-boost-headers.patch		\
  %D%/packages/patches/pingus-sdl-libs-config.patch		\
  %D%/packages/patches/pixman-CVE-2016-5296.patch		\
  %D%/packages/patches/pjproject-correct-the-cflags-field.patch \
  %D%/packages/patches/pjproject-fix-pkg-config-ldflags.patch	\
  %D%/packages/patches/plink-1.07-unclobber-i.patch		\
  %D%/packages/patches/plink-endian-detection.patch		\
  %D%/packages/patches/plib-CVE-2011-4620.patch		\
  %D%/packages/patches/plib-CVE-2012-4552.patch		\
  %D%/packages/patches/plotutils-spline-test.patch		\
  %D%/packages/patches/portaudio-audacity-compat.patch		\
  %D%/packages/patches/portmidi-modular-build.patch		\
  %D%/packages/patches/postgresql-disable-resolve_symlinks.patch	\
  %D%/packages/patches/procmail-ambiguous-getline-debian.patch  \
  %D%/packages/patches/procmail-CVE-2014-3618.patch		\
  %D%/packages/patches/procmail-CVE-2017-16844.patch		\
  %D%/packages/patches/proot-test-fhs.patch			\
  %D%/packages/patches/psm-arch.patch				\
  %D%/packages/patches/psm-disable-memory-stats.patch		\
  %D%/packages/patches/psm-ldflags.patch			\
  %D%/packages/patches/psm-repro.patch				\
  %D%/packages/patches/pulseaudio-fix-mult-test.patch		\
  %D%/packages/patches/pulseaudio-longer-test-timeout.patch	\
  %D%/packages/patches/pulseview-qt515-compat.patch		\
  %D%/packages/patches/purescript-relax-dependencies.patch	\
  %D%/packages/patches/pybugz-encode-error.patch		\
  %D%/packages/patches/pybugz-stty.patch			\
  %D%/packages/patches/pygpgme-disable-problematic-tests.patch  \
  %D%/packages/patches/pyqt-configure.patch			\
  %D%/packages/patches/python-2-deterministic-build-info.patch	\
  %D%/packages/patches/python-2.7-adjust-tests.patch		\
  %D%/packages/patches/python-2.7-search-paths.patch		\
  %D%/packages/patches/python-2.7-site-prefixes.patch		\
  %D%/packages/patches/python-2.7-source-date-epoch.patch	\
  %D%/packages/patches/python-2.7-CVE-2021-3177.patch		\
  %D%/packages/patches/python-3-arm-alignment.patch		\
  %D%/packages/patches/python-3-deterministic-build-info.patch	\
  %D%/packages/patches/python-3-search-paths.patch		\
  %D%/packages/patches/python-3-fix-tests.patch			\
  %D%/packages/patches/python-3.8-fix-tests.patch		\
  %D%/packages/patches/python-3.8-CVE-2021-3177.patch		\
  %D%/packages/patches/python-3.9-fix-tests.patch		\
  %D%/packages/patches/python-CVE-2018-14647.patch		\
  %D%/packages/patches/python-CVE-2020-26116.patch		\
  %D%/packages/patches/python-aionotify-0.2.0-py3.8.patch	\
  %D%/packages/patches/python-argcomplete-1.11.1-fish31.patch	\
  %D%/packages/patches/python-axolotl-AES-fix.patch		\
  %D%/packages/patches/python-cross-compile.patch		\
  %D%/packages/patches/python2-larch-coverage-4.0a6-compatibility.patch \
  %D%/packages/patches/python-configobj-setuptools.patch	\
  %D%/packages/patches/python-flask-restful-werkzeug-compat.patch	\
  %D%/packages/patches/python-keras-integration-test.patch	\
  %D%/packages/patches/python-pep8-stdlib-tokenize-compat.patch \
  %D%/packages/patches/python-pyfakefs-remove-bad-test.patch	\
  %D%/packages/patches/python-flint-includes.patch		\
  %D%/packages/patches/python-libxml2-utf8.patch		\
  %D%/packages/patches/python-matplotlib-run-under-wayland-gtk3.patch	\
  %D%/packages/patches/python-mediafile-wavpack.patch		\
  %D%/packages/patches/python-memcached-syntax-warnings.patch	\
  %D%/packages/patches/python-mox3-python3.6-compat.patch	\
  %D%/packages/patches/python-testtools.patch			\
  %D%/packages/patches/python-onnx-use-system-googletest.patch	\
  %D%/packages/patches/python-packaging-test-arch.patch		\
  %D%/packages/patches/python2-parameterized-docstring-test.patch	\
  %D%/packages/patches/python-paste-remove-timing-test.patch	\
  %D%/packages/patches/python-pycrypto-CVE-2013-7459.patch	\
  %D%/packages/patches/python-pycrypto-time-clock.patch		\
  %D%/packages/patches/python-pydot-regression-test.patch	\
  %D%/packages/patches/python2-pygobject-2-deprecation.patch	\
  %D%/packages/patches/python-pygpgme-fix-pinentry-tests.patch	\
  %D%/packages/patches/python-robotframework-source-date-epoch.patch \
  %D%/packages/patches/python2-subprocess32-disable-input-test.patch	\
  %D%/packages/patches/python-unittest2-python3-compat.patch	\
  %D%/packages/patches/python-unittest2-remove-argparse.patch	\
  %D%/packages/patches/python-waitress-fix-tests.patch		\
  %D%/packages/patches/pypy3-7.3.1-fix-tests.patch		\
  %D%/packages/patches/qemu-build-info-manual.patch		\
  %D%/packages/patches/qemu-CVE-2021-20203.patch		\
  %D%/packages/patches/qemu-glibc-2.27.patch 			\
  %D%/packages/patches/qemu-glibc-2.30.patch 			\
  %D%/packages/patches/qpdfview-qt515-compat.patch		\
  %D%/packages/patches/qrcodegen-cpp-make-install.patch		\
  %D%/packages/patches/qt4-ldflags.patch			\
  %D%/packages/patches/qtbase-absolute-runpath.patch		\
  %D%/packages/patches/qtbase-moc-ignore-gcc-macro.patch	\
  %D%/packages/patches/qtbase-use-TZDIR.patch			\
  %D%/packages/patches/qtscript-disable-tests.patch		\
  %D%/packages/patches/quagga-reproducible-build.patch          \
  %D%/packages/patches/quassel-qt-514-compat.patch		\
  %D%/packages/patches/quickswitch-fix-dmenu-check.patch	\
  %D%/packages/patches/qtwebkit-pbutils-include.patch		\
  %D%/packages/patches/randomjungle-disable-static-build.patch	\
  %D%/packages/patches/rapicorn-isnan.patch			\
  %D%/packages/patches/rapidjson-gcc-compat.patch		\
  %D%/packages/patches/raptor2-heap-overflow.patch		\
  %D%/packages/patches/ratpoints-sturm_and_rp_private.patch	\
  %D%/packages/patches/ratpoison-shell.patch			\
  %D%/packages/patches/rcs-5.10.0-no-stdin.patch		\
  %D%/packages/patches/rct-add-missing-headers.patch		\
  %D%/packages/patches/readline-link-ncurses.patch		\
  %D%/packages/patches/readline-6.2-CVE-2014-2524.patch		\
  %D%/packages/patches/renpy-use-system-fribidi.patch		\
  %D%/packages/patches/reposurgeon-add-missing-docbook-files.patch	\
  %D%/packages/patches/r-httpuv-1.5.5-unvendor-libuv.patch	\
  %D%/packages/patches/ri-li-modernize_cpp.patch		\
  %D%/packages/patches/ripperx-missing-file.patch		\
  %D%/packages/patches/rpcbind-CVE-2017-8779.patch		\
  %D%/packages/patches/rtags-separate-rct.patch			\
  %D%/packages/patches/racket-sh-via-rktio.patch		\
  %D%/packages/patches/racket-store-checksum-override.patch	\
  %D%/packages/patches/remake-impure-dirs.patch			\
  %D%/packages/patches/retroarch-LIBRETRO_DIRECTORY.patch	\
  %D%/packages/patches/rnp-add-version.cmake.patch		\
  %D%/packages/patches/rnp-disable-ruby-rnp-tests.patch		\
  %D%/packages/patches/rnp-unbundle-googletest.patch		\
  %D%/packages/patches/ruby-sanitize-system-libxml.patch	\
  %D%/packages/patches/rust-1.19-mrustc.patch			\
  %D%/packages/patches/rust-1.25-accept-more-detailed-gdb-lines.patch \
  %D%/packages/patches/rust-1.45-linker-locale.patch		\
  %D%/packages/patches/rust-1.48-linker-locale.patch		\
  %D%/packages/patches/rust-bootstrap-stage0-test.patch		\
  %D%/packages/patches/rust-coresimd-doctest.patch		\
  %D%/packages/patches/rust-ndarray-remove-blas-src-dep.patch	\
  %D%/packages/patches/rust-nettle-disable-vendor.patch		 \
  %D%/packages/patches/rust-nettle-sys-disable-vendor.patch	 \
  %D%/packages/patches/rust-reproducible-builds.patch		 \
  %D%/packages/patches/rust-openssl-sys-no-vendor.patch	\
  %D%/packages/patches/rxvt-unicode-escape-sequences.patch	\
  %D%/packages/patches/sbc-fix-build-non-x86.patch		\
  %D%/packages/patches/sbcl-clml-fix-types.patch		\
  %D%/packages/patches/scalapack-blacs-mpi-deprecations.patch	\
  %D%/packages/patches/scheme48-tests.patch			\
  %D%/packages/patches/scotch-build-parallelism.patch		\
  %D%/packages/patches/scotch-integer-declarations.patch	\
  %D%/packages/patches/screen-CVE-2021-26937.patch		\
  %D%/packages/patches/screen-hurd-path-max.patch		\
  %D%/packages/patches/sdl-libx11-1.6.patch			\
  %D%/packages/patches/seed-webkit.patch			\
  %D%/packages/patches/seq24-rename-mutex.patch			\
  %D%/packages/patches/serf-python3.patch			\
  %D%/packages/patches/shakespeare-spl-fix-grammar.patch		\
  %D%/packages/patches/sharutils-CVE-2018-1000097.patch		\
  %D%/packages/patches/shadow-hurd-pctrl.patch			\
  %D%/packages/patches/shishi-fix-libgcrypt-detection.patch	\
  %D%/packages/patches/slim-session.patch			\
  %D%/packages/patches/slim-config.patch			\
  %D%/packages/patches/slim-sigusr1.patch			\
  %D%/packages/patches/slim-reset.patch				\
  %D%/packages/patches/slim-login.patch				\
  %D%/packages/patches/slim-display.patch			\
  %D%/packages/patches/snappy-add-O2-flag-in-CmakeLists.txt.patch	\
  %D%/packages/patches/sphinxbase-fix-doxygen.patch		\
  %D%/packages/patches/sssd-fix-samba.patch			\
  %D%/packages/patches/sssd-system-directories.patch		\
  %D%/packages/patches/steghide-fixes.patch			\
  %D%/packages/patches/suitesparse-mongoose-cmake.patch		\
  %D%/packages/patches/superlu-dist-awpm-grid.patch		\
  %D%/packages/patches/superlu-dist-scotchmetis.patch		\
  %D%/packages/patches/supertux-unbundle-squirrel.patch		\
  %D%/packages/patches/swish-e-search.patch			\
  %D%/packages/patches/swish-e-format-security.patch		\
  %D%/packages/patches/symmetrica-bruch.patch			\
  %D%/packages/patches/symmetrica-int32.patch			\
  %D%/packages/patches/symmetrica-return_values.patch 		\
  %D%/packages/patches/symmetrica-sort_sum_rename.patch 	\
  %D%/packages/patches/t1lib-CVE-2010-2642.patch		\
  %D%/packages/patches/t1lib-CVE-2011-0764.patch		\
  %D%/packages/patches/t1lib-CVE-2011-1552+.patch		\
  %D%/packages/patches/t4k-common-libpng16.patch		\
  %D%/packages/patches/tao-add-missing-headers.patch		\
  %D%/packages/patches/tao-fix-parser-types.patch		\
  %D%/packages/patches/tar-remove-wholesparse-check.patch	\
  %D%/packages/patches/tar-skip-unreliable-tests.patch		\
  %D%/packages/patches/tcc-boot-0.9.27.patch			\
  %D%/packages/patches/tclxml-3.2-install.patch			\
  %D%/packages/patches/tcl-fix-cross-compilation.patch		\
  %D%/packages/patches/tcsh-fix-autotest.patch			\
  %D%/packages/patches/teensy-loader-cli-help.patch		\
  %D%/packages/patches/texinfo-5-perl-compat.patch		\
  %D%/packages/patches/texlive-bin-poppler-0.83.patch		\
  %D%/packages/patches/texlive-bin-poppler-0.86.patch		\
  %D%/packages/patches/telegram-purple-adjust-test.patch	\
  %D%/packages/patches/telepathy-glib-channel-memory-leak.patch	\
  %D%/packages/patches/texi2html-document-encoding.patch	\
  %D%/packages/patches/texi2html-i18n.patch			\
  %D%/packages/patches/thefuck-test-environ.patch		\
  %D%/packages/patches/tidy-CVE-2015-5522+5523.patch		\
  %D%/packages/patches/tinyxml-use-stl.patch			\
  %D%/packages/patches/tipp10-disable-downloader.patch		\
  %D%/packages/patches/tipp10-fix-compiling.patch		\
  %D%/packages/patches/tipp10-remove-license-code.patch		\
  %D%/packages/patches/tipp10-qt5.patch			\
  %D%/packages/patches/tk-find-library.patch			\
  %D%/packages/patches/transcode-ffmpeg.patch	\
  %D%/packages/patches/transmission-honor-localedir.patch	\
  %D%/packages/patches/ttf2eot-cstddef.patch			\
  %D%/packages/patches/tup-unbundle-dependencies.patch		\
  %D%/packages/patches/tuxpaint-stamps-path.patch		\
  %D%/packages/patches/twinkle-bcg729.patch			\
  %D%/packages/patches/u-boot-riscv64-fix-extlinux.patch	\
  %D%/packages/patches/ucx-tcp-iface-ioctl.patch		\
  %D%/packages/patches/udiskie-no-appindicator.patch		\
  %D%/packages/patches/ungoogled-chromium-extension-search-path.patch	\
  %D%/packages/patches/ungoogled-chromium-system-nspr.patch	\
  %D%/packages/patches/ungoogled-chromium-system-opus.patch	\
  %D%/packages/patches/unison-fix-ocaml-4.08.patch		\
  %D%/packages/patches/unknown-horizons-python-3.8-distro.patch	\
  %D%/packages/patches/unzip-CVE-2014-8139.patch		\
  %D%/packages/patches/unzip-CVE-2014-8140.patch		\
  %D%/packages/patches/unzip-CVE-2014-8141.patch		\
  %D%/packages/patches/unzip-CVE-2014-9636.patch		\
  %D%/packages/patches/unzip-CVE-2015-7696.patch		\
  %D%/packages/patches/unzip-CVE-2015-7697.patch		\
  %D%/packages/patches/unzip-allow-greater-hostver-values.patch	\
  %D%/packages/patches/unzip-attribs-overflow.patch		\
  %D%/packages/patches/unzip-overflow-on-invalid-input.patch	\
  %D%/packages/patches/unzip-format-secure.patch		\
  %D%/packages/patches/unzip-initialize-symlink-flag.patch	\
  %D%/packages/patches/unzip-overflow-long-fsize.patch		\
  %D%/packages/patches/unzip-remove-build-date.patch		\
  %D%/packages/patches/unzip-case-insensitive.patch		\
  %D%/packages/patches/unzip-COVSCAN-fix-unterminated-string.patch	\
  %D%/packages/patches/unzip-CVE-2016-9844.patch		\
  %D%/packages/patches/unzip-CVE-2018-1000035.patch		\
  %D%/packages/patches/unzip-CVE-2018-18384.patch		\
  %D%/packages/patches/unzip-alt-iconv-utf8-print.patch	\
  %D%/packages/patches/unzip-alt-iconv-utf8.patch		\
  %D%/packages/patches/unzip-close.patch			\
  %D%/packages/patches/unzip-exec-shield.patch			\
  %D%/packages/patches/unzip-fix-recmatch.patch		\
  %D%/packages/patches/unzip-manpage-fix.patch			\
  %D%/packages/patches/unzip-overflow.patch			\
  %D%/packages/patches/unzip-timestamp.patch			\
  %D%/packages/patches/unzip-valgrind.patch			\
  %D%/packages/patches/unzip-x-option.patch			\
  %D%/packages/patches/unzip-zipbomb-manpage.patch		\
  %D%/packages/patches/unzip-zipbomb-part1.patch		\
  %D%/packages/patches/unzip-zipbomb-part2.patch		\
  %D%/packages/patches/unzip-zipbomb-part3.patch		\
  %D%/packages/patches/unzip-32bit-zipbomb-fix.patch    \
  %D%/packages/patches/upx-CVE-2021-20285.patch		\
  %D%/packages/patches/ustr-fix-build-with-gcc-5.patch		\
  %D%/packages/patches/util-linux-tests.patch			\
  %D%/packages/patches/upower-builddir.patch			\
  %D%/packages/patches/valgrind-enable-arm.patch		\
  %D%/packages/patches/vboot-utils-fix-format-load-address.patch	\
  %D%/packages/patches/vboot-utils-fix-tests-show-contents.patch	\
  %D%/packages/patches/vboot-utils-skip-test-workbuf.patch	\
  %D%/packages/patches/vigra-python-compat.patch		\
  %D%/packages/patches/vinagre-newer-freerdp.patch             \
  %D%/packages/patches/vinagre-newer-rdp-parameters.patch      \
  %D%/packages/patches/virglrenderer-CVE-2017-6386.patch 	\
  %D%/packages/patches/vsearch-unbundle-cityhash.patch		\
  %D%/packages/patches/vte-CVE-2012-2738-pt1.patch			\
  %D%/packages/patches/vte-CVE-2012-2738-pt2.patch			\
  %D%/packages/patches/vtk-fix-freetypetools-build-failure.patch	\
  %D%/packages/patches/warsow-qfusion-fix-bool-return-type.patch	\
  %D%/packages/patches/webkitgtk-share-store.patch		\
  %D%/packages/patches/webkitgtk-bind-all-fonts.patch		\
  %D%/packages/patches/websocketpp-fix-for-cmake-3.15.patch	\
  %D%/packages/patches/wgetpaste-update-bpaste.patch		\
  %D%/packages/patches/wicd-bitrate-none-fix.patch		\
  %D%/packages/patches/wicd-get-selected-profile-fix.patch	\
  %D%/packages/patches/wicd-urwid-1.3.patch			\
  %D%/packages/patches/wicd-wpa2-ttls.patch			\
  %D%/packages/patches/widelands-system-wide_minizip.patch	\
  %D%/packages/patches/wmctrl-64-fix.patch			\
  %D%/packages/patches/wmfire-update-for-new-gdk-versions.patch	\
  %D%/packages/patches/wordnet-CVE-2008-2149.patch			\
  %D%/packages/patches/wordnet-CVE-2008-3908-pt1.patch			\
  %D%/packages/patches/wordnet-CVE-2008-3908-pt2.patch			\
  %D%/packages/patches/wpa-supplicant-CVE-2021-27803.patch	\
  %D%/packages/patches/wpa-supplicant-CVE-2021-30004.patch	\
  %D%/packages/patches/x265-arm-flags.patch			\
  %D%/packages/patches/xf86-video-ark-remove-mibstore.patch	\
  %D%/packages/patches/xf86-video-mach64-glibc-2.20.patch	\
  %D%/packages/patches/xf86-video-savage-xorg-compat.patch 	\
  %D%/packages/patches/xf86-video-siliconmotion-fix-ftbfs.patch \
  %D%/packages/patches/xf86-video-tga-remove-mibstore.patch	\
  %D%/packages/patches/xf86-video-voodoo-pcitag.patch		\
  %D%/packages/patches/xfce4-panel-plugins.patch		\
  %D%/packages/patches/xfce4-settings-defaults.patch		\
  %D%/packages/patches/xmonad-dynamic-linking.patch		\
  %D%/packages/patches/xplanet-1.3.1-cxx11-eof.patch		\
  %D%/packages/patches/xplanet-1.3.1-libdisplay_DisplayOutput.cpp.patch	\
  %D%/packages/patches/xplanet-1.3.1-libimage_gif.c.patch	\
  %D%/packages/patches/xplanet-1.3.1-xpUtil-Add2017LeapSecond.cpp.patch	\
  %D%/packages/patches/xpra-4.0.1-systemd-run.patch	\
  %D%/packages/patches/xsane-fix-memory-leak.patch		\
  %D%/packages/patches/xsane-fix-pdf-floats.patch		\
  %D%/packages/patches/xsane-fix-snprintf-buffer-length.patch	\
  %D%/packages/patches/xsane-support-ipv6.patch			\
  %D%/packages/patches/xsane-tighten-default-umask.patch	\
  %D%/packages/patches/yggdrasil-extra-config.patch	\
  %D%/packages/patches/ytnef-CVE-2021-3403.patch	\
  %D%/packages/patches/ytnef-CVE-2021-3404.patch	\
  %D%/packages/patches/zstd-CVE-2021-24031_CVE-2021-24032.patch	\
  %D%/packages/patches/zziplib-CVE-2018-16548.patch

MISC_DISTRO_FILES =				\
  %D%/packages/ld-wrapper.in
