/** @file cmdline1.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.2
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE1_H
#define CMDLINE1_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "sample1"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "sample1"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "2.0"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * str_opt_arg;	/**< @brief A string option, for a filename.  */
  char * str_opt_orig;	/**< @brief A string option, for a filename original value given at command line.  */
  const char *str_opt_help; /**< @brief A string option, for a filename help description.  */
  int my_opt_arg;	/**< @brief Another integer option, this time the description of the option should be \"quite\" long to require wrapping... possibly more than one wrapping :-) especially if I\nrequire a line break.  */
  char * my_opt_orig;	/**< @brief Another integer option, this time the description of the option should be \"quite\" long to require wrapping... possibly more than one wrapping :-) especially if I\nrequire a line break original value given at command line.  */
  const char *my_opt_help; /**< @brief Another integer option, this time the description of the option should be \"quite\" long to require wrapping... possibly more than one wrapping :-) especially if I\nrequire a line break help description.  */
  int int_opt_arg;	/**< @brief A int option.  */
  char * int_opt_orig;	/**< @brief A int option original value given at command line.  */
  const char *int_opt_help; /**< @brief A int option help description.  */
  int flag_opt_flag;	/**< @brief A flag option (default=off).  */
  const char *flag_opt_help; /**< @brief A flag option help description.  */
  const char *funct_opt_help; /**< @brief A function option help description.  */
  long long_opt_arg;	/**< @brief A long option.  */
  char * long_opt_orig;	/**< @brief A long option original value given at command line.  */
  const char *long_opt_help; /**< @brief A long option help description.  */
  char * def_opt_arg;	/**< @brief A string option with default (default='Hello').  */
  char * def_opt_orig;	/**< @brief A string option with default original value given at command line.  */
  const char *def_opt_help; /**< @brief A string option with default help description.  */
  char * enum_opt_arg;	/**< @brief A string option with list of values (default='hello').  */
  char * enum_opt_orig;	/**< @brief A string option with list of values original value given at command line.  */
  const char *enum_opt_help; /**< @brief A string option with list of values help description.  */
  int secret_arg;	/**< @brief hidden option will not appear in --help.  */
  char * secret_orig;	/**< @brief hidden option will not appear in --help original value given at command line.  */
  const char *secret_help; /**< @brief hidden option will not appear in --help help description.  */
  int dependant_arg;	/**< @brief option that depends on str-opt.  */
  char * dependant_orig;	/**< @brief option that depends on str-opt original value given at command line.  */
  const char *dependant_help; /**< @brief option that depends on str-opt help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int str_opt_given ;	/**< @brief Whether str-opt was given.  */
  unsigned int my_opt_given ;	/**< @brief Whether my-opt was given.  */
  unsigned int int_opt_given ;	/**< @brief Whether int-opt was given.  */
  unsigned int flag_opt_given ;	/**< @brief Whether flag-opt was given.  */
  unsigned int funct_opt_given ;	/**< @brief Whether funct-opt was given.  */
  unsigned int long_opt_given ;	/**< @brief Whether long-opt was given.  */
  unsigned int def_opt_given ;	/**< @brief Whether def-opt was given.  */
  unsigned int enum_opt_given ;	/**< @brief Whether enum-opt was given.  */
  unsigned int secret_given ;	/**< @brief Whether secret was given.  */
  unsigned int dependant_given ;	/**< @brief Whether dependant was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *gengetopt_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_enum_opt_values[];  /**< @brief Possible values for enum-opt. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE1_H */
