(defpackage "GDI"
  (:export
   POINT POINT-FLOAT RECT *white* *black* pixarray-1-element-type 
   pixarray-4-element-type pixarray-8-element-type pixarray-16-element-type
   pixarray-24-element-type pixarray-32-element-type
   make-point make-point-float make-logfont make-textmetric make-iconinfo
   make-createstruct make-wndclass add-callbacks *current-event*
   bitmap-image
   SM_CXSCREEN SM_CYSCREEN SM_CXVSCROLL SM_CYHSCROLL SM_CYCAPTION
   SM_CXBORDER SM_CYBORDER SM_CXDLGFRAME SM_CXFIXEDFRAME SM_CYDLGFRAME
   SM_CYFIXEDFRAME SM_CYVTHUMB SM_CXHTHUMB SM_CXICON SM_CYICON SM_CXCURSOR
   SM_CYCURSOR SM_CYMENU SM_CXFULLSCREEN SM_CYFULLSCREEN SM_CYKANJIWINDOW
   SM_MOUSEPRESENT SM_CYVSCROLL SM_CXHSCROLL SM_DEBUG SM_SWAPBUTTON
   SM_RESERVED1 SM_RESERVED2 SM_RESERVED3 SM_RESERVED4 SM_CXMIN SM_CYMIN
   SM_CXSIZE SM_CYSIZE SM_CXSIZEFRAME SM_CXFRAME SM_CYSIZEFRAME SM_CYFRAME
   SM_CXMINTRACK SM_CYMINTRACK SM_CXDOUBLECLK SM_CYDOUBLECLK SM_CXICONSPACING
   SM_CYICONSPACING SM_MENUDROPALIGNMENT SM_PENWINDOWS SM_DBCSENABLED
   SM_CMOUSEBUTTONS SM_SECURE SM_CXEDGE SM_CYEDGE SM_CXMINSPACING
   SM_CYMINSPACING SM_CXSMICON SM_CYSMICON SM_CYSMCAPTION SM_CXSMSIZE
   SM_CYSMSIZE SM_CXMENUSIZE SM_CYMENUSIZE SM_ARRANGE SM_CXMINIMIZED
   SM_CYMINIMIZED SM_CXMAXTRACK SM_CYMAXTRACK SM_CXMAXIMIZED SM_CYMAXIMIZED
   SM_NETWORK SM_CLEANBOOT SM_CXDRAG SM_CYDRAG SM_SHOWSOUNDS SM_CXMENUCHECK
   SM_CYMENUCHECK SM_SLOWMACHINE SM_MIDEASTENABLED SM_MOUSEWHEELPRESENT
   SM_XVIRTUALSCREEN SM_YVIRTUALSCREEN SM_CXVIRTUALSCREEN SM_CYVIRTUALSCREEN
   SM_CMONITORS SM_SAMEDISPLAYFORMAT SM_CMETRICS
   BI_RGB BI_RLE8 BI_RLE4 BI_BITFIELDS LF_FACESIZE LF_FULLFACESIZE
   CA_NEGATIVE CA_LOG_FILTER ILLUMINANT_DEVICE_DEFAULT ILLUMINANT_A
   ILLUMINANT_B ILLUMINANT_C ILLUMINANT_D50 ILLUMINANT_D55 ILLUMINANT_D65
   ILLUMINANT_D75 ILLUMINANT_F2 ILLUMINANT_MAX_INDEX ILLUMINANT_FLUORESCENT
   RGB_GAMMA_MIN RGB_GAMMA_MAX REFERENCE_WHITE_MIN REFERENCE_WHITE_MAX
   REFERENCE_BLACK_MIN REFERENCE_BLACK_MAX COLOR_ADJ_MAX CCHDEVICENAME
   CCHFORMNAME DI_COMPAT DI_DEFAULTSIZE DI_IMAGE DI_MASK DI_NORMAL
   DI_APPBANDING EMR_HEADER EMR_POLYBEZIER EMR_POLYGON EMR_POLYLINE
   EMR_POLYBEZIERTO EMR_POLYLINETO EMR_POLYPOLYLINE EMR_POLYPOLYGON
   EMR_SETWINDOWEXTEX EMR_SETWINDOWORGEX EMR_SETVIEWPORTEXTEX
   EMR_SETVIEWPORTORGEX EMR_SETBRUSHORGEX EMR_EOF EMR_SETPIXELV
   EMR_SETMAPPERFLAGS EMR_SETMAPMODE EMR_SETBKMODE EMR_SETPOLYFILLMODE
   EMR_SETROP2 EMR_SETSTRETCHBLTMODE EMR_SETTEXTALIGN EMR_SETCOLORADJUSTMENT
   EMR_SETTEXTCOLOR EMR_SETBKCOLOR EMR_OFFSETCLIPRGN EMR_MOVETOEX
   EMR_SETMETARGN EMR_EXCLUDECLIPRECT EMR_INTERSECTCLIPRECT
   EMR_SCALEVIEWPORTEXTEX EMR_SCALEWINDOWEXTEX EMR_SAVEDC EMR_RESTOREDC
   EMR_SETWORLDTRANSFORM EMR_MODIFYWORLDTRANSFORM EMR_SELECTOBJECT
   EMR_CREATEPEN EMR_CREATEBRUSHINDIRECT EMR_DELETEOBJECT EMR_ANGLEARC
   EMR_ELLIPSE EMR_RECTANGLE EMR_ROUNDRECT EMR_ARC EMR_CHORD EMR_PIE
   EMR_SELECTPALETTE EMR_CREATEPALETTE EMR_SETPALETTEENTRIES
   EMR_RESIZEPALETTE EMR_REALIZEPALETTE EMR_EXTFLOODFILL EMR_LINETO EMR_ARCTO
   EMR_POLYDRAW EMR_SETARCDIRECTION EMR_SETMITERLIMIT EMR_BEGINPATH
   EMR_ENDPATH EMR_CLOSEFIGURE EMR_FILLPATH EMR_STROKEANDFILLPATH
   EMR_STROKEPATH EMR_FLATTENPATH EMR_WIDENPATH EMR_SELECTCLIPPATH
   EMR_ABORTPATH EMR_GDICOMMENT EMR_FILLRGN EMR_FRAMERGN EMR_INVERTRGN
   EMR_PAINTRGN EMR_EXTSELECTCLIPRGN EMR_BITBLT EMR_STRETCHBLT EMR_MASKBLT
   EMR_PLGBLT EMR_SETDIBITSTODEVICE EMR_STRETCHDIBITS EMR_EXTCREATEFONTINDIRECTW
   EMR_EXTTEXTOUTA EMR_EXTTEXTOUTW EMR_POLYBEZIER16 EMR_POLYGON16 EMR_POLYLINE16
   EMR_POLYBEZIERTO16 EMR_POLYLINETO16 EMR_POLYPOLYLINE16 EMR_POLYPOLYGON16
   EMR_POLYDRAW16 EMR_CREATEMONOBRUSH EMR_CREATEDIBPATTERNBRUSHPT
   EMR_EXTCREATEPEN EMR_POLYTEXTOUTA EMR_POLYTEXTOUTW EMR_SETICMMODE
   EMR_CREATECOLORSPACE EMR_SETCOLORSPACE EMR_DELETECOLORSPACE EMR_GLSRECORD
   EMR_GLSBOUNDEDRECORD EMR_PIXELFORMAT ENHMETA_SIGNATURE EPS_SIGNATURE
   META_SETBKCOLOR META_SETBKMODE META_SETMAPMODE META_SETROP2 META_SETRELABS
   META_SETPOLYFILLMODE META_SETSTRETCHBLTMODE META_SETTEXTCHAREXTRA
   META_SETTEXTCOLOR META_SCALEWINDOWEXT META_OFFSETVIEWPORTORG
   META_SCALEVIEWPORTEXT META_LINETO META_MOVETO META_EXCLUDECLIPRECT
   META_INTERSECTCLIPRECT META_ARC META_ELLIPSE META_FLOODFILL
   META_OFFSETCLIPRGN META_TEXTOUT META_BITBLT META_STRETCHBLT META_POLYGON
   META_POLYLINE META_ESCAPE META_RESTOREDC META_FILLREGION META_FRAMEREGION
   META_CHORD META_SETMAPPERFLAGS META_EXTTEXTOUT META_SETDIBTODEV
   META_SELECTPALETTE META_REALIZEPALETTE META_ANIMATEPALETTE META_SETPALENTRIES
   META_POLYPOLYGON META_RESIZEPALETTE META_DIBBITBLT META_DIBSTRETCHBLT
   META_DIBCREATEPATTERNBRUSH META_STRETCHDIB META_EXTFLOODFILL
   META_DELETEOBJECT META_CREATEPALETTE META_CREATEPATTERNBRUSH
   PT_MOVETO PT_LINETO PT_BEZIERTO PT_CLOSEFIGURE ELF_VENDOR_SIZE
   ELF_VERSION ELF_CULTURE_LATIN PFD_TYPE_RGBA PFD_TYPE_COLORINDEX
   PFD_MAIN_PLANE PFD_OVERLAY_PLANE PFD_DOUBLEBUFFER PFD_STEREO
   PFD_DRAW_TO_WINDOW PFD_DRAW_TO_BITMAP PFD_SUPPORT_GDI PFD_SUPPORT_OPENGL
   PFD_GENERIC_FORMAT PFD_NEED_PALETTE PFD_NEED_SYSTEM_PALETTE PFD_SWAP_EXCHANGE
   PFD_SWAP_COPY PFD_DOUBLEBUFFER_DONTCARE PFD_STEREO_DONTCARE
   BLACKNESS NOTSRCERASE NOTSRCCOPY SRCERASE DSTINVERT PATINVERT SRCINVERT
   SRCAND MERGEPAINT SRCCOPY SRCPAINT PATCOPY PATPAINT WHITENESS R2_BLACK
   R2_COPYPEN R2_MASKNOTPEN R2_MASKPEN R2_MASKPENNOT R2_MERGENOTPEN
   R2_MERGEPEN R2_MERGEPENNOT R2_NOP R2_NOT R2_NOTCOPYPEN R2_NOTMASKPEN
   R2_NOTMERGEPEN R2_NOTXORPEN R2_WHITE R2_XORPEN CM_OUT_OF_GAMUT
   CM_IN_GAMUT RGN_AND RGN_COPY RGN_DIFF RGN_OR RGN_XOR NULLREGION SIMPLEREGION
   COMPLEXREGION ERROR CBM_INIT DIB_PAL_COLORS DIB_RGB_COLORS FW_DONTCARE
   FW_THIN FW_EXTRALIGHT FW_LIGHT FW_NORMAL FW_REGULAR FW_MEDIUM FW_SEMIBOLD
   FW_BOLD FW_EXTRABOLD FW_HEAVY ANSI_CHARSET DEFAULT_CHARSET SYMBOL_CHARSET
   SHIFTJIS_CHARSET HANGEUL_CHARSET HANGUL_CHARSET GB2312_CHARSET
   CHINESEBIG5_CHARSET GREEK_CHARSET TURKISH_CHARSET HEBREW_CHARSET
   ARABIC_CHARSET BALTIC_CHARSET RUSSIAN_CHARSET THAI_CHARSET EASTEUROPE_CHARSET
   OEM_CHARSET JOHAB_CHARSET VIETNAMESE_CHARSET MAC_CHARSET BALTIC_CHARSET
   JOHAB_CHARSET VIETNAMESE_CHARSET OUT_DEFAULT_PRECIS OUT_STRING_PRECIS
   OUT_CHARACTER_PRECIS OUT_STROKE_PRECIS OUT_TT_PRECIS OUT_DEVICE_PRECIS
   OUT_RASTER_PRECIS OUT_TT_ONLY_PRECIS OUT_OUTLINE_PRECIS CLIP_DEFAULT_PRECIS
   CLIP_CHARACTER_PRECIS CLIP_STROKE_PRECIS CLIP_MASK CLIP_LH_ANGLES
   CLIP_TT_ALWAYS CLIP_EMBEDDED DEFAULT_QUALITY DRAFT_QUALITY PROOF_QUALITY
   NONANTIALIASED_QUALITY ANTIALIASED_QUALITY DEFAULT_PITCH FIXED_PITCH
   VARIABLE_PITCH MONO_FONT FF_DECORATIVE FF_DONTCARE FF_MODERN FF_ROMAN
   FF_SCRIPT FF_SWISS PANOSE_COUNT PAN_FAMILYTYPE_INDEX PAN_SERIFSTYLE_INDEX
   PAN_WEIGHT_INDEX PAN_PROPORTION_INDEX PAN_CONTRAST_INDEX
   PAN_STROKEVARIATION_INDEX PAN_ARMSTYLE_INDEX PAN_LETTERFORM_INDEX
   PAN_MIDLINE_INDEX PAN_XHEIGHT_INDEX PAN_CULTURE_LATIN PAN_ANY PAN_NO_FIT
   PAN_FAMILY_TEXT_DISPLAY PAN_FAMILY_SCRIPT PAN_FAMILY_DECORATIVE
   PAN_FAMILY_PICTORIAL PAN_SERIF_COVE PAN_SERIF_OBTUSE_COVE
   PAN_SERIF_SQUARE_COVE PAN_SERIF_OBTUSE_SQUARE_COVE PAN_SERIF_SQUARE
   PAN_SERIF_THIN PAN_SERIF_BONE PAN_SERIF_EXAGGERATED PAN_SERIF_TRIANGLE
   PAN_SERIF_NORMAL_SANS PAN_SERIF_OBTUSE_SANS PAN_SERIF_PERP_SANS
   PAN_SERIF_FLARED PAN_SERIF_ROUNDED PAN_WEIGHT_VERY_LIGHT PAN_WEIGHT_LIGHT
   PAN_WEIGHT_THIN PAN_WEIGHT_BOOK PAN_WEIGHT_MEDIUM PAN_WEIGHT_DEMI
   PAN_WEIGHT_BOLD PAN_WEIGHT_HEAVY PAN_WEIGHT_BLACK PAN_WEIGHT_NORD
   PAN_PROP_OLD_STYLE PAN_PROP_MODERN PAN_PROP_EVEN_WIDTH
   PAN_PROP_EXPANDED PAN_PROP_CONDENSED PAN_PROP_VERY_EXPANDED
   PAN_PROP_VERY_CONDENSED PAN_PROP_MONOSPACED PAN_CONTRAST_NONE
   PAN_CONTRAST_VERY_LOW PAN_CONTRAST_LOW PAN_CONTRAST_MEDIUM_LOW
   PAN_CONTRAST_MEDIUM PAN_CONTRAST_MEDIUM_HIGH PAN_CONTRAST_HIGH
   PAN_CONTRAST_VERY_HIGH PAN_STROKE_GRADUAL_DIAG PAN_STROKE_GRADUAL_TRAN
   PAN_STROKE_GRADUAL_VERT PAN_STROKE_GRADUAL_HORZ PAN_STROKE_RAPID_VERT
   PAN_STROKE_RAPID_HORZ PAN_STROKE_INSTANT_VERT PAN_STRAIGHT_ARMS_HORZ
   PAN_STRAIGHT_ARMS_WEDGE PAN_STRAIGHT_ARMS_VERT PAN_STRAIGHT_ARMS_SINGLE_SERIF
   PAN_STRAIGHT_ARMS_DOUBLE_SERIF PAN_BENT_ARMS_HORZ PAN_BENT_ARMS_WEDGE
   PAN_BENT_ARMS_VERT PAN_BENT_ARMS_SINGLE_SERIF PAN_BENT_ARMS_DOUBLE_SERIF
   PAN_LETT_NORMAL_CONTACT PAN_LETT_NORMAL_WEIGHTED PAN_LETT_NORMAL_BOXED
   PAN_LETT_NORMAL_FLATTENED PAN_LETT_NORMAL_ROUNDED PAN_LETT_NORMAL_OFF_CENTER
   PAN_LETT_NORMAL_SQUARE PAN_LETT_OBLIQUE_CONTACT PAN_LETT_OBLIQUE_WEIGHTED
   PAN_LETT_OBLIQUE_BOXED PAN_LETT_OBLIQUE_FLATTENED PAN_LETT_OBLIQUE_ROUNDED
   PAN_LETT_OBLIQUE_OFF_CENTER PAN_LETT_OBLIQUE_SQUARE
   PAN_MIDLINE_STANDARD_TRIMMED PAN_MIDLINE_STANDARD_POINTED
   PAN_MIDLINE_STANDARD_SERIFED PAN_MIDLINE_HIGH_TRIMMED
   PAN_MIDLINE_HIGH_POINTED PAN_MIDLINE_HIGH_SERIFED
   PAN_MIDLINE_CONSTANT_TRIMMED PAN_MIDLINE_CONSTANT_POINTED
   PAN_MIDLINE_CONSTANT_SERIFED PAN_MIDLINE_LOW_TRIMMED PAN_MIDLINE_LOW_POINTED
   PAN_MIDLINE_LOW_SERIFED PAN_XHEIGHT_CONSTANT_SMALL PAN_XHEIGHT_CONSTANT_STD
   PAN_XHEIGHT_CONSTANT_LARGE PAN_XHEIGHT_DUCKING_SMALL PAN_XHEIGHT_DUCKING_STD
   PAN_XHEIGHT_DUCKING_LARGE FS_LATIN1 FS_LATIN2 FS_CYRILLIC FS_GREEK FS_TURKISH
   FS_HEBREW FS_ARABIC FS_BALTIC FS_THAI FS_JISJAPAN FS_CHINESESIMP FS_WANSUNG
   FS_CHINESETRAD FS_JOHAB FS_SYMBOL HS_BDIAGONAL HS_CROSS HS_DIAGCROSS
   HS_FDIAGONAL HS_HORIZONTAL HS_VERTICAL PS_GEOMETRIC PS_COSMETIC
   PS_ALTERNATE PS_SOLID PS_DASH PS_DOT PS_DASHDOT PS_DASHDOTDOT
   PS_NULL PS_USERSTYLE PS_INSIDEFRAME PS_ENDCAP_ROUND PS_ENDCAP_SQUARE
   PS_ENDCAP_FLAT PS_JOIN_BEVEL PS_JOIN_MITER PS_JOIN_ROUND PS_STYLE_MASK
   PS_ENDCAP_MASK PS_TYPE_MASK ALTERNATE WINDING DC_BINNAMES DC_BINS
   DC_COPIES DC_DRIVER DC_DATATYPE_PRODUCED DC_DUPLEX DC_EMF_COMPLIANT
   DC_ENUMRESOLUTIONS DC_EXTRA DC_FIELDS DC_FILEDEPENDENCIES DC_MAXEXTENT
   DC_MINEXTENT DC_ORIENTATION DC_PAPERNAMES DC_PAPERS DC_PAPERSIZE
   DC_SIZE DC_TRUETYPE DCTT_BITMAP DCTT_DOWNLOAD DCTT_SUBDEV
   DCTT_DOWNLOAD_OUTLINE DC_VERSION DC_BINADJUST DC_EMF_COMPLIANT
   DC_DATATYPE_PRODUCED DC_MANUFACTURER DC_MODEL DCBA_FACEUPNONE
   DCBA_FACEUPCENTER DCBA_FACEUPLEFT DCBA_FACEUPRIGHT DCBA_FACEDOWNNONE
   DCBA_FACEDOWNCENTER DCBA_FACEDOWNLEFT DCBA_FACEDOWNRIGHT FLOODFILLBORDER
   FLOODFILLSURFACE ETO_CLIPPED ETO_GLYPH_INDEX ETO_OPAQUE ETO_RTLREADING
   GDICOMMENT_BEGINGROUP GDICOMMENT_ENDGROUP GDICOMMENT_MULTIFORMATS
   GDICOMMENT_IDENTIFIER AD_COUNTERCLOCKWISE AD_CLOCKWISE RDH_RECTANGLES
   GCPCLASS_LATIN GCPCLASS_HEBREW GCPCLASS_ARABIC GCPCLASS_NEUTRAL
   GCPCLASS_LOCALNUMBER GCPCLASS_LATINNUMBER GCPCLASS_LATINNUMERICTERMINATOR
   GCPCLASS_LATINNUMERICSEPARATOR GCPCLASS_NUMERICSEPARATOR GCPCLASS_PREBOUNDLTR
   GCPCLASS_PREBOUNDRTL GCPCLASS_POSTBOUNDLTR GCPCLASS_POSTBOUNDRTL
   GCPGLYPH_LINKBEFORE GCPGLYPH_LINKAFTER DCB_DISABLE DCB_ENABLE DCB_RESET
   DCB_SET DCB_ACCUMULATE DCB_DIRTY OBJ_BRUSH OBJ_PEN OBJ_PAL OBJ_FONT
   OBJ_BITMAP OBJ_EXTPEN OBJ_REGION OBJ_DC OBJ_MEMDC OBJ_METAFILE OBJ_METADC
   OBJ_ENHMETAFILE OBJ_ENHMETADC DRIVERVERSION TECHNOLOGY DT_PLOTTER
   DT_RASDISPLAY DT_RASPRINTER DT_RASCAMERA DT_CHARSTREAM DT_METAFILE
   DT_DISPFILE HORZSIZE VERTSIZE HORZRES VERTRES LOGPIXELSX LOGPIXELSY BITSPIXEL
   PLANES NUMBRUSHES NUMPENS NUMFONTS NUMCOLORS NUMMARKERS ASPECTX
   ASPECTY ASPECTXY PDEVICESIZE CLIPCAPS SIZEPALETTE NUMRESERVED
   COLORRES PHYSICALWIDTH PHYSICALHEIGHT PHYSICALOFFSETX PHYSICALOFFSETY
   SCALINGFACTORX SCALINGFACTORY VREFRESH DESKTOPHORZRES DESKTOPVERTRES
   BLTALIGNMENT RASTERCAPS RC_BANDING RC_BITBLT RC_BITMAP64 RC_DI_BITMAP
   RC_DIBTODEV RC_FLOODFILL RC_GDI20_OUTPUT RC_PALETTE RC_SCALING
   RC_STRETCHBLT RC_STRETCHDIB RC_DEVBITS RC_OP_DX_OUTPUT CURVECAPS
   CC_NONE CC_CIRCLES CC_PIE CC_CHORD CC_ELLIPSES CC_WIDE CC_STYLED
   CC_WIDESTYLED CC_INTERIORS CC_ROUNDRECT LINECAPS LC_NONE LC_POLYLINE
   LC_MARKER LC_POLYMARKER LC_WIDE LC_STYLED LC_WIDESTYLED LC_INTERIORS
   POLYGONALCAPS RC_BANDING RC_BIGFONT RC_BITBLT RC_BITMAP64 RC_DEVBITS
   RC_DI_BITMAP RC_GDI20_OUTPUT RC_GDI20_STATE RC_NONE RC_OP_DX_OUTPUT
   RC_PALETTE RC_SAVEBITMAP RC_SCALING PC_NONE PC_POLYGON PC_POLYPOLYGON
   PC_PATHS PC_RECTANGLE PC_WINDPOLYGON PC_SCANLINE PC_TRAPEZOID PC_WIDE
   PC_STYLED PC_WIDESTYLED PC_INTERIORS PC_PATHS TEXTCAPS TC_OP_CHARACTER
   TC_OP_STROKE TC_CP_STROKE TC_CR_90 TC_CR_ANY TC_SF_X_YINDEP TC_SA_DOUBLE
   TC_SA_INTEGER TC_SA_CONTIN TC_EA_DOUBLE TC_IA_ABLE TC_UA_ABLE TC_SO_ABLE
   TC_RA_ABLE TC_VA_ABLE TC_RESERVED TC_SCROLLBLT GCP_DBCS GCP_ERROR GCP_CLASSIN
   GCP_DIACRITIC GCP_DISPLAYZWG GCP_GLYPHSHAPE GCP_JUSTIFY GCP_JUSTIFYIN
   GCP_KASHIDA GCP_LIGATE GCP_MAXEXTENT GCP_NEUTRALOVERRIDE GCP_NUMERICOVERRIDE
   GCP_NUMERICSLATIN GCP_NUMERICSLOCAL GCP_REORDER GCP_SYMSWAPOFF GCP_USEKERNING
   FLI_GLYPHS GGO_BITMAP GGO_NATIVE GGO_METRICS GGO_GRAY2_BITMAP
   GGO_GRAY4_BITMAP GGO_GRAY8_BITMAP GGO_GLYPH_INDEX GM_COMPATIBLE GM_ADVANCED
   MM_ANISOTROPIC MM_HIENGLISH MM_HIMETRIC MM_ISOTROPIC MM_LOENGLISH MM_LOMETRIC
   MM_TEXT MM_TWIPS ABSOLUTE RELATIVE PC_EXPLICIT PC_NOCOLLAPSE PC_RESERVED
   CLR_DEFAULT PT_MOVETO PT_LINETO PT_BEZIERTO PT_CLOSEFIGURE TT_AVAILABLE
   TT_ENABLED BLACK_BRUSH DKGRAY_BRUSH GRAY_BRUSH HOLLOW_BRUSH LTGRAY_BRUSH
   NULL_BRUSH WHITE_BRUSH BLACK_PEN NULL_PEN WHITE_PEN ANSI_FIXED_FONT
   ANSI_VAR_FONT DEVICE_DEFAULT_FONT DEFAULT_GUI_FONT OEM_FIXED_FONT
   SYSTEM_FONT SYSTEM_FIXED_FONT DEFAULT_PALETTE SYSPAL_NOSTATIC SYSPAL_STATIC
   SYSPAL_ERROR TA_BASELINE TA_BOTTOM TA_TOP TA_CENTER TA_LEFT TA_RIGHT
   TA_RTLREADING TA_NOUPDATECP TA_UPDATECP VTA_BASELINE VTA_CENTER MWT_IDENTITY
   MWT_LEFTMULTIPLY MWT_RIGHTMULTIPLY OPAQUE TRANSPARENT BLACKONWHITE
   WHITEONBLACK COLORONCOLOR HALFTONE MAXSTRETCHBLTMODE STRETCH_ANDSCANS
   STRETCH_DELETESCANS STRETCH_HALFTONE STRETCH_ORSCANS TCI_SRCCHARSET
   TCI_SRCCODEPAGE TCI_SRCFONTSIG ICM_ON ICM_OFF ICM_QUERY NEWFRAME ABORTDOC
   NEXTBAND SETCOLORTABLE GETCOLORTABLE FLUSHOUTPUT DRAFTMODE QUERYESCSUPPORT
   SETABORTPROC STARTDOC ENDDOC GETPHYSPAGESIZE GETPRINTINGOFFSET
   GETSCALINGFACTOR MFCOMMENT GETPENWIDTH SETCOPYCOUNT SELECTPAPERSOURCE
   DEVICEDATA PASSTHROUGH GETTECHNOLGY GETTECHNOLOGY SETLINECAP SETLINEJOIN
   SETMITERLIMIT BANDINFO DRAWPATTERNRECT GETVECTORPENSIZE GETVECTORBRUSHSIZE
   ENABLEDUPLEX GETSETPAPERBINS GETSETPRINTORIENT ENUMPAPERBINS SETDIBSCALING
   EPSPRINTING ENUMPAPERMETRICS GETSETPAPERMETRICS POSTSCRIPT_DATA
   POSTSCRIPT_IGNORE MOUSETRAILS GETDEVICEUNITS GETEXTENDEDTEXTMETRICS
   GETEXTENTTABLE GETPAIRKERNTABLE GETTRACKKERNTABLE EXTTEXTOUT GETFACENAME
   DOWNLOADFACE ENABLERELATIVEWIDTHS ENABLEPAIRKERNING SETKERNTRACK
   SETALLJUSTVALUES SETCHARSET STRETCHBLT GETSETSCREENPARAMS QUERYDIBSUPPORT
   BEGIN_PATH CLIP_TO_PATH END_PATH EXT_DEVICE_CAPS RESTORE_CTM SAVE_CTM
   SET_ARC_DIRECTION SET_BACKGROUND_COLOR SET_POLY_MODE SET_SCREEN_ANGLE
   SET_SPREAD TRANSFORM_CTM SET_CLIP_BOX SET_BOUNDS SET_MIRROR_MODE
   OPENCHANNEL DOWNLOADHEADER CLOSECHANNEL POSTSCRIPT_PASSTHROUGH
   ENCAPSULATED_POSTSCRIPT QDI_SETDIBITS QDI_GETDIBITS QDI_DIBTOSCREEN
   QDI_STRETCHDIB SP_NOTREPORTED PR_JOBSTATUS ASPECT_FILTERING BS_SOLID
   BS_NULL BS_HOLLOW BS_HATCHED BS_PATTERN BS_INDEXED BS_DIBPATTERN
   BS_DIBPATTERNPT BS_PATTERN8X8 BS_DIBPATTERN8X8 LCS_CALIBRATED_RGB
   LCS_DEVICE_RGB LCS_DEVICE_CMYK LCS_GM_BUSINESS LCS_GM_GRAPHICS
   LCS_GM_IMAGES RASTER_FONTTYPE DEVICE_FONTTYPE TRUETYPE_FONTTYPE
   DMORIENT_PORTRAIT DMORIENT_LANDSCAPE DMPAPER_FIRST DMPAPER_LETTER
   DMPAPER_LETTERSMALL DMPAPER_TABLOID DMPAPER_LEDGER DMPAPER_LEGAL
   DMPAPER_STATEMENT DMPAPER_EXECUTIVE DMPAPER_A3 DMPAPER_A4 DMPAPER_A4SMALL
   DMPAPER_A5 DMPAPER_B4 DMPAPER_B5 DMPAPER_FOLIO DMPAPER_QUARTO DMPAPER_10X14
   DMPAPER_11X17 DMPAPER_NOTE DMPAPER_ENV_9 DMPAPER_ENV_10 DMPAPER_ENV_11
   DMPAPER_ENV_12 DMPAPER_ENV_14 DMPAPER_CSHEET DMPAPER_DSHEET DMPAPER_ESHEET
   DMPAPER_ENV_DL DMPAPER_ENV_C5 DMPAPER_ENV_C3 DMPAPER_ENV_C4 DMPAPER_ENV_C6
   DMPAPER_ENV_C65 DMPAPER_ENV_B4 DMPAPER_ENV_B5 DMPAPER_ENV_B6
   DMPAPER_ENV_ITALY DMPAPER_ENV_MONARCH DMPAPER_ENV_PERSONAL DMPAPER_FANFOLD_US
   DMPAPER_FANFOLD_STD_GERMAN DMPAPER_FANFOLD_LGL_GERMAN DMPAPER_ISO_B4
   DMPAPER_JAPANESE_POSTCARD DMPAPER_9X11 DMPAPER_10X11 DMPAPER_15X11
   DMPAPER_ENV_INVITE DMPAPER_RESERVED_48 DMPAPER_RESERVED_49
   DMPAPER_LETTER_EXTRA DMPAPER_LEGAL_EXTRA DMPAPER_TABLOID_EXTRA
   DMPAPER_A4_EXTRA DMPAPER_LETTER_TRANSVERSE DMPAPER_A4_TRANSVERSE
   DMPAPER_LETTER_EXTRA_TRANSVERSE DMPAPER_A_PLUS DMPAPER_B_PLUS
   DMPAPER_LETTER_PLUS DMPAPER_A4_PLUS DMPAPER_A5_TRANSVERSE
   DMPAPER_B5_TRANSVERSE DMPAPER_A3_EXTRA DMPAPER_A5_EXTRA DMPAPER_B5_EXTRA
   DMPAPER_A2 DMPAPER_A3_TRANSVERSE DMPAPER_A3_EXTRA_TRANSVERSE DMPAPER_LAST
   DMPAPER_USER DMBIN_FIRST DMBIN_UPPER DMBIN_ONLYONE DMBIN_LOWER DMBIN_MIDDLE
   DMBIN_MANUAL DMBIN_ENVELOPE DMBIN_ENVMANUAL DMBIN_AUTO DMBIN_TRACTOR
   DMBIN_SMALLFMT DMBIN_LARGEFMT DMBIN_LARGECAPACITY DMBIN_CASSETTE
   DMBIN_FORMSOURCE DMBIN_LAST DMBIN_USER DMCOLOR_MONOCHROME DMCOLOR_COLOR
   DMDUP_SIMPLEX DMDUP_VERTICAL DMDUP_HORIZONTAL DMTT_BITMAP DMTT_DOWNLOAD
   DMTT_SUBDEV DMTT_DOWNLOAD_OUTLINE DMCOLLATE_FALSE DMCOLLATE_TRUE
   DM_GRAYSCALE DM_INTERLACED DM_UPDATE DM_COPY DM_PROMPT DM_MODIFY
   DM_ORIENTATION DM_PAPERSIZE DM_PAPERLENGTH DM_PAPERWIDTH DM_SCALE DM_COPIES
   DM_DEFAULTSOURCE DM_PRINTQUALITY DM_COLOR DM_DUPLEX DM_YRESOLUTION
   DM_TTOPTION DM_COLLATE DM_FORMNAME DM_LOGPIXELS DM_BITSPERPEL DM_PELSWIDTH
   DM_PELSHEIGHT DM_DISPLAYFLAGS DM_DISPLAYFREQUENCY DM_ICMMETHOD DM_ICMINTENT
   DM_MEDIATYPE DM_DITHERTYPE DMICMMETHOD_NONE DMICMMETHOD_SYSTEM
   DMICMMETHOD_DRIVER DMICMMETHOD_DEVICE DMICMMETHOD_USER DMICM_SATURATE
   DMICM_CONTRAST DMICM_COLORMETRIC DMICM_USER DMMEDIA_STANDARD
   DMMEDIA_TRANSPARENCY DMMEDIA_GLOSSY DMMEDIA_USER DMDITHER_NONE
   DMDITHER_COARSE DMDITHER_FINE DMDITHER_LINEART DMDITHER_ERRORDIFFUSION
   DMDITHER_RESERVED6 DMDITHER_RESERVED7 DMDITHER_RESERVED8 DMDITHER_RESERVED9
   DMDITHER_GRAYSCALE DMDITHER_USER TMPF_FIXED_PITCH TMPF_VECTOR TMPF_TRUETYPE
   TMPF_DEVICE NTM_ITALIC NTM_BOLD NTM_REGULAR TT_POLYGON_TYPE TT_PRIM_LINE
   TT_PRIM_QSPLINE FONTMAPPER_MAX ENHMETA_STOCK_OBJECT WGL_FONT_LINES
   WGL_FONT_POLYGONS LPD_DOUBLEBUFFER LPD_STEREO LPD_SUPPORT_GDI
   LPD_SUPPORT_OPENGL LPD_SHARE_DEPTH LPD_SHARE_STENCIL LPD_SHARE_ACCUM
   LPD_SWAP_EXCHANGE LPD_SWAP_COPY LPD_TRANSPARENT LPD_TYPE_RGBA
   LPD_TYPE_COLORINDEX IDC_STATIC IDC_ARROW IDC_IBEAM IDC_WAIT IDC_CROSS
   IDC_UPARROW IDC_SIZENWSE IDC_SIZENESW IDC_SIZEWE IDC_SIZENS IDC_SIZEALL
   IDC_NO IDC_HAND IDC_APPSTARTING IDC_HELP IDC_ICON IDC_SIZE
   WGL_SWAP_MAIN_PLANE WGL_SWAP_OVERLAY1 WGL_SWAP_OVERLAY2
   WGL_SWAP_OVERLAY3 WGL_SWAP_OVERLAY4 WGL_SWAP_OVERLAY5 WGL_SWAP_OVERLAY6
   WGL_SWAP_OVERLAY7 WGL_SWAP_OVERLAY8 WGL_SWAP_OVERLAY9 WGL_SWAP_OVERLAY10
   WGL_SWAP_OVERLAY11 WGL_SWAP_OVERLAY12 WGL_SWAP_OVERLAY13 WGL_SWAP_OVERLAY14
   WGL_SWAP_OVERLAY15 WGL_SWAP_UNDERLAY1 WGL_SWAP_UNDERLAY2 WGL_SWAP_UNDERLAY3
   WGL_SWAP_UNDERLAY4 WGL_SWAP_UNDERLAY5 WGL_SWAP_UNDERLAY6 WGL_SWAP_UNDERLAY7
   WGL_SWAP_UNDERLAY8 WGL_SWAP_UNDERLAY9 WGL_SWAP_UNDERLAY10 WGL_SWAP_UNDERLAY11
   WGL_SWAP_UNDERLAY12 WGL_SWAP_UNDERLAY13 WGL_SWAP_UNDERLAY14
   WGL_SWAP_UNDERLAY15 RGB
   WS_BORDER WS_CAPTION WS_CHILD WS_CHILDWINDOW WS_CLIPCHILDREN WS_CLIPSIBLINGS
   WS_DISABLED WS_DLGFRAME WS_GROUP WS_HSCROLL WS_ICONIC WS_MAXIMIZE
   WS_MAXIMIZEBOX WS_MINIMIZE WS_MINIMIZEBOX WS_OVERLAPPED WS_OVERLAPPEDWINDOW
   WS_POPUP WS_POPUPWINDOW WS_SIZEBOX WS_SYSMENU WS_TABSTOP WS_THICKFRAME
   WS_TILED WS_TILEDWINDOW WS_VISIBLE WS_VSCROLL WS_EX_ACCEPTFILES
   WS_EX_APPWINDOW WS_EX_CLIENTEDGE WS_EX_CONTEXTHELP WS_EX_CONTROLPARENT
   WS_EX_DLGMODALFRAME WS_EX_LEFT WS_EX_LEFTSCROLLBAR WS_EX_LTRREADING
   WS_EX_MDICHILD WS_EX_NOPARENTNOTIFY WS_EX_OVERLAPPEDWINDOW
   WS_EX_PALETTEWINDOW WS_EX_RIGHT WS_EX_RIGHTSCROLLBAR WS_EX_RTLREADING
   WS_EX_STATICEDGE WS_EX_TOOLWINDOW WS_EX_TOPMOST WS_EX_TRANSPARENT
   WS_EX_WINDOWEDGE
   WM_ACTIVATE WM_ACTIVATEAPP WM_AFXFIRST WM_AFXLAST WM_ASKCBFORMATNAME
   WM_CANCELJOURNAL WM_CANCELMODE WM_CAPTURECHANGED WM_CHANGECBCHAIN
   WM_CHAR WM_CHARTOITEM WM_CHILDACTIVATE WM_CLEAR WM_CLOSE WM_COMMAND
   WM_COMPACTING WM_COMPAREITEM WM_CONTEXTMENU WM_COPY WM_COPYDATA WM_CREATE
   WM_CTLCOLORBTN WM_CTLCOLORDLG WM_CTLCOLOREDIT WM_CTLCOLORLISTBOX
   WM_CTLCOLORMSGBOX WM_CTLCOLORSCROLLBAR WM_CTLCOLORSTATIC WM_CUT WM_DEADCHAR
   WM_DELETEITEM WM_DESTROY WM_DESTROYCLIPBOARD WM_DEVICECHANGE WM_DEVMODECHANGE
   WM_DISPLAYCHANGE WM_DRAWCLIPBOARD WM_DRAWITEM WM_DROPFILES WM_ENABLE
   WM_ENDSESSION WM_ENTERIDLE WM_ENTERMENULOOP WM_ENTERSIZEMOVE WM_ERASEBKGND
   WM_EXITMENULOOP WM_EXITSIZEMOVE WM_FONTCHANGE WM_GETDLGCODE WM_GETFONT
   WM_GETHOTKEY WM_GETICON WM_GETMINMAXINFO WM_GETTEXT WM_GETTEXTLENGTH
   WM_HANDHELDFIRST WM_HANDHELDLAST WM_HELP WM_HOTKEY WM_HSCROLL
   WM_HSCROLLCLIPBOARD WM_ICONERASEBKGND WM_INITDIALOG WM_INITMENU
   WM_INITMENUPOPUP WM_INPUTLANGCHANGE WM_INPUTLANGCHANGEREQUEST WM_KEYDOWN
   WM_KEYUP WM_KILLFOCUS WM_MDIACTIVATE WM_MDICASCADE WM_MDICREATE WM_MDIDESTROY
   WM_MDIGETACTIVE WM_MDIICONARRANGE WM_MDIMAXIMIZE WM_MDINEXT WM_MDIREFRESHMENU
   WM_MDIRESTORE WM_MDISETMENU WM_MDITILE WM_MEASUREITEM WM_MENUCHAR
   WM_MENUSELECT WM_NEXTMENU WM_MOVE WM_MOVING WM_NCACTIVATE WM_NCCALCSIZE
   WM_NCCREATE WM_NCDESTROY WM_NCHITTEST WM_NCLBUTTONDBLCLK WM_NCLBUTTONDOWN
   WM_NCLBUTTONUP WM_NCMBUTTONDBLCLK WM_NCMBUTTONDOWN WM_NCMBUTTONUP
   WM_NCMOUSEMOVE WM_NCPAINT WM_NCRBUTTONDBLCLK WM_NCRBUTTONDOWN WM_NCRBUTTONUP
   WM_NEXTDLGCTL WM_NEXTMENU WM_NOTIFY WM_NOTIFYFORMAT WM_NULL WM_PAINT
   WM_PAINTCLIPBOARD WM_PAINTICON WM_PALETTECHANGED WM_PALETTEISCHANGING
   WM_PARENTNOTIFY WM_PASTE WM_PENWINFIRST WM_PENWINLAST WM_POWER
   WM_POWERBROADCAST WM_PRINT WM_PRINTCLIENT WM_QUERYDRAGICON
   WM_QUERYENDSESSION WM_QUERYNEWPALETTE WM_QUERYOPEN WM_QUEUESYNC WM_QUIT
   WM_RENDERALLFORMATS WM_RENDERFORMAT WM_SETCURSOR WM_SETFOCUS WM_SETFONT
   WM_SETHOTKEY WM_SETICON WM_SETREDRAW WM_SETTEXT WM_SETTINGCHANGE
   WM_SHOWWINDOW WM_SIZE WM_SIZECLIPBOARD WM_SIZING WM_SPOOLERSTATUS
   WM_STYLECHANGED WM_STYLECHANGING WM_SYSCHAR WM_SYSCOLORCHANGE WM_SYSCOMMAND
   WM_SYSDEADCHAR WM_SYSKEYDOWN WM_SYSKEYUP WM_TCARD WM_TIMECHANGE WM_TIMER
   WM_UNDO WM_USER WM_USERCHANGED WM_VKEYTOITEM WM_VSCROLL WM_VSCROLLCLIPBOARD
   WM_WINDOWPOSCHANGED WM_WINDOWPOSCHANGING WM_WININICHANGE WM_KEYFIRST
   WM_KEYLAST WM_SYNCPAINT WM_MOUSEACTIVATE WM_MOUSEMOVE WM_LBUTTONDOWN
   WM_LBUTTONUP WM_LBUTTONDBLCLK WM_RBUTTONDOWN WM_RBUTTONUP WM_RBUTTONDBLCLK
   WM_MBUTTONDOWN WM_MBUTTONUP WM_MBUTTONDBLCLK WM_MOUSEWHEEL WM_MOUSEFIRST
   WM_MOUSELAST WM_MOUSEHOVER WM_MOUSELEAVE
   SW_HIDE SW_NORMAL SW_SHOWNORMAL SW_SHOWMINIMIZED SW_MAXIMIZE
   SW_SHOWMAXIMIZED SW_SHOWNOACTIVATE SW_SHOW SW_MINIMIZE SW_SHOWMINNOACTIVE
   SW_SHOWNA SW_RESTORE SW_SHOWDEFAULT SW_FORCEMINIMIZE SW_MAX
   SW_PARENTCLOSING SW_OTHERZOOM SW_PARENTOPENING SW_OTHERUNZOOM
   SW_SCROLLCHILDREN SW_INVALIDATE SW_ERASE))

(in-package "GDI")

(push :gdi *features*)
(defconstant SM_CXSCREEN 0)
(defconstant SM_CYSCREEN 1)
(defconstant SM_CXVSCROLL 2)
(defconstant SM_CYHSCROLL 3)
(defconstant SM_CYCAPTION 4)
(defconstant SM_CXBORDER 5)
(defconstant SM_CYBORDER 6)
(defconstant SM_CXDLGFRAME 7)
(defconstant SM_CXFIXEDFRAME 7)
(defconstant SM_CYDLGFRAME 8)
(defconstant SM_CYFIXEDFRAME 8)
(defconstant SM_CYVTHUMB 9)
(defconstant SM_CXHTHUMB 10)
(defconstant SM_CXICON 11)
(defconstant SM_CYICON 12)
(defconstant SM_CXCURSOR 13)
(defconstant SM_CYCURSOR 14)
(defconstant SM_CYMENU 15)
(defconstant SM_CXFULLSCREEN 16)
(defconstant SM_CYFULLSCREEN 17)
(defconstant SM_CYKANJIWINDOW 18)
(defconstant SM_MOUSEPRESENT 19)
(defconstant SM_CYVSCROLL 20)
(defconstant SM_CXHSCROLL 21)
(defconstant SM_DEBUG 22)
(defconstant SM_SWAPBUTTON 23)
(defconstant SM_RESERVED1 24)
(defconstant SM_RESERVED2 25)
(defconstant SM_RESERVED3 26)
(defconstant SM_RESERVED4 27)
(defconstant SM_CXMIN 28)
(defconstant SM_CYMIN 29)
(defconstant SM_CXSIZE 30)
(defconstant SM_CYSIZE 31)
(defconstant SM_CXSIZEFRAME 32)
(defconstant SM_CXFRAME 32)
(defconstant SM_CYSIZEFRAME 33)
(defconstant SM_CYFRAME 33)
(defconstant SM_CXMINTRACK 34)
(defconstant SM_CYMINTRACK 35)
(defconstant SM_CXDOUBLECLK 36)
(defconstant SM_CYDOUBLECLK 37)
(defconstant SM_CXICONSPACING 38)
(defconstant SM_CYICONSPACING 39)
(defconstant SM_MENUDROPALIGNMENT 40)
(defconstant SM_PENWINDOWS 41)
(defconstant SM_DBCSENABLED 42)
(defconstant SM_CMOUSEBUTTONS 43)
(defconstant SM_SECURE 44)
(defconstant SM_CXEDGE 45)
(defconstant SM_CYEDGE 46)
(defconstant SM_CXMINSPACING 47)
(defconstant SM_CYMINSPACING 48)
(defconstant SM_CXSMICON 49)
(defconstant SM_CYSMICON 50)
(defconstant SM_CYSMCAPTION 51)
(defconstant SM_CXSMSIZE 52)
(defconstant SM_CYSMSIZE 53)
(defconstant SM_CXMENUSIZE 54)
(defconstant SM_CYMENUSIZE 55)
(defconstant SM_ARRANGE 56)
(defconstant SM_CXMINIMIZED 57)
(defconstant SM_CYMINIMIZED 58)
(defconstant SM_CXMAXTRACK 59)
(defconstant SM_CYMAXTRACK 60)
(defconstant SM_CXMAXIMIZED 61)
(defconstant SM_CYMAXIMIZED 62)
(defconstant SM_NETWORK 63)
(defconstant SM_CLEANBOOT 67)
(defconstant SM_CXDRAG 68)
(defconstant SM_CYDRAG 69)
(defconstant SM_SHOWSOUNDS 70)
(defconstant SM_CXMENUCHECK 71)
(defconstant SM_CYMENUCHECK 72)
(defconstant SM_SLOWMACHINE 73)
(defconstant SM_MIDEASTENABLED 74)
(defconstant SM_MOUSEWHEELPRESENT 75)
(defconstant SM_XVIRTUALSCREEN 76)
(defconstant SM_YVIRTUALSCREEN 77)
(defconstant SM_CXVIRTUALSCREEN 78)
(defconstant SM_CYVIRTUALSCREEN 79)
(defconstant SM_CMONITORS 80)
(defconstant SM_SAMEDISPLAYFORMAT 81)
;(defconstant SM_CMETRICS 76) use on versions of nt < 4.0
(defconstant SM_CMETRICS 83)

(defconstant BI_RGB 0)
(defconstant BI_RLE8 1)
(defconstant BI_RLE4 2)
(defconstant BI_BITFIELDS 3)
(defconstant LF_FACESIZE 32)
(defconstant LF_FULLFACESIZE 64)
(defconstant CA_NEGATIVE 1)
(defconstant CA_LOG_FILTER 2)
(defconstant ILLUMINANT_DEVICE_DEFAULT 0)
(defconstant ILLUMINANT_A 1)
(defconstant ILLUMINANT_B 2)
(defconstant ILLUMINANT_C 3)
(defconstant ILLUMINANT_D50 4)
(defconstant ILLUMINANT_D55 5)
(defconstant ILLUMINANT_D65 6)
(defconstant ILLUMINANT_D75 7)
(defconstant ILLUMINANT_F2 8)
(defconstant ILLUMINANT_MAX_INDEX ILLUMINANT_F2)
(defconstant ILLUMINANT_FLUORESCENT ILLUMINANT_F2)
(defconstant RGB_GAMMA_MIN 2500)
(defconstant RGB_GAMMA_MAX 65000)
(defconstant REFERENCE_WHITE_MIN 6000)
(defconstant REFERENCE_WHITE_MAX 10000)
(defconstant REFERENCE_BLACK_MIN 0)
(defconstant REFERENCE_BLACK_MAX 4000)
(defconstant COLOR_ADJ_MAX 100)
(defconstant CCHDEVICENAME 32)
(defconstant CCHFORMNAME 32)
(defconstant DI_COMPAT 4)
(defconstant DI_DEFAULTSIZE 8)
(defconstant DI_IMAGE 2)
(defconstant DI_MASK 1)
(defconstant DI_NORMAL 3)
(defconstant DI_APPBANDING 1)
(defconstant EMR_HEADER 1)
(defconstant EMR_POLYBEZIER 2)
(defconstant EMR_POLYGON 3)
(defconstant EMR_POLYLINE 4)
(defconstant EMR_POLYBEZIERTO 5)
(defconstant EMR_POLYLINETO 6)
(defconstant EMR_POLYPOLYLINE 7)
(defconstant EMR_POLYPOLYGON 8)
(defconstant EMR_SETWINDOWEXTEX 9)
(defconstant EMR_SETWINDOWORGEX 10)
(defconstant EMR_SETVIEWPORTEXTEX 11)
(defconstant EMR_SETVIEWPORTORGEX 12)
(defconstant EMR_SETBRUSHORGEX 13)
(defconstant EMR_EOF 14)
(defconstant EMR_SETPIXELV 15)
(defconstant EMR_SETMAPPERFLAGS 16)
(defconstant EMR_SETMAPMODE 17)
(defconstant EMR_SETBKMODE 18)
(defconstant EMR_SETPOLYFILLMODE 19)
(defconstant EMR_SETROP2 20)
(defconstant EMR_SETSTRETCHBLTMODE 21)
(defconstant EMR_SETTEXTALIGN 22)
(defconstant EMR_SETCOLORADJUSTMENT 23)
(defconstant EMR_SETTEXTCOLOR 24)
(defconstant EMR_SETBKCOLOR 25)
(defconstant EMR_OFFSETCLIPRGN 26)
(defconstant EMR_MOVETOEX 27)
(defconstant EMR_SETMETARGN 28)
(defconstant EMR_EXCLUDECLIPRECT 29)
(defconstant EMR_INTERSECTCLIPRECT 30)
(defconstant EMR_SCALEVIEWPORTEXTEX 31)
(defconstant EMR_SCALEWINDOWEXTEX 32)
(defconstant EMR_SAVEDC 33)
(defconstant EMR_RESTOREDC 34)
(defconstant EMR_SETWORLDTRANSFORM 35)
(defconstant EMR_MODIFYWORLDTRANSFORM 36)
(defconstant EMR_SELECTOBJECT 37)
(defconstant EMR_CREATEPEN 38)
(defconstant EMR_CREATEBRUSHINDIRECT 39)
(defconstant EMR_DELETEOBJECT 40)
(defconstant EMR_ANGLEARC 41)
(defconstant EMR_ELLIPSE 42)
(defconstant EMR_RECTANGLE 43)
(defconstant EMR_ROUNDRECT 44)
(defconstant EMR_ARC 45)
(defconstant EMR_CHORD 46)
(defconstant EMR_PIE 47)
(defconstant EMR_SELECTPALETTE 48)
(defconstant EMR_CREATEPALETTE 49)
(defconstant EMR_SETPALETTEENTRIES 50)
(defconstant EMR_RESIZEPALETTE 51)
(defconstant EMR_REALIZEPALETTE 52)
(defconstant EMR_EXTFLOODFILL 53)
(defconstant EMR_LINETO 54)
(defconstant EMR_ARCTO 55)
(defconstant EMR_POLYDRAW 56)
(defconstant EMR_SETARCDIRECTION 57)
(defconstant EMR_SETMITERLIMIT 58)
(defconstant EMR_BEGINPATH 59)
(defconstant EMR_ENDPATH 60)
(defconstant EMR_CLOSEFIGURE 61)
(defconstant EMR_FILLPATH 62)
(defconstant EMR_STROKEANDFILLPATH 63)
(defconstant EMR_STROKEPATH 64)
(defconstant EMR_FLATTENPATH 65)
(defconstant EMR_WIDENPATH 66)
(defconstant EMR_SELECTCLIPPATH 67)
(defconstant EMR_ABORTPATH 68)
(defconstant EMR_GDICOMMENT 70)
(defconstant EMR_FILLRGN 71)
(defconstant EMR_FRAMERGN 72)
(defconstant EMR_INVERTRGN 73)
(defconstant EMR_PAINTRGN 74)
(defconstant EMR_EXTSELECTCLIPRGN 75)
(defconstant EMR_BITBLT 76)
(defconstant EMR_STRETCHBLT 77)
(defconstant EMR_MASKBLT 78)
(defconstant EMR_PLGBLT 79)
(defconstant EMR_SETDIBITSTODEVICE 80)
(defconstant EMR_STRETCHDIBITS 81)
(defconstant EMR_EXTCREATEFONTINDIRECTW 82)
(defconstant EMR_EXTTEXTOUTA 83)
(defconstant EMR_EXTTEXTOUTW 84)
(defconstant EMR_POLYBEZIER16 85)
(defconstant EMR_POLYGON16 86)
(defconstant EMR_POLYLINE16 87)
(defconstant EMR_POLYBEZIERTO16 88)
(defconstant EMR_POLYLINETO16 89)
(defconstant EMR_POLYPOLYLINE16 90)
(defconstant EMR_POLYPOLYGON16 91)
(defconstant EMR_POLYDRAW16 92)
(defconstant EMR_CREATEMONOBRUSH 93)
(defconstant EMR_CREATEDIBPATTERNBRUSHPT 94)
(defconstant EMR_EXTCREATEPEN 95)
(defconstant EMR_POLYTEXTOUTA 96)
(defconstant EMR_POLYTEXTOUTW 97)
(defconstant EMR_SETICMMODE 98)
(defconstant EMR_CREATECOLORSPACE 99)
(defconstant EMR_SETCOLORSPACE 100)
(defconstant EMR_DELETECOLORSPACE 101)
(defconstant EMR_GLSRECORD 102)
(defconstant EMR_GLSBOUNDEDRECORD 103)
(defconstant EMR_PIXELFORMAT 104)
(defconstant ENHMETA_SIGNATURE 1179469088)
(defconstant EPS_SIGNATURE #x46535045)
(defconstant META_SETBKCOLOR #x201)
(defconstant META_SETBKMODE #x102)
(defconstant META_SETMAPMODE #x103)
(defconstant META_SETROP2 #x104)
(defconstant META_SETRELABS #x105)
(defconstant META_SETPOLYFILLMODE #x106)
(defconstant META_SETSTRETCHBLTMODE #x107)
(defconstant META_SETTEXTCHAREXTRA #x108)
(defconstant META_SETTEXTCOLOR #x209)
(defconstant META_SCALEWINDOWEXT #x410)
(defconstant META_OFFSETVIEWPORTORG #x211)
(defconstant META_SCALEVIEWPORTEXT #x412)
(defconstant META_LINETO #x213)
(defconstant META_MOVETO #x214)
(defconstant META_EXCLUDECLIPRECT #x415)
(defconstant META_INTERSECTCLIPRECT #x416)
(defconstant META_ARC #x817)
(defconstant META_ELLIPSE #x418)
(defconstant META_FLOODFILL #x419)
(defconstant META_OFFSETCLIPRGN #x220)
(defconstant META_TEXTOUT #x521)
(defconstant META_BITBLT #x922)
(defconstant META_STRETCHBLT #xB23)
(defconstant META_POLYGON #x324)
(defconstant META_POLYLINE #x325)
(defconstant META_ESCAPE #x626)
(defconstant META_RESTOREDC #x127)
(defconstant META_FILLREGION #x228)
(defconstant META_FRAMEREGION #x429)
(defconstant META_CHORD #x830)
(defconstant META_SETMAPPERFLAGS #x231)
(defconstant META_EXTTEXTOUT #xa32)
(defconstant META_SETDIBTODEV #xd33)
(defconstant META_SELECTPALETTE #x234)
(defconstant META_REALIZEPALETTE #x35)
(defconstant META_ANIMATEPALETTE #x436)
(defconstant META_SETPALENTRIES #x37)
(defconstant META_POLYPOLYGON #x538)
(defconstant META_RESIZEPALETTE #x139)
(defconstant META_DIBBITBLT #x940)
(defconstant META_DIBSTRETCHBLT #xb41)
(defconstant META_DIBCREATEPATTERNBRUSH #x142)
(defconstant META_STRETCHDIB #xf43)
(defconstant META_EXTFLOODFILL #x548)
(defconstant META_DELETEOBJECT #x1f0)
(defconstant META_CREATEPALETTE #xf7)
(defconstant META_CREATEPATTERNBRUSH #x1F9)
(defconstant PT_MOVETO 6)
(defconstant PT_LINETO 2)
(defconstant PT_BEZIERTO 4)
(defconstant PT_CLOSEFIGURE 1)
(defconstant ELF_VENDOR_SIZE 4)
(defconstant ELF_VERSION 0)
(defconstant ELF_CULTURE_LATIN 0)
(defconstant PFD_TYPE_RGBA 0)
(defconstant PFD_TYPE_COLORINDEX 1)
(defconstant PFD_MAIN_PLANE 0)
(defconstant PFD_OVERLAY_PLANE 1)
(defconstant PFD_DOUBLEBUFFER 1)
(defconstant PFD_STEREO 2)
(defconstant PFD_DRAW_TO_WINDOW 4)
(defconstant PFD_DRAW_TO_BITMAP 8)
(defconstant PFD_SUPPORT_GDI 16)
(defconstant PFD_SUPPORT_OPENGL 32)
(defconstant PFD_GENERIC_FORMAT 64)
(defconstant PFD_NEED_PALETTE 128)
(defconstant PFD_NEED_SYSTEM_PALETTE #x00000100)
(defconstant PFD_SWAP_EXCHANGE #x00000200)
(defconstant PFD_SWAP_COPY #x00000400)
(defconstant PFD_DOUBLEBUFFER_DONTCARE #x40000000)
(defconstant PFD_STEREO_DONTCARE #x80000000)
(defconstant BLACKNESS #x42)
(defconstant NOTSRCERASE #x1100A6)
(defconstant NOTSRCCOPY #x330008)
(defconstant SRCERASE #x440328)
(defconstant DSTINVERT #x550009)
(defconstant PATINVERT #x5A0049)
(defconstant SRCINVERT #x660046)
(defconstant SRCAND #x8800C6)
(defconstant MERGEPAINT #xBB0226)
(defconstant SRCCOPY #xCC0020)
(defconstant SRCPAINT #xEE0086)
(defconstant PATCOPY #xF00021)
(defconstant PATPAINT #xFB0A09)
(defconstant WHITENESS #xFF0062)
(defconstant R2_BLACK 1)
(defconstant R2_COPYPEN 13)
(defconstant R2_MASKNOTPEN 3)
(defconstant R2_MASKPEN 9)
(defconstant R2_MASKPENNOT 5)
(defconstant R2_MERGENOTPEN 12)
(defconstant R2_MERGEPEN 15)
(defconstant R2_MERGEPENNOT 14)
(defconstant R2_NOP 11)
(defconstant R2_NOT 6)
(defconstant R2_NOTCOPYPEN 4)
(defconstant R2_NOTMASKPEN 8)
(defconstant R2_NOTMERGEPEN 2)
(defconstant R2_NOTXORPEN 10)
(defconstant R2_WHITE 16)
(defconstant R2_XORPEN 7)
(defconstant CM_OUT_OF_GAMUT 255)
(defconstant CM_IN_GAMUT 0)
(defconstant RGN_AND 1)
(defconstant RGN_COPY 5)
(defconstant RGN_DIFF 4)
(defconstant RGN_OR 2)
(defconstant RGN_XOR 3)
(defconstant NULLREGION 1)
(defconstant SIMPLEREGION 2)
(defconstant COMPLEXREGION 3)
(defconstant ERROR 0)
(defconstant CBM_INIT 4)
(defconstant DIB_PAL_COLORS 1)
(defconstant DIB_RGB_COLORS 0)
(defconstant FW_DONTCARE 0)
(defconstant FW_THIN 100)
(defconstant FW_EXTRALIGHT 200)
(defconstant FW_LIGHT 300)
(defconstant FW_NORMAL 400)
(defconstant FW_REGULAR 400)
(defconstant FW_MEDIUM 500)
(defconstant FW_SEMIBOLD 600)
(defconstant FW_BOLD 700)
(defconstant FW_EXTRABOLD 800)
(defconstant FW_HEAVY 900)
(defconstant ANSI_CHARSET 0)
(defconstant DEFAULT_CHARSET 1)
(defconstant SYMBOL_CHARSET 2)
(defconstant SHIFTJIS_CHARSET 128)
(defconstant HANGEUL_CHARSET 129)
(defconstant HANGUL_CHARSET 129)
(defconstant GB2312_CHARSET 134)
(defconstant CHINESEBIG5_CHARSET 136)
(defconstant GREEK_CHARSET 161)
(defconstant TURKISH_CHARSET 162)
(defconstant HEBREW_CHARSET 177)
(defconstant ARABIC_CHARSET 178)
(defconstant BALTIC_CHARSET 186)
(defconstant RUSSIAN_CHARSET 204)
(defconstant THAI_CHARSET 222)
(defconstant EASTEUROPE_CHARSET 238)
(defconstant OEM_CHARSET 255)
(defconstant JOHAB_CHARSET 130)
(defconstant VIETNAMESE_CHARSET 163)
(defconstant MAC_CHARSET 77)
(defconstant BALTIC_CHARSET 186)
(defconstant JOHAB_CHARSET 130)
(defconstant VIETNAMESE_CHARSET 163)
(defconstant OUT_DEFAULT_PRECIS 0)
(defconstant OUT_STRING_PRECIS 1)
(defconstant OUT_CHARACTER_PRECIS 2)
(defconstant OUT_STROKE_PRECIS 3)
(defconstant OUT_TT_PRECIS 4)
(defconstant OUT_DEVICE_PRECIS 5)
(defconstant OUT_RASTER_PRECIS 6)
(defconstant OUT_TT_ONLY_PRECIS 7)
(defconstant OUT_OUTLINE_PRECIS 8)
(defconstant CLIP_DEFAULT_PRECIS 0)
(defconstant CLIP_CHARACTER_PRECIS 1)
(defconstant CLIP_STROKE_PRECIS 2)
(defconstant CLIP_MASK 15)
(defconstant CLIP_LH_ANGLES 16)
(defconstant CLIP_TT_ALWAYS 32)
(defconstant CLIP_EMBEDDED 128)
(defconstant DEFAULT_QUALITY 0)
(defconstant DRAFT_QUALITY 1)
(defconstant PROOF_QUALITY 2)
(defconstant NONANTIALIASED_QUALITY 3)
(defconstant ANTIALIASED_QUALITY 4)
(defconstant DEFAULT_PITCH 0)
(defconstant FIXED_PITCH 1)
(defconstant VARIABLE_PITCH 2)
(defconstant MONO_FONT 8)
(defconstant FF_DECORATIVE 80)
(defconstant FF_DONTCARE 0)
(defconstant FF_MODERN 48)
(defconstant FF_ROMAN 16)
(defconstant FF_SCRIPT 64)
(defconstant FF_SWISS 32)
(defconstant PANOSE_COUNT 10)
(defconstant PAN_FAMILYTYPE_INDEX 0)
(defconstant PAN_SERIFSTYLE_INDEX 1)
(defconstant PAN_WEIGHT_INDEX 2)
(defconstant PAN_PROPORTION_INDEX 3)
(defconstant PAN_CONTRAST_INDEX 4)
(defconstant PAN_STROKEVARIATION_INDEX 5)
(defconstant PAN_ARMSTYLE_INDEX 6)
(defconstant PAN_LETTERFORM_INDEX 7)
(defconstant PAN_MIDLINE_INDEX 8)
(defconstant PAN_XHEIGHT_INDEX 9)
(defconstant PAN_CULTURE_LATIN 0)
(defconstant PAN_ANY 0)
(defconstant PAN_NO_FIT 1)
(defconstant PAN_FAMILY_TEXT_DISPLAY 2)
(defconstant PAN_FAMILY_SCRIPT 3)
(defconstant PAN_FAMILY_DECORATIVE 4)
(defconstant PAN_FAMILY_PICTORIAL 5)
(defconstant PAN_SERIF_COVE 2)
(defconstant PAN_SERIF_OBTUSE_COVE 3)
(defconstant PAN_SERIF_SQUARE_COVE 4)
(defconstant PAN_SERIF_OBTUSE_SQUARE_COVE 5)
(defconstant PAN_SERIF_SQUARE 6)
(defconstant PAN_SERIF_THIN 7)
(defconstant PAN_SERIF_BONE 8)
(defconstant PAN_SERIF_EXAGGERATED 9)
(defconstant PAN_SERIF_TRIANGLE 10)
(defconstant PAN_SERIF_NORMAL_SANS 11)
(defconstant PAN_SERIF_OBTUSE_SANS 12)
(defconstant PAN_SERIF_PERP_SANS 13)
(defconstant PAN_SERIF_FLARED 14)
(defconstant PAN_SERIF_ROUNDED 15)
(defconstant PAN_WEIGHT_VERY_LIGHT 2)
(defconstant PAN_WEIGHT_LIGHT 3)
(defconstant PAN_WEIGHT_THIN 4)
(defconstant PAN_WEIGHT_BOOK 5)
(defconstant PAN_WEIGHT_MEDIUM 6)
(defconstant PAN_WEIGHT_DEMI 7)
(defconstant PAN_WEIGHT_BOLD 8)
(defconstant PAN_WEIGHT_HEAVY 9)
(defconstant PAN_WEIGHT_BLACK 10)
(defconstant PAN_WEIGHT_NORD 11)
(defconstant PAN_PROP_OLD_STYLE 2)
(defconstant PAN_PROP_MODERN 3)
(defconstant PAN_PROP_EVEN_WIDTH 4)
(defconstant PAN_PROP_EXPANDED 5)
(defconstant PAN_PROP_CONDENSED 6)
(defconstant PAN_PROP_VERY_EXPANDED 7)
(defconstant PAN_PROP_VERY_CONDENSED 8)
(defconstant PAN_PROP_MONOSPACED 9)
(defconstant PAN_CONTRAST_NONE 2)
(defconstant PAN_CONTRAST_VERY_LOW 3)
(defconstant PAN_CONTRAST_LOW 4)
(defconstant PAN_CONTRAST_MEDIUM_LOW 5)
(defconstant PAN_CONTRAST_MEDIUM 6)
(defconstant PAN_CONTRAST_MEDIUM_HIGH 7)
(defconstant PAN_CONTRAST_HIGH 8)
(defconstant PAN_CONTRAST_VERY_HIGH 9)
(defconstant PAN_STROKE_GRADUAL_DIAG 2)
(defconstant PAN_STROKE_GRADUAL_TRAN 3)
(defconstant PAN_STROKE_GRADUAL_VERT 4)
(defconstant PAN_STROKE_GRADUAL_HORZ 5)
(defconstant PAN_STROKE_RAPID_VERT 6)
(defconstant PAN_STROKE_RAPID_HORZ 7)
(defconstant PAN_STROKE_INSTANT_VERT 8)
(defconstant PAN_STRAIGHT_ARMS_HORZ 2)
(defconstant PAN_STRAIGHT_ARMS_WEDGE 3)
(defconstant PAN_STRAIGHT_ARMS_VERT 4)
(defconstant PAN_STRAIGHT_ARMS_SINGLE_SERIF 5)
(defconstant PAN_STRAIGHT_ARMS_DOUBLE_SERIF 6)
(defconstant PAN_BENT_ARMS_HORZ 7)
(defconstant PAN_BENT_ARMS_WEDGE 8)
(defconstant PAN_BENT_ARMS_VERT 9)
(defconstant PAN_BENT_ARMS_SINGLE_SERIF 10)
(defconstant PAN_BENT_ARMS_DOUBLE_SERIF 11)
(defconstant PAN_LETT_NORMAL_CONTACT 2)
(defconstant PAN_LETT_NORMAL_WEIGHTED 3)
(defconstant PAN_LETT_NORMAL_BOXED 4)
(defconstant PAN_LETT_NORMAL_FLATTENED 5)
(defconstant PAN_LETT_NORMAL_ROUNDED 6)
(defconstant PAN_LETT_NORMAL_OFF_CENTER 7)
(defconstant PAN_LETT_NORMAL_SQUARE 8)
(defconstant PAN_LETT_OBLIQUE_CONTACT 9)
(defconstant PAN_LETT_OBLIQUE_WEIGHTED 10)
(defconstant PAN_LETT_OBLIQUE_BOXED 11)
(defconstant PAN_LETT_OBLIQUE_FLATTENED 12)
(defconstant PAN_LETT_OBLIQUE_ROUNDED 13)
(defconstant PAN_LETT_OBLIQUE_OFF_CENTER 14)
(defconstant PAN_LETT_OBLIQUE_SQUARE 15)
(defconstant PAN_MIDLINE_STANDARD_TRIMMED 2)
(defconstant PAN_MIDLINE_STANDARD_POINTED 3)
(defconstant PAN_MIDLINE_STANDARD_SERIFED 4)
(defconstant PAN_MIDLINE_HIGH_TRIMMED 5)
(defconstant PAN_MIDLINE_HIGH_POINTED 6)
(defconstant PAN_MIDLINE_HIGH_SERIFED 7)
(defconstant PAN_MIDLINE_CONSTANT_TRIMMED 8)
(defconstant PAN_MIDLINE_CONSTANT_POINTED 9)
(defconstant PAN_MIDLINE_CONSTANT_SERIFED 10)
(defconstant PAN_MIDLINE_LOW_TRIMMED 11)
(defconstant PAN_MIDLINE_LOW_POINTED 12)
(defconstant PAN_MIDLINE_LOW_SERIFED 13)
(defconstant PAN_XHEIGHT_CONSTANT_SMALL 2)
(defconstant PAN_XHEIGHT_CONSTANT_STD 3)
(defconstant PAN_XHEIGHT_CONSTANT_LARGE 4)
(defconstant PAN_XHEIGHT_DUCKING_SMALL 5)
(defconstant PAN_XHEIGHT_DUCKING_STD 6)
(defconstant PAN_XHEIGHT_DUCKING_LARGE 7)
(defconstant FS_LATIN1 1)
(defconstant FS_LATIN2 2)
(defconstant FS_CYRILLIC 4)
(defconstant FS_GREEK 8)
(defconstant FS_TURKISH 16)
(defconstant FS_HEBREW 32)
(defconstant FS_ARABIC 64)
(defconstant FS_BALTIC 128)
(defconstant FS_THAI #x10000)
(defconstant FS_JISJAPAN #x20000)
(defconstant FS_CHINESESIMP #x40000)
(defconstant FS_WANSUNG #x80000)
(defconstant FS_CHINESETRAD #x100000)
(defconstant FS_JOHAB #x200000)
(defconstant FS_SYMBOL #x80000000)
(defconstant HS_BDIAGONAL 3)
(defconstant HS_CROSS 4)
(defconstant HS_DIAGCROSS 5)
(defconstant HS_FDIAGONAL 2)
(defconstant HS_HORIZONTAL 0)
(defconstant HS_VERTICAL 1)
(defconstant PS_GEOMETRIC 65536)
(defconstant PS_COSMETIC 0)
(defconstant PS_ALTERNATE 8)
(defconstant PS_SOLID 0)
(defconstant PS_DASH 1)
(defconstant PS_DOT 2)
(defconstant PS_DASHDOT 3)
(defconstant PS_DASHDOTDOT 4)
(defconstant PS_NULL 5)
(defconstant PS_USERSTYLE 7)
(defconstant PS_INSIDEFRAME 6)
(defconstant PS_ENDCAP_ROUND 0)
(defconstant PS_ENDCAP_SQUARE 256)
(defconstant PS_ENDCAP_FLAT 512)
(defconstant PS_JOIN_BEVEL 4096)
(defconstant PS_JOIN_MITER 8192)
(defconstant PS_JOIN_ROUND 0)
(defconstant PS_STYLE_MASK 15)
(defconstant PS_ENDCAP_MASK 3840)
(defconstant PS_TYPE_MASK 983040)
(defconstant ALTERNATE 1)
(defconstant WINDING 2)
(defconstant DC_BINNAMES 12)
(defconstant DC_BINS 6)
(defconstant DC_COPIES 18)
(defconstant DC_DRIVER 11)
(defconstant DC_DATATYPE_PRODUCED 21)
(defconstant DC_DUPLEX 7)
(defconstant DC_EMF_COMPLIANT 20)
(defconstant DC_ENUMRESOLUTIONS 13)
(defconstant DC_EXTRA 9)
(defconstant DC_FIELDS 1)
(defconstant DC_FILEDEPENDENCIES 14)
(defconstant DC_MAXEXTENT 5)
(defconstant DC_MINEXTENT 4)
(defconstant DC_ORIENTATION 17)
(defconstant DC_PAPERNAMES 16)
(defconstant DC_PAPERS 2)
(defconstant DC_PAPERSIZE 3)
(defconstant DC_SIZE 8)
(defconstant DC_TRUETYPE 15)
(defconstant DCTT_BITMAP 1)
(defconstant DCTT_DOWNLOAD 2)
(defconstant DCTT_SUBDEV 4)
(defconstant DCTT_DOWNLOAD_OUTLINE 8)
(defconstant DC_VERSION 10)
(defconstant DC_BINADJUST 19)
(defconstant DC_EMF_COMPLIANT 20)
(defconstant DC_DATATYPE_PRODUCED 21)
(defconstant DC_MANUFACTURER 23)
(defconstant DC_MODEL 24)
(defconstant DCBA_FACEUPNONE 0)
(defconstant DCBA_FACEUPCENTER 1)
(defconstant DCBA_FACEUPLEFT 2)
(defconstant DCBA_FACEUPRIGHT 3)
(defconstant DCBA_FACEDOWNNONE 256)
(defconstant DCBA_FACEDOWNCENTER 257)
(defconstant DCBA_FACEDOWNLEFT 258)
(defconstant DCBA_FACEDOWNRIGHT 259)
(defconstant FLOODFILLBORDER 0)
(defconstant FLOODFILLSURFACE 1)
(defconstant ETO_CLIPPED 4)
(defconstant ETO_GLYPH_INDEX 16)
(defconstant ETO_OPAQUE 2)
(defconstant ETO_RTLREADING 128)
(defconstant GDICOMMENT_BEGINGROUP 2)
(defconstant GDICOMMENT_ENDGROUP 3)
(defconstant GDICOMMENT_MULTIFORMATS 1073741828)
(defconstant GDICOMMENT_IDENTIFIER 1128875079)
(defconstant AD_COUNTERCLOCKWISE 1)
(defconstant AD_CLOCKWISE 2)
(defconstant RDH_RECTANGLES 1)
(defconstant GCPCLASS_LATIN 1)
(defconstant GCPCLASS_HEBREW 2)
(defconstant GCPCLASS_ARABIC 2)
(defconstant GCPCLASS_NEUTRAL 3)
(defconstant GCPCLASS_LOCALNUMBER 4)
(defconstant GCPCLASS_LATINNUMBER 5)
(defconstant GCPCLASS_LATINNUMERICTERMINATOR 6)
(defconstant GCPCLASS_LATINNUMERICSEPARATOR 7)
(defconstant GCPCLASS_NUMERICSEPARATOR 8)
(defconstant GCPCLASS_PREBOUNDLTR 128)
(defconstant GCPCLASS_PREBOUNDRTL 64)
(defconstant GCPCLASS_POSTBOUNDLTR 32)
(defconstant GCPCLASS_POSTBOUNDRTL 16)
(defconstant GCPGLYPH_LINKBEFORE #x8000)
(defconstant GCPGLYPH_LINKAFTER #x4000)
(defconstant DCB_DISABLE 8)
(defconstant DCB_ENABLE 4)
(defconstant DCB_RESET 1)
(defconstant DCB_SET 3)
(defconstant DCB_ACCUMULATE 2)
(defconstant DCB_DIRTY 2)
(defconstant OBJ_BRUSH 2)
(defconstant OBJ_PEN 1)
(defconstant OBJ_PAL 5)
(defconstant OBJ_FONT 6)
(defconstant OBJ_BITMAP 7)
(defconstant OBJ_EXTPEN 11)
(defconstant OBJ_REGION 8)
(defconstant OBJ_DC 3)
(defconstant OBJ_MEMDC 10)
(defconstant OBJ_METAFILE 9)
(defconstant OBJ_METADC 4)
(defconstant OBJ_ENHMETAFILE 13)
(defconstant OBJ_ENHMETADC 12)
(defconstant DRIVERVERSION 0)
(defconstant TECHNOLOGY 2)
(defconstant DT_PLOTTER 0)
(defconstant DT_RASDISPLAY 1)
(defconstant DT_RASPRINTER 2)
(defconstant DT_RASCAMERA 3)
(defconstant DT_CHARSTREAM 4)
(defconstant DT_METAFILE 5)
(defconstant DT_DISPFILE 6)
(defconstant HORZSIZE 4)
(defconstant VERTSIZE 6)
(defconstant HORZRES 8)
(defconstant VERTRES 10)
(defconstant LOGPIXELSX 88)
(defconstant LOGPIXELSY 90)
(defconstant BITSPIXEL 12)
(defconstant PLANES 14)
(defconstant NUMBRUSHES 16)
(defconstant NUMPENS 18)
(defconstant NUMFONTS 22)
(defconstant NUMCOLORS 24)
(defconstant NUMMARKERS 20)
(defconstant ASPECTX 40)
(defconstant ASPECTY 42)
(defconstant ASPECTXY 44)
(defconstant PDEVICESIZE 26)
(defconstant CLIPCAPS 36)
(defconstant SIZEPALETTE 104)
(defconstant NUMRESERVED 106)
(defconstant COLORRES 108)
(defconstant PHYSICALWIDTH 110)
(defconstant PHYSICALHEIGHT 111)
(defconstant PHYSICALOFFSETX 112)
(defconstant PHYSICALOFFSETY 113)
(defconstant SCALINGFACTORX 114)
(defconstant SCALINGFACTORY 115)
(defconstant VREFRESH 116)
(defconstant DESKTOPHORZRES 118)
(defconstant DESKTOPVERTRES 117)
(defconstant BLTALIGNMENT 119)
(defconstant RASTERCAPS 38)
(defconstant RC_BANDING 2)
(defconstant RC_BITBLT 1)
(defconstant RC_BITMAP64 8)
(defconstant RC_DI_BITMAP 128)
(defconstant RC_DIBTODEV 512)
(defconstant RC_FLOODFILL 4096)
(defconstant RC_GDI20_OUTPUT 16)
(defconstant RC_PALETTE 256)
(defconstant RC_SCALING 4)
(defconstant RC_STRETCHBLT 2048)
(defconstant RC_STRETCHDIB 8192)
(defconstant RC_DEVBITS #x8000)
(defconstant RC_OP_DX_OUTPUT #x4000)
(defconstant CURVECAPS 28)
(defconstant CC_NONE 0)
(defconstant CC_CIRCLES 1)
(defconstant CC_PIE 2)
(defconstant CC_CHORD 4)
(defconstant CC_ELLIPSES 8)
(defconstant CC_WIDE 16)
(defconstant CC_STYLED 32)
(defconstant CC_WIDESTYLED 64)
(defconstant CC_INTERIORS 128)
(defconstant CC_ROUNDRECT 256)
(defconstant LINECAPS 30)
(defconstant LC_NONE 0)
(defconstant LC_POLYLINE 2)
(defconstant LC_MARKER 4)
(defconstant LC_POLYMARKER 8)
(defconstant LC_WIDE 16)
(defconstant LC_STYLED 32)
(defconstant LC_WIDESTYLED 64)
(defconstant LC_INTERIORS 128)
(defconstant POLYGONALCAPS 32)
(defconstant RC_BANDING 2)
(defconstant RC_BIGFONT 1024)
(defconstant RC_BITBLT 1)
(defconstant RC_BITMAP64 8)
(defconstant RC_DEVBITS #x8000)
(defconstant RC_DI_BITMAP 128)
(defconstant RC_GDI20_OUTPUT 16)
(defconstant RC_GDI20_STATE 32)
(defconstant RC_NONE 0)
(defconstant RC_OP_DX_OUTPUT #x4000)
(defconstant RC_PALETTE 256)
(defconstant RC_SAVEBITMAP 64)
(defconstant RC_SCALING 4)
(defconstant PC_NONE 0)
(defconstant PC_POLYGON 1)
(defconstant PC_POLYPOLYGON 256)
(defconstant PC_PATHS 512)
(defconstant PC_RECTANGLE 2)
(defconstant PC_WINDPOLYGON 4)
(defconstant PC_SCANLINE 8)
(defconstant PC_TRAPEZOID 4)
(defconstant PC_WIDE 16)
(defconstant PC_STYLED 32)
(defconstant PC_WIDESTYLED 64)
(defconstant PC_INTERIORS 128)
(defconstant PC_PATHS 512)
(defconstant TEXTCAPS 34)
(defconstant TC_OP_CHARACTER 1)
(defconstant TC_OP_STROKE 2)
(defconstant TC_CP_STROKE 4)
(defconstant TC_CR_90 8)
(defconstant TC_CR_ANY 16)
(defconstant TC_SF_X_YINDEP 32)
(defconstant TC_SA_DOUBLE 64)
(defconstant TC_SA_INTEGER 128)
(defconstant TC_SA_CONTIN 256)
(defconstant TC_EA_DOUBLE 512)
(defconstant TC_IA_ABLE 1024)
(defconstant TC_UA_ABLE 2048)
(defconstant TC_SO_ABLE 4096)
(defconstant TC_RA_ABLE 8192)
(defconstant TC_VA_ABLE 16384)
(defconstant TC_RESERVED 32768)
(defconstant TC_SCROLLBLT 65536)
(defconstant GCP_DBCS 1)
(defconstant GCP_ERROR #x8000)
(defconstant GCP_CLASSIN #x80000)
(defconstant GCP_DIACRITIC 256)
(defconstant GCP_DISPLAYZWG #x400000)
(defconstant GCP_GLYPHSHAPE 16)
(defconstant GCP_JUSTIFY #x10000)
(defconstant GCP_JUSTIFYIN #x200000)
(defconstant GCP_KASHIDA 1024)
(defconstant GCP_LIGATE 32)
(defconstant GCP_MAXEXTENT #x100000)
(defconstant GCP_NEUTRALOVERRIDE #x2000000)
(defconstant GCP_NUMERICOVERRIDE #x1000000)
(defconstant GCP_NUMERICSLATIN #x4000000)
(defconstant GCP_NUMERICSLOCAL #x8000000)
(defconstant GCP_REORDER 2)
(defconstant GCP_SYMSWAPOFF #x800000)
(defconstant GCP_USEKERNING 8)
(defconstant FLI_GLYPHS #x40000)
(defconstant GGO_BITMAP 1)
(defconstant GGO_NATIVE 2)
(defconstant GGO_METRICS 0)
(defconstant GGO_GRAY2_BITMAP 4)
(defconstant GGO_GRAY4_BITMAP 5)
(defconstant GGO_GRAY8_BITMAP 6)
(defconstant GGO_GLYPH_INDEX 128)
(defconstant GM_COMPATIBLE 1)
(defconstant GM_ADVANCED 2)
(defconstant MM_ANISOTROPIC 8)
(defconstant MM_HIENGLISH 5)
(defconstant MM_HIMETRIC 3)
(defconstant MM_ISOTROPIC 7)
(defconstant MM_LOENGLISH 4)
(defconstant MM_LOMETRIC 2)
(defconstant MM_TEXT 1)
(defconstant MM_TWIPS 6)
(defconstant ABSOLUTE 1)
(defconstant RELATIVE 2)
(defconstant PC_EXPLICIT 2)
(defconstant PC_NOCOLLAPSE 4)
(defconstant PC_RESERVED 1)
(defconstant CLR_DEFAULT #xff000000)
(defconstant PT_MOVETO 6)
(defconstant PT_LINETO 2)
(defconstant PT_BEZIERTO 4)
(defconstant PT_CLOSEFIGURE 1)
(defconstant TT_AVAILABLE 1)
(defconstant TT_ENABLED 2)
(defconstant BLACK_BRUSH 4)
(defconstant DKGRAY_BRUSH 3)
(defconstant GRAY_BRUSH 2)
(defconstant HOLLOW_BRUSH 5)
(defconstant LTGRAY_BRUSH 1)
(defconstant NULL_BRUSH 5)
(defconstant WHITE_BRUSH 0)
(defconstant BLACK_PEN 7)
(defconstant NULL_PEN 8)
(defconstant WHITE_PEN 6)
(defconstant ANSI_FIXED_FONT 11)
(defconstant ANSI_VAR_FONT 12)
(defconstant DEVICE_DEFAULT_FONT 14)
(defconstant DEFAULT_GUI_FONT 17)
(defconstant OEM_FIXED_FONT 10)
(defconstant SYSTEM_FONT 13)
(defconstant SYSTEM_FIXED_FONT 16)
(defconstant DEFAULT_PALETTE 15)
(defconstant SYSPAL_NOSTATIC 2)
(defconstant SYSPAL_STATIC 1)
(defconstant SYSPAL_ERROR 0)
(defconstant TA_BASELINE 24)
(defconstant TA_BOTTOM 8)
(defconstant TA_TOP 0)
(defconstant TA_CENTER 6)
(defconstant TA_LEFT 0)
(defconstant TA_RIGHT 2)
(defconstant TA_RTLREADING 256)
(defconstant TA_NOUPDATECP 0)
(defconstant TA_UPDATECP 1)
(defconstant VTA_BASELINE 24)
(defconstant VTA_CENTER 6)
(defconstant MWT_IDENTITY 1)
(defconstant MWT_LEFTMULTIPLY 2)
(defconstant MWT_RIGHTMULTIPLY 3)
(defconstant OPAQUE 2)
(defconstant TRANSPARENT 1)
(defconstant BLACKONWHITE 1)
(defconstant WHITEONBLACK 2)
(defconstant COLORONCOLOR 3)
(defconstant HALFTONE 4)
(defconstant MAXSTRETCHBLTMODE 4)
(defconstant STRETCH_ANDSCANS 1)
(defconstant STRETCH_DELETESCANS 3)
(defconstant STRETCH_HALFTONE 4)
(defconstant STRETCH_ORSCANS 2)
(defconstant TCI_SRCCHARSET 1)
(defconstant TCI_SRCCODEPAGE 2)
(defconstant TCI_SRCFONTSIG 3)
(defconstant ICM_ON 2)
(defconstant ICM_OFF 1)
(defconstant ICM_QUERY 3)
(defconstant NEWFRAME 1)
(defconstant ABORTDOC 2)
(defconstant NEXTBAND 3)
(defconstant SETCOLORTABLE 4)
(defconstant GETCOLORTABLE 5)
(defconstant FLUSHOUTPUT 6)
(defconstant DRAFTMODE 7)
(defconstant QUERYESCSUPPORT 8)
(defconstant SETABORTPROC 9)
(defconstant STARTDOC 10)
(defconstant ENDDOC 11)
(defconstant GETPHYSPAGESIZE 12)
(defconstant GETPRINTINGOFFSET 13)
(defconstant GETSCALINGFACTOR 14)
(defconstant MFCOMMENT 15)
(defconstant GETPENWIDTH 16)
(defconstant SETCOPYCOUNT 17)
(defconstant SELECTPAPERSOURCE 18)
(defconstant DEVICEDATA 19)
(defconstant PASSTHROUGH 19)
(defconstant GETTECHNOLGY 20)
(defconstant GETTECHNOLOGY 20)
(defconstant SETLINECAP 21)
(defconstant SETLINEJOIN 22)
(defconstant SETMITERLIMIT 23)
(defconstant BANDINFO 24)
(defconstant DRAWPATTERNRECT 25)
(defconstant GETVECTORPENSIZE 26)
(defconstant GETVECTORBRUSHSIZE 27)
(defconstant ENABLEDUPLEX 28)
(defconstant GETSETPAPERBINS 29)
(defconstant GETSETPRINTORIENT 30)
(defconstant ENUMPAPERBINS 31)
(defconstant SETDIBSCALING 32)
(defconstant EPSPRINTING 33)
(defconstant ENUMPAPERMETRICS 34)
(defconstant GETSETPAPERMETRICS 35)
(defconstant POSTSCRIPT_DATA 37)
(defconstant POSTSCRIPT_IGNORE 38)
(defconstant MOUSETRAILS 39)
(defconstant GETDEVICEUNITS 42)
(defconstant GETEXTENDEDTEXTMETRICS 256)
(defconstant GETEXTENTTABLE 257)
(defconstant GETPAIRKERNTABLE 258)
(defconstant GETTRACKKERNTABLE 259)
(defconstant EXTTEXTOUT 512)
(defconstant GETFACENAME 513)
(defconstant DOWNLOADFACE 514)
(defconstant ENABLERELATIVEWIDTHS 768)
(defconstant ENABLEPAIRKERNING 769)
(defconstant SETKERNTRACK 770)
(defconstant SETALLJUSTVALUES 771)
(defconstant SETCHARSET 772)
(defconstant STRETCHBLT 2048)
(defconstant GETSETSCREENPARAMS 3072)
(defconstant QUERYDIBSUPPORT 3073)
(defconstant BEGIN_PATH 4096)
(defconstant CLIP_TO_PATH 4097)
(defconstant END_PATH 4098)
(defconstant EXT_DEVICE_CAPS 4099)
(defconstant RESTORE_CTM 4100)
(defconstant SAVE_CTM 4101)
(defconstant SET_ARC_DIRECTION 4102)
(defconstant SET_BACKGROUND_COLOR 4103)
(defconstant SET_POLY_MODE 4104)
(defconstant SET_SCREEN_ANGLE 4105)
(defconstant SET_SPREAD 4106)
(defconstant TRANSFORM_CTM 4107)
(defconstant SET_CLIP_BOX 4108)
(defconstant SET_BOUNDS 4109)
(defconstant SET_MIRROR_MODE 4110)
(defconstant OPENCHANNEL 4110)
(defconstant DOWNLOADHEADER 4111)
(defconstant CLOSECHANNEL 4112)
(defconstant POSTSCRIPT_PASSTHROUGH 4115)
(defconstant ENCAPSULATED_POSTSCRIPT 4116)
(defconstant QDI_SETDIBITS 1)
(defconstant QDI_GETDIBITS 2)
(defconstant QDI_DIBTOSCREEN 4)
(defconstant QDI_STRETCHDIB 8)
(defconstant SP_NOTREPORTED #x4000)
(defconstant PR_JOBSTATUS 0)
(defconstant ASPECT_FILTERING 1)
(defconstant BS_SOLID 0)
(defconstant BS_NULL 1)
(defconstant BS_HOLLOW 1)
(defconstant BS_HATCHED 2)
(defconstant BS_PATTERN 3)
(defconstant BS_INDEXED 4)
(defconstant BS_DIBPATTERN 5)
(defconstant BS_DIBPATTERNPT 6)
(defconstant BS_PATTERN8X8 7)
(defconstant BS_DIBPATTERN8X8 8)
(defconstant LCS_CALIBRATED_RGB 0)
(defconstant LCS_DEVICE_RGB 1)
(defconstant LCS_DEVICE_CMYK 2)
(defconstant LCS_GM_BUSINESS 1)
(defconstant LCS_GM_GRAPHICS 2)
(defconstant LCS_GM_IMAGES 4)
(defconstant RASTER_FONTTYPE 1)
(defconstant DEVICE_FONTTYPE 2)
(defconstant TRUETYPE_FONTTYPE 4)
(defconstant DMORIENT_PORTRAIT 1)
(defconstant DMORIENT_LANDSCAPE 2)
(defconstant DMPAPER_FIRST 1)
(defconstant DMPAPER_LETTER 1)
(defconstant DMPAPER_LETTERSMALL 2)
(defconstant DMPAPER_TABLOID 3)
(defconstant DMPAPER_LEDGER 4)
(defconstant DMPAPER_LEGAL 5)
(defconstant DMPAPER_STATEMENT 6)
(defconstant DMPAPER_EXECUTIVE 7)
(defconstant DMPAPER_A3 8)
(defconstant DMPAPER_A4 9)
(defconstant DMPAPER_A4SMALL 10)
(defconstant DMPAPER_A5 11)
(defconstant DMPAPER_B4 12)
(defconstant DMPAPER_B5 13)
(defconstant DMPAPER_FOLIO 14)
(defconstant DMPAPER_QUARTO 15)
(defconstant DMPAPER_10X14 16)
(defconstant DMPAPER_11X17 17)
(defconstant DMPAPER_NOTE 18)
(defconstant DMPAPER_ENV_9 19)
(defconstant DMPAPER_ENV_10 20)
(defconstant DMPAPER_ENV_11 21)
(defconstant DMPAPER_ENV_12 22)
(defconstant DMPAPER_ENV_14 23)
(defconstant DMPAPER_CSHEET 24)
(defconstant DMPAPER_DSHEET 25)
(defconstant DMPAPER_ESHEET 26)
(defconstant DMPAPER_ENV_DL 27)
(defconstant DMPAPER_ENV_C5 28)
(defconstant DMPAPER_ENV_C3 29)
(defconstant DMPAPER_ENV_C4 30)
(defconstant DMPAPER_ENV_C6 31)
(defconstant DMPAPER_ENV_C65 32)
(defconstant DMPAPER_ENV_B4 33)
(defconstant DMPAPER_ENV_B5 34)
(defconstant DMPAPER_ENV_B6 35)
(defconstant DMPAPER_ENV_ITALY 36)
(defconstant DMPAPER_ENV_MONARCH 37)
(defconstant DMPAPER_ENV_PERSONAL 38)
(defconstant DMPAPER_FANFOLD_US 39)
(defconstant DMPAPER_FANFOLD_STD_GERMAN 40)
(defconstant DMPAPER_FANFOLD_LGL_GERMAN 41)
(defconstant DMPAPER_ISO_B4 42)
(defconstant DMPAPER_JAPANESE_POSTCARD 43)
(defconstant DMPAPER_9X11 44)
(defconstant DMPAPER_10X11 45)
(defconstant DMPAPER_15X11 46)
(defconstant DMPAPER_ENV_INVITE 47)
(defconstant DMPAPER_RESERVED_48 48)
(defconstant DMPAPER_RESERVED_49 49)
(defconstant DMPAPER_LETTER_EXTRA 50)
(defconstant DMPAPER_LEGAL_EXTRA 51)
(defconstant DMPAPER_TABLOID_EXTRA 52)
(defconstant DMPAPER_A4_EXTRA 53)
(defconstant DMPAPER_LETTER_TRANSVERSE 54)
(defconstant DMPAPER_A4_TRANSVERSE 55)
(defconstant DMPAPER_LETTER_EXTRA_TRANSVERSE 56)
(defconstant DMPAPER_A_PLUS 57)
(defconstant DMPAPER_B_PLUS 58)
(defconstant DMPAPER_LETTER_PLUS 59)
(defconstant DMPAPER_A4_PLUS 60)
(defconstant DMPAPER_A5_TRANSVERSE 61)
(defconstant DMPAPER_B5_TRANSVERSE 62)
(defconstant DMPAPER_A3_EXTRA 63)
(defconstant DMPAPER_A5_EXTRA 64)
(defconstant DMPAPER_B5_EXTRA 65)
(defconstant DMPAPER_A2 66)
(defconstant DMPAPER_A3_TRANSVERSE 67)
(defconstant DMPAPER_A3_EXTRA_TRANSVERSE 68)
(defconstant DMPAPER_LAST 68)
(defconstant DMPAPER_USER 256)
(defconstant DMBIN_FIRST 1)
(defconstant DMBIN_UPPER 1)
(defconstant DMBIN_ONLYONE 1)
(defconstant DMBIN_LOWER 2)
(defconstant DMBIN_MIDDLE 3)
(defconstant DMBIN_MANUAL 4)
(defconstant DMBIN_ENVELOPE 5)
(defconstant DMBIN_ENVMANUAL 6)
(defconstant DMBIN_AUTO 7)
(defconstant DMBIN_TRACTOR 8)
(defconstant DMBIN_SMALLFMT 9)
(defconstant DMBIN_LARGEFMT 10)
(defconstant DMBIN_LARGECAPACITY 11)
(defconstant DMBIN_CASSETTE 14)
(defconstant DMBIN_FORMSOURCE 15)
(defconstant DMBIN_LAST 15)
(defconstant DMBIN_USER 256)
(defconstant DMCOLOR_MONOCHROME 1)
(defconstant DMCOLOR_COLOR 2)
(defconstant DMDUP_SIMPLEX 1)
(defconstant DMDUP_VERTICAL 2)
(defconstant DMDUP_HORIZONTAL 3)
(defconstant DMTT_BITMAP 1)
(defconstant DMTT_DOWNLOAD 2)
(defconstant DMTT_SUBDEV 3)
(defconstant DMTT_DOWNLOAD_OUTLINE 4)
(defconstant DMCOLLATE_FALSE 0)
(defconstant DMCOLLATE_TRUE 1)
(defconstant DM_GRAYSCALE 1)
(defconstant DM_INTERLACED 2)
(defconstant DM_UPDATE 1)
(defconstant DM_COPY 2)
(defconstant DM_PROMPT 4)
(defconstant DM_MODIFY 8)
(defconstant DM_ORIENTATION 1)
(defconstant DM_PAPERSIZE 2)
(defconstant DM_PAPERLENGTH 4)
(defconstant DM_PAPERWIDTH 8)
(defconstant DM_SCALE 16)
(defconstant DM_COPIES 256)
(defconstant DM_DEFAULTSOURCE 512)
(defconstant DM_PRINTQUALITY 1024)
(defconstant DM_COLOR 2048)
(defconstant DM_DUPLEX 4096)
(defconstant DM_YRESOLUTION 8192)
(defconstant DM_TTOPTION 16384)
(defconstant DM_COLLATE 32768)
(defconstant DM_FORMNAME 65536)
(defconstant DM_LOGPIXELS #x20000)
(defconstant DM_BITSPERPEL #x40000)
(defconstant DM_PELSWIDTH #x80000)
(defconstant DM_PELSHEIGHT #x100000)
(defconstant DM_DISPLAYFLAGS #x200000)
(defconstant DM_DISPLAYFREQUENCY #x400000)
(defconstant DM_ICMMETHOD #x800000)
(defconstant DM_ICMINTENT #x1000000)
(defconstant DM_MEDIATYPE #x2000000)
(defconstant DM_DITHERTYPE #x4000000)
(defconstant DMICMMETHOD_NONE 1)
(defconstant DMICMMETHOD_SYSTEM 2)
(defconstant DMICMMETHOD_DRIVER 3)
(defconstant DMICMMETHOD_DEVICE 4)
(defconstant DMICMMETHOD_USER 256)
(defconstant DMICM_SATURATE 1)
(defconstant DMICM_CONTRAST 2)
(defconstant DMICM_COLORMETRIC 3)
(defconstant DMICM_USER 256)
(defconstant DMMEDIA_STANDARD 1)
(defconstant DMMEDIA_TRANSPARENCY 2)
(defconstant DMMEDIA_GLOSSY 3)
(defconstant DMMEDIA_USER 256)
(defconstant DMDITHER_NONE 1)
(defconstant DMDITHER_COARSE 2)
(defconstant DMDITHER_FINE 3)
(defconstant DMDITHER_LINEART 4)
(defconstant DMDITHER_ERRORDIFFUSION 5)
(defconstant DMDITHER_RESERVED6 6)
(defconstant DMDITHER_RESERVED7 7)
(defconstant DMDITHER_RESERVED8 8)
(defconstant DMDITHER_RESERVED9 9)
(defconstant DMDITHER_GRAYSCALE 10)
(defconstant DMDITHER_USER 256)
(defconstant TMPF_FIXED_PITCH 1)
(defconstant TMPF_VECTOR 2)
(defconstant TMPF_TRUETYPE 4)
(defconstant TMPF_DEVICE 8)
(defconstant NTM_ITALIC 1)
(defconstant NTM_BOLD 32)
(defconstant NTM_REGULAR 64)
(defconstant TT_POLYGON_TYPE 24)
(defconstant TT_PRIM_LINE 1)
(defconstant TT_PRIM_QSPLINE 2)
(defconstant FONTMAPPER_MAX 10)
(defconstant ENHMETA_STOCK_OBJECT #x80000000)
(defconstant WGL_FONT_LINES 0)
(defconstant WGL_FONT_POLYGONS 1)
(defconstant LPD_DOUBLEBUFFER 1)
(defconstant LPD_STEREO 2)
(defconstant LPD_SUPPORT_GDI 16)
(defconstant LPD_SUPPORT_OPENGL 32)
(defconstant LPD_SHARE_DEPTH 64)
(defconstant LPD_SHARE_STENCIL 128)
(defconstant LPD_SHARE_ACCUM 256)
(defconstant LPD_SWAP_EXCHANGE 512)
(defconstant LPD_SWAP_COPY 1024)
(defconstant LPD_TRANSPARENT 4096)
(defconstant LPD_TYPE_RGBA 0)
(defconstant LPD_TYPE_COLORINDEX 1)
(defconstant WGL_SWAP_MAIN_PLANE 1)
(defconstant WGL_SWAP_OVERLAY1 2)
(defconstant WGL_SWAP_OVERLAY2 4)
(defconstant WGL_SWAP_OVERLAY3 8)
(defconstant WGL_SWAP_OVERLAY4 16)
(defconstant WGL_SWAP_OVERLAY5 32)
(defconstant WGL_SWAP_OVERLAY6 64)
(defconstant WGL_SWAP_OVERLAY7 128)
(defconstant WGL_SWAP_OVERLAY8 256)
(defconstant WGL_SWAP_OVERLAY9 512)
(defconstant WGL_SWAP_OVERLAY10 1024)
(defconstant WGL_SWAP_OVERLAY11 2048)
(defconstant WGL_SWAP_OVERLAY12 4096)
(defconstant WGL_SWAP_OVERLAY13 8192)
(defconstant WGL_SWAP_OVERLAY14 16384)
(defconstant WGL_SWAP_OVERLAY15 32768)
(defconstant WGL_SWAP_UNDERLAY1 65536)
(defconstant WGL_SWAP_UNDERLAY2 #x20000)
(defconstant WGL_SWAP_UNDERLAY3 #x40000)
(defconstant WGL_SWAP_UNDERLAY4 #x80000)
(defconstant WGL_SWAP_UNDERLAY5 #x100000)
(defconstant WGL_SWAP_UNDERLAY6 #x200000)
(defconstant WGL_SWAP_UNDERLAY7 #x400000)
(defconstant WGL_SWAP_UNDERLAY8 #x800000)
(defconstant WGL_SWAP_UNDERLAY9 #x1000000)
(defconstant WGL_SWAP_UNDERLAY10 #x2000000)
(defconstant WGL_SWAP_UNDERLAY11 #x4000000)
(defconstant WGL_SWAP_UNDERLAY12 #x8000000)
(defconstant WGL_SWAP_UNDERLAY13 #x10000000)
(defconstant WGL_SWAP_UNDERLAY14 #x20000000)
(defconstant WGL_SWAP_UNDERLAY15 #x40000000)
(defconstant WS_BORDER	#x800000)
(defconstant WS_CAPTION	#xc00000)
(defconstant WS_CHILD	#x40000000)
(defconstant WS_CHILDWINDOW	#x40000000)
(defconstant WS_CLIPCHILDREN #x2000000)
(defconstant WS_CLIPSIBLINGS #x4000000)
(defconstant WS_DISABLED	#x8000000)
(defconstant WS_DLGFRAME	#x400000)
(defconstant WS_GROUP	#x20000)
(defconstant WS_HSCROLL	#x100000)
(defconstant WS_ICONIC	#x20000000)
(defconstant WS_MAXIMIZE	#x1000000)
(defconstant WS_MAXIMIZEBOX	#x10000)
(defconstant WS_MINIMIZE	#x20000000)
(defconstant WS_MINIMIZEBOX	#x20000)
(defconstant WS_OVERLAPPED	0)
(defconstant WS_OVERLAPPEDWINDOW	#xcf0000)
(defconstant WS_POPUP	#x80000000)
(defconstant WS_POPUPWINDOW	#x80880000)
(defconstant WS_SIZEBOX	#x40000)
(defconstant WS_SYSMENU	#x80000)
(defconstant WS_TABSTOP	#x10000)
(defconstant WS_THICKFRAME	#x40000)
(defconstant WS_TILED	0)
(defconstant WS_TILEDWINDOW	#xcf0000)
(defconstant WS_VISIBLE	#x10000000)
(defconstant WS_VSCROLL	#x200000)
(defconstant WS_EX_ACCEPTFILES 16)
(defconstant WS_EX_APPWINDOW #x40000)
(defconstant WS_EX_CLIENTEDGE 512)
(defconstant WS_EX_CONTEXTHELP #x400)
(defconstant WS_EX_CONTROLPARENT #x10000)
(defconstant WS_EX_DLGMODALFRAME 1)
(defconstant WS_EX_LEFT 0)
(defconstant WS_EX_LEFTSCROLLBAR #x4000)
(defconstant WS_EX_LTRREADING 0)
(defconstant WS_EX_MDICHILD 64)
(defconstant WS_EX_NOPARENTNOTIFY 4)
(defconstant WS_EX_OVERLAPPEDWINDOW #x300)
(defconstant WS_EX_PALETTEWINDOW #x188)
(defconstant WS_EX_RIGHT #x1000)
(defconstant WS_EX_RIGHTSCROLLBAR 0)
(defconstant WS_EX_RTLREADING #x2000)
(defconstant WS_EX_STATICEDGE #x20000)
(defconstant WS_EX_TOOLWINDOW 128)
(defconstant WS_EX_TOPMOST 8)
(defconstant WS_EX_TRANSPARENT 32)
(defconstant WS_EX_WINDOWEDGE 256)
(defconstant IDC_STATIC 0)
(defconstant IDC_ARROW 1)
(defconstant IDC_IBEAM 2)
(defconstant IDC_WAIT 3)
(defconstant IDC_CROSS 4)
(defconstant IDC_UPARROW 5)
(defconstant IDC_SIZENWSE 6)
(defconstant IDC_SIZENESW 7)
(defconstant IDC_SIZEWE 8)
(defconstant IDC_SIZENS 9)
(defconstant IDC_SIZEALL 10)
(defconstant IDC_NO 11)
(defconstant IDC_HAND 12)
(defconstant IDC_APPSTARTING 13)
(defconstant IDC_HELP 14)
(defconstant IDC_ICON 15)
(defconstant IDC_SIZE 16)
(defconstant WM_ACTIVATE 6)
(defconstant WM_ACTIVATEAPP 28)
(defconstant WM_AFXFIRST 864)
(defconstant WM_AFXLAST 895)
(defconstant WM_ASKCBFORMATNAME 780)
(defconstant WM_CANCELJOURNAL 75)
(defconstant WM_CANCELMODE 31)
(defconstant WM_CAPTURECHANGED 533)
(defconstant WM_CHANGECBCHAIN 781)
(defconstant WM_CHAR 258)
(defconstant WM_CHARTOITEM 47)
(defconstant WM_CHILDACTIVATE 34)
(defconstant WM_CLEAR 771)
(defconstant WM_CLOSE 16)
(defconstant WM_COMMAND 273)
(defconstant WM_COMPACTING 65)
(defconstant WM_COMPAREITEM 57)
(defconstant WM_CONTEXTMENU 123)
(defconstant WM_COPY 769)
(defconstant WM_COPYDATA 74)
(defconstant WM_CREATE 1)
(defconstant WM_CTLCOLORBTN 309)
(defconstant WM_CTLCOLORDLG 310)
(defconstant WM_CTLCOLOREDIT 307)
(defconstant WM_CTLCOLORLISTBOX 308)
(defconstant WM_CTLCOLORMSGBOX 306)
(defconstant WM_CTLCOLORSCROLLBAR 311)
(defconstant WM_CTLCOLORSTATIC 312)
(defconstant WM_CUT 768)
(defconstant WM_DEADCHAR 259)
(defconstant WM_DELETEITEM 45)
(defconstant WM_DESTROY 2)
(defconstant WM_DESTROYCLIPBOARD 775)
(defconstant WM_DEVICECHANGE 537)
(defconstant WM_DEVMODECHANGE 27)
(defconstant WM_DISPLAYCHANGE 126)
(defconstant WM_DRAWCLIPBOARD 776)
(defconstant WM_DRAWITEM 43)
(defconstant WM_DROPFILES 563)
(defconstant WM_ENABLE 10)
(defconstant WM_ENDSESSION 22)
(defconstant WM_ENTERIDLE 289)
(defconstant WM_ENTERMENULOOP 529)
(defconstant WM_ENTERSIZEMOVE 561)
(defconstant WM_ERASEBKGND 20)
(defconstant WM_EXITMENULOOP 530)
(defconstant WM_EXITSIZEMOVE 562)
(defconstant WM_FONTCHANGE 29)
(defconstant WM_GETDLGCODE 135)
(defconstant WM_GETFONT 49)
(defconstant WM_GETHOTKEY 51)
(defconstant WM_GETICON 127)
(defconstant WM_GETMINMAXINFO 36)
(defconstant WM_GETTEXT 13)
(defconstant WM_GETTEXTLENGTH 14)
(defconstant WM_HANDHELDFIRST 856)
(defconstant WM_HANDHELDLAST 863)
(defconstant WM_HELP 83)
(defconstant WM_HOTKEY 786)
(defconstant WM_HSCROLL 276)
(defconstant WM_HSCROLLCLIPBOARD 782)
(defconstant WM_ICONERASEBKGND 39)
(defconstant WM_INITDIALOG 272)
(defconstant WM_INITMENU 278)
(defconstant WM_INITMENUPOPUP 279)
(defconstant WM_INPUTLANGCHANGE 81)
(defconstant WM_INPUTLANGCHANGEREQUEST 80)
(defconstant WM_KEYDOWN 256)
(defconstant WM_KEYUP 257)
(defconstant WM_KILLFOCUS 8)
(defconstant WM_MDIACTIVATE 546)
(defconstant WM_MDICASCADE 551)
(defconstant WM_MDICREATE 544)
(defconstant WM_MDIDESTROY 545)
(defconstant WM_MDIGETACTIVE 553)
(defconstant WM_MDIICONARRANGE 552)
(defconstant WM_MDIMAXIMIZE 549)
(defconstant WM_MDINEXT 548)
(defconstant WM_MDIREFRESHMENU 564)
(defconstant WM_MDIRESTORE 547)
(defconstant WM_MDISETMENU 560)
(defconstant WM_MDITILE 550)
(defconstant WM_MEASUREITEM 44)
(defconstant WM_MENUCHAR 288)
(defconstant WM_MENUSELECT 287)
(defconstant WM_NEXTMENU 531)
(defconstant WM_MOVE 3)
(defconstant WM_MOVING 534)
(defconstant WM_NCACTIVATE 134)
(defconstant WM_NCCALCSIZE 131)
(defconstant WM_NCCREATE 129)
(defconstant WM_NCDESTROY 130)
(defconstant WM_NCHITTEST 132)
(defconstant WM_NCLBUTTONDBLCLK 163)
(defconstant WM_NCLBUTTONDOWN 161)
(defconstant WM_NCLBUTTONUP 162)
(defconstant WM_NCMBUTTONDBLCLK 169)
(defconstant WM_NCMBUTTONDOWN 167)
(defconstant WM_NCMBUTTONUP 168)
(defconstant WM_NCMOUSEMOVE 160)
(defconstant WM_NCPAINT 133)
(defconstant WM_NCRBUTTONDBLCLK 166)
(defconstant WM_NCRBUTTONDOWN 164)
(defconstant WM_NCRBUTTONUP 165)
(defconstant WM_NEXTDLGCTL 40)
(defconstant WM_NEXTMENU 531)
(defconstant WM_NOTIFY 78)
(defconstant WM_NOTIFYFORMAT 85)
(defconstant WM_NULL 0)
(defconstant WM_PAINT 15)
(defconstant WM_PAINTCLIPBOARD 777)
(defconstant WM_PAINTICON 38)
(defconstant WM_PALETTECHANGED 785)
(defconstant WM_PALETTEISCHANGING 784)
(defconstant WM_PARENTNOTIFY 528)
(defconstant WM_PASTE 770)
(defconstant WM_PENWINFIRST 896)
(defconstant WM_PENWINLAST 911)
(defconstant WM_POWER 72)
(defconstant WM_POWERBROADCAST 536)
(defconstant WM_PRINT 791)
(defconstant WM_PRINTCLIENT 792)
(defconstant WM_QUERYDRAGICON 55)
(defconstant WM_QUERYENDSESSION 17)
(defconstant WM_QUERYNEWPALETTE 783)
(defconstant WM_QUERYOPEN 19)
(defconstant WM_QUEUESYNC 35)
(defconstant WM_QUIT 18)
(defconstant WM_RENDERALLFORMATS 774)
(defconstant WM_RENDERFORMAT 773)
(defconstant WM_SETCURSOR 32)
(defconstant WM_SETFOCUS 7)
(defconstant WM_SETFONT 48)
(defconstant WM_SETHOTKEY 50)
(defconstant WM_SETICON 128)
(defconstant WM_SETREDRAW 11)
(defconstant WM_SETTEXT 12)
(defconstant WM_SETTINGCHANGE 26)
(defconstant WM_SHOWWINDOW 24)
(defconstant WM_SIZE 5)
(defconstant WM_SIZECLIPBOARD 779)
(defconstant WM_SIZING 532)
(defconstant WM_SPOOLERSTATUS 42)
(defconstant WM_STYLECHANGED 125)
(defconstant WM_STYLECHANGING 124)
(defconstant WM_SYSCHAR 262)
(defconstant WM_SYSCOLORCHANGE 21)
(defconstant WM_SYSCOMMAND 274)
(defconstant WM_SYSDEADCHAR 263)
(defconstant WM_SYSKEYDOWN 260)
(defconstant WM_SYSKEYUP 261)
(defconstant WM_TCARD 82)
(defconstant WM_TIMECHANGE 30)
(defconstant WM_TIMER 275)
(defconstant WM_UNDO 772)
(defconstant WM_USER 1024)
(defconstant WM_USERCHANGED 84)
(defconstant WM_VKEYTOITEM 46)
(defconstant WM_VSCROLL 277)
(defconstant WM_VSCROLLCLIPBOARD 778)
(defconstant WM_WINDOWPOSCHANGED 71)
(defconstant WM_WINDOWPOSCHANGING 70)
(defconstant WM_WININICHANGE 26)
(defconstant WM_KEYFIRST 256)
(defconstant WM_KEYLAST 264)
(defconstant WM_SYNCPAINT  136)
(defconstant WM_MOUSEACTIVATE 33)
(defconstant WM_MOUSEMOVE 512)
(defconstant WM_LBUTTONDOWN 513)
(defconstant WM_LBUTTONUP 514)
(defconstant WM_LBUTTONDBLCLK 515)
(defconstant WM_RBUTTONDOWN 516)
(defconstant WM_RBUTTONUP 517)
(defconstant WM_RBUTTONDBLCLK 518)
(defconstant WM_MBUTTONDOWN 519)
(defconstant WM_MBUTTONUP 520)
(defconstant WM_MBUTTONDBLCLK 521)
(defconstant WM_MOUSEWHEEL 522)
(defconstant WM_MOUSEFIRST 512)
(defconstant WM_MOUSELAST 522)
(defconstant WM_MOUSEHOVER #x2A1)
(defconstant WM_MOUSELEAVE #x2A3)
(defconstant SW_HIDE 0)
(defconstant SW_NORMAL 1)
(defconstant SW_SHOWNORMAL 1)
(defconstant SW_SHOWMINIMIZED 2)
(defconstant SW_MAXIMIZE 3)
(defconstant SW_SHOWMAXIMIZED 3)
(defconstant SW_SHOWNOACTIVATE 4)
(defconstant SW_SHOW 5)
(defconstant SW_MINIMIZE 6)
(defconstant SW_SHOWMINNOACTIVE 7)
(defconstant SW_SHOWNA 8)
(defconstant SW_RESTORE 9)
(defconstant SW_SHOWDEFAULT 10)
(defconstant SW_FORCEMINIMIZE 11)
(defconstant SW_MAX  11)
(defconstant SW_PARENTCLOSING 1)
(defconstant SW_OTHERZOOM 2)
(defconstant SW_PARENTOPENING 3)
(defconstant SW_OTHERUNZOOM 4)
(defconstant SW_SCROLLCHILDREN 1)
(defconstant SW_INVALIDATE 2)
(defconstant SW_ERASE 4)

(defstruct (RGB (:constructor make-rgb (r g b))) r g b)
(defconstant *black* (make-rgb 0 0 0))
(defconstant *white* (make-rgb #xff #xff #xff))

(deftype pixarray-1-element-type ()  'bit)
(deftype pixarray-4-element-type ()  '(unsigned-byte 4))
(deftype pixarray-8-element-type ()  '(unsigned-byte 8))
(deftype pixarray-16-element-type () '(unsigned-byte 16))
(deftype pixarray-24-element-type () '(unsigned-byte 24))
(deftype pixarray-32-element-type () '(unsigned-byte 32))

(defstruct (rect (:constructor make-rect (&optional left top right bottom)))
   left top right bottom)

(defstruct (point (:constructor make-point (&optional x y)))
  (x 0 :type integer) (y 0 :type integer))
(defstruct (point-float (:constructor make-point-float (&optional x y)))
  (x 0.0 :type short-float) (y 0.0 :type short-float))

(defstruct (logfont (:constructor make-logfont (&optional
   lfheight lfwidth lfescapement lforientation lfweight lfitalic
   lfunderline lfstrikeout lfcharset lfoutprecision lfclipprecision
   lfquality lfpitchandfamily lffacename)))
   (lfheight 0 :type fixnum)
   (lfwidth 0 :type fixnum)
   (lfescapement 0 :type fixnum)
   (lforientation 0 :type fixnum)
   (lfweight 0 :type fixnum)
   (lfitalic 0 :type fixnum)
   (lfunderline 0 :type fixnum)
   (lfstrikeout 0 :type fixnum)
   (lfcharset 0 :type fixnum)
   (lfoutprecision 0 :type fixnum)
   (lfclipprecision 0 :type fixnum)
   (lfquality 0 :type fixnum)
   (lfpitchandfamily 0 :type fixnum)
   (lffacename "" :type string))

(defstruct (createstruct (:constructor make-createstruct (&optional
   dwexstyle lpszclass lpszname style x y cx cy hwndparent hmenu 
   hinstance lpcreateparams)))
   (dwexstyle 0 :type (unsigned 32))
   (lpszclass "" :type string)
   (lpszname "" :type string)
   (style 0 :type (unsigned 32))
   (x 0 :type fixnum)
   (y 0 :type fixnum)
   (cx 0 :type fixnum)
   (cy 0 :type fixnum)
   (hwndparent 0 :type foreign)
   (hmenu 0 :type foreign)
   (hinstance 0 :type foreign)
   (lpcreateparams 0 :type foreign))

(defstruct (iconinfo (:constructor make-iconinfo (&optional
	fIcon xHotspot yHotspot hbmMask hbmColor)))
	fIcon
	xHotspot
	yHotspot
	hbmMask
	hbmColor)

(defstruct (wndclass (:constructor make-wndclass (&optional
   style cbclsextra cbwndextra hinstance hicon hcursor
   hbrbackground lpszmenuname lpszclassname)))
   (style 0 :type fixnum)
   (cbclsextra 0 :type fixnum)
   (cbwndextra 0 :type fixnum)
   (hinstance 0 :type foreign)
   (hicon 0 :type foreign)
   (hcursor 0 :type foreign)
   (hbrbackground 0 :type foreign)
   (lpszmenuname "" :type string)
   (lpszclassname "" :type string))

(defstruct (textmetric (:constructor make-textmetric (&optional
    tmheight tmascent tmdescent tminternalleading tmexternalleading
    tmavecharwidth tmmaxcharwidth tmweight tmoverhang tmdigitizedaspectx
    tmdigitizedaspecty tmfirstchar tmlastchar tmdefaultchar tmbreakchar
    tmitalic tmunderlined tmstruckout tmpitchandfamily tmcharset)))
   (tmheight 0 :type fixnum)
   (tmascent 0 :type fixnum)
   (tmdescent 0 :type fixnum)
   (tminternalleading 0 :type fixnum)
   (tmexternalleading 0 :type fixnum)
   (tmavecharwidth 0 :type fixnum)
   (tmmaxcharwidth 0 :type fixnum)
   (tmweight 0 :type fixnum)
   (tmoverhang 0 :type fixnum)
   (tmdigitizedaspectx 0 :type fixnum)
   (tmdigitizedaspecty 0 :type fixnum)
   (tmfirstchar #\space :type character)
   (tmlastchar #\space :type character)
   (tmdefaultchar #\space :type fixnum)
   (tmbreakchar #\space :type fixnum)
   (tmitalic 0 :type fixnum)
   (tmunderlined 0 :type fixnum)
   (tmstruckout 0 :type fixnum)
   (tmpitchandfamily 0 :type fixnum)
   (tmcharset 0 :type fixnum))

;;; This function is similar to the clx function draw-arc.
;;; To avoid using optional arguments, args are passed in as points.
(defun draw-arc (hdc pPosition pDimension pAngle)
   (let* ((x (point-x pPosition))
          (y (point-y pPosition))
          (width (point-x pDimension))
          (height (point-y pDimension))
          (angle (point-float-y pAngle))
          angle1 angle2)
      (if (>= angle 0.0)
          (setf angle1 (point-float-x pAngle) angle2 (+ angle angle1))
          (setf angle2 (point-float-x pAngle) angle1 (- angle2 angle)))
      (ARC hdc x y (+ x width -1) (+ y height -1)
          (truncate (+ x (/ width 2) (* width (cos angle1))))
          (truncate (+ y (/ height 2) (- (* height (sin angle1)))))
          (truncate (+ x (/ width 2) (* width (cos angle2))))
          (truncate (+ y (/ height 2) (- (* height (sin angle2))))))))

(defun bitmap-image (&rest r) t)

; I am not sure if this is needed, it is from the mac implementation
(defvar *current-event* nil)
; If we switch to a fixnum for this, it will be faster
; but for now, get it working
(defvar *functions* (make-hash-table :test #'equalp))
(defun onCreate (hWnd)
   (let* ((k (cons 0 WM_NCCREATE))
          (alist (gethash k *functions*)))
      (when alist (remhash k *functions*))
      (mapc #'(lambda (c)
              (setf (gethash (cons hWnd (car c)) *functions*) (cdr c)))
         alist)))

(defun init-gdi () (gdi::initc *functions* #'onCreate))
(defvar *hinstance* (init-gdi))

(defun create-gcontext (&rest r) t)

(defun add-callbacks (message-id a)
   (let ((key (cons  0 message-id )))
        (setf (gethash key *functions*) a)))
(defun remove-callback (hwnd message-id)
   (remhash (cons hwnd message-id) *functions*))

(defun handle-textmetric (hfont)
  (let* ((hdc (multiple-value-bind (retval h) (gdi::getdc nil)
                 (if retval h (error "getdc ~S" h))))
         (tm (make-textmetric))
         (hOldFont (multiple-value-bind (retval h)
                  (gdi::selectobject hdc hfont)
                  (if retval h (error "selectobject ~S" h)))))
     (multiple-value-bind (retval h)
        (gdi::gettextmetricsa hdc tm)
        (unless retval (error "gettextmetricsa ~S" h)))
     (multiple-value-bind (retval h)
        (gdi::selectobject hdc hOldFont)
        (if retval h (error "selectobject ~S" h)))
       tm))

(defun max-char-ascent (hfont)
   (textmetric-tmascent (handle-textmetric hfont)))

(defun max-char-descent (hfont)
   (textmetric-tmdescent (handle-textmetric hfont)))
