/* LocaleInformation_ca.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_ca extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ESP";

  private static final String currenciesDisplayNameValues = "ESP";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ESP";

  private static final String currenciesSymbolValues = "\u20a7";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "gen.",
    "febr.",
    "mar\u00e7",
    "abr.",
    "maig",
    "juny",
    "jul.",
    "ag.",
    "set.",
    "oct.",
    "nov.",
    "des.",
    null,
  };

  private static final String[] months = {
    "gener",
    "febrer",
    "mar\u00e7",
    "abril",
    "maig",
    "juny",
    "juliol",
    "agost",
    "setembre",
    "octubre",
    "novembre",
    "desembre",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "dg.",
    "dl.",
    "dt.",
    "dc.",
    "dj.",
    "dv.",
    "ds.",
  };

  private static final String[] weekdays = {
    null,
    "diumenge",
    "dilluns",
    "dimarts",
    "dimecres",
    "dijous",
    "divendres",
    "dissabte",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|GW|GT|GR|GQ|GP|SZ|SY|GN|GM|SV|GH|SR|GF|SP|GE|SO|SN|GB|SL|GA|SK|SI|SG|SE|SD|SC|SA|FR|FM|RW|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|DK|DJ|PT|PR|DE|PL|PK|PH|PG|PF|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|AZ|NE|NC|AW|ZM|AU|NA|AT|AR|MZ|AO|MY|AN|MX|AM|AL|ZA|MU|MT|AI|MS|MR|MQ|AF|AE|AD|MN|MM|ML|MK|YU|YT|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LB|LA|KZ|KW|KR|KP|KM|KI|KH|KG|KE|JP|JO|JM|VU|VN|VI|VG|VE|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|TW|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor|Tokelau|Tadjikistan|Tail\u00e0ndia|Togo|Territoris Meridionals Francesos|Guyana|Txad|Guinea Bissau|Guatemala|Gr\u00e8cia|Guinea Equatorial|Guadeloupe|Swazil\u00e0ndia|S\u00edria|Guinea|G\u00e0mbia|El Salvador|Ghana|Surinam|Guaiana Francesa|S\u00e8rbia|Ge\u00f2rgia|Som\u00e0lia|Senegal|Regne Unit|Sierra Leone|Gabon|Eslov\u00e0quia|Eslov\u00e8nia|Singapur|Su\u00e8cia|Sudan|Seychelles|Ar\u00e0bia Saud\u00ed|Fran\u00e7a|Micron\u00e8sia|Rwanda|R\u00fassia|Fiji|Finl\u00e0ndia|Romania|Eti\u00f2pia|Espanya|Eritrea|S\u00e0hara Occidental|Egipte|Est\u00f2nia|Equador|Alg\u00e8ria|Qatar|Rep\u00fablica Dominicana|Paraguai|Dominica|Dinamarca|Djibouti|Portugal|Puerto Rico|Alemanya|Pol\u00f2nia|Pakistan|Filipines|Papua Nova Guinea|Polin\u00e8sia Francesa|Rep\u00fablica Txeca|Per\u00fa|Xipre|Cap Verd|Panam\u00e0|Cuba|Costa Rica|Col\u00f2mbia|Xina|Camerun|Xile|Costa d\u2019Ivori|Switzerland|Congo|Rep\u00fablica Centrafricana|Oman|Canad\u00e0|Belize|Bielor\u00fassia|Botswana|Bhutan|Bahames|Brasil|Nova Zelanda|Bol\u00edvia|Brunei|Bermudes|Niue|Benin|Burundi|Bahrain|Bulg\u00e0ria|Burkina Faso|Nepal|B\u00e8lgica|Noruega|Bangla Desh|Barbados|Zimbabwe|Pa\u00efsos Baixos|B\u00f2snia i Hercegovina|Nicaragua|Nig\u00e8ria|Azerbaidjan|N\u00edger|Nova Caled\u00f2nia|Aruba|Z\u00e0mbia|Austr\u00e0lia|Nam\u00edbia|\u00c2ustria|Argentina|Mo\u00e7ambic|Angola|Mal\u00e0isia|Antilles Holandeses|M\u00e8xic|Arm\u00e8nia|Alb\u00e0nia|Sud-\u00e0frica|Maurici|Malta|Anguilla|Montserrat|Maurit\u00e0nia|Martinica|Afganistan|Uni\u00f3 dels Emirats \u00c0rabs|Andorra|Mong\u00f2lia|Myanmar|Mali|Maced\u00f2nia|Iugosl\u00e0via|Mayotte|Madagascar|Mold\u00e0via|M\u00f2naco|Marroc|Iemen|L\u00edbia|Let\u00f2nia|Luxemburg|Litu\u00e0nia|Lesotho|Lib\u00e8ria|Sri Lanka|Liechtenstein|L\u00edban|Laos|Kazakhstan|Kuwait|Corea del Sud|Corea del Nord|Comores|Kiribati|Cambodja|Kirgizistan|Kenya|Jap\u00f3|Jord\u00e0nia|Jamaica|Vanuatu|Vietnam|Illes Verges dels USA|Illes Verges Brit\u00e0niques|Vene\u00e7uela|Vatic\u00e0|It\u00e0lia|Isl\u00e0ndia|Iran|Iraq|Uzbekistan|Uruguai|\u00cdndia|Israel|Estats Units|Irlanda|Indon\u00e8sia|Uganda|Ucra\u00efna|Hongria|Hait\u00ed|Cro\u00e0cia|Tanz\u00e0nia|Hondures|Taiwan|Hong Kong|Trinitat i Tobago|Turquia|Tonga|Tun\u00edsia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "espanyol|kurd|esperanto|caixmiri|angl\u00e8s|grec|qu\u00e8txua|core\u00e0|kannada|cambodj\u00e0|greenland\u00e8s|kazakh|w\u00f2lof|georgi\u00e0|bhutan\u00e8s|javan\u00e8s|portugu\u00e8s|paixto|alemany|polon\u00e8s|dan\u00e8s|volapuk|japon\u00e8s|vietnamita|gal\u00b7l\u00e8s|panjabi|txec|inuktitut|itali\u00e0|cors|island\u00e8s|uzbek|oriya|inupiak|urd\u00fa|oromo (afan)|catal\u00e0|interlingue|indonesi|ucra\u00efn\u00e8s|interlingua|occit\u00e0|uigur|armeni|bret\u00f3|hongar\u00e8s|tibet\u00e0|bengal\u00ed|croat|bislama|twi|bihari|b\u00falgar|t\u00e0tar|noruec|bielor\u00fas|tsonga|hindi|turc|neerland\u00e8s|zulu|baixkir|tonga|hebreu|tswana|tag\u00e0log|turcman|hausa|nepal\u00e8s|\u00e0zeri|tigrinya|aimara|thai|tadjik|nauru\u00e0|telugu|xin\u00e9s|assam\u00e8s|\u00e2rab|t\u00e0mil|gujarati|birm\u00e0|amh\u00e0ric|zhuang|malt\u00e8s|malai|guaran\u00ed|swahili|marathi|suec|gallec|sundan\u00e8s|afrikaans|sotho|moldau|siswati|mongol|serbi|alban\u00e8s|malaialam|abkhaz|macedoni|\u00e0far|somali|shona|maori|escoc\u00e8s|samo\u00e0|eslov\u00e8|malgaix|eslovac|irland\u00e8s|ioruba|sinhal\u00e8s|serbo-croat|sango|jiddish|sindhi|fris\u00f3|s\u00e0nscrit|franc\u00e8s|let\u00f3|litu\u00e0|fero\u00e8s|kinyarwanda|rus|laosi\u00e0|fiji\u00e0|lingala|fin\u00e8s|roman\u00e8s|kirundi|retorom\u00e0nic|persa|llat\u00ed|xosa|basc|kirgu\u00eds|estoni\u00e0";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GuMtkHmsSEDFwWahKzUeygAZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "shortDateFormat", "dd/MM/yy" },
    { "mediumDateFormat", "dd/MM/yyyy" },
    { "longDateFormat", "d 'd\u2019'MMMM 'de' yyyy" },
    { "fullDateFormat", "EEEE d 'd\u2019'MMMM 'de' yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H:mm:ss z" },
    { "fullTimeFormat", "H:mm:ss z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
