/*
 * dip		A program for handling dialup IP connections.
 *
 *		This module  implements  a  very rudimentary  terminal
 *		emulator,  which  can be used  to log  into some  host
 *		manually, or to debug the connection.
 *
 *
 * Version:	@(#)term.c	1.01	23.April.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include "dip.h"


void  do_terminal ( void )
{

  void (*old_sigs[32])	( int );

  char			buff [ 1024 ];

  struct termios	otty;
  struct termios	ntty;

  fd_set		mask;
  fd_set		rmask;

  register int		i;
  int			tty;


  (void) printf ( "[ Entering TERMINAL mode.  "
				"Use CTRL-] or CTRL-A to get back ].\n\n" );


  /*
   *  Zuerst fragen wir die dip-Funktion tty_askfd() nach der zugehoerigen
   *  FileDescriptor-Nummer.
   */
  tty = tty_askfd ();


  /*
   *  Tastatur-Eingaben zulassen.
   */
  if ( tcgetattr ( STDIN_FILENO, &otty )  <  0 )
  {
    (void) fprintf ( stderr, "DIP: term: tcgetattr(stdin): %s\n",
							strerror ( errno ) );
    return;
  }
  
  ntty = otty;
  ntty.c_lflag &= ~(ECHO | ICANON);
  ntty.c_iflag &= ~(ICRNL | ISIG | IXON | IXANY);
  ntty.c_oflag &= ~(ONLCR | OPOST);

  if ( tcsetattr ( STDIN_FILENO, TCSANOW, &ntty )  <  0 )
  {
    (void) fprintf ( stderr, "DIP: term: tcsetattr(stdin): %s\n",
							strerror ( errno ) );
    return;
  }

  
  /*
   *  Set up the correct descriptor masks for select(2).
   */
  FD_ZERO ( &mask );
  FD_SET  ( STDIN_FILENO, &mask );
  FD_SET  ( tty, &mask );


  /*
   *  Alle originalen Signal-Haendler speichern.
   */
  for ( i = 0; i < 32; i++ )
  {
    old_sigs [ i ] = signal( i + 1, SIG_IGN );
  }


  /*
   *  Endlos-Schleife... Terminal loop. Ende durch CTRL-A oder CTRL-]
   */
  while ( 1 )
  {
    rmask = mask;

    if ( select ( 32, &rmask, (fd_set*) NULL, (fd_set*) NULL,
					(struct timeval*) NULL )  <=  0 )
    {
      break;
    }

    if ( FD_ISSET ( STDIN_FILENO, &rmask ) )
    {
      if ( ( i = read ( STDIN_FILENO, buff, 1 ) )  >  0 )
	{
	  if ( ( buff [ 0 ]  ==  ( ']' & 037 ) )
	    || ( buff [ 0 ]  ==  ( 'A' & 037 ) ) )
	  {
	    break;
	  }

	  (void) write ( tty, buff, i );
	}
    }

    if ( FD_ISSET ( tty, &rmask ) )
    {
      if ( ( i = read ( tty, buff, 1024 ) )  >  0 )
      {
	(void) write ( STDOUT_FILENO, buff, i );
      }
    }
  }


  /*
   *  Wiederherstellen der originalen Tastatur-TTY-Daten.
   */
  if ( tcsetattr ( STDIN_FILENO, TCSANOW, &otty )  <  0 )
  {
    (void) fprintf ( stderr, "DIP: term: tcsetattr(stdin): %s\n",
							strerror ( errno ) );
    return;
  }

  
  /*
   *  Alle vorherigen Singnal-Haendler wiederherstellen.
   */
  for ( i = 0; i < 32; i++ )
  {
    (void) signal ( i + 1, old_sigs [ i ] );
  }


  (void) printf ( "\n[ Back to LOCAL mode. ]\n\n" );
}
