/*
 * dip		A program for handling dialup IP connections.
 *
 *		This module does: Save alarm context, sleep, restore
 *		it.
 *
 * Note:	Doing this overhead seems to be unnecessary in  BSD,
 *		because  (believing sleep(3)),  the  system function
 *		already does so!
 *
 *
 * Version:	@(#)sleep.c	1.01	23.April.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Author:      lilo <TaRDiS@MBS.Telesys.UTexas.EDU>
 *
 *		Copyright 1994 by lilo <TaRDiS@MBS.Telesys.UTexas.EDU.
 *		All rights reserved.  Licensing information follows.
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#ifdef USEOWNSLEEP

#include "dip.h"



void  save_sleep ( int sec )
{
  void (*oldsig) (int);

  int oldalarm;


  /*
   *  Turn off alarm timer and signal setting; save old values.
   */
  oldalarm = alarm ( 0 );
  oldsig   = signal ( SIGALRM, SIG_IGN );


  /*
   *  If old alarm timer value was nonzero and no time is left after
   *  the sleep, restore old signal and process the alarm signal
   *  *now* as specified by that value.
   */	
  if ( oldalarm )
  {
    if ( oldalarm <= sec )
    {
      (void) signal ( SIGALRM, oldsig );
      (void) kill ( getpid ( ), SIGALRM );
    }
  }


  /*
   *  Otherwise perform the sleep.  Restore the timer to its prior
   *  value, minus the length of time we slept.  Then restore the
   *  signal and quit.
   */	
  (void) sleep ( sec );	

  (void) alarm ( oldalarm-sec );

  (void) signal ( SIGALRM, oldsig );
}

#endif /* USEOWNSLEEP */
