/*
 * dip		A program for handling dialup IP connections.
 *
 *		Modem driving module.  On systems that support the
 *		dial(3) package, we (should) use that.  Otherwise,
 *		we use a very rudimentary HAYES-type dialer.
 *
 *
 * Version:	@(#)modem.c	1.01	23.April.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include "dip.h"


/*
 *  Here are some HAYES modem commands.
 */
#define AT_ATTN	 "+++"			/* "attention" string		*/
#define AT_RSET	 "ATZ"			/* reset the modem		*/
#define AT_INIT	 "ATE0Q0V1X1"		/* setup for dialing		*/
#define AT_DIAL	 "ATD"			/* start a dial			*/
#define AT_EOL	 "\r"			/* AT "CRLF" mark		*/


static  char	mdm_init_s [ 64 ];	/* current INIT string		*/
static  char	mdm_type   [ 16 ];	/* current Modem type		*/

static  short	mdm_setup = 0;		/* can we do anything?		*/



/*
 *  Einstellen des Init-Strings fuer den aktuell eingestellten Modem-Typ.
 */
int  mdm_init ( char *text )
{
  /*
   *  Nur, wenn der neue Init-String nicht zu lang ist, wird er kopiert.
   */
  if ( strlen ( text )  >=  63 )
  {
    (void) fprintf ( stderr, "DIP: Modem: New init string to long! "
						"Setting it to default\n" );
    text = AT_INIT;
  }

  /*
   *  Ausnullen, damit nichts falsches liegen bleibt.
   */
  (void) memset ( mdm_init_s, 0, 64 );


  /*
   *  Kopieren der ersten 63 Zeichen des uebergebenen Init-Strings.
   */
  (void) strncpy ( mdm_init_s, text, 64-1 );


  /*
   *  Ausgeben, was nun wirklich eingestellt wurde.
   */
  if ( opt_verb )
  {
    (void) printf ( "Modem INIT string set to \"%s\".\n", mdm_init_s );
  }


  return 0;
}



/*
 *  Setzen des angegebenen Modem-Typs.
 */
char*  mdm_modem ( char *modem )
{
  /*
   *  Da wir nur HAYES kennen, lassen wir keinen anderen String zu :)
   */
  if ( strcmp ( modem, DEF_MODEM )  !=  0 )
  {
    (void) fprintf ( stderr, "DIP: Modem: Unknown modem type \"%s\"!\n",
								modem );
    mdm_setup = 0;

    return (char*) NULL;
  }


  /*
   *  Ausnullen des Modem-Typ-Strings.
   */
  (void) memset ( mdm_type, 0, 16 );


  /*
   *  Merken des Modem-Typ-Strings. Maximal 15+1 Byte.
   */
  (void) strncpy ( mdm_type, modem, 16-1 );


  /*
   *  Merken, dass wir schon einen Modem-Typ gesetzt haben.
   */
  mdm_setup = 1;


  /*
   *  Nun noch ausgeben, was wir tatsaechlich eingetragen haben.
   */
  if ( opt_verb )
  {
    (void) printf ( "Modem set to \"%s\".\n", mdm_type );
  }


  /*
   *  Zugehoerigen Init-String setzen.
   */
  (void) mdm_init ( AT_INIT );


  return mdm_type;
}



/*
 *  Anwaehlen der uebergebenen Tel.-Nummer.
 */
int  mdm_dial ( char *number )
{

  char	buff [ 64 ];


  /*
   *  Kennen wir den Modem-Typ schon?
   */
  if ( ! mdm_setup )
  {
    return -1;
  }


  /*
   *  Initialisierung des Modem vorweg.
   */
  (void) sprintf ( buff, "%s%s", mdm_init_s, AT_EOL );

  tty_puts ( buff );


  (void) save_sleep ( 1 );


  /*
   *  Waehlen der Tel.-Nummer.
   */
  (void) sprintf ( buff, "%s%s%s", AT_DIAL, number, AT_EOL );

  tty_puts ( buff );


  return 0;
}



/*
 *  Modem Reset.
 */
int  mdm_reset ( void )
{

  char	buff [ 64 ];


  /*
   *  Kennen wir den Modem-Typ schon?
   */
  if ( ! mdm_setup )
  {
    return -1;
  }


  /*
   *  Make the modem listen to us.
   */
  (void) save_sleep ( 1 );

  tty_puts ( AT_ATTN );

  (void) save_sleep ( 1 );


  /*
   * Modem reset'n.
   */
  (void) sprintf ( buff, "%s%s", AT_RSET, AT_EOL );

  tty_puts ( buff );

  (void) save_sleep ( 1 );


  return 0;
}
