/*
 * dip		A program for handling dialup IP connections.
 *
 *		Incoming connection handling module.
 *
 *
 * Version:	@(#)login.c	1.01	23.April.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include "dip.h"


int  getdipnam ( char *who )
{

  char			buff [ 1024 ];

  char			*bp;
  char			*sp;

  FILE			*fp;


  if ( ( fp = fopen ( PATH_ETC_DIPHOSTS, "r") )  ==  (FILE*) NULL )
  {
    (void) fprintf ( stderr, "DIP: Cannot open %s\n", PATH_ETC_DIPHOSTS );

    syslog ( LOG_ERR, "cannot open %s", PATH_ETC_DIPHOSTS );

    return -1;
  }


  while ( fgets ( buff, 1024, fp )  !=  (char*) NULL)
  {
    if ( ( sp = strchr ( buff, '\n' ) )  !=  (char*) NULL)
      *sp = '\0';

    if ( ( buff[0] == '#' ) || ( buff[0] == '\0' ) )
      continue;


    bp = sp = buff;
    while ( *sp && ( *sp != ':' ) )
      sp++;
    *sp++ = '\0';

    if ( strcmp ( bp, who ) )
      continue;

    (void) strncpy ( mydip.username, bp, MAXUSERNMLEN-1 );


    bp = sp;
    while ( *sp && ( *sp != ':' ) )
      sp++;
    *sp++ = '\0';

    (void) strncpy ( mydip.userpasswd, bp, MAXPASSWDLEN-1 );


    bp = sp;
    while ( *sp && ( *sp != ':' ) )
      sp++;
    *sp++ = '\0';

    (void) strncpy ( mydip.remote, bp, MAXHOSTNAMELEN-1 );


    bp = sp;
    while ( *sp && ( *sp != ':' ) )
      sp++;
    *sp++ = '\0';

    (void) strncpy ( mydip.comment, bp, MAXCOMMENTLEN-1 );


    bp = sp;
    while ( *sp && ( *sp != ':' ) && ( *sp != ',' ) )
      sp++;
    *sp++ = '\0';

    (void) strncpy ( mydip.protostr, bp, 8-1 );


    bp = sp;
    while ( *sp && ( *sp != ',' ) )
      sp++;
    *sp++ = '\0';

    mydip.mtu = atoi ( bp );


    (void) fclose ( fp );

    return 0;
  }

  (void) fclose ( fp );


  return -1;
}


int  do_login ( char *name, char **argp )
{
  char		  buff [ MAXHOSTNAMELEN+8 ];

  struct hostent  *hp;

  int		  i;

  extern char	  *h_errlist [];
  extern int	  h_errno;


  openlog ( "DIP", LOG_PID, LOG_DAEMON );


  /*
   *  Ist der User in /etc/diphosts eingetragen?
   */
  if ( getdipnam ( name )  <  0 )
  {
    (void) fprintf ( stderr, "DIP: You do not have DIP access.  Go away.\n" );

    syslog ( LOG_WARNING, "%s tried to access DIP: no access!", name );

    closelog ( );

    return -1;
  }


  /*
   *  Resolve the this caller's host name to an IP address.
   */
  if ( ( hp = gethostbyname ( mydip.remote ) )  ==  (struct hostent*) NULL )
  {
    syslog ( LOG_ERR, "unknown host %s: %s\n",
					mydip.remote, h_errlist [ -h_errno ] );

    closelog ( );

    return -1;
  }


  (void) strncpy ( mydip.remote, hp->h_name, MAXHOSTNAMELEN-1 );

  (void) memcpy ( (char*) &mydip.ip_rmt, (char*) hp->h_addr_list[0],
								hp->h_length );


  /*
   *  Find out which protocol we have to use.
   */
  if ( ( i = get_protocol ( mydip.protostr ) )  ==  0 )
  {
    syslog ( LOG_ERR, "%s wants unknown protocol %s",
						mydip.remote, mydip.protostr );
    closelog ( );

    return -1;
  }

  mydip.protonr = i;


  /*
   *  Show some info.
   */
  if ( opt_verb )
  {
    (void) printf ( "Hostname: \"%s\" [%s]\n"
		    "Comments: \"%s\"\n"
		    "Protocol: \"%s\" (%d)\n"
		    "IP MTU  : %d\n",
		    mydip.remote, inet_ntoa ( mydip.ip_rmt ),
		    mydip.comment,
		    mydip.protostr, mydip.protonr,
		    mydip.mtu );
  }

  syslog ( LOG_INFO, "%s  connected as  %s (%s)  with  %s/%d",
			mydip.username,
			mydip.remote, inet_ntoa ( mydip.ip_rmt ),
			mydip.protostr, mydip.mtu );

  (void) sprintf ( buff, "-dip (%s)", mydip.remote );

  *argp = buff;


  (void) printf ( "starting %s\n", mydip.protostr );

  (void) fflush ( stdout );


  /*
   *  Set up stdin for "no messages". We do not want to be disturbed
   *  anymore.
   */
  (void) tty_nomesg ( );


  /*
   *  Initialize this terminal line for 8-bit clean operation.
   */
  (void) tty_open ( NULL );


  /*
   *  Ab in den Hintergrund.
   */
  dip_setup ( );


  /*
   *  Unter normalen Umstaenden kommen wir hier nicht wieder zurueck.
   */
  return 0;
}
