/*
 * dip		A program for handling dialup IP connections.
 *
 *
 * Version:	@(#)dip.h	1.02	1.July.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <varargs.h>
#include <sys/param.h>
#include <sys/termios.h>
#include <sys/types.h>
#include <pwd.h>
#include <signal.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/slip.h>
#include <net/if_slvar.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
extern  int h_errno;


#define MAXUSERNMLEN	16
#define MAXPASSWDLEN	16
#define MAXCOMMENTLEN	128
#define MAXPROTSTRLEN	8


struct dip
{
  char  username   [ MAXUSERNMLEN  ];	/* Login name at host		  */
  char  userpasswd [ MAXPASSWDLEN  ];	/* Users password at host	  */
  char  userhome   [ MAXPATHLEN    ];	/* Users home directory at host	  */
  char  comment	   [ MAXCOMMENTLEN ];	/* Comment (taken from diphosts)  */

  char  protostr   [ MAXPROTSTRLEN ];	/* Protocol to use (ASCII-String) */
  short protonr;			/* Decoded protocol number 	  */
  short	rtdefault;			/* Use default routing ?	  */
  char  ifname	   [ IFNAMSIZ ];	/* Attached to interface xxx	  */
  short isattached;			/* Are we really attached?	  */
  short setsdisc;			/* Already set slip discipline?	  */
  short isdaemon;			/* Are we a daemon?		  */
  int   mtu;				/* MTU to use for connection	  */
  int   timeout;			/* Timeout given per cmd-line	  */
  int   counter;			/* Counter for $counter-Var.	  */

  char  local   [ MAXHOSTNAMELEN ];	/* Local host name (256 Bytes)	  */
  char  remote  [ MAXHOSTNAMELEN ];	/* Remote host name		  */
  char  gateway [ MAXHOSTNAMELEN ];	/* Remote gateway name		  */
  char  route   [ MAXHOSTNAMELEN ];	/* Remote route name		  */
  char  netmask [ 16 ];			/* Netmask of route		  */
  struct in_addr  ip_loc;		/* Mapped local IP address	  */
  struct in_addr  ip_rmt;		/* Mapped remote IP address	  */
  struct in_addr  ip_rmt_gw;		/* Mapped remote gateway IP addr  */
  struct in_addr  ip_rmt_rt;		/* Mapped remote route IP address */

  char  pidfile   [ 256 ];		/* Full path+file to pid-File	  */
  char  shellfile [ 256 ];		/* Full path+file to shell-File	  */
};


struct protosw
{
  char  *name;
  int   type;
  int   (*func)( void );
};



/*
 *  SLIP-Default-Werte
 */
#define DEF_MTU		296
#define DEF_NETMASK	"255.255.255.0"
#define DEF_PROTOCOL	"SLIP"
#define DEF_MODEM	"HAYES"
#define DEF_SPEED	"38400"



/*
 *  Pfad- und Dateinamen-Konstanten
 */
#define PATH_LOCKD		"/var/spool/uucp/LCK.."
#define PATH_ETC_DIPHOSTS	"/etc/diphosts"
#define PATH_BIN_IFCONFIG	"/sbin/ifconfig"
#define PATH_BIN_ROUTE		"/sbin/route"

#define PATH_DIP_PID		"/var/run/dip"
#define EXT_DIP_PID		".pid"
#define EXT_DIP_DIP		".dip"
#define UID_UUCP		"uucp"


/*
 * Extern benoetigte Variablen
 */
extern  int		errno;

extern  short		opt_debg;	/* Debugging-output-flag	*/
extern  short		opt_verb;	/* Verbose-flag			*/

extern  struct dip	mydip;		/* Structure for diplogin	*/


/*
 *  Prototypen fuer exportierte Funktionen
 */

/*
 *  aus: attach.c
 */
#define DO_ATTACH	0
#define DO_DETACH	1
int   attach ( int );

/*
 *  aus: command.c
 */
int  do_command ( FILE* );

/*
 *  aus: config.c
 */
int   get_protocol ( char* );

/*
 *  aus: daemon.c
 */
void  dip_setup  ( void );
int   dip_daemon ( void );

/*
 *  aus: ipdump.c
 */
void  ip_dump ( char *, int );

/*
 *  aus: login.c
 */
int  do_login ( char*, char** );

/*
 *  aus: modem.c
 */
char*  mdm_modem ( char* );
int    mdm_init  ( char* );
int    mdm_dial  ( char* );
int    mdm_reset ( void  );

/*
 *  aus: sleep.c
 */
#ifdef USEOWNSLEEP
void  save_sleep ( int );
#else
#define  save_sleep  sleep
#endif /* USEOWNSLEEP */

/*
 *  aus: slip.c  u.  ppp.c
 */
int  do_slip  ( void );
int  do_cslip ( void );
int  do_ppp   ( void );

/*
 *  aus: term.c
 */
void  do_terminal ( void );

/*
 *  aus: tty.c
 */
int  tty_nomesg ( void );
int  tty_lock ( char*, int );
int  tty_set_encap ( int );
void  tty_set_online ( void );
void  tty_set_offline ( void );
int  tty_get_disc ( int * );
int  tty_set_disc ( int );
int  tty_getc ( short );
int  tty_putc ( int );
void tty_puts ( char * );
int  tty_askfd ( void );
int  tty_databits ( char * );
int  tty_stopbits ( char * );
int  tty_parity ( char * );
int  tty_speed ( char * );
int  hanguptty ( void );
int  tty_flush ( void );
int  tty_close ( void );
int  tty_open ( char * );
