/*
 * dip		A program for handling dialup IP connections.
 *
 *		This module  handles  the process  of going  into  the
 *		background.
 *
 *
 * Version:	@(#)daemon.c	1.02	1.July.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include "dip.h"


extern  struct protosw  protosw[];	/* Definition in config.c	*/
extern  int             opt_i;          /* Definition in dip.c          */

volatile  short  carrier_lost; /* Merker fuer Lost Carriers. Wenn ein CL   */
                               /* auftritt, werden alle tty-Einstellungen  */
                               /* zurueckgenommen und versucht, in dem     */
                               /* Script-File weitere Befehle abzuarbeiten */


/*
 *  Catch any signals.
 */
static void  sig_catcher ( int sig )
{
  /*
   *  Wenn ein Signal kommt, erstmal  tty  schliessen.
   *  Folgende Aktionen werden ausgefuehrt:
   *    - Drop DTR (immer)
   *    - Detach (falls ueberhaupt attached)
   *    - Line discipline auf vorigen Wert zurueckstellen
   *    - uucp-Lock-Datei loeschen
   */
  (void) tty_close ( );


  if ( sig == SIGALRM )
  {
    (void) fprintf ( stderr, "\nDIP: Catched ALARM-Signal (timeout=%d sec). "
					"Immediate exit!\n", mydip.timeout );

    exit ( 5 );
  }

  if ( opt_verb )
    (void) fprintf ( stderr, "\nDIP: Catched Signal (%d). "
						"Immediate exit!\n", sig );

  switch ( sig )
  {
    case SIGHUP  : if ( opt_i )   /* running in Dial-In-Mode ... exit   */
                     exit ( 6 );

                   syslog ( LOG_ERR, "Carrier lost!" );
                   carrier_lost = 1;
                   return;        /* running in Dial-Out-Mode... redial */

    case SIGINT  : exit ( 7 );
    case SIGTERM : exit ( 8 );
  }

  exit ( 200 + sig );
}



void  dip_setup ( void )
{

  int i;


  for ( i = 1; i < 32; i++ )
    if ( i  !=  SIGALRM )
      (void) signal ( i, SIG_IGN );

  (void) signal ( SIGHUP,  sig_catcher );
  (void) signal ( SIGINT,  sig_catcher );
  (void) signal ( SIGTERM, sig_catcher );


  /*
   *  If this point is reached, we are connected to another system.
   *  So we have to watch for the presence of the carrier.
   */
  tty_set_online ( );


  (void) chdir ( mydip.userhome );


  /*
   *  Fire up the protocol here. 
   */
  (int) protosw [ mydip.protonr - 1 ].func ( );


  /*
   *  Clear the alarm and wait forever to terminate.
   */  
  (void) signal ( SIGALRM, SIG_IGN );
  (void) alarm ( 0 );


  syslog ( LOG_ERR, "Connection established!" );


  carrier_lost = 0;
  while ( ! carrier_lost )
    (void) sleep ( 60 );


  /*
   *  Set tty to CLOCAL and ~HUPCL to allow sending modem commands.
   */
  tty_set_offline ( );
}



int  dip_daemon ( void )
{

  FILE	*fp;

  /*
   *  If required, fork off a sub-process and reinstate alarm.
   *  Required, if this is the first try to instantiate a daemon.
   */
  if ( ! mydip.isdaemon )  {
    daemon ( 1, 1 );
    mydip.isdaemon = 1;

    openlog ( "DIP", LOG_PID, LOG_DAEMON );
  }


  (void) signal ( SIGALRM, sig_catcher );
  (void) alarm ( mydip.timeout );


  /*
   *  Record the current PID in a file.
   *  If the file exists, it will be truncated to zero length...
   */
  if ( ( fp = fopen ( mydip.pidfile, "w" ) )  ==  NULL )
  {
    (void) fprintf ( stderr, "DIP: cannot create %s: %s\n",
					mydip.pidfile, strerror ( errno ) );
    return -1;
  }

  (void) fprintf ( fp, "%d\n", getpid ( ) );

  (void) fclose ( fp );


  dip_setup ( );


  /*
   *  If this point is reached, we received a HUP-signal.
   *  Info:  We already removed line discipline, lock files and are offline
   *         and are no longer attached (all done by signal handler).
   */

  return 0;
}
