/*
 * dip		A program for handling dialup IP connections.
 *
 *
 * Version:	@(#)config.c	1.01	23.April.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include "dip.h"


#define DIP_HAVE_SLIP	1		/* select "SLIP"		*/
#define DIP_HAVE_CSLIP	1		/* select "CompressedSLIP"	*/
#define DIP_HAVE_PPP	0		/* select "PPP"			*/



#if DIP_HAVE_SLIP
  extern  int  do_slip  ( void );
#endif

#if DIP_HAVE_CSLIP
  extern  int  do_cslip ( void );
#endif

#if DIP_HAVE_PPP
  extern  int  do_ppp   ( void );
#endif


struct protosw  protosw [ ] =
{
#if DIP_HAVE_SLIP
  { "SLIP",		1,	do_slip	},
#endif
#if DIP_HAVE_CSLIP
  { "CSLIP",		2,	do_slip	},
#endif
#if DIP__HAVE_PPP
  { "PPP",		3,	do_ppp	},
#endif
  { (char *)NULL,	0,	NULL	}
};



int  get_protocol ( char *name )
{
  register int	i = 0;
  register int	j = atoi ( name );

  while ( protosw[i].name  !=  (char*) NULL )
  {
    if ( ! strcmp ( protosw[i].name, name ) )
    {
      return protosw[i].type;
    }

    if ( protosw[i].type  ==  j )
    {
      return protosw[i].type;
    }

    i++;
  }

  return 0;
}
