/*
 * dip		A program for handling dialup IP connections.
 *
 *		This module handles setting the interface and
 *		its routing table entry.
 *
 *
 * Version:	@(#)attach.c	1.01	23.April.1995
 *
 *
 * New Author:	Joachim Bartz, <injb@sun.rz.tu-clausthal.de>
 *
 *		There have been so many changes to get  dip work under
 *		BSD...   So I believe, you can call me an author, too.
 *		Please read the  ReadMe  file and the man page to know
 *		what, when, why.
 *
 *
 * Org.Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Copyright 1988-1993 MicroWalt Corporation
 *
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 *
 *		This program is  distributed in the  hope that it will
 *		be useful, but WITHOUT ANY WARRANTY;  without even the
 *		implied warranty of MERCHANTABILITY  or  FITNESS FOR A
 *		PARTICULAR  PURPOSE.    See  the  GNU  General  Public
 *		License for more details.
 *
 *		You  should have received  a copy  of the  GNU General
 *		Public License along with this program;  if not, write
 *		to the
 *			Free Software Foundation, Inc.
 *			675 Mass Ave
 *			Cambridge, MA 02139, USA
 */

#include "dip.h"

#include <paths.h>



int  attach ( int what )
{

  char  cwhat [   16 ];
  char	temp  [   16 ];
  char	buff  [ 1536 ];

  int ret;


  if ( what  ==  DO_ATTACH )
    (void) strcpy ( cwhat, ">>> ATTACH " );
  else
    if ( what  ==  DO_DETACH )
      (void) strcpy ( cwhat, ">>> DETACH " );


  if ( mydip.shellfile[0] )
  {
    (void) sprintf ( temp, "%d", mydip.mtu );

    (void) strcpy ( buff, mydip.shellfile );			/* 256 */

    if ( what  ==  DO_ATTACH )
      (void) strcat ( buff, " UP \"" );
    else
      if ( what  ==  DO_DETACH )
	(void) strcat ( buff, " DOWN \"" );			/*   7 */

    (void) strcat ( buff, mydip.ifname );			/*  16 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    (void) strcat ( buff, mydip.protostr );			/*   8 */
    (void) strcat ( buff, "\" " );				/*   2 */
    (void) strcat ( buff, temp );				/*  16 */
    (void) strcat ( buff, " \"" );				/*   2 */
    (void) strcat ( buff, mydip.local );			/* 256 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    if ( mydip.ip_loc.s_addr != 0 )
      (void) strcat ( buff, inet_ntoa ( mydip.ip_loc ) );	/*  16 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    (void) strcat ( buff, mydip.remote );			/* 256 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    if ( mydip.ip_rmt.s_addr != 0 )
      (void) strcat ( buff, inet_ntoa ( mydip.ip_rmt ) );	/*  16 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    (void) strcat ( buff, mydip.gateway );			/* 256 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    if ( mydip.ip_rmt_gw.s_addr != 0 )
      (void) strcat ( buff, inet_ntoa( mydip.ip_rmt_gw ));	/*  16 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    (void) strcat ( buff, mydip.netmask );			/*  16 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    (void) strcat ( buff, mydip.route );			/* 256 */
    (void) strcat ( buff, "\" \"" );				/*   3 */
    if ( mydip.ip_rmt_rt.s_addr != 0 )
      (void) strcat ( buff, inet_ntoa( mydip.ip_rmt_rt ));	/*  16 */
    (void) strcat ( buff, "\" " );				/*   2 */

    (void) sprintf ( temp, "%d %d", mydip.rtdefault ? 1 : 0, mydip.timeout );
    (void) strcat ( buff, temp );				/*  16 */

    if ( opt_debg )
      syslog(LOG_DEBUG, "%s \"%s\"\n", cwhat, buff );

    if ( ( ret = system ( buff ) )  !=  0 )
    {
      syslog ( LOG_ERR, "%s \"%s\"\n", cwhat, buff );
      syslog ( LOG_ERR, ">>> Return code %d", ret );

      if ( ret == -1 )
	syslog ( LOG_ERR, ">>> Error code %m" );

      return -1;
    }
  }
  else
  {
    /*
     *  Use 'internal' commands ifconfig & route
     */
    if ( what  ==  DO_ATTACH )
    {
      /*
       *  Set the desired interface up.
       */
      (void) strcpy ( buff, PATH_BIN_IFCONFIG );
      (void) strcat ( buff, " " );
      (void) strcat ( buff, mydip.ifname );
      (void) strcat ( buff, " inet " );
      (void) strcat ( buff, inet_ntoa ( mydip.ip_loc ) );
      (void) strcat ( buff, " " );
      (void) strcat ( buff, inet_ntoa ( mydip.ip_rmt ) );
      (void) strcat ( buff, " netmask " );
      (void) strcat ( buff, mydip.netmask );

      if ( mydip.protonr  ==  1 )
	(void) strcat ( buff, " -link0" );
      else
	if ( mydip.protonr  ==  2 )
	  (void) strcat ( buff, " link0" );

      (void) strcat ( buff, " link2 up" );

      if ( opt_debg )
        syslog ( LOG_DEBUG, "%s\"%s\"\n", cwhat, buff );

      (void) strcat ( buff, " > " _PATH_DEVNULL );	/*  16 */

      if ( ( ret = system ( buff ) )  !=  0 )
      {
	syslog ( LOG_ERR, ">>> %s Return code %d", PATH_BIN_IFCONFIG, ret );

	if ( ret == -1 )
	  syslog ( LOG_ERR, ">>> Error code %m" );

	return -1;
      }

      (void) strcpy ( buff, PATH_BIN_ROUTE );
      (void) strcat ( buff, " add " );

      if ( mydip.rtdefault )
      {
	(void) strcat ( buff, "default " );
	(void) strcat ( buff, inet_ntoa ( mydip.ip_rmt ) );
      }
      else /* normal routing */
      {
	(void) strcat ( buff, inet_ntoa ( mydip.ip_rmt ) );
	(void) strcat ( buff, " " );
	(void) strcat ( buff, inet_ntoa ( mydip.ip_loc ) );
      }

      if ( opt_debg )
	syslog ( LOG_DEBUG, "%s\"%s\"\n", cwhat, buff );

      (void) strcat ( buff, " > " _PATH_DEVNULL );	/*  16 */

      if ( ( ret = system ( buff ) )  !=  0 )
      {
	syslog ( LOG_ERR, ">>> %s Return code %d", PATH_BIN_ROUTE, ret );

	if ( ret == -1 )
	  syslog ( LOG_ERR, ">>> Error code %m" );

	return -1;
      }
    }
    else
    {
      if ( what  ==  DO_DETACH )
      {
	/*
	 *  Set the desired interface down.
	 */
	(void) strcpy ( buff, PATH_BIN_IFCONFIG );
	(void) strcat ( buff, " " );
	(void) strcat ( buff, mydip.ifname );
	(void) strcat ( buff, " inet down" );

	if ( opt_debg )
	  syslog ( LOG_DEBUG, "%s\"%s\"\n", cwhat, buff );

	(void) strcat ( buff, " > " _PATH_DEVNULL );	/*  16 */

	if ( ( ret = system ( buff ) )  !=  0 )
	{
	  syslog ( LOG_ERR, ">>> %s Return code %d", PATH_BIN_IFCONFIG, ret );

	  if ( ret == -1 )
	    syslog ( LOG_ERR, ">>> Error code %m" );

	  return -1;
	}

	(void) strcpy ( buff, PATH_BIN_ROUTE );
	(void) strcat ( buff, " delete " );

	if ( mydip.rtdefault )
	{
	  (void) strcat ( buff, "default " );
	}
	else
	{
	  (void) strcat ( buff, inet_ntoa ( mydip.ip_rmt ) );
	  (void) strcat ( buff, " " );
	  (void) strcat ( buff, inet_ntoa ( mydip.ip_loc ) );
	}

	if ( opt_debg )
	  syslog ( LOG_DEBUG, "%s\"%s\"\n", cwhat, buff );

	(void) strcat ( buff, " > " _PATH_DEVNULL );	/*  16 */

	if ( ( ret = system ( buff ) )  !=  0 )
	{
	  syslog ( LOG_ERR, ">>> %s Return code %d", PATH_BIN_ROUTE, ret );

	  if ( ret == -1 )
	    syslog ( LOG_ERR, ">>> Error code %m" );

	  return -1;
	}
      }
    }
  }

  return 0;
}
