/* partbl.c */

#define NENTRY  94 
#define YES	1
#define NO	0
#define NOFONT	0
#define ROMAN	1
#define SYMBOL  2
#define PLOT 	3

/* postscript has a kind of a "bug" in which the overline "rn" character
 * is printed not over the current location but over the *next* location.
 * this fixes that problem, by redefining a new overline character in
 * the PLOT font; but it is an ugly fix, because the PLOT font is much
 * wider than the text fonts.
 */
#ifndef UGLY_RN_FIX
#define UGLY_RN_FIX 0
#endif

typedef struct entry {
	char *pair;
	char code;
	int font;
} Entry;

static Entry table[] = {
"pl", 'a', PLOT,
"cr", 'b', PLOT,
"di", 'c', PLOT,
"sq", 'd', PLOT,
"oc", 'e', PLOT,
"fd", 'f', PLOT,
"fs", 'g', PLOT,
"fx", 'h', PLOT,
"fp", 'i', PLOT,
"bu", 'j', PLOT,
"ga", 'a', SYMBOL,
"gA", 'A', SYMBOL,
"gb", 'b', SYMBOL,
"gB", 'B', SYMBOL,
"gg", 'g', SYMBOL,
"gG", 'G', SYMBOL,
"gd", 'd', SYMBOL,
"gD", 'D', SYMBOL,
"ge", 'e', SYMBOL,
"gE", 'E', SYMBOL,
"gz", 'z', SYMBOL,
"gZ", 'Z', SYMBOL,
"gy", 'h', SYMBOL,
"gY", 'H', SYMBOL,
"gh", 'q', SYMBOL,
"gH", 'Q', SYMBOL,
"gi", 'i', SYMBOL,
"gI", 'I', SYMBOL,
"gk", 'k', SYMBOL,
"gK", 'K', SYMBOL,
"gl", 'l', SYMBOL,
"gL", 'L', SYMBOL,
"gm", 'm', SYMBOL,
"gM", 'M', SYMBOL,
"gn", 'n', SYMBOL,
"gN", 'N', SYMBOL,
"gc", 'c', SYMBOL,
"gC", 'C', SYMBOL,
"go", 'o', SYMBOL,
"gO", 'O', SYMBOL,
"gp", 'p', SYMBOL,
"gP", 'P', SYMBOL,
"gr", 'r', SYMBOL,
"gR", 'R', SYMBOL,
"gs", 's', SYMBOL,
"gS", 'S', SYMBOL,
"gt", 't', SYMBOL,
"gT", 'T', SYMBOL,
"gu", 'u', SYMBOL,
"gU", 'U', SYMBOL,
"gf", 'f', SYMBOL,
"gF", 'F', SYMBOL,
"gx", 'x', SYMBOL,
"gX", 'X', SYMBOL,
"gq", 'y', SYMBOL,
"gQ", 'Y', SYMBOL,
"gw", 'w', SYMBOL,
"gW", 'W', SYMBOL,
"tm", '\264', SYMBOL,
"dv", '\270', SYMBOL,
"+-", '\261', SYMBOL,
"<=", '\243', SYMBOL,
">=", '\263', SYMBOL,
"~=", '\273', SYMBOL,
"n=", '\271', SYMBOL,
"pt", '\265', SYMBOL,
"is", '\362', SYMBOL,
"pd", '\266', SYMBOL,
"dl", '\321', SYMBOL,
"sr", '\326', SYMBOL,
"ul", '\137', SYMBOL,
#if UGLY_RN_FIX
/* fix the postscript "bug" which makes the overbar
 * symbol appear not over the current location, but
 * over the next location.
 * but this is an ugly fix because PLOT is wrong width!
 */
"rn", 'k', PLOT,
#else
"rn", '\140', SYMBOL,
#endif
"de", '\260', SYMBOL,
"in", '\245', SYMBOL,
"dg", '\262', ROMAN,
"dd", '\263', ROMAN,
"<-", '\254', SYMBOL,
"->", '\256', SYMBOL,
"da", '\257', SYMBOL,
"ua", '\255', SYMBOL,
"la", '\341', SYMBOL,
"ra", '\361', SYMBOL,
"ib", '!', ROMAN,
"sc", '\266', ROMAN,
"ca", '\307', SYMBOL,
"cu", '\310', SYMBOL,
"mo", '\316', SYMBOL,
"nm", '\317', SYMBOL,
"ex", '\044', SYMBOL,
"al", '\042', SYMBOL,
"su", '\314', SYMBOL,
"ds", '\305', SYMBOL,
"dp", '\304', SYMBOL,
"so", '\311', SYMBOL
} ;


int eq(a,b)
char *a,*b;
{
	return(strcmp(a,b)==0);
}


getcode(pair,font,code)
char pair[],*code;
int *font;
{
	int i;

	i=0;
	while(i<NENTRY) 
	  if (!eq(pair,table[i].pair)) { 
		++i;
		continue;
	  } else {
		*font=table[i].font;
		*code=table[i].code;
		return(YES);
	  }
	
	  return(NO);
}
