/* datstr.c */
/* code for the "datastring" option in xyplot
 */
#include <stdio.h>

/* Global flags */

extern int absf;
extern int errf;
extern int verbose;

countchar(c,s)
char c;
char *s;
{
	int count = 0;
	while (*s)
	{
		if ( c == *s) 
			++count;
		++s;
	}
	return count;
}
	
convert_datastring(shdata,fmt,datastring)
char *shdata,*fmt,*datastring;
{
	char *tt;
	int nx=0, ny=0, ne=0;
	
	fmt[0] = shdata[0] = '\0';

	if (*datastring == '\0') return 0;

	for ( tt = datastring; *tt != '\0' ; ++tt)
	{
		switch (*tt)
		{
		case '.':
			strcat(fmt,"%*f");
			break;
		case 'x':
			if (nx==0) {
				strcat(shdata,"x");
				strcat(fmt,"%f");
			}
			else
				strcat(fmt,"%*f");
			++nx;
			break;
		case 'y':
			if (ny==0) {
				strcat(shdata,"y");
				strcat(fmt,"%f");
			}
			else
				strcat(fmt,"%*f");
			++ny;
			break;
		case 'e':
			errf = 1;
			if (ne==0) {
				strcat (shdata,"e");
				strcat(fmt,"%f");
			}
			else
				strcat(fmt,"%*f");
			++ne;
			break;
		default:
			fatal("Invalid datastring");
			break;
		}
		
	}
	return 1;
}


get_xye(pxval,pyval,pyerr,t,datastring,newf)
float *pxval,*pyval,*pyerr;
char *t;
char *datastring;
int newf;
{
	float x,y,e;
	static char	   fmt[150];
	static char    shdata[10];
	static int     nx=0,ny=0,ne=0,ndot=0;
	int            i,ncols;
	float          z[3];

	if (verbose) fprintf(stderr,"get_xye: (%d) [%s] %s\n",newf,datastring,t); 
		
	if (newf)
	{
		nx =   countchar('x',datastring);
		ny =   countchar('y',datastring);
		ne =   countchar('e',datastring);
		ndot = countchar('.',datastring);

		convert_datastring(shdata,fmt,datastring);
		
		if (verbose>1) fprintf(stderr,"#sd %s\n#fmt %s\n",shdata,fmt);
		
		if (ny==0)
			fatal("Invalid datastring: no y");
	}

	if (verbose) fprintf(stderr,"       : [%s] [%s]\n",fmt,shdata);
	
	absf = (nx == 0 ? 1 : 0);
	errf = (ne == 0 ? 0 : 1); 
	
	ncols = (nx==0 ? 0 : 1) + 1 + (ne==0 ? 0 : 1);
	
	if (verbose>1) fprintf(stderr,"%d:\n",ncols);
	
	switch (ncols)
	{
	case 1: /* y */
		if (sscanf(t, fmt, &z[0] ) != ncols ) return 0;
		break;
	case 2: /* xy, yx, ye */
		if (sscanf(t, fmt, &z[0], &z[1] ) != ncols ) return 0;
		break;
	case 3: /* xye, yxe, ... */
		if (sscanf(t, fmt, &z[0], &z[1], &z[2] ) != ncols ) return 0;
		break;
	default:
		fatal("Invalid datastring -- too many columns");
	}
	
	for (i=0; i<ncols; ++i)
	{
		switch (shdata[i])
		{
		case 'x':
			x = z[i];
			break;
		case 'y':
			y = z[i];
			break;
		case 'e':
			e = z[i];
		}
	}
	*pxval = x;
	*pyval = y;
	*pyerr = e;
}


