#define CHUNKSTEP 	1000
#define BIGLINE		512
#define SCALE   	0.123   /* scale factor in the post.ps prolog */
#define TX      	40.0    /* x translate in the post.ps prolog */
#define TY      	120.0   /* y translate in the post.ps prolog */
#define LX		92.0	/* x space for y label */
#define LY		61.0	/* y space for x label */
#define xconvert(x)	((x) * SCALE + TX )
#define yconvert(x)	((x) * SCALE + TY )
#define YES		(1)
#define NO		(0)
#include <stdio.h>

static char **lines;
static int total;

getxyin(file,box)
FILE *file;
struct { int llx,lly,urx,ury; } *box;
{
	char *in;
	int chunk,i,j,c;
	extern int erasures;

	erasures=0;
	chunk=CHUNKSTEP;
	lines=(char **) malloc(sizeof(char *)*chunk);
	if(lines==NULL) gerror("No memory for lines");

	i=0;j=0;
	while((c=fgetc(file))!=EOF) {
		in=(char *) malloc(BIGLINE*sizeof(char));
		if(in==NULL) gerror("No memory for input");
		while((c==' ' || c=='\t') && c!=EOF && c!='\n') c=fgetc(file);
		in[i++]=c;
		while((c=fgetc(file))!=EOF && c!='\n') in[i++]=c;
		in[i]='\0';
		in=(char *) realloc((void *)in,sizeof(char)*(i+1));
		if (in==NULL) gerror("Reallocation error");
		if ( in[0] == 'e' ) ++erasures;
		if ( in[0] == 'b' ) {
			computebbox(in,box);
		} else {
			lines[j++]=in;
		}
		i=0;
		if (j>=chunk) {
			chunk += CHUNKSTEP;
			lines=(char **)realloc(
				    (void *)lines, sizeof(char *)*chunk );
			if(lines==NULL) gerror("Lines reallocation error");
		}
	}

	total=j;

	box->llx = xconvert(box->llx) - LX;
	box->lly = yconvert(box->lly) - LY;
	box->urx = xconvert(box->urx);
	box->ury = yconvert(box->ury);
}

char * nextline()
{
	static int linenumber=0;

	if(linenumber<total)
		return(lines[linenumber++]);
	else
		return(NULL);
}

gerror(s)
char *s;
{
	extern char *ProgName;

	fprintf(stderr,"%s: %s\n",ProgName,s);
	exit(-1);
}

computebbox(in,b)
char *in;
struct { int llx,lly,urx,ury; } *b;
{
	static int firstQ=YES;
	int i1,i2,i3,i4;

	sscanf(in+1,"%d %d %d %d",&i1,&i2,&i3,&i4);
	if(firstQ) {
		b->llx=i1;
		b->lly=i2;
		b->urx=i3;
		b->ury=i4;
		firstQ=NO;
	} else {
		if (b->llx > i1 ) b->llx = i1;
		if (b->lly > i2 ) b->lly = i2;
		if (b->urx < i3 ) b->urx = i3;
		if (b->ury < i4 ) b->ury = i4;
	}

}
