#include "sipp.h"
#include "shaders.h"

void
mask_shader(a, b, c, u, v, w, view_vec, lights, sd, color)
    double  a, b, c, u, v, w;
    Vector  view_vec;
    Lightsource *lights;
    Mask_desc *sd;
    Color *color;
{
    int  ras_x, ras_y;
    bool mapped;

    ras_x = u * sd->xscale + sd->x0;
    ras_y = v * sd->yscale + sd->y0;
    mapped = ((ras_x >=0 && ras_x < sd->xsize) 
              && (ras_y >= 0 && ras_y < sd->ysize)
              && sd->pixel_test(sd->mask, ras_x, ras_y));
    if (mapped) {
        sd->fg_shader(a, b, c, u, v, w, view_vec, lights, sd->fg_surface,
                      color); 
    } else {
        sd->bg_shader(a, b, c, u, v, w, view_vec, lights, sd->bg_surface,
                      color); 
    }
}
