/*
 * Basic shading model, somewhat modified and simplified version of
 * Blinn's
 */

#include <math.h>

#include <sipp.h>


void
basic_shader(a, b, c, u, v, w, view_vec, lights, sd, color)
    double       a, b, c, u, v, w;
    Vector       view_vec;
    Lightsource *lights;
    Surf_desc   *sd;
    Color       *color;
{
    double       nx, ny, nz, l;
    double       xs, ys, zs;
    double       coss, cosi, diffsum, specsum;
    double       c3two;
    Lightsource *lp;

    l = (a * a + b * b + c * c);
    nx = a;
    ny = b;
    nz = c;
    if (fabs(l - 1.0) > 1e-5) {
        l = sqrt(l);
        nx /= l;
        ny /= l;
        nz /= l;
    }
    diffsum = specsum = 0;
    c3two = sd->c3 * sd->c3;
    for (lp = lights; lp != (Lightsource *)0; lp = lp->next) {
        cosi = (lp->dir.x * nx + lp->dir.y * ny + lp->dir.z * nz);
         if (cosi > 0)
            diffsum += cosi * lp->intensity;
        cosi *= -2.0;
        xs = -lp->dir.x - cosi * nx;
        ys = -lp->dir.y - cosi * ny;
        zs = -lp->dir.z - cosi * nz;
        coss = (xs * view_vec.x + ys * view_vec.y + zs * view_vec.z);
        if (coss > 0)
            specsum += lp->intensity * c3two * coss / 
	                               (coss * coss * (c3two -1) + 1);
    }
    color->red = (sd->color.red * (sd->ambient + diffsum) + sd->specular
                  * specsum); 
    if (color->red > 1.0) color->red = 1.0;
    color->grn = (sd->color.grn * (sd->ambient + diffsum) + sd->specular
                  * specsum); 
    if (color->grn > 1.0) color->grn = 1.0;
    color->blu = (sd->color.blu * (sd->ambient + diffsum) + sd->specular
                  * specsum);
    if (color->blu > 1.0) color->blu = 1.0;
}



