
/*  @(#)expr.h 1.5 93/06/01
 *
 *  Definitions used in the popi yacc grammar.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include <stdio.h>

enum tree { T_Abs,      T_Add,     T_And,     T_Assign,  T_Atan,     /*  0 */
            T_Bang,     T_Color,   T_Comb,    T_Comma,   T_Cond,     /*  5 */
            T_Coord,    T_Cos,     T_Debug,   T_Display, T_Div,      /* 10 */
            T_Eq,       T_Explo,   T_Extcmd,  T_File,    T_Fnum,     /* 15 */
            T_Free,     T_Ge,      T_Genep,   T_Genps,   T_Get,      /* 20 */
            T_Gray,     T_Gt,      T_Help,    T_Hypot,   T_Image,    /* 25 */
            T_Inum,     T_Land,    T_Le,      T_List,    T_Logfile,  /* 30 */
            T_Luma,     T_Lor,     T_Lshift,  T_Log,     T_Lt,       /* 35 */
            T_Mapcoord, T_Matte,   T_Melt,    T_Minus,   T_Mod,      /* 40 */
            T_Mono,     T_Mul,     T_Ne,      T_Neg,     T_New,      /* 45 */
            T_Nop,      T_Not,     T_Ofmt,    T_Oil,     T_Or,       /* 50 */
            T_Pang,     T_Plus,    T_Polar,   T_Pow,     T_Prad,     /* 55 */
            T_Put,      T_Quit,    T_Rand,    T_Range,   T_Rcut,     /* 60 */
            T_Read,     T_Rminmax, T_Rwrap,   T_Rshift,  T_Shear,    /* 65 */
            T_Signed,   T_Sin,     T_Size,    T_Slice,   T_Sqr,      /* 70 */
            T_Sqrt,     T_Store,   T_Sub,     T_Tan,     T_Tile,     /* 75 */
            T_Top,      T_Trunc,   T_Undo,    T_VAngle,  T_Var,      /* 80 */
            T_VRadius,  T_Verbose, T_Ver,     T_Write,   T_Xcoord,   /* 85 */
            T_Xor,      T_Ycoord                                     /* 90 */
} ;

typedef struct Tree Tree ;

struct Tree {
  enum tree t ;
  int siz ;
  int i ;
  double d ;
  unsigned hash ;
  struct Tree *kids[3] ;
} ;

typedef enum { Mem, Reg } SClass ;

struct var {
  char *n ;
  int r ;
  int slot ;
  SClass sc ;
  int v ;
  int dep ;
};
 
struct builtin {
  char *n ;
  enum tree t ;
  int a ;
  int (*func)() ;
  int var ;
} ;

/* alloc.c */
extern void *ealloc P((size_t)) ;
extern void *alloc  P((size_t)) ;
extern void afree   P((void)) ;

#ifndef offsetof
#define  offsetof(t, m)  ((size_t) &((t *) 0)->m)
#endif /*!offsetof*/

/* main.c */
extern void Quit       P((Tree *)) ;
extern void version    P((Tree *)) ;
extern int saw_eof ;
extern Tree *tree ;

/* gen.c */
extern int  calc       P((Tree *)) ;
extern void compile    P((Tree *)) ;
extern void allocRegs  P((struct var *, int)) ;
extern int  cost       P((Tree *)) ;

/* io.c */
extern void showfiles    P((Tree *)) ;

/* mk.c */
extern Tree *treealloc   P((int)) ;
extern Tree *mk          P((enum tree, Tree *, Tree *)) ;
extern Tree *mkCond      P((Tree *, Tree *, Tree *)) ;
extern Tree *mkCoord     P((int, Tree *)) ;
extern Tree *mkMapcoord  P((int, Tree *, Tree *)) ;
extern Tree *mkun        P((enum tree, void *)) ;
extern Tree *mkInum      P((int)) ;
extern Tree *mkFnum      P((double)) ;
extern Tree *mkVar       P((char *)) ;
extern Tree *mkempty     P((enum tree)) ;
extern Tree *mkBuiltin   P((char *, int, ...)) ;
extern Tree *mkAssign    P((char *, Tree *)) ;
extern Tree *mkTop       P((Tree *, Tree *, Tree *, Tree *, Tree *)) ;
extern struct builtin builtins[] ;
extern int nbuiltin ;

/* special.c */
extern void debug      P((Tree *)) ;
extern void displayimg P((Tree *)) ;
extern void dolog      P((Tree *)) ;
extern void dorange    P((Tree *)) ;
extern void dosigned   P((Tree *)) ;
extern void dostore    P((Tree *)) ;
extern void freeimg    P((Tree *)) ;
extern void genepson   P((Tree *)) ;
extern void genps      P((Tree *)) ;
extern void getrgb     P((Tree *)) ;
extern void help       P((Tree *)) ;
extern void imtrunc    P((Tree *)) ;
extern void matte      P((Tree *)) ;
extern void melt       P((Tree *)) ;
extern void ofmt       P((Tree *)) ;
extern void oil        P((Tree *)) ;
extern void putrgb     P((Tree *)) ;
extern void readimg    P((Tree *)) ;
extern void setcolor   P((Tree *)) ;
extern void setgray    P((Tree *)) ;
extern void setmono    P((Tree *)) ;
extern void shear      P((Tree *)) ;
extern void dosize     P((Tree *)) ;
extern void slice      P((Tree *)) ;
extern void stopict    P((Tree *, int, char *)) ;
extern void tile       P((Tree *)) ;
extern void undo       P((Tree *)) ;
extern void verbose    P((Tree *)) ;
extern void writeimg   P((Tree *)) ;
extern Tree *extcmd    P((char *)) ;

/* trig.c */
extern int sin_cache[], cos_cache[], tan_cache[] ;
extern void cache_trig  P((void)) ;
extern int isqrt        P((int)) ;
extern int dist         P((int, int, int, int)) ;
extern int angle        P((int, int, int, int)) ;
extern int polar        P((int, int)) ;
extern int dorand       P(()) ;

/* optimise.c */
extern Tree *opttree    P((Tree *)) ;

/* colspec.c */
extern void luma       P((Tree *)) ;
extern void explode    P((Tree *)) ;
extern void combine    P((Tree *)) ;
extern void getputrgb  P((Tree *, int)) ;

/* vars.c */
extern int allocName        P((char *)) ;
extern void clearVars       P((void)) ;
extern struct var *findVar  P((int)) ;
extern char *tmpvar         P((void)) ;
extern void allocVars       P((void)) ;
extern void devalVar        P((int)) ;
extern void valVar          P((int)) ;
extern void setvardep       P((int, int)) ;
extern int getvardep        P((int)) ;
 
/* dtree.c */
#ifdef TREEDEBUG
extern void dtree    P((char *, Tree *, int)) ;
#else
#define dtree(a, b, c)
#endif /*TREEDEBUG*/
