/* $Id: internal.h,v 2.3 89/09/20 17:01:43 mbp Exp $
 *
 * internal.h: definitions shared among several files but which are
 *	meant to be internal to GR; application programs should not
 *	use these.
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/walkmenu.h>
#include <suntool/scrollbar.h>
#include <suntool/tty.h>
#include <suntool/textsw.h>
#include <pixrect/pixrect_hs.h>

#define GR_ERROR_MESSAGE_LENGTH	109

extern Frame	GR_base_frame;
extern Canvas	GR_canvas;

extern Panel	GR_app_panel;
extern Panel	GR_control_panel;
extern Panel	GR_error_panel;

extern Frame	GR_help_frame;
extern Panel	GR_help_panel;
extern Textsw	GR_help_textsw;

extern Frame	GR_ps_frame;
extern Panel	GR_ps_panel;

extern Frame	GR_confirmer_frame;
extern Panel	GR_confirmer_panel;

extern Pixwin	*GR_canvas_pw;

extern Frame	GR_anim_frame;
extern Panel	GR_anim_panel;

extern int		GR_canvas_width;
extern int		GR_canvas_height;
extern Panel_item	GR_app_coordinate_message;
extern char		*(*GR_coordinate_display_proc)();
extern int		GR_window_open;
extern int		GR_show_ps_frame();
extern Pixrect		*GR_mouse_image_pr_ptr();
extern Pixfont		*GR_regular_font, *GR_bold_font;
extern gr_Menu		GR_current_menu;
extern int 		(*GR_redraw_proc)();
extern char		*GR_logo;
extern char 		*GR_center_string();

#ifdef THREE_D
extern Panel	GR_view_control_panel;

extern int	GR_save_button_proc();
extern int	GR_recording_trigger;
extern int	GR_recording_count;
extern int	GR_interrupted;
extern int	GR_drawing_mode_value;
extern int	GR_rotation_angle_slider_value;
extern int	GR_zoom_factor_slider_value;
extern int	GR_perspective_factor_slider_value;
extern double	GR_pan_factor;
extern int	*GR_point_list;
extern int	GR_point_list_count;

#define GR_ANIM_MESSAGE_LENGTH 39

#define GR_EYE		1
#define GR_FOCUS	2
#define GR_UP		3
#define GR_VPW		4

#endif
