/*ScianTimers.h
  External stuff for timers in scian
  Eric Pepke
  September 9, 1990
*/

#define NALARMS		30		/*Number of alarms active at once*/

typedef struct
    {
	ObjPtr object;			/*The object to kick*/
	NameTyp method;			/*The method to send it*/
	double when;			/*The time to send the method*/
	double startTime;		/*The time to start counting lateness*/
	Bool wallTime;			/*True iff wall time only*/
    } AlarmRec;

extern ObjPtr timedObjClass;
extern Bool interpolateP;

/*Time format bits for flag*/
#define TF_SUBSECONDS	1		/*Stuff less than a second*/
#define TF_SECONDS	2		/*Seconds*/
#define TF_MINUTES	4		/*Minutes*/
#define TF_HOURS	8		/*Hours*/

/*Is timed obj predicate*/
#define IsTimedObj(object) IntVarEql(object, CLASSID, CLASS_TIMEDOBJ)

#ifdef PROTO
void InitTimers(void);
void IdleTimers(void);
void KillTimers(void);
Bool WakeMe(ObjPtr, NameTyp, double);
Bool SetTimeout(ObjPtr, NameTyp, double);
void DoNotDisturb(ObjPtr, NameTyp);
double Clock(void);
double WallClock(void);
void SetSystemClock(double);
void ClockOff(void);
void ClockOn(void);
ObjPtr NewTimedObject(ObjPtr, ObjPtr);
ObjPtr NewTimeControl(int, int, int, int, char*);
int ParseTime(real *, int *, char s[]);
#else
void InitTimers();
void IdleTimers();
void KillTimers();
Bool WakeMe();
void DoNotDisturb();
double Clock(void);
void SetSystemClock();
void ClockOff();
void ClockOn();
ObjPtr NewTimedObject();
ObjPtr NewClock();
void SetClock();
ObjPtr NewTimeControl();
int ParseTime();
#endif
